/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.point;

import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTextDataResponse;
import com.tridium.aapup.messages.PupWriteAttributeMessage;
import com.tridium.aapup.point.BPupProxyExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="valueToWriteIfTrue", type="double", defaultValue="1.0"), @NiagaraProperty(name="valueToWriteIfFalse", type="double", defaultValue="0.0")})
public class BPupBooleanProxyExt
extends BPupProxyExt {
    @Generated
    public static final Property valueToWriteIfTrue = BPupBooleanProxyExt.newProperty((int)0, (double)1.0, null);
    @Generated
    public static final Property valueToWriteIfFalse = BPupBooleanProxyExt.newProperty((int)0, (double)0.0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPupBooleanProxyExt.class);

    @Generated
    public double getValueToWriteIfTrue() {
        return this.getDouble(valueToWriteIfTrue);
    }

    @Generated
    public void setValueToWriteIfTrue(double v) {
        this.setDouble(valueToWriteIfTrue, v, null);
    }

    @Generated
    public double getValueToWriteIfFalse() {
        return this.getDouble(valueToWriteIfFalse);
    }

    @Generated
    public void setValueToWriteIfFalse(double v) {
        this.setDouble(valueToWriteIfFalse, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBooleanPoint;
    }

    @Override
    public void setValue(PupResponse rsp) {
        BBoolean value;
        if (rsp instanceof PupNumericDataResponse) {
            PupNumericDataResponse numRsp = (PupNumericDataResponse)rsp;
            value = numRsp.getBoolean();
            this.setAttributeValue(numRsp.getString().getString());
        } else if (rsp instanceof PupTextDataResponse) {
            PupTextDataResponse txtRsp = (PupTextDataResponse)rsp;
            value = txtRsp.getBoolean(((BControlPoint)this.getParent()).getFacets());
            this.setAttributeValue(txtRsp.getString().getString());
        } else {
            this.readFail("message type incorrect");
            return;
        }
        BStatusBoolean bv = new BStatusBoolean(value.getBoolean(), BStatus.makeOverridden((BStatus)this.getReadValue().getStatus(), (boolean)this.getOverriddenState()));
        this.readOk((BStatusValue)bv);
    }

    @Override
    boolean updateOutput(BStatusValue out) {
        if (!this.prewriteAttribute()) {
            this.writeFail("unable to set override or manual");
            return false;
        }
        double dataOut = Double.NaN;
        if (out instanceof BStatusBoolean) {
            boolean bValue = ((BStatusBoolean)out).getValue();
            dataOut = bValue ? this.getValueToWriteIfTrue() : this.getValueToWriteIfFalse();
        } else {
            this.writeFail("unsupported data type");
            return false;
        }
        PupWriteAttributeMessage msg = new PupWriteAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute(), this.getAttributeType(), dataOut);
        PupResponse rsp = (PupResponse)this.pupNetwork().sendSync(msg);
        if (!this.isValidWriteResponse(rsp)) {
            return false;
        }
        if (rsp instanceof PupAckResponse) {
            this.getPupLog().fine("Write Succeeded on " + this);
            this.writeOk(out);
            return true;
        }
        if (rsp instanceof PupErrorResponse) {
            PupErrorResponse errRsp = (PupErrorResponse)rsp;
            this.getPupLog().fine("Received error response writing " + this);
            this.writeFail(errRsp.getError());
            return false;
        }
        this.getPupLog().fine("Received invalid message type writing " + this);
        this.writeFail("invalid message type");
        return false;
    }
}

