/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;

public class PupWriteRegionDataMessage
extends PupMessage
implements AaPupConst {
    private int regionNumber;
    private int offset;
    private byte[] data;

    public PupWriteRegionDataMessage(int targetUnitNumber, int regionNumber, int offset, byte[] data) {
        super(targetUnitNumber);
        this.regionNumber = regionNumber;
        this.offset = offset;
        byte[] newData = new byte[data.length];
        System.arraycopy(data, 0, newData, 0, data.length);
        this.data = newData;
    }

    public int getRegionNumber() {
        return this.regionNumber;
    }

    public void setRegionNumber(int regionNumber) {
        this.regionNumber = regionNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        byte[] newData = new byte[data.length];
        System.arraycopy(data, 0, newData, 0, data.length);
        this.data = newData;
    }

    @Override
    void writeBytes(PupOutputStream out) {
        out.write(0);
        out.write(6);
        out.writeInt(this.data.length + 10);
        out.write(this.regionNumber);
        out.writeInt(this.offset);
        out.write(this.data);
    }

    @Override
    PupResponse getResponse(PupReceivedMessage rcvdMsg) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (rcvdMsg.getData()[4] == -128) {
            return new PupErrorResponse(rcvdMsg);
        }
        if (rcvdMsg.getData()[4] == -127) {
            return new PupAckResponse(rcvdMsg);
        }
        return new PupErrorResponse(rcvdMsg);
    }

    @Override
    public String toString() {
        return "PupWriteRegionDataMessage::unit:" + this.unitNumber + " region number:" + this.regionNumber + " offset:" + this.offset;
    }
}

