/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupRegionDataResponse;
import com.tridium.aapup.messages.PupResponse;

public class PupReadRegionDataMessage
extends PupMessage
implements AaPupConst {
    private int regionNumber;
    private int offset;
    private int numBytes;

    public PupReadRegionDataMessage(int targetUnitNumber, int regionNumber, int offset, int bytes) {
        super(targetUnitNumber);
        this.regionNumber = regionNumber;
        this.offset = offset;
        this.numBytes = bytes;
    }

    public int getRegionNumber() {
        return this.regionNumber;
    }

    public void setRegionNumber(int num) {
        this.regionNumber = num;
        if (num < 0) {
            this.regionNumber = 0;
        }
        if (num > 255) {
            this.regionNumber = 255;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public void setoffset(int offset) {
        this.offset = offset;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public void setNumBytes(int num) {
        this.numBytes = num;
    }

    @Override
    void writeBytes(PupOutputStream out) {
        out.write(10);
        out.write(5);
        out.write(this.regionNumber);
        out.writeInt(this.offset);
        out.writeInt(this.numBytes);
    }

    @Override
    PupResponse getResponse(PupReceivedMessage rcvdMsg) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (rcvdMsg.getData()[4] == -128) {
            return new PupErrorResponse(rcvdMsg);
        }
        if (rcvdMsg.getData()[4] == -124) {
            return new PupRegionDataResponse(rcvdMsg);
        }
        return new PupErrorResponse(rcvdMsg);
    }

    @Override
    public String toString() {
        return "PupReadRegionDataMessage::unit:" + this.unitNumber + " regionNumber:" + this.regionNumber + " offset:" + this.offset + " bytes to read" + this.numBytes;
    }
}

