/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import java.io.ByteArrayOutputStream;
import javax.baja.sys.BAbsTime;

public class PupOutputStream
extends ByteArrayOutputStream
implements AaPupConst {
    private int[] weekdayTranslation = new int[]{6, 0, 1, 2, 3, 4, 5};
    int pupchecksum = 0;

    public static PupOutputStream make() {
        return new PupOutputStream();
    }

    private PupOutputStream() {
        this.write(2);
    }

    @Override
    public void reset() {
        super.reset();
        this.pupchecksum = 0;
        this.write(2);
    }

    public void writeInt(int anyInt) {
        this.write(anyInt & 0xFF);
        this.write((anyInt & 0xFF00) >> 8);
    }

    public void writeTime(BAbsTime anyTime, boolean holiday) {
        this.write(anyTime.getSecond());
        this.write(anyTime.getMinute());
        this.write(anyTime.getHour());
        int weekday = this.weekdayTranslation[anyTime.getWeekday().getOrdinal()];
        if (holiday) {
            weekday += 128;
        }
        this.write(weekday);
        this.write(anyTime.getDay());
        this.write(anyTime.getMonth().getOrdinal() + 1);
        this.write(anyTime.getYear() % 100);
    }

    public void writeAttribute(String attribute, boolean fetchNextFlag, boolean fetchPreviousFlag) {
        byte[] stringBytes = attribute.getBytes();
        try {
            if (fetchPreviousFlag) {
                stringBytes[0] = (byte)(stringBytes[0] | 0x80);
            }
            if (fetchNextFlag) {
                stringBytes[1] = (byte)(stringBytes[1] | 0x80);
            }
            this.write(stringBytes[0] & 0xFF);
            this.write(stringBytes[1] & 0xFF);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            this.write(32);
            this.write(32);
        }
    }

    public void writeString(String text) {
        byte[] stringBytes = text.getBytes();
        try {
            for (int i = 0; i < stringBytes.length; ++i) {
                this.write(stringBytes[i] & 0x7F);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public synchronized void write(int b) {
        super.write(b);
        this.pupchecksum ^= b;
        ++this.pupchecksum;
        this.pupchecksum &= 0xFF;
    }

    @Override
    public synchronized void write(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            this.write(b[i] & 0xFF);
        }
    }

    public final void writeChecksum() {
        super.write(this.pupchecksum);
    }
}

