/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.util.TimeFormat;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.user.BUser;

public class PupNumericDataResponse
extends PupResponse
implements AaPupConst {
    String attributeName;
    int dataType;
    byte[] rawdata = new byte[4];
    String text;

    public PupNumericDataResponse(PupReceivedMessage msg) {
        super(msg);
        this.attributeName = this.getIn().readAttributeName();
        this.dataType = this.getIn().read();
        this.getIn().read(this.rawdata, 0, this.rawdata.length);
        this.text = this.getIn().readText();
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getText() {
        return this.text;
    }

    public boolean isFirst() {
        return this.getIn().isFirst();
    }

    public boolean isLast() {
        return this.getIn().isLast();
    }

    public boolean isOnlyAttribute() {
        return this.getIn().isFirst() & this.getIn().isLast();
    }

    public BDouble getDouble() {
        switch (this.dataType) {
            case 255: {
                return BDouble.make((double)this.getInt());
            }
            case 254: {
                return BDouble.make((double)this.getLong());
            }
            case 253: {
                return BDouble.make((double)((double)this.getInt() / 10.0));
            }
            case 252: {
                return BDouble.make((double)((double)this.getLong() / 10.0));
            }
            case 251: {
                return BDouble.make((double)((double)this.getInt() / 100.0));
            }
            case 250: {
                return BDouble.make((double)((double)this.getLong() / 100.0));
            }
            case 249: {
                return BDouble.make((double)((double)this.getInt() / 1000.0));
            }
            case 248: {
                return BDouble.make((double)((double)this.getLong() / 1000.0));
            }
            case 247: {
                return BDouble.make((double)((double)this.getInt() / 10000.0));
            }
            case 246: {
                return BDouble.make((double)((double)this.getLong() / 10000.0));
            }
            case 245: {
                return BDouble.make((double)((double)this.getInt() / 100000.0));
            }
            case 244: {
                return BDouble.make((double)((double)this.getLong() / 100000.0));
            }
            case 243: {
                return BDouble.make((double)((double)this.getInt() / 1000000.0));
            }
            case 242: {
                return BDouble.make((double)((double)this.getLong() / 1000000.0));
            }
            case 241: {
                return BDouble.make((double)((double)this.getInt() / 1.0E7));
            }
            case 240: {
                return BDouble.make((double)((double)this.getLong() / 1.0E7));
            }
            case 239: {
                return BDouble.make((double)((double)this.getInt() / 1.0E8));
            }
            case 238: {
                return BDouble.make((double)((double)this.getLong() / 1.0E8));
            }
            case 237: {
                return BDouble.make((double)((double)this.getInt() / 1.0E9));
            }
            case 236: {
                return BDouble.make((double)((double)this.getLong() / 1.0E9));
            }
            case 235: {
                return BDouble.make((double)((double)this.getInt() / 1.0E10));
            }
            case 234: {
                return BDouble.make((double)((double)this.getLong() / 1.0E10));
            }
            case 233: {
                return BDouble.make((double)this.getLong());
            }
            case 232: {
                return BDouble.make((double)this.getLong());
            }
            case 231: {
                int hmsHdigit1 = (this.rawdata[0] & 0xF0) >>> 4;
                int hmsHdigit2 = this.rawdata[0] & 0xF;
                int hmsMdigit1 = (this.rawdata[1] & 0xF0) >>> 4;
                int hmsMdigit2 = this.rawdata[1] & 0xF;
                int hmsSdigit1 = (this.rawdata[2] & 0xF0) >>> 4;
                int hmsSdigit2 = this.rawdata[3] & 0xF;
                int hmsHours = hmsHdigit1 * 10 + hmsHdigit2;
                int hmsMinutes = hmsMdigit1 * 10 + hmsMdigit2;
                int hmsSeconds = hmsSdigit1 * 10 + hmsSdigit2;
                hmsSeconds = hmsHours * 360 + hmsMinutes * 60 + hmsSeconds;
                return BDouble.make((double)hmsSeconds);
            }
            case 230: {
                int hmHdigit1 = (this.rawdata[0] & 0xF0) >>> 4;
                int hmHdigit2 = this.rawdata[0] & 0xF;
                int hmMdigit1 = (this.rawdata[1] & 0xF0) >>> 4;
                int hmMdigit2 = this.rawdata[1] & 0xF;
                int hmHours = hmHdigit1 * 10 + hmHdigit2;
                int hmMinutes = hmMdigit1 * 10 + hmMdigit2;
                int hmSeconds = hmHours * 360 + hmMinutes * 60;
                return BDouble.make((double)hmSeconds);
            }
            case 229: {
                int pdigit1 = (this.rawdata[0] & 0xF0) >>> 4;
                int pdigit2 = this.rawdata[0] & 0xF;
                int pdigit3 = (this.rawdata[1] & 0xF0) >>> 4;
                int pdigit4 = this.rawdata[1] & 0xF;
                int pdigit5 = (this.rawdata[2] & 0xF0) >>> 4;
                int pdigit6 = this.rawdata[2] & 0xF;
                int pdigit7 = (this.rawdata[3] & 0xF0) >>> 4;
                int pdigit8 = this.rawdata[3] & 0xF;
                return BDouble.make((double)((double)pdigit1 + (double)(pdigit2 * 10) + (double)pdigit3 * 100.0 + (double)pdigit4 * 1000.0 + (double)pdigit5 * 10000.0 + (double)pdigit6 * 100000.0 + (double)pdigit7 * 1000000.0 + (double)pdigit8 * 1.0E7));
            }
            case 228: {
                int digit1 = (this.rawdata[3] & 0xF0) >>> 4;
                int digit2 = this.rawdata[3] & 0xF;
                int digit3 = (this.rawdata[2] & 0xF0) >>> 4;
                int digit4 = this.rawdata[2] & 0xF;
                int year = digit1 * 1000 + digit2 * 100 + digit3 * 10 + digit4;
                System.out.println("year:" + year);
                if (year > 70 && year <= 99) {
                    year += 1900;
                }
                if (year <= 70) {
                    year += 2000;
                }
                int digit5 = (this.rawdata[1] & 0xF0) >>> 4;
                int digit6 = this.rawdata[1] & 0xF;
                int month = digit5 * 10 + digit6;
                int digit7 = (this.rawdata[0] & 0xF0) >>> 4;
                int digit8 = this.rawdata[0] & 0xF;
                int day = digit7 * 10 + digit8;
                System.out.println("year:" + year + " month:" + month + " day:" + day);
                if (month == 0) {
                    return BDouble.make((double)0.0);
                }
                BAbsTime atime = BAbsTime.make((int)year, (BMonth)BMonth.make((int)(month - 1)), (int)day);
                return BDouble.make((double)atime.getDayOfYear());
            }
            case 227: {
                int byear = ((this.rawdata[2] & 0xFF) << 8) + (this.rawdata[3] & 0xFF);
                int bmonth = this.rawdata[1] & 0xFF;
                int bday = this.rawdata[0] & 0xFF;
                BAbsTime btime = BAbsTime.make((int)byear, (BMonth)BMonth.make((int)(bmonth - 1)), (int)bday);
                return BDouble.make((double)btime.getDayOfYear());
            }
            case 224: {
                return BDouble.make((double)Float.intBitsToFloat(this.getInt()));
            }
            case 223: {
                int intData;
                char[] chars = new char[]{(char)(this.rawdata[0] & 0x7F), (char)(this.rawdata[1] & 0x7F), (char)(this.rawdata[2] & 0x7F), (char)(this.rawdata[3] & 0x7F)};
                try {
                    intData = Integer.parseInt(new String(chars));
                }
                catch (NumberFormatException e) {
                    return BDouble.make((double)Double.NaN);
                }
                return BDouble.make((double)intData);
            }
            case 127: {
                return BDouble.make((double)((this.rawdata[1] & 0xFF) << 8 | this.rawdata[0] & 0xFF));
            }
            case 8: {
                long dword = this.getLong() >>> 1;
                int pminute = (int)((dword >>>= 3) | 0x3FL);
                int phour = (int)((dword >>>= 6) | 0x1FL);
                int pday = (int)((dword >>>= 5) | 0x1FL);
                int pmonth = (int)((dword >>>= 5) | 0xFL);
                int pyear = (int)((dword >>>= 4) | 0x7FL) + 1991;
                if (pmonth == 0) {
                    return BDouble.make((double)0.0);
                }
                BAbsTime ptime = BAbsTime.make((int)pyear, (BMonth)BMonth.make((int)(pmonth - 1)), (int)pday, (int)phour, (int)pminute);
                return BDouble.make((double)ptime.getDayOfYear());
            }
            case 7: {
                return BDouble.make((double)this.getInt());
            }
        }
        return BDouble.make((double)this.getLong());
    }

    public BBoolean getBoolean() {
        return BBoolean.make((!this.getDouble().equals((Object)BDouble.make((double)0.0)) ? 1 : 0) != 0);
    }

    public BString getString() {
        switch (this.dataType) {
            case 255: {
                BFacets facetsToUse = BFacets.makeNumeric((int)0);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getInt() / 1.0), (Context)provideFacets));
            }
            case 254: {
                BFacets facetsToUse = BFacets.makeNumeric((int)0);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getLong() / 1.0), (Context)provideFacets));
            }
            case 253: {
                BFacets facetsToUse = BFacets.makeNumeric((int)1);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getInt() / 10.0), (Context)provideFacets));
            }
            case 252: {
                BFacets facetsToUse = BFacets.makeNumeric((int)1);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getLong() / 10.0), (Context)provideFacets));
            }
            case 251: {
                BFacets facetsToUse = BFacets.makeNumeric((int)2);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getInt() / 100.0), (Context)provideFacets));
            }
            case 250: {
                BFacets facetsToUse = BFacets.makeNumeric((int)2);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getLong() / 100.0), (Context)provideFacets));
            }
            case 249: {
                BFacets facetsToUse = BFacets.makeNumeric((int)3);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getInt() / 1000.0), (Context)provideFacets));
            }
            case 248: {
                BFacets facetsToUse = BFacets.makeNumeric((int)3);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getLong() / 1000.0), (Context)provideFacets));
            }
            case 247: {
                BFacets facetsToUse = BFacets.makeNumeric((int)4);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getInt() / 10000.0), (Context)provideFacets));
            }
            case 246: {
                BFacets facetsToUse = BFacets.makeNumeric((int)4);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getLong() / 10000.0), (Context)provideFacets));
            }
            case 245: {
                BFacets facetsToUse = BFacets.makeNumeric((int)5);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getInt() / 100000.0), (Context)provideFacets));
            }
            case 244: {
                BFacets facetsToUse = BFacets.makeNumeric((int)5);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getLong() / 100000.0), (Context)provideFacets));
            }
            case 243: {
                BFacets facetsToUse = BFacets.makeNumeric((int)6);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getInt() / 1000000.0), (Context)provideFacets));
            }
            case 242: {
                BFacets facetsToUse = BFacets.makeNumeric((int)6);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getLong() / 1000000.0), (Context)provideFacets));
            }
            case 241: {
                BFacets facetsToUse = BFacets.makeNumeric((int)7);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getInt() / 1.0E7), (Context)provideFacets));
            }
            case 240: {
                BFacets facetsToUse = BFacets.makeNumeric((int)7);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getLong() / 1.0E7), (Context)provideFacets));
            }
            case 239: {
                BFacets facetsToUse = BFacets.makeNumeric((int)8);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getInt() / 1.0E8), (Context)provideFacets));
            }
            case 238: {
                BFacets facetsToUse = BFacets.makeNumeric((int)8);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getLong() / 1.0E8), (Context)provideFacets));
            }
            case 237: {
                BFacets facetsToUse = BFacets.makeNumeric((int)9);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getInt() / 1.0E9), (Context)provideFacets));
            }
            case 236: {
                BFacets facetsToUse = BFacets.makeNumeric((int)9);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getLong() / 1.0E9), (Context)provideFacets));
            }
            case 235: {
                BFacets facetsToUse = BFacets.makeNumeric((int)10);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getInt() / 1.0E10), (Context)provideFacets));
            }
            case 234: {
                BFacets facetsToUse = BFacets.makeNumeric((int)10);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                return BString.make((String)BDouble.toString((double)((double)this.getLong() / 1.0E10), (Context)provideFacets));
            }
            case 232: 
            case 233: {
                long lval = this.getLong();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < 32; ++i) {
                    if ((lval & 0x80000000L) == 0L) {
                        sb.append("0");
                    } else {
                        sb.append("1");
                    }
                    lval <<= 1;
                    if ((i + 1) % 8 != 0) continue;
                    sb.append(" ");
                }
                return BString.make((String)((this.dataType == 233 ? "Channel Map:" : "Text Bitmap:") + sb.toString()));
            }
            case 231: {
                int hmsHdigit1 = (this.rawdata[0] & 0xF0) >>> 4;
                int hmsHdigit2 = this.rawdata[0] & 0xF;
                int hmsMdigit1 = (this.rawdata[1] & 0xF0) >>> 4;
                int hmsMdigit2 = this.rawdata[1] & 0xF;
                int hmsSdigit1 = (this.rawdata[2] & 0xF0) >>> 4;
                int hmsSdigit2 = this.rawdata[2] & 0xF;
                return BString.make((String)(Integer.toString(hmsHdigit1) + Integer.toString(hmsHdigit2) + ":" + Integer.toString(hmsMdigit1) + Integer.toString(hmsMdigit2) + ":" + Integer.toString(hmsSdigit1) + Integer.toString(hmsSdigit2)));
            }
            case 230: {
                int hmHdigit1 = (this.rawdata[0] & 0xF0) >>> 4;
                int hmHdigit2 = this.rawdata[0] & 0xF;
                int hmMdigit1 = (this.rawdata[1] & 0xF0) >>> 4;
                int hmMdigit2 = this.rawdata[1] & 0xF;
                return BString.make((String)(Integer.toString(hmHdigit1) + Integer.toString(hmHdigit2) + ":" + Integer.toString(hmMdigit1) + Integer.toString(hmMdigit2)));
            }
            case 229: {
                BFacets facetsToUse = BFacets.makeNumeric((int)0);
                BasicContext provideFacets = new BasicContext(new BUser(), facetsToUse);
                int pdigit1 = (this.rawdata[0] & 0xF0) >>> 4;
                int pdigit2 = this.rawdata[0] & 0xF;
                int pdigit3 = (this.rawdata[1] & 0xF0) >>> 4;
                int pdigit4 = this.rawdata[1] & 0xF;
                int pdigit5 = (this.rawdata[2] & 0xF0) >>> 4;
                int pdigit6 = this.rawdata[2] & 0xF;
                int pdigit7 = (this.rawdata[3] & 0xF0) >>> 4;
                int pdigit8 = this.rawdata[3] & 0xF;
                return BString.make((String)(Integer.toString(pdigit1) + Integer.toString(pdigit2) + Integer.toString(pdigit3) + Integer.toString(pdigit4) + Integer.toString(pdigit5) + Integer.toString(pdigit6) + Integer.toString(pdigit7) + Integer.toString(pdigit8)));
            }
            case 228: {
                int digit6;
                int digit5;
                int month;
                int digit1 = (this.rawdata[3] & 0xF0) >>> 4;
                int digit2 = this.rawdata[3] & 0xF;
                int digit3 = (this.rawdata[2] & 0xF0) >>> 4;
                int digit4 = this.rawdata[2] & 0xF;
                int year = digit1 * 1000 + digit2 * 100 + digit3 * 10 + digit4;
                if (year > 70 && year <= 99) {
                    year += 1900;
                }
                if (year <= 70) {
                    year += 2000;
                }
                if ((month = (digit5 = (this.rawdata[1] & 0xF0) >>> 4) * 10 + (digit6 = this.rawdata[1] & 0xF)) == 0) {
                    return BString.make((String)"invalid date");
                }
                int digit7 = (this.rawdata[0] & 0xF0) >>> 4;
                int digit8 = this.rawdata[0] & 0xF;
                int day = digit7 * 10 + digit8;
                BAbsTime bcdDate = BAbsTime.make((int)year, (BMonth)BMonth.make((int)(month - 1)), (int)day);
                return BString.make((String)TimeFormat.format((BAbsTime)bcdDate, (String)"MM/DD/YYYY"));
            }
            case 227: {
                int byear = ((this.rawdata[2] & 0xFF) << 8) + (this.rawdata[3] & 0xFF);
                int bmonth = this.rawdata[1] & 0xFF;
                int bday = this.rawdata[0] & 0xFF;
                BAbsTime btime = BAbsTime.make((int)byear, (BMonth)BMonth.make((int)(bmonth - 1)), (int)bday);
                return BString.make((String)TimeFormat.format((BAbsTime)btime, (String)"MM/DD/YYYY"));
            }
            case 224: {
                return BString.make((String)Float.valueOf(Float.intBitsToFloat(this.getInt())).toString());
            }
            case 223: {
                char[] chars = new char[]{(char)(this.rawdata[0] & 0x7F), (char)(this.rawdata[1] & 0x7F), (char)(this.rawdata[2] & 0x7F), (char)(this.rawdata[3] & 0x7F)};
                return BString.make((String)new String(chars));
            }
            case 127: {
                return BString.make((String)String.valueOf((this.rawdata[1] & 0xFF) << 8 | this.rawdata[0] & 0xFF));
            }
            case 8: {
                long dword = this.getLong() >>> 1;
                int pminute = (int)((dword >>>= 3) | 0x3FL);
                int phour = (int)((dword >>>= 6) | 0x1FL);
                int pday = (int)((dword >>>= 5) | 0x1FL);
                int pmonth = (int)((dword >>>= 5) | 0xFL);
                int pyear = (int)((dword >>>= 4) | 0x7FL) + 1991;
                BAbsTime ptime = BAbsTime.make((int)pyear, (BMonth)BMonth.make((int)(pmonth - 1)), (int)pday, (int)phour, (int)pminute);
                return BString.make((String)ptime.toString(null));
            }
            case 7: {
                return BString.make((String)(this.getInt() == 0 ? "false" : "true"));
            }
            case 3: 
            case 6: {
                int offset = (this.rawdata[0] & 0xFF) + ((this.rawdata[2] & 0xFF) << 8);
                int segment = (this.rawdata[2] & 0xFF) + ((this.rawdata[3] & 0xFF) << 8);
                return BString.make((String)("segment:" + segment + " offset:" + offset));
            }
            case 5: {
                int dosday = this.getInt();
                if (dosday < 0 || dosday > 6) {
                    return BString.make((String)"unknown");
                }
                String[] dow = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
                return BString.make((String)dow[dosday]);
            }
            case 4: {
                return BString.make((String)Integer.toHexString(this.getInt()));
            }
            case 2: {
                return BString.make((String)Integer.toHexString(this.getInt()));
            }
            case 1: {
                return BString.make((String)Integer.toHexString(this.getInt()));
            }
            case 0: {
                return BString.make((String)Integer.toHexString(this.getInt()));
            }
        }
        return BString.make((String)"");
    }

    private int getInt() {
        return (this.rawdata[0] & 0xFF) + ((this.rawdata[1] & 0xFF) << 8) + ((this.rawdata[2] & 0xFF) << 16) + ((this.rawdata[3] & 0xFF) << 24);
    }

    private long getLong() {
        return ((long)this.rawdata[0] & 0xFFL) + (((long)this.rawdata[1] & 0xFFL) << 8) + (((long)this.rawdata[2] & 0xFFL) << 16) + (((long)this.rawdata[3] & 0xFFL) << 24);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PupNumericDataResponse:() from " + this.getIn().getUnitNumber() + "\n").append("  attributeName:" + this.attributeName).append("  is first attribute:" + this.isFirst()).append("  is last attribute :" + this.isLast() + "\n").append("  dataType     :" + this.dataType + "\n").append("  data         :" + ByteArrayUtil.toHexString((byte[])this.rawdata) + "\n").append("  text         :" + this.text);
        return sb.toString();
    }
}

