/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupRegionNameResponse;
import com.tridium.aapup.messages.PupResponse;

public class PupLookupNamedRegionMessage
extends PupMessage
implements AaPupConst {
    private String regionName;
    private int regionNameLength;
    private int regionNumber;

    public PupLookupNamedRegionMessage(int targetUnitNumber, String name) {
        super(targetUnitNumber);
        this.regionName = name.length() > 8 ? name.substring(0, 8) : name;
        this.regionNameLength = this.regionName.length();
        this.regionNumber = 0;
    }

    public PupLookupNamedRegionMessage(int targetUnitNumber, int regionNumber) {
        super(targetUnitNumber);
        this.regionNumber = regionNumber;
        if (regionNumber < 0) {
            this.regionNumber = 0;
        }
        if (regionNumber > 255) {
            this.regionNumber = 255;
        }
        this.regionName = "";
        this.regionNameLength = 0;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String name) {
        this.regionName = name.length() > 8 ? name.substring(0, 8) : name;
        this.regionNameLength = this.regionName.length();
        this.regionNumber = 0;
    }

    public int getRegionNumber() {
        return this.regionNumber;
    }

    public void setRegionNumber(int num) {
        this.regionNumber = num;
        if (num < 0) {
            this.regionNumber = 0;
        }
        if (num > 255) {
            this.regionNumber = 255;
        }
        this.regionName = "";
        this.regionNameLength = 0;
    }

    @Override
    void writeBytes(PupOutputStream out) {
        if (this.regionNameLength == 0) {
            out.write(7);
        } else {
            out.write(6 + this.regionNameLength);
        }
        out.write(8);
        out.write(this.regionNameLength);
        if (this.regionNameLength == 0) {
            out.write(this.regionNumber);
        } else {
            out.writeString(this.regionName);
        }
    }

    @Override
    PupResponse getResponse(PupReceivedMessage rcvdMsg) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (rcvdMsg.getData()[4] == -128) {
            return new PupErrorResponse(rcvdMsg);
        }
        if (rcvdMsg.getData()[4] == -121) {
            return new PupRegionNameResponse(rcvdMsg);
        }
        return new PupErrorResponse(rcvdMsg);
    }

    @Override
    public String toString() {
        return "PupLookupNamedRegionMessage::unit:" + this.unitNumber + " regionName:" + this.regionName + " regionNumber:" + this.regionNumber;
    }
}

