/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.job;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.datatypes.BDownloadRegionParams;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupCreateNamedRegionMessage;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupFreeRegionMessage;
import com.tridium.aapup.messages.PupHelloMessage;
import com.tridium.aapup.messages.PupRegionNameResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupWriteRegionDataMessage;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BBlob;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BPupDownloadRegionJob
extends BSimpleJob
implements AaPupConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BPupDownloadRegionJob.class);
    private BPupNetwork network;
    private BPupDevice device;
    private BDownloadRegionParams params;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPupDownloadRegionJob() {
    }

    public BPupDownloadRegionJob(BPupDevice device, BDownloadRegionParams params) {
        this.device = device;
        this.params = params;
        this.network = device.pupNetwork();
    }

    public void run(Context cx) throws Exception {
        PupErrorResponse errRsp;
        boolean problem = true;
        if (this.device == null) {
            throw new IllegalStateException("Must submit thru PupDevice.submitDeviceDiscoveryJob()");
        }
        byte[] splBytes = this.getSplBytes();
        int regionNumber = 0;
        String regionName = "";
        int bufferSize = 0;
        String errorMsg = "";
        if (!this.isAlive()) {
            return;
        }
        this.logMessage("Creating region " + this.params.getRegionName() + " and will download from file " + this.params.getSplFile());
        int address = this.device.getUnitNumber();
        PupResponse rsp = (PupResponse)this.network.sendSync(new PupHelloMessage(this.device.getSerialNumber() | 0x8000));
        if (rsp != null && rsp.getIn().verifyChecksum() && rsp instanceof PupAckResponse) {
            address = this.device.getSerialNumber() | 0x8000;
        }
        if ((rsp = (PupResponse)this.network.sendSync(new PupCreateNamedRegionMessage(address, this.params.getRegionName(), this.params.getRegionType(), splBytes.length))) != null && rsp.getIn().verifyChecksum() && rsp instanceof PupRegionNameResponse) {
            PupRegionNameResponse nameRsp = (PupRegionNameResponse)rsp;
            regionNumber = nameRsp.getRegionNumber();
            regionName = nameRsp.getRegionName();
            bufferSize = nameRsp.getRegionAvailableBufferSize();
            problem = false;
        }
        if (problem) {
            this.failed(new Throwable("error creating region " + this.params.getRegionName() + " in device" + this.device.getUnitNumber()));
            return;
        }
        this.logMessage("created region " + this.params.getRegionName() + " in device" + this.device.getUnitNumber());
        this.progress(10);
        if ((bufferSize /= 2) > 512) {
            bufferSize = 512;
        }
        int iterations = splBytes.length / bufferSize;
        if (splBytes.length % bufferSize > 0) {
            ++iterations;
        }
        this.logMessage("sending " + splBytes.length + " bytes, using buffer size " + bufferSize);
        for (int i = 0; i < iterations; ++i) {
            problem = true;
            byte[] data = (i + 1) * bufferSize <= splBytes.length ? new byte[bufferSize] : new byte[splBytes.length % bufferSize];
            System.arraycopy(splBytes, i * bufferSize, data, 0, data.length);
            rsp = (PupResponse)this.network.sendSync(new PupWriteRegionDataMessage(address, regionNumber, i * bufferSize, data), BRelTime.make((long)(this.network.getResponseTimeout().getMillis() * 3L)), 0);
            if (rsp != null) {
                if (rsp.getIn().verifyChecksum()) {
                    if (rsp instanceof PupAckResponse) {
                        problem = false;
                        this.logMessage("buffer " + i + " of size " + data.length + " sent successfully");
                    }
                    if (rsp instanceof PupErrorResponse) {
                        errRsp = (PupErrorResponse)rsp;
                        errorMsg = errRsp.getError();
                    }
                } else {
                    errorMsg = "bad checksum";
                }
            } else {
                errorMsg = "no response";
            }
            if (!problem) continue;
            this.failed(new Throwable("error writing region data: " + errorMsg));
            return;
        }
        this.progress(90);
        this.logMessage("finished downloading region:" + regionNumber + "(" + regionName + ")");
        rsp = (PupResponse)this.network.sendSync(new PupFreeRegionMessage(this.device.getUnitNumber(), regionNumber, false));
        if (rsp != null) {
            if (rsp.getIn().verifyChecksum()) {
                if (rsp instanceof PupAckResponse) {
                    problem = false;
                }
                if (rsp instanceof PupErrorResponse) {
                    errRsp = (PupErrorResponse)rsp;
                    errorMsg = errRsp.getError();
                }
            } else {
                errorMsg = "bad checksum";
            }
        } else {
            errorMsg = "no response";
        }
        if (problem) {
            this.failed(new Throwable("error unlocking region: " + errorMsg));
            return;
        }
        this.logMessage("unlocked region:" + regionNumber + "(" + regionName + ")");
        this.device.fireRegionChanged((BValue)BString.make((String)""));
        this.progress(100);
    }

    private byte[] getSplBytes() throws IOException {
        BBlob blobFromClient = this.params.getSplBlob();
        if (blobFromClient == null || blobFromClient.copyBytes().length == 0) {
            this.logMessage("blob is null, checking to see if it is a station file ord");
            BOrd stationFileOrd = this.params.getSplFile();
            if (stationFileOrd != null) {
                this.logMessage("found station file ord");
                BIFile splFile = (BIFile)stationFileOrd.resolve().get();
                try (InputStream splIn = splFile.getInputStream();){
                    ByteBuffer splBytes = new ByteBuffer(splIn.available());
                    splBytes.readToEnd(splIn);
                    byte[] byArray = splBytes.toByteArray();
                    return byArray;
                }
            }
            throw new IllegalStateException("Oops...forgot to pass enough info about the firmware file to station VM.");
        }
        this.logMessage("file data is from blob");
        return blobFromClient.copyBytes();
    }

    private void logMessage(String message) {
        this.log().message(message);
        if (this.network != null) {
            int severity = this.network.getLog().getSeverity();
            this.network.getLog().setSeverity(1);
            this.network.getLog().message("Download Region Job:" + message);
            this.network.getLog().setSeverity(severity);
        }
    }
}

