/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.datatypes;

import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.enums.BPupPeerTypeEnum;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="tokenPassingEnabled", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(\"enabled\",\"disabled\")")}), @NiagaraProperty(name="passToDownDevices", type="boolean", defaultValue="false"), @NiagaraProperty(name="peerType", type="BPupPeerTypeEnum", defaultValue="BPupPeerTypeEnum.fullAdminRoundRobin", flags=1), @NiagaraProperty(name="tokenRecovery", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(\"enabled\",\"disabled\")")}), @NiagaraProperty(name="tokenRecoveryType", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.makeBoolean(\"No Token Passes Detected\",\"No Bus Activity Detected\")")}), @NiagaraProperty(name="tokenRecoveryTimeout", type="BRelTime", defaultValue="BRelTime.make(1000L)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(500L), BFacets.MAX, BRelTime.make(Long.MAX_VALUE))")}), @NiagaraProperty(name="tokenRecoveryCount", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="passTokenOnTransactionCount", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.makeBoolean(\"enabled\",\"disabled\")")}), @NiagaraProperty(name="transactionsPerToken", type="int", defaultValue="10"), @NiagaraProperty(name="passTokenOnTimeout", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(\"enabled\",\"disabled\")")}), @NiagaraProperty(name="timePerToken", type="BRelTime", defaultValue="BRelTime.make(1000L)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(200L), BFacets.MAX, BRelTime.make(Long.MAX_VALUE))")}), @NiagaraProperty(name="tokenSnoop", type="String", defaultValue="", flags=3, facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE, BFacets.FIELD_WIDTH, BInteger.make(64))")}), @NiagaraProperty(name="logTokenSnoopOnTokenRecovery", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="resetTokenRecoveryCount"), @NiagaraAction(name="logTokenSnoop"), @NiagaraAction(name="clearTokenSnoop")})
public class BPupTokenPassConfig
extends BComponent {
    @Generated
    public static final Property tokenPassingEnabled = BPupTokenPassConfig.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    @Generated
    public static final Property passToDownDevices = BPupTokenPassConfig.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property peerType = BPupTokenPassConfig.newProperty((int)1, (BValue)BPupPeerTypeEnum.fullAdminRoundRobin, null);
    @Generated
    public static final Property tokenRecovery = BPupTokenPassConfig.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    @Generated
    public static final Property tokenRecoveryType = BPupTokenPassConfig.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"No Token Passes Detected", (String)"No Bus Activity Detected"));
    @Generated
    public static final Property tokenRecoveryTimeout = BPupTokenPassConfig.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)500L), (String)"max", (BIDataValue)BRelTime.make((long)Long.MAX_VALUE)));
    @Generated
    public static final Property tokenRecoveryCount = BPupTokenPassConfig.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property passTokenOnTransactionCount = BPupTokenPassConfig.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    @Generated
    public static final Property transactionsPerToken = BPupTokenPassConfig.newProperty((int)0, (int)10, null);
    @Generated
    public static final Property passTokenOnTimeout = BPupTokenPassConfig.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    @Generated
    public static final Property timePerToken = BPupTokenPassConfig.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)200L), (String)"max", (BIDataValue)BRelTime.make((long)Long.MAX_VALUE)));
    @Generated
    public static final Property tokenSnoop = BPupTokenPassConfig.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"fieldWidth", (BIDataValue)BInteger.make((int)64)));
    @Generated
    public static final Property logTokenSnoopOnTokenRecovery = BPupTokenPassConfig.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action resetTokenRecoveryCount = BPupTokenPassConfig.newAction((int)0, null);
    @Generated
    public static final Action logTokenSnoop = BPupTokenPassConfig.newAction((int)0, null);
    @Generated
    public static final Action clearTokenSnoop = BPupTokenPassConfig.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPupTokenPassConfig.class);
    private static int TOKEN_SNOOP_SIZE = 8;
    private String[] snoops;

    @Generated
    public boolean getTokenPassingEnabled() {
        return this.getBoolean(tokenPassingEnabled);
    }

    @Generated
    public void setTokenPassingEnabled(boolean v) {
        this.setBoolean(tokenPassingEnabled, v, null);
    }

    @Generated
    public boolean getPassToDownDevices() {
        return this.getBoolean(passToDownDevices);
    }

    @Generated
    public void setPassToDownDevices(boolean v) {
        this.setBoolean(passToDownDevices, v, null);
    }

    @Generated
    public BPupPeerTypeEnum getPeerType() {
        return (BPupPeerTypeEnum)this.get(peerType);
    }

    @Generated
    public void setPeerType(BPupPeerTypeEnum v) {
        this.set(peerType, (BValue)v, null);
    }

    @Generated
    public boolean getTokenRecovery() {
        return this.getBoolean(tokenRecovery);
    }

    @Generated
    public void setTokenRecovery(boolean v) {
        this.setBoolean(tokenRecovery, v, null);
    }

    @Generated
    public boolean getTokenRecoveryType() {
        return this.getBoolean(tokenRecoveryType);
    }

    @Generated
    public void setTokenRecoveryType(boolean v) {
        this.setBoolean(tokenRecoveryType, v, null);
    }

    @Generated
    public BRelTime getTokenRecoveryTimeout() {
        return (BRelTime)this.get(tokenRecoveryTimeout);
    }

    @Generated
    public void setTokenRecoveryTimeout(BRelTime v) {
        this.set(tokenRecoveryTimeout, (BValue)v, null);
    }

    @Generated
    public int getTokenRecoveryCount() {
        return this.getInt(tokenRecoveryCount);
    }

    @Generated
    public void setTokenRecoveryCount(int v) {
        this.setInt(tokenRecoveryCount, v, null);
    }

    @Generated
    public boolean getPassTokenOnTransactionCount() {
        return this.getBoolean(passTokenOnTransactionCount);
    }

    @Generated
    public void setPassTokenOnTransactionCount(boolean v) {
        this.setBoolean(passTokenOnTransactionCount, v, null);
    }

    @Generated
    public int getTransactionsPerToken() {
        return this.getInt(transactionsPerToken);
    }

    @Generated
    public void setTransactionsPerToken(int v) {
        this.setInt(transactionsPerToken, v, null);
    }

    @Generated
    public boolean getPassTokenOnTimeout() {
        return this.getBoolean(passTokenOnTimeout);
    }

    @Generated
    public void setPassTokenOnTimeout(boolean v) {
        this.setBoolean(passTokenOnTimeout, v, null);
    }

    @Generated
    public BRelTime getTimePerToken() {
        return (BRelTime)this.get(timePerToken);
    }

    @Generated
    public void setTimePerToken(BRelTime v) {
        this.set(timePerToken, (BValue)v, null);
    }

    @Generated
    public String getTokenSnoop() {
        return this.getString(tokenSnoop);
    }

    @Generated
    public void setTokenSnoop(String v) {
        this.setString(tokenSnoop, v, null);
    }

    @Generated
    public boolean getLogTokenSnoopOnTokenRecovery() {
        return this.getBoolean(logTokenSnoopOnTokenRecovery);
    }

    @Generated
    public void setLogTokenSnoopOnTokenRecovery(boolean v) {
        this.setBoolean(logTokenSnoopOnTokenRecovery, v, null);
    }

    @Generated
    public void resetTokenRecoveryCount() {
        this.invoke(resetTokenRecoveryCount, null, null);
    }

    @Generated
    public void logTokenSnoop() {
        this.invoke(logTokenSnoop, null, null);
    }

    @Generated
    public void clearTokenSnoop() {
        this.invoke(clearTokenSnoop, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.snoops = new String[TOKEN_SNOOP_SIZE];
        for (int i = 0; i < this.snoops.length; ++i) {
            this.snoops[i] = "";
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        BPupNetwork parent = (BPupNetwork)this.getParent();
        if (parent != null) {
            if (property == tokenPassingEnabled) {
                if (this.getTokenPassingEnabled()) {
                    if (this.getPassTokenOnTimeout()) {
                        if (this.getTokenPassingEnabled()) {
                            parent.initializeTokenTimer();
                        } else {
                            parent.cancelTokenTimer();
                        }
                    }
                } else {
                    parent.cancelTokenTimer();
                    parent.cancelTokenRecoveryTimer();
                }
            }
            if (property == passTokenOnTimeout) {
                if (this.getPassTokenOnTimeout()) {
                    parent.initializeTokenTimer();
                } else {
                    parent.cancelTokenTimer();
                }
            } else if (property == timePerToken) {
                parent.initializeTokenTimer();
            } else if (property == tokenRecovery || property == tokenRecoveryTimeout) {
                if (this.getTokenRecovery()) {
                    parent.initializeTokenRecoveryTimer();
                } else {
                    parent.cancelTokenRecoveryTimer();
                }
            }
        }
    }

    public void doResetTokenRecoveryCount() {
        this.setTokenRecoveryCount(0);
    }

    public void incrementTokenRecoveryCount() {
        this.setTokenRecoveryCount(this.getTokenRecoveryCount() + 1);
    }

    public void appendTokenSnoop(String txt) {
        this.snoops[0] = this.snoops[0] + txt;
        if (txt.endsWith("\n") || txt.endsWith("*recover*") || this.snoops[0].length() > 60) {
            System.arraycopy(this.snoops, 0, this.snoops, 1, this.snoops.length - 1);
            this.snoops[0] = "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = TOKEN_SNOOP_SIZE; i > 0; --i) {
            sb.append(this.snoops[i - 1]);
        }
        this.setTokenSnoop(sb.toString());
    }

    public void doLogTokenSnoop() {
        BPupNetwork parent = (BPupNetwork)this.getParent();
        if (parent != null) {
            parent.getPupLog().info("TokenSnoop:\n" + this.getTokenSnoop());
        }
    }

    public void doClearTokenSnoop() {
        for (int i = 0; i < TOKEN_SNOOP_SIZE; ++i) {
            this.snoops[i] = "";
        }
        this.setTokenSnoop("");
    }
}

