/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.BPupRegionsFolder;
import com.tridium.aapup.datatypes.BDownloadRegionParams;
import com.tridium.aapup.datatypes.BPupPointDiscoveryConfig;
import com.tridium.aapup.datatypes.BUploadRegionParams;
import com.tridium.aapup.enums.BPingMessageSelectionEnum;
import com.tridium.aapup.enums.BPupPeerTypeEnum;
import com.tridium.aapup.job.BPupDiscoverPointsJob;
import com.tridium.aapup.job.BPupDownloadRegionJob;
import com.tridium.aapup.job.BPupLearnRegionsJob;
import com.tridium.aapup.job.BPupUploadRegionJob;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupAcknowledgeTransactionMessage;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupFreeRegionMessage;
import com.tridium.aapup.messages.PupHelloMessage;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupReadAttributeMessage;
import com.tridium.aapup.messages.PupReportExceptionMessage;
import com.tridium.aapup.messages.PupReportExceptionResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTimeSyncMessage;
import com.tridium.aapup.point.BPupPointDeviceExt;
import com.tridium.basicdriver.BBasicDevice;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="unitNumber", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(0,0xFFFF)")}), @NiagaraProperty(name="manufacturer", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="controllerType", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="serialNumber", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="controllerDescription", type="String", defaultValue="", flags=1), @NiagaraProperty(name="peerType", type="BPupPeerTypeEnum", defaultValue="BPupPeerTypeEnum.slave", flags=1), @NiagaraProperty(name="allowTokenPassingToThisDevice", type="boolean", defaultValue="true"), @NiagaraProperty(name="version", type="boolean", defaultValue="false", flags=1, facets={@Facet(value="BFacets.makeBoolean(\"version 8 supported\",\"version 8 not supported\")")}), @NiagaraProperty(name="pingMessageType", type="BPingMessageSelectionEnum", defaultValue="BPingMessageSelectionEnum.reportExceptionMessage"), @NiagaraProperty(name="nativeAlarmSourceInfo", type="BAlarmSourceInfo", defaultValue="new BAlarmSourceInfo()"), @NiagaraProperty(name="regions", type="BPupRegionsFolder", defaultValue="new BPupRegionsFolder()", flags=6), @NiagaraProperty(name="points", type="BPupPointDeviceExt", defaultValue="new BPupPointDeviceExt()"), @NiagaraProperty(name="splFile", type="BOrd", defaultValue="BOrd.make(\"local:|file:/default.plb\")", flags=4), @NiagaraProperty(name="allowTimeSync", type="boolean", defaultValue="true")})
@NiagaraActions(value={@NiagaraAction(name="submitPointDiscoveryJob", parameterType="BPupPointDiscoveryConfig", defaultValue="new BPupPointDiscoveryConfig()", returnType="BOrd", flags=4), @NiagaraAction(name="submitLearnRegionsJob", parameterType="BInteger", defaultValue="BInteger.make(-1)", returnType="BOrd", flags=4), @NiagaraAction(name="submitDownloadSplJob", parameterType="BDownloadRegionParams", defaultValue="new BDownloadRegionParams()", returnType="BOrd", flags=4), @NiagaraAction(name="submitUploadRegionJob", parameterType="BUploadRegionParams", defaultValue="new BUploadRegionParams()", returnType="BOrd", flags=4), @NiagaraAction(name="genTestAlm", flags=4), @NiagaraAction(name="syncTime"), @NiagaraAction(name="freeRegion", parameterType="BInteger", defaultValue="BInteger.make(-1)", flags=4), @NiagaraAction(name="unlockRegion", parameterType="BInteger", defaultValue="BInteger.make(-1)", flags=4), @NiagaraAction(name="readDeviceValues")})
@NiagaraTopic(name="regionChanged")
public class BPupDevice
extends BBasicDevice
implements AaPupConst,
BIAlarmSource {
    @Generated
    public static final Property unitNumber = BPupDevice.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)65535));
    @Generated
    public static final Property manufacturer = BPupDevice.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property controllerType = BPupDevice.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property serialNumber = BPupDevice.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property controllerDescription = BPupDevice.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property peerType = BPupDevice.newProperty((int)1, (BValue)BPupPeerTypeEnum.slave, null);
    @Generated
    public static final Property allowTokenPassingToThisDevice = BPupDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property version = BPupDevice.newProperty((int)1, (boolean)false, (BFacets)BFacets.makeBoolean((String)"version 8 supported", (String)"version 8 not supported"));
    @Generated
    public static final Property pingMessageType = BPupDevice.newProperty((int)0, (BValue)BPingMessageSelectionEnum.reportExceptionMessage, null);
    @Generated
    public static final Property nativeAlarmSourceInfo = BPupDevice.newProperty((int)0, (BValue)new BAlarmSourceInfo(), null);
    @Generated
    public static final Property regions = BPupDevice.newProperty((int)6, (BValue)new BPupRegionsFolder(), null);
    @Generated
    public static final Property points = BPupDevice.newProperty((int)0, (BValue)new BPupPointDeviceExt(), null);
    @Generated
    public static final Property splFile = BPupDevice.newProperty((int)4, (BValue)BOrd.make((String)"local:|file:/default.plb"), null);
    @Generated
    public static final Property allowTimeSync = BPupDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action submitPointDiscoveryJob = BPupDevice.newAction((int)4, (BValue)new BPupPointDiscoveryConfig(), null);
    @Generated
    public static final Action submitLearnRegionsJob = BPupDevice.newAction((int)4, (BValue)BInteger.make((int)-1), null);
    @Generated
    public static final Action submitDownloadSplJob = BPupDevice.newAction((int)4, (BValue)new BDownloadRegionParams(), null);
    @Generated
    public static final Action submitUploadRegionJob = BPupDevice.newAction((int)4, (BValue)new BUploadRegionParams(), null);
    @Generated
    public static final Action genTestAlm = BPupDevice.newAction((int)4, null);
    @Generated
    public static final Action syncTime = BPupDevice.newAction((int)0, null);
    @Generated
    public static final Action freeRegion = BPupDevice.newAction((int)4, (BValue)BInteger.make((int)-1), null);
    @Generated
    public static final Action unlockRegion = BPupDevice.newAction((int)4, (BValue)BInteger.make((int)-1), null);
    @Generated
    public static final Action readDeviceValues = BPupDevice.newAction((int)0, null);
    @Generated
    public static final Topic regionChanged = BPupDevice.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPupDevice.class);
    private int oldUnitNumber;
    private AlarmSupport alarmSupport;
    public static Lexicon LEXICON = Lexicon.make((String)"aapup");

    @Generated
    public int getUnitNumber() {
        return this.getInt(unitNumber);
    }

    @Generated
    public void setUnitNumber(int v) {
        this.setInt(unitNumber, v, null);
    }

    @Generated
    public int getManufacturer() {
        return this.getInt(manufacturer);
    }

    @Generated
    public void setManufacturer(int v) {
        this.setInt(manufacturer, v, null);
    }

    @Generated
    public int getControllerType() {
        return this.getInt(controllerType);
    }

    @Generated
    public void setControllerType(int v) {
        this.setInt(controllerType, v, null);
    }

    @Generated
    public int getSerialNumber() {
        return this.getInt(serialNumber);
    }

    @Generated
    public void setSerialNumber(int v) {
        this.setInt(serialNumber, v, null);
    }

    @Generated
    public String getControllerDescription() {
        return this.getString(controllerDescription);
    }

    @Generated
    public void setControllerDescription(String v) {
        this.setString(controllerDescription, v, null);
    }

    @Generated
    public BPupPeerTypeEnum getPeerType() {
        return (BPupPeerTypeEnum)this.get(peerType);
    }

    @Generated
    public void setPeerType(BPupPeerTypeEnum v) {
        this.set(peerType, (BValue)v, null);
    }

    @Generated
    public boolean getAllowTokenPassingToThisDevice() {
        return this.getBoolean(allowTokenPassingToThisDevice);
    }

    @Generated
    public void setAllowTokenPassingToThisDevice(boolean v) {
        this.setBoolean(allowTokenPassingToThisDevice, v, null);
    }

    @Generated
    public boolean getVersion() {
        return this.getBoolean(version);
    }

    @Generated
    public void setVersion(boolean v) {
        this.setBoolean(version, v, null);
    }

    @Generated
    public BPingMessageSelectionEnum getPingMessageType() {
        return (BPingMessageSelectionEnum)this.get(pingMessageType);
    }

    @Generated
    public void setPingMessageType(BPingMessageSelectionEnum v) {
        this.set(pingMessageType, (BValue)v, null);
    }

    @Generated
    public BAlarmSourceInfo getNativeAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(nativeAlarmSourceInfo);
    }

    @Generated
    public void setNativeAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(nativeAlarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public BPupRegionsFolder getRegions() {
        return (BPupRegionsFolder)this.get(regions);
    }

    @Generated
    public void setRegions(BPupRegionsFolder v) {
        this.set(regions, (BValue)v, null);
    }

    @Generated
    public BPupPointDeviceExt getPoints() {
        return (BPupPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BPupPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public BOrd getSplFile() {
        return (BOrd)this.get(splFile);
    }

    @Generated
    public void setSplFile(BOrd v) {
        this.set(splFile, (BValue)v, null);
    }

    @Generated
    public boolean getAllowTimeSync() {
        return this.getBoolean(allowTimeSync);
    }

    @Generated
    public void setAllowTimeSync(boolean v) {
        this.setBoolean(allowTimeSync, v, null);
    }

    @Generated
    public BOrd submitPointDiscoveryJob(BPupPointDiscoveryConfig parameter) {
        return (BOrd)this.invoke(submitPointDiscoveryJob, (BValue)parameter, null);
    }

    @Generated
    public BOrd submitLearnRegionsJob(BInteger parameter) {
        return (BOrd)this.invoke(submitLearnRegionsJob, (BValue)parameter, null);
    }

    @Generated
    public BOrd submitDownloadSplJob(BDownloadRegionParams parameter) {
        return (BOrd)this.invoke(submitDownloadSplJob, (BValue)parameter, null);
    }

    @Generated
    public BOrd submitUploadRegionJob(BUploadRegionParams parameter) {
        return (BOrd)this.invoke(submitUploadRegionJob, (BValue)parameter, null);
    }

    @Generated
    public void genTestAlm() {
        this.invoke(genTestAlm, null, null);
    }

    @Generated
    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    @Generated
    public void freeRegion(BInteger parameter) {
        this.invoke(freeRegion, (BValue)parameter, null);
    }

    @Generated
    public void unlockRegion(BInteger parameter) {
        this.invoke(unlockRegion, (BValue)parameter, null);
    }

    @Generated
    public void readDeviceValues() {
        this.invoke(readDeviceValues, null, null);
    }

    @Generated
    public void fireRegionChanged(BValue event) {
        this.fire(regionChanged, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPupDevice() {
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    public void started() throws Exception {
        super.started();
        if (this.getAllowTokenPassingToThisDevice() && this.pupNetwork().getTokenPassConfig().getTokenPassingEnabled()) {
            this.pupNetwork().getPeerList().addRecord(this.getUnitNumber(), this.getPeerType());
        }
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getNativeAlarmSourceInfo());
        this.oldUnitNumber = this.getUnitNumber();
        this.readDeviceValues();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == unitNumber) {
            this.readDeviceValues();
        }
        if (property == unitNumber || property == peerType) {
            this.pupNetwork().getPeerList().removeRecord(this.oldUnitNumber);
            this.oldUnitNumber = this.getUnitNumber();
            if (this.getAllowTokenPassingToThisDevice() && this.pupNetwork().getTokenPassConfig().getTokenPassingEnabled()) {
                this.pupNetwork().getPeerList().addRecord(this.getUnitNumber(), this.getPeerType());
            }
        }
        if (property == allowTokenPassingToThisDevice) {
            if (this.getAllowTokenPassingToThisDevice()) {
                if (this.pupNetwork().getTokenPassConfig().getTokenPassingEnabled()) {
                    this.pupNetwork().getPeerList().addRecord(this.getUnitNumber(), this.getPeerType());
                }
            } else {
                this.pupNetwork().getPeerList().removeRecord(this.getUnitNumber());
            }
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.pupNetwork().getPeerList().removeRecord(this.getUnitNumber());
    }

    public Type getNetworkType() {
        return BPupNetwork.TYPE;
    }

    public BPupNetwork pupNetwork() {
        return (BPupNetwork)this.getNetwork();
    }

    public Logger getPupLog() {
        return this.pupNetwork().getPupLog();
    }

    public BOrd doSubmitPointDiscoveryJob(BPupPointDiscoveryConfig params, Context cx) {
        return new BPupDiscoverPointsJob(this, params).submit(cx);
    }

    public BOrd doSubmitLearnRegionsJob(BInteger unit, Context cx) {
        return new BPupLearnRegionsJob(this, unit.getInt()).submit(cx);
    }

    public BOrd doSubmitDownloadSplJob(BDownloadRegionParams params) {
        if (params == null) {
            return null;
        }
        return new BPupDownloadRegionJob(this, params).submit(null);
    }

    public BOrd doSubmitUploadRegionJob(BUploadRegionParams params) {
        if (params == null) {
            return null;
        }
        return new BPupUploadRegionJob(this, params).submit(null);
    }

    public void doPing() {
        this.getPupLog().fine("doPing " + this.getUnitNumber());
        switch (this.getPingMessageType().getOrdinal()) {
            case 0: {
                boolean moreExceptions = true;
                while (moreExceptions) {
                    PupReportExceptionMessage req = new PupReportExceptionMessage(this.getUnitNumber());
                    PupResponse rsp = (PupResponse)this.pupNetwork().sendSync(req);
                    if (rsp != null) {
                        if (rsp.getIn().verifyChecksum()) {
                            if (rsp.getIn().getUnitNumber() != this.getUnitNumber()) {
                                this.getPupLog().severe("Ping: Request to unit " + this.getUnitNumber() + " but received from " + rsp.getIn().getUnitNumber());
                                this.pingFail("Requested unit " + this.getUnitNumber() + " but received " + rsp.getIn().getUnitNumber());
                                return;
                            }
                            this.getPupLog().severe("Read Succeeded!");
                            if (rsp instanceof PupReportExceptionResponse) {
                                PupReportExceptionResponse excRsp = (PupReportExceptionResponse)rsp;
                                this.getPupLog().severe("ping " + this.getUnitNumber() + ":transaction = " + excRsp.getTransactionNumber());
                                if (excRsp.getTransactionNumber() == 0) {
                                    moreExceptions = false;
                                    this.pingOk();
                                    return;
                                }
                                this.generateAlarm(excRsp);
                                continue;
                            }
                            if (rsp instanceof PupErrorResponse) {
                                PupErrorResponse errRsp = (PupErrorResponse)rsp;
                                this.getPupLog().fine("Received error response pinging " + this.getUnitNumber());
                                this.pingFail(errRsp.getError());
                                return;
                            }
                            this.getPupLog().fine("Received invalid message type pinging " + this.getUnitNumber());
                            this.pingFail("invalid message type");
                            return;
                        }
                        this.getPupLog().fine("Checksum Error pinging " + this.getUnitNumber());
                        this.pingFail("Bad Checksum");
                        return;
                    }
                    this.getPupLog().fine("Ping Failed - no response pinging " + this.getUnitNumber());
                    this.pingFail("No Response");
                    return;
                }
                return;
            }
            case 1: {
                PupHelloMessage req = new PupHelloMessage(this.getUnitNumber());
                PupResponse rsp = (PupResponse)this.pupNetwork().sendSync(req);
                if (rsp != null) {
                    if (rsp.getIn().verifyChecksum()) {
                        if (rsp.getIn().getUnitNumber() != this.getUnitNumber()) {
                            this.getPupLog().severe("Ping: Request to unit " + this.getUnitNumber() + " but received from " + rsp.getIn().getUnitNumber());
                            this.pingFail("Requested unit " + this.getUnitNumber() + " but received " + rsp.getIn().getUnitNumber());
                            return;
                        }
                        this.getPupLog().fine("Read Succeeded!");
                        if (rsp instanceof PupAckResponse) {
                            this.getPupLog().fine("ping " + this.getUnitNumber());
                            this.pingOk();
                            return;
                        }
                        this.getPupLog().fine("Received invalid message type pinging " + this.getUnitNumber());
                        this.pingFail("invalid message type");
                        return;
                    }
                    this.getPupLog().fine("Checksum Error pinging " + this.getUnitNumber());
                    this.pingFail("Bad Checksum");
                    return;
                }
                this.getPupLog().fine("Ping Failed - no response pinging " + this.getUnitNumber());
                this.pingFail("No Response");
                return;
            }
            case 2: {
                PupReadAttributeMessage attreq = new PupReadAttributeMessage(this.getUnitNumber(), 65280, "ID");
                PupResponse attrsp = (PupResponse)this.pupNetwork().sendSync(attreq);
                if (attrsp != null) {
                    if (attrsp.getIn().verifyChecksum()) {
                        if (attrsp.getIn().getUnitNumber() != this.getUnitNumber()) {
                            this.getPupLog().severe("Ping: Request to unit " + this.getUnitNumber() + " but received from " + attrsp.getIn().getUnitNumber());
                            this.pingFail("Requested unit " + this.getUnitNumber() + " but received " + attrsp.getIn().getUnitNumber());
                            return;
                        }
                        this.getPupLog().fine("Read Succeeded!");
                        if (attrsp instanceof PupNumericDataResponse) {
                            this.getPupLog().fine("ping " + this.getUnitNumber());
                            this.pingOk();
                            return;
                        }
                        if (attrsp instanceof PupErrorResponse) {
                            PupErrorResponse errRsp = (PupErrorResponse)attrsp;
                            this.getPupLog().fine("Received error response pinging " + this.getUnitNumber());
                            this.pingFail(errRsp.getError());
                            return;
                        }
                        this.getPupLog().fine("Received invalid message type pinging " + this.getUnitNumber());
                        this.pingFail("invalid message type");
                        return;
                    }
                    this.getPupLog().fine("Checksum Error pinging " + this.getUnitNumber());
                    this.pingFail("Bad Checksum");
                    return;
                }
                this.getPupLog().fine("Ping Failed - no response pinging " + this.getUnitNumber());
                this.pingFail("No Response");
                return;
            }
        }
        this.pingFail("no message type for ping");
    }

    public void pingOk() {
        if (this.isDown()) {
            this.doSyncTime();
            this.doReadDeviceValues();
        }
        super.pingOk();
    }

    public void doGenTestAlm() {
        System.out.println("new test alarm");
        boolean test = true;
        PupReportExceptionResponse rsp = new PupReportExceptionResponse(test);
        System.out.println(rsp);
        System.out.println("calculated checksum:" + rsp.getIn().getCalculatedChecksum());
        this.generateAlarm(rsp);
    }

    public void doSyncTime() {
        if (this.getAllowTimeSync()) {
            this.getPupLog().fine("doSyncTime");
            PupTimeSyncMessage req = new PupTimeSyncMessage(this.getUnitNumber(), BAbsTime.now());
            req.setHoliday(this.pupNetwork().getHoliday().getBoolean());
            this.pupNetwork().sendSync(req);
        }
    }

    public void doUnlockRegion(BInteger bregion) {
        final int region = bregion.getInt();
        this.getPupLog().fine("doUnlockRegion:" + bregion.getInt());
        this.pupNetwork().post(new Runnable(){

            @Override
            public void run() {
                PupFreeRegionMessage msg = new PupFreeRegionMessage(BPupDevice.this.getUnitNumber(), region, false);
                PupResponse rsp = (PupResponse)BPupDevice.this.pupNetwork().sendSync(msg);
                if (rsp.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                    BPupDevice.this.getPupLog().severe("Unlock Region: Request to unit " + BPupDevice.this.getUnitNumber() + " but received from " + rsp.getIn().getUnitNumber());
                    return;
                }
                if (rsp instanceof PupAckResponse) {
                    BPupDevice.this.getPupLog().info("successfully unlocked region " + region);
                } else {
                    BPupDevice.this.getPupLog().severe("unable to unlock region " + region);
                }
                BPupDevice.this.fireRegionChanged((BValue)BString.make((String)""));
            }
        });
    }

    public void doFreeRegion(BInteger bregion) {
        final int region = bregion.getInt();
        this.getPupLog().fine("doFreeRegion:" + bregion.getInt());
        this.pupNetwork().post(new Runnable(){

            @Override
            public void run() {
                PupFreeRegionMessage msg = new PupFreeRegionMessage(BPupDevice.this.getUnitNumber(), region, true);
                PupResponse rsp = (PupResponse)BPupDevice.this.pupNetwork().sendSync(msg);
                if (rsp != null) {
                    if (rsp.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                        BPupDevice.this.getPupLog().severe("Free Region: Request to unit " + BPupDevice.this.getUnitNumber() + " but received from " + rsp.getIn().getUnitNumber());
                    } else if (rsp instanceof PupAckResponse) {
                        BPupDevice.this.getPupLog().info("successfully freed region " + region);
                    } else {
                        BPupDevice.this.getPupLog().severe("unable to free region " + region);
                    }
                }
                BPupDevice.this.fireRegionChanged((BValue)BString.make((String)""));
            }
        });
    }

    public void doReadDeviceValues() {
        this.getPupLog().fine("doReadDeviceValues:" + this.getUnitNumber());
        this.pupNetwork().post(new Runnable(){

            @Override
            public void run() {
                PupNumericDataResponse dataRsp;
                PupResponse rsp = (PupResponse)BPupDevice.this.pupNetwork().sendSync(new PupReadAttributeMessage(BPupDevice.this.getUnitNumber(), 65280, "CT"));
                if (rsp == null) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":no response while determining controller type, defaulting to -1");
                    BPupDevice.this.setControllerType(-1);
                } else if (!rsp.getIn().verifyChecksum()) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":checksum error while determining controller type, defaulting to -1");
                    BPupDevice.this.setControllerType(-1);
                } else if (rsp.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":while determining controller type, responding unit number " + rsp.getIn().getUnitNumber() + " does not equal requested unit number " + BPupDevice.this.getUnitNumber());
                    BPupDevice.this.setControllerType(-1);
                } else if (rsp instanceof PupNumericDataResponse) {
                    dataRsp = (PupNumericDataResponse)rsp;
                    BPupDevice.this.setControllerType(dataRsp.getDouble().getInt());
                    BPupDevice.this.getPupLog().info("unit " + BPupDevice.this.getUnitNumber() + ":controller type = " + BPupDevice.this.getControllerType());
                } else {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":invalid response type determining controller type, defaulting to -1");
                    BPupDevice.this.setControllerType(-1);
                }
                rsp = (PupResponse)BPupDevice.this.pupNetwork().sendSync(new PupReadAttributeMessage(BPupDevice.this.getUnitNumber(), 65280, "CM"));
                if (rsp == null) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":no response while determining manufactuer, defaulting to -1");
                    BPupDevice.this.setManufacturer(-1);
                } else if (!rsp.getIn().verifyChecksum()) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":checksum error while determining manufactuer, defaulting to -1");
                    BPupDevice.this.setManufacturer(-1);
                } else if (rsp.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":while determining manuf, responding unit number " + rsp.getIn().getUnitNumber() + " does not equal requested unit number " + BPupDevice.this.getUnitNumber());
                    BPupDevice.this.setManufacturer(-1);
                } else if (rsp instanceof PupNumericDataResponse) {
                    dataRsp = (PupNumericDataResponse)rsp;
                    BPupDevice.this.setManufacturer(dataRsp.getDouble().getInt());
                    BPupDevice.this.getPupLog().info("device " + BPupDevice.this.getUnitNumber() + " manufacturer = " + BPupDevice.this.getManufacturer());
                } else {
                    BPupDevice.this.getPupLog().severe("warning - " + BPupDevice.this.getUnitNumber() + ":unable to determine manufacturer, defaulting to -1");
                    BPupDevice.this.setManufacturer(-1);
                }
                int infoChannel = BPupDevice.this.getControllerType() < 100 ? 32768 : 65280;
                rsp = (PupResponse)BPupDevice.this.pupNetwork().sendSync(new PupReadAttributeMessage(BPupDevice.this.getUnitNumber(), infoChannel, "SN"));
                if (rsp == null) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":no response while determining sn, defaulting to 0");
                    BPupDevice.this.setSerialNumber(0);
                } else if (!rsp.getIn().verifyChecksum()) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":checksum error while determining sn, defaulting to 0");
                    BPupDevice.this.setSerialNumber(0);
                } else if (rsp.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":while determining sn, responding unit number " + rsp.getIn().getUnitNumber() + " does not equal requested unit number " + BPupDevice.this.getUnitNumber());
                    BPupDevice.this.setSerialNumber(0);
                } else if (rsp instanceof PupNumericDataResponse) {
                    dataRsp = (PupNumericDataResponse)rsp;
                    BPupDevice.this.setSerialNumber(dataRsp.getDouble().getInt() & Short.MAX_VALUE);
                } else {
                    BPupDevice.this.getPupLog().severe("warning - " + BPupDevice.this.getUnitNumber() + ":unable to determine serial number, defaulting to 0");
                    BPupDevice.this.setSerialNumber(0);
                }
                BPupDevice.this.getPupLog().info("device " + BPupDevice.this.getUnitNumber() + " serial number = " + BPupDevice.this.getSerialNumber());
                BPupDevice.this.setControllerDescription(BPupDevice.this.pupNetwork().getControllerDescription(BPupDevice.this.getManufacturer(), BPupDevice.this.getControllerType()));
                rsp = (PupResponse)BPupDevice.this.pupNetwork().sendSync(new PupReadAttributeMessage(BPupDevice.this.getUnitNumber(), 65280, "TP"));
                if (rsp == null) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":no response while determining peer type, defaulting to slave");
                    BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                } else if (!rsp.getIn().verifyChecksum()) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":checksum error while determining peer type, defaulting to slave");
                    BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                } else if (rsp.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                    BPupDevice.this.getPupLog().severe("unit " + BPupDevice.this.getUnitNumber() + ":while determining peer type, responding unit number " + rsp.getIn().getUnitNumber() + " does not equal requested unit number " + BPupDevice.this.getUnitNumber());
                    BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                } else if (rsp instanceof PupNumericDataResponse) {
                    dataRsp = (PupNumericDataResponse)rsp;
                    BPupDevice.this.setPeerType(BPupPeerTypeEnum.make(dataRsp.getDouble().getInt()));
                    BPupDevice.this.getPupLog().info("unit " + BPupDevice.this.getUnitNumber() + ":peer type = " + (Object)((Object)BPupDevice.this.getPeerType()));
                } else if (rsp instanceof PupErrorResponse) {
                    PupErrorResponse errRsp = (PupErrorResponse)rsp;
                    if (errRsp.getErrorNumber() == 65532) {
                        BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                        BPupDevice.this.getPupLog().info("unit " + BPupDevice.this.getUnitNumber() + ":peer type = " + (Object)((Object)BPupDevice.this.getPeerType()));
                    } else {
                        BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                        BPupDevice.this.getPupLog().info("unit " + BPupDevice.this.getUnitNumber() + ":error response = " + errRsp.getErrorNumber() + " ,defaulting to slave");
                    }
                } else {
                    BPupDevice.this.getPupLog().severe("warning - unit " + BPupDevice.this.getUnitNumber() + ":unable to determine peer type, defaulting to slave");
                    BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                }
            }
        });
    }

    public void generateAlarm(PupReportExceptionResponse rsp) {
        String[] keys = new String[2];
        BIDataValue[] values = new BIDataValue[2];
        String msgText = "unit:" + this.getUnitNumber() + " class:" + rsp.getExceptionClass() + " channel:" + Integer.toHexString(rsp.getExceptionChannel()) + " cause:" + rsp.getCause() + " desc:" + rsp.getExceptionText();
        keys[0] = "transaction";
        values[0] = BInteger.make((int)rsp.getTransactionNumber());
        keys[1] = "msgText";
        values[1] = BString.make((String)msgText);
        BFacets alarmFacets = BFacets.make((String[])keys, (BIDataValue[])values);
        try {
            if (rsp.isReturnToNormal()) {
                this.alarmSupport.toNormal(alarmFacets, null);
            } else {
                this.alarmSupport.newOffnormalAlarm(alarmFacets);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord alarmRecord) {
        this.getPupLog().fine("doAckAlarm:" + alarmRecord);
        BObject transaction = alarmRecord.getAlarmFacet("transaction");
        if (transaction == null) {
            return super.doAckAlarm(alarmRecord);
        }
        this.pupNetwork().post(new AlarmTransactionAck(this.pupNetwork(), alarmRecord, this));
        return BBoolean.make((boolean)false);
    }

    private class AlarmTransactionAck
    implements Runnable {
        BPupDevice source;
        BAlarmRecord alarmRecord;
        BPupNetwork basicNet;
        BRelTime responseTimeout;
        int retryCount;

        public AlarmTransactionAck(BPupNetwork basicNet, BAlarmRecord alarmRecord, BPupDevice source) {
            this.basicNet = basicNet;
            this.alarmRecord = alarmRecord;
            this.source = source;
            this.responseTimeout = BPupDevice.this.pupNetwork().getResponseTimeout();
            this.retryCount = BPupDevice.this.pupNetwork().getRetryCount();
        }

        @Override
        public void run() {
            if (this.source == null) {
                return;
            }
            BFacets alarmData = this.alarmRecord.getAlarmData();
            BInteger transaction = (BInteger)alarmData.get("transaction");
            PupAcknowledgeTransactionMessage req = new PupAcknowledgeTransactionMessage(this.source.getUnitNumber(), transaction.getInt());
            PupResponse response = (PupResponse)this.basicNet.sendSync(req, this.responseTimeout, this.retryCount);
            if (response == null) {
                BPupDevice.this.getPupLog().severe("Ack Alarm: no response, unit number " + BPupDevice.this.getUnitNumber());
                return;
            }
            if (response.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                BPupDevice.this.getPupLog().fine("Ack Alarm: Request to unit " + BPupDevice.this.getUnitNumber() + " but received from " + response.getIn().getUnitNumber());
                return;
            }
            if (response instanceof PupAckResponse) {
                try {
                    BPupDevice.this.alarmSupport.ackAlarm(this.alarmRecord);
                }
                catch (Exception e) {
                    BPupDevice.this.getPupLog().severe("unable to acknowledge exception from device " + this.source.getUnitNumber() + " ,transaction=" + transaction.getInt());
                }
                return;
            }
            if (response instanceof PupErrorResponse) {
                PupErrorResponse errRsp = (PupErrorResponse)response;
                if (errRsp.getErrorNumber() == 65534) {
                    BPupDevice.this.getPupLog().fine("device " + this.source.getUnitNumber() + " does not support native alarm ack");
                    try {
                        BPupDevice.this.alarmSupport.ackAlarm(this.alarmRecord);
                    }
                    catch (Exception e) {
                        BPupDevice.this.getPupLog().severe("unable to acknowledge exception from device " + this.source.getUnitNumber() + " ,transaction=" + transaction.getInt());
                    }
                    return;
                }
                BPupDevice.this.getPupLog().severe("error response acknowledging transaction from device " + this.source.getUnitNumber() + " ,transaction=" + transaction.getInt() + " ,error=" + errRsp.codeToString(errRsp.getErrorNumber()));
                return;
            }
            BPupDevice.this.getPupLog().severe("invalid response acknowledging transaction from device " + this.source.getUnitNumber() + " ,transaction=" + transaction.getInt());
        }
    }
}

