/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.schedule.ScheduleUtil;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BEnumSetSchedule;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BEnumSet;

@NiagaraType
@NiagaraProperty(name="set", type="BEnumSet", defaultValue="BEnumSet.DEFAULT", flags=0x10000000, facets={@Facet(name="BFacets.RANGE", value="BEnumRange.make(ScheduleUtil.weeksOfMonth)")}, override=true)
public class BWeekOfMonthSchedule
extends BEnumSetSchedule {
    @Generated
    public static final Property set = BWeekOfMonthSchedule.newProperty((int)0x10000000, (BValue)BEnumSet.DEFAULT, (BFacets)BFacets.make((String)"range", (BIDataValue)BEnumRange.make((String[])ScheduleUtil.weeksOfMonth)));
    @Generated
    public static final Type TYPE = Sys.loadType(BWeekOfMonthSchedule.class);
    BWeekday firstDayOfWeek = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static final int dayToWeek(int dayOfMonth) {
        while (dayOfMonth % 7 != 0) {
            ++dayOfMonth;
        }
        return dayOfMonth / 7;
    }

    public final int dayToCalWeek(BAbsTime at) {
        int dayOfMonth;
        int firstDayOfWeek;
        BAbsTime first = BAbsTime.make((int)at.getYear(), (BMonth)at.getMonth(), (int)1);
        int firstWeekday = first.getWeekday().getOrdinal();
        if (this.firstDayOfWeek == null) {
            this.firstDayOfWeek = this.findFirstDayOfWeek();
        }
        if ((firstDayOfWeek = this.firstDayOfWeek.getOrdinal()) > firstWeekday) {
            firstWeekday += 7;
        }
        if ((dayOfMonth = at.getDay() + firstWeekday - firstDayOfWeek) % 7 != 0) {
            dayOfMonth += 7 - dayOfMonth % 7;
        }
        return dayOfMonth / 7;
    }

    private BWeekday findFirstDayOfWeek() {
        BAbstractSchedule root = this.getRootSchedule();
        BOrd refBase = (BOrd)root.get("refBase");
        if (refBase != null) {
            BAbstractSchedule schedule = (BAbstractSchedule)refBase.resolve().get();
            return FoxRpcUtil.doSilentRpc((BISpaceNode)schedule, (String)"getFirstDayOfWeek", (Object[])new Object[0]).orElse(BWeekday.DEFAULT);
        }
        if (root.isMounted()) {
            return FoxRpcUtil.doSilentRpc((BISpaceNode)root, (String)"getFirstDayOfWeek", (Object[])new Object[0]).orElse(BWeekday.DEFAULT);
        }
        return root.getFirstDayOfWeek(null, null);
    }

    @Override
    public int getMax() {
        return 12;
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public boolean isAlwaysEffective() {
        if (super.isAlwaysEffective()) {
            return true;
        }
        BEnumSet set = this.getSet();
        if (!set.contains(1) && !set.contains(7)) {
            return false;
        }
        if (!(set.contains(1) && set.contains(2) || set.contains(8))) {
            return false;
        }
        if (!(set.contains(2) && set.contains(3) || set.contains(9))) {
            return false;
        }
        if (!(set.contains(3) && set.contains(4) || set.contains(10))) {
            return false;
        }
        if (!(set.contains(4) && (set.contains(5) || set.contains(6)) || set.contains(11))) {
            return false;
        }
        return set.contains(5) || set.contains(6) || set.contains(12);
    }

    @Override
    public boolean isEffective(BAbsTime at) {
        int wk = BWeekOfMonthSchedule.dayToWeek(at.getDay());
        int calWk = this.dayToCalWeek(at);
        if (this.isEffective(wk)) {
            return true;
        }
        if (this.isEffective(calWk + 6)) {
            return true;
        }
        if (this.contains(6)) {
            return at.getDay() > BAbsTime.getDaysInMonth((int)at.getYear(), (BMonth)at.getMonth()) - 7;
        }
        return false;
    }

    @Override
    public BAbsTime nextEvent(BAbsTime from) {
        if (this.isAlwaysEffective() || this.isNeverEffective()) {
            return null;
        }
        boolean effective = this.isEffective(from);
        from = BAbsTime.make((int)from.getYear(), (BMonth)from.getMonth(), (int)from.getDay(), (int)0, (int)0, (int)0, (int)0, (BTimeZone)from.getTimeZone());
        while (this.isEffective(from) == effective) {
            from = from.nextDay();
        }
        return from;
    }
}

