/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule;

import com.tridium.sys.Nre;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BIScheduleValidator;
import javax.baja.security.AuditEvent;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.util.BIValidator;
import javax.baja.util.Lexicon;

public abstract class ScheduleUtil {
    static Array<String> skipList = new Array((Object[])new String[]{"outSource", "out", "in", "nextValue", "nextTime", "nextTrigger", "lastTrigger"});
    static Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(ScheduleUtil.class).getModuleName());
    public static String[] weeksOfMonth = new String[]{ScheduleUtil.lex("week.anyWeek"), ScheduleUtil.lex("week.week") + SlotPath.escape((String)" 1"), ScheduleUtil.lex("week.week") + SlotPath.escape((String)" 2"), ScheduleUtil.lex("week.week") + SlotPath.escape((String)" 3"), ScheduleUtil.lex("week.week") + SlotPath.escape((String)" 4"), ScheduleUtil.lex("week.week") + SlotPath.escape((String)" 5"), ScheduleUtil.lex("dayofmonth.last7days"), ScheduleUtil.lex("week.calendarWeek") + SlotPath.escape((String)" 1"), ScheduleUtil.lex("week.calendarWeek") + SlotPath.escape((String)" 2"), ScheduleUtil.lex("week.calendarWeek") + SlotPath.escape((String)" 3"), ScheduleUtil.lex("week.calendarWeek") + SlotPath.escape((String)" 4"), ScheduleUtil.lex("week.calendarWeek") + SlotPath.escape((String)" 5"), ScheduleUtil.lex("week.calendarWeek") + SlotPath.escape((String)" 6")};
    public static String[] months = new String[]{SlotPath.escape((String)BMonth.january.getShortDisplayTag(null)), SlotPath.escape((String)BMonth.february.getShortDisplayTag(null)), SlotPath.escape((String)BMonth.march.getShortDisplayTag(null)), SlotPath.escape((String)BMonth.april.getShortDisplayTag(null)), SlotPath.escape((String)BMonth.may.getShortDisplayTag(null)), SlotPath.escape((String)BMonth.june.getShortDisplayTag(null)), SlotPath.escape((String)BMonth.july.getShortDisplayTag(null)), SlotPath.escape((String)BMonth.august.getShortDisplayTag(null)), SlotPath.escape((String)BMonth.september.getShortDisplayTag(null)), SlotPath.escape((String)BMonth.october.getShortDisplayTag(null)), SlotPath.escape((String)BMonth.november.getShortDisplayTag(null)), SlotPath.escape((String)BMonth.december.getShortDisplayTag(null)), ScheduleUtil.lex("month.jan_mar_may_jul_sep_nov"), ScheduleUtil.lex("month.feb_apr_jun_aug_oct_dec")};
    public static String[] weekdays = new String[]{SlotPath.escape((String)BWeekday.sunday.getDisplayTag(null)), SlotPath.escape((String)BWeekday.monday.getDisplayTag(null)), SlotPath.escape((String)BWeekday.tuesday.getDisplayTag(null)), SlotPath.escape((String)BWeekday.wednesday.getDisplayTag(null)), SlotPath.escape((String)BWeekday.thursday.getDisplayTag(null)), SlotPath.escape((String)BWeekday.friday.getDisplayTag(null)), SlotPath.escape((String)BWeekday.saturday.getDisplayTag(null))};
    public static String[] daysOfMonth = new String[32];

    public static void auditableCopyFrom(BComplex original, BComplex copy, Context cx) {
        try {
            if (original.isComponent()) {
                original.asComponent().lease(99);
            }
            if (copy.isComponent()) {
                copy.asComponent().lease(99);
            }
            ScheduleUtil.recursiveAuditableCopyFrom(original, copy, cx);
        }
        catch (Exception e) {
            e.printStackTrace();
            original.copyFrom(copy, cx);
        }
    }

    private static void recursiveAuditableCopyFrom(BComplex original, BComplex copy, Context cx) throws Exception {
        int j;
        int i;
        int j2;
        Property[] props = original.getPropertiesArray();
        Property[] copyProps = copy.getPropertiesArray();
        int[] handled = new int[props.length];
        int[] copyHandled = new int[copyProps.length];
        for (j2 = 0; j2 < copyProps.length; ++j2) {
            copyHandled[j2] = -1;
        }
        block1: for (i = 0; i < props.length; ++i) {
            handled[i] = -1;
            for (j = 0; j < copyProps.length; ++j) {
                if (!props[i].getName().equals(copyProps[j].getName())) continue;
                if (original.get(props[i]).isSimple()) {
                    if (!original.get(props[i]).equivalent((Object)copy.get(copyProps[j])) && !skipList.contains((Object)props[i].getName())) {
                        original.set(props[i], copy.get(copyProps[j]), cx);
                    }
                } else if (!original.get(props[i]).getType().equals(copy.get(copyProps[j]).getType())) {
                    BValue copyValue = copy.get(copyProps[j]).newCopy(true);
                    original.asComponent().set(props[i], copyValue.asValue(), cx);
                } else {
                    ScheduleUtil.recursiveAuditableCopyFrom(original.get(props[i]).asComplex(), copy.get(copyProps[j]).asComplex(), cx);
                }
                handled[i] = j;
                copyHandled[j] = i;
                continue block1;
            }
        }
        for (i = 0; i < props.length; ++i) {
            for (j = 0; j < copyProps.length; ++j) {
                if (handled[i] != -1 || copyHandled[j] != -1 || !original.isComponent() || !original.get(props[i]).equivalent((Object)copy.get(copyProps[j])) || props[i].isFrozen() || copyProps[j].isFrozen()) continue;
                handled[i] = j;
                copyHandled[j] = i;
                original.asComponent().rename(props[i], copyProps[j].getName(), cx);
            }
            if (handled[i] != -1 || props[i] == null || props[i].isFrozen() || Flags.isMetadata((BComplex)original, (Slot)props[i])) continue;
            original.asComponent().remove(props[i], cx);
        }
        for (j2 = 0; j2 < copyHandled.length; ++j2) {
            if (copyHandled[j2] != -1) continue;
            original.asComponent().add(copyProps[j2].getName() + "?", copy.get(copyProps[j2]).newCopy(true), cx);
        }
        if (original instanceof BDaySchedule) {
            return;
        }
        boolean reorderRequired = false;
        boolean handledFound = false;
        for (int j3 = copyProps.length - 1; j3 >= 0; --j3) {
            if (copyHandled[j3] == -1 && handledFound) {
                reorderRequired = true;
                continue;
            }
            handledFound = true;
        }
        if (!reorderRequired) {
            reorderRequired = ScheduleUtil.isOutOfOrder(handled);
        }
        if (reorderRequired) {
            Array dynamicProps = new Array(Property.class);
            for (int j4 = 0; j4 < copyProps.length; ++j4) {
                if (!copyProps[j4].isDynamic()) continue;
                dynamicProps.add((Object)original.getProperty(copyProps[j4].getName()));
            }
            if (!dynamicProps.isEmpty()) {
                original.asComponent().reorder((Property[])dynamicProps.trim(), cx);
            }
        }
    }

    public static void stationSideAuditableCopyFrom(BAbstractSchedule original, BAbstractSchedule copy, Context cx) {
        SlotPath slotPath;
        String auditSlotPath = null;
        BComponent comp = original.getParentComponent();
        if (comp != null && (slotPath = comp.getSlotPath()) != null) {
            auditSlotPath = slotPath.getBody();
        }
        ScheduleUtil.stationSideAuditableCopyFrom(original, copy, cx, auditSlotPath);
    }

    public static void stationSideAuditableCopyFrom(BAbstractSchedule original, BAbstractSchedule copy, Context cx, String auditSlotPath) {
        if (!original.getPermissions(cx).hasOperatorWrite()) {
            throw new PermissionException("" + original.asComponent().getPermissions(cx) + " < " + BPermissions.operatorWrite);
        }
        try {
            String username = "";
            if (cx != null && cx.getUser() != null) {
                username = cx.getUser().getUsername();
            }
            ScheduleUtil.stationSideRecursiveAuditableCopyFrom((BComplex)original, (BComplex)copy, username, auditSlotPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            original.copyFrom(copy, cx);
        }
    }

    private static void stationSideRecursiveAuditableCopyFrom(BComplex original, BComplex copy, String userName, String auditSlotPath) throws Exception {
        AuditEvent auditEvent;
        int i;
        int j;
        boolean audit = auditSlotPath != null && Nre.auditor != null && !userName.isEmpty();
        Property[] props = original.getPropertiesArray();
        Property[] copyProps = copy.getPropertiesArray();
        int[] handled = new int[props.length];
        int[] copyHandled = new int[copyProps.length];
        for (j = 0; j < copyProps.length; ++j) {
            copyHandled[j] = -1;
        }
        block1: for (i = 0; i < props.length; ++i) {
            handled[i] = -1;
            for (int j2 = 0; j2 < copyProps.length; ++j2) {
                if (!props[i].getName().equals(copyProps[j2].getName())) continue;
                if (original.get(props[i]).isSimple()) {
                    if (!(original.get(props[i]).equivalent((Object)copy.get(copyProps[j2])) || skipList.contains((Object)props[i].getName()) || props[i].getName().equals("lastModified"))) {
                        if (audit) {
                            auditEvent = new AuditEvent("Changed", auditSlotPath, props[i].getName(), original.get(props[i]).toString(), copy.get(copyProps[j2]).toString(), userName);
                            Nre.auditor.audit(auditEvent);
                        }
                        original.set(props[i], copy.get(copyProps[j2]));
                    }
                } else if (!skipList.contains((Object)props[i].getName())) {
                    if (!original.get(props[i]).getType().equals(copy.get(copyProps[j2]).getType())) {
                        BValue copyValue = copy.get(copyProps[j2]).newCopy(true);
                        if (audit) {
                            AuditEvent auditEvent2 = new AuditEvent("Changed", auditSlotPath, props[i].getName(), original.get(props[i]).toString(), copy.get(copyProps[j2]).toString(), userName);
                            Nre.auditor.audit(auditEvent2);
                        }
                        original.asComponent().set(props[i], copyValue.asValue());
                    } else {
                        String newAuditSlotPath = auditSlotPath != null ? auditSlotPath + '/' + props[i].getName() : null;
                        ScheduleUtil.stationSideRecursiveAuditableCopyFrom(original.get(props[i]).asComplex(), copy.get(copyProps[j2]).asComplex(), userName, newAuditSlotPath);
                    }
                }
                handled[i] = j2;
                copyHandled[j2] = i;
                continue block1;
            }
        }
        for (i = 0; i < props.length; ++i) {
            for (int j3 = 0; j3 < copyProps.length; ++j3) {
                if (handled[i] != -1 || copyHandled[j3] != -1 || !original.isComponent() || !original.get(props[i]).equivalent((Object)copy.get(copyProps[j3])) || props[i].isFrozen() || copyProps[j3].isFrozen()) continue;
                handled[i] = j3;
                copyHandled[j3] = i;
                if (audit) {
                    auditEvent = new AuditEvent("Renamed", auditSlotPath, props[i].getName(), "", copyProps[j3].getName(), userName);
                    Nre.auditor.audit(auditEvent);
                }
                original.asComponent().rename(props[i], copyProps[j3].getName());
            }
            if (handled[i] != -1 || props[i] == null || props[i].isFrozen() || Flags.isMetadata((BComplex)original, (Slot)props[i])) continue;
            if (audit) {
                AuditEvent auditEvent3 = new AuditEvent("Removed", auditSlotPath, props[i].getName(), original.get(props[i]).toString(), "", userName);
                Nre.auditor.audit(auditEvent3);
            }
            original.asComponent().remove(props[i]);
        }
        for (j = 0; j < copyHandled.length; ++j) {
            if (copyHandled[j] != -1) continue;
            BValue copyValue = copy.get(copyProps[j]).newCopy(true);
            original.asComponent().add(copyProps[j].getName() + "?", copyValue.asValue());
            if (!audit) continue;
            auditEvent = new AuditEvent("Added", auditSlotPath, copyProps[j].getName(), "", copyValue.toString(), userName);
            Nre.auditor.audit(auditEvent);
        }
        if (original instanceof BDaySchedule) {
            return;
        }
        boolean reorderRequired = false;
        boolean handledFound = false;
        for (int j4 = copyProps.length - 1; j4 >= 0; --j4) {
            if (copyHandled[j4] == -1 && handledFound) {
                reorderRequired = true;
                continue;
            }
            handledFound = true;
        }
        if (!reorderRequired) {
            reorderRequired = ScheduleUtil.isOutOfOrder(handled);
        }
        if (reorderRequired) {
            Array dynamicProps = new Array(Property.class);
            for (int j5 = 0; j5 < copyProps.length; ++j5) {
                if (!copyProps[j5].isDynamic()) continue;
                dynamicProps.add((Object)original.getProperty(copyProps[j5].getName()));
            }
            if (!dynamicProps.isEmpty()) {
                if (audit) {
                    AuditEvent auditEvent4 = new AuditEvent("Reordered", auditSlotPath, "", "", "", userName);
                    Nre.auditor.audit(auditEvent4);
                }
                original.asComponent().reorder((Property[])dynamicProps.trim());
            }
        }
    }

    private static boolean isOutOfOrder(int[] handled) {
        boolean outOfOrder = false;
        int last = -1;
        for (int i = 0; i < handled.length; ++i) {
            if (handled[i] == -1) continue;
            if (handled[i] < last) {
                outOfOrder = true;
                break;
            }
            last = handled[i];
        }
        return outOfOrder;
    }

    public static void validateSchedule(BAbstractSchedule schedule, Context cx) {
        SlotCursor sc = schedule.getProperties();
        while (sc.next(BIScheduleValidator.class)) {
            BIValidator v = (BIValidator)sc.get();
            v.validate((BObject)schedule, cx);
        }
    }

    public static String lex(String entry) {
        return SlotPath.escape((String)lex.getText(entry));
    }

    public static void main(String[] args) {
        try {
            ScheduleUtil.auditableCopyFrom((BComplex)new BComponent(), (BComplex)new BComponent(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        ScheduleUtil.daysOfMonth[0] = ScheduleUtil.lex("dayofmonth.anyDay");
        for (int i = 1; i < daysOfMonth.length; ++i) {
            ScheduleUtil.daysOfMonth[i] = SlotPath.escape((String)Integer.toString(i));
        }
    }
}

