/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public class IntSet
implements Serializable {
    private int[] ints = new int[0];

    public IntSet() {
    }

    public IntSet(int[] _ints) {
        int i = _ints.length;
        while (--i >= 0) {
            this.add(_ints[i]);
        }
    }

    public boolean add(int value) {
        if (this.contains(value)) {
            return false;
        }
        this.ints = this.union(value, this.ints);
        return true;
    }

    public void clear() {
        this.ints = new int[0];
    }

    public boolean contains(int value) {
        if (this.ints.length == 0) {
            return false;
        }
        int idx = this.predecessor(value, this.ints) + 1;
        if (idx == this.ints.length) {
            return false;
        }
        return this.ints[idx] == value;
    }

    public void decode(DataInput in) throws IOException {
        int len = in.readInt();
        this.ints = new int[len];
        for (int i = 0; i < len; ++i) {
            this.ints[i] = in.readInt();
        }
    }

    public void decodeFromString(String in) {
        char ch;
        int len = in.length();
        int numInts = 0;
        char last = ' ';
        for (int i = 0; i < len; ++i) {
            ch = in.charAt(i);
            if (Character.isDigit(ch) && !Character.isDigit(last)) {
                ++numInts;
            }
            last = ch;
        }
        if (numInts == 0) {
            return;
        }
        StringBuilder buf = new StringBuilder(len);
        this.ints = new int[numInts];
        int idx = 0;
        for (int i = 0; i < len; ++i) {
            ch = in.charAt(i);
            if (Character.isDigit(ch)) {
                buf.append(ch);
                continue;
            }
            if (buf.length() <= 0) continue;
            this.ints[idx] = Integer.parseInt(buf.toString());
            ++idx;
            buf.setLength(0);
        }
        if (buf.length() > 0) {
            this.ints[idx] = Integer.parseInt(buf.toString());
        }
        if (idx != numInts) {
            throw new RuntimeException("Error parsing int set: " + in);
        }
    }

    public void encode(DataOutput out) throws IOException {
        int len = this.ints.length;
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeInt(this.ints[i]);
        }
    }

    public String encodeToString() {
        StringBuilder buf = new StringBuilder(this.ints.length * 5);
        buf.append('{');
        boolean delimit = false;
        int len = this.ints.length;
        for (int i = 0; i < len; ++i) {
            if (delimit) {
                buf.append(", ");
            } else {
                delimit = true;
            }
            buf.append(this.ints[i]);
        }
        buf.append('}');
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntSet intSet = (IntSet)o;
        return Arrays.equals(this.ints, intSet.ints);
    }

    public int hashCode() {
        return Arrays.hashCode(this.ints);
    }

    public int get(int index) {
        return this.ints[index];
    }

    public int[] intern() {
        return this.ints;
    }

    public boolean isEmpty() {
        return this.ints.length == 0;
    }

    public boolean remove(int i) {
        if (!this.contains(i)) {
            return false;
        }
        this.ints = this.ints.length == 1 ? new int[0] : this.intersection(i, this.ints);
        return true;
    }

    public int size() {
        return this.ints.length;
    }

    public int[] toIntArray() {
        int[] retern = new int[this.ints.length];
        System.arraycopy(this.ints, 0, retern, 0, retern.length);
        return retern;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static IntSet wrap(int[] master) {
        IntSet ret = new IntSet();
        ret.ints = master;
        return ret;
    }

    private int[] intersection(int val, int[] src) {
        if (src.length == 1) {
            return new int[0];
        }
        int[] newInts = new int[src.length - 1];
        int idx = this.predecessor(val, src) + 1;
        if (idx == 0) {
            System.arraycopy(src, 1, newInts, 0, newInts.length);
        } else if (idx == newInts.length) {
            System.arraycopy(src, 0, newInts, 0, newInts.length);
        } else {
            System.arraycopy(src, 0, newInts, 0, idx);
            System.arraycopy(src, idx + 1, newInts, idx, newInts.length - idx);
        }
        return newInts;
    }

    private int predecessor(int val, int[] src) {
        if (src.length == 0) {
            return -1;
        }
        int start = 0;
        if (src[start] >= val) {
            return -1;
        }
        int end = src.length - 1;
        if (src[end] < val) {
            return end;
        }
        while (true) {
            int mid;
            int curr;
            if ((curr = src[mid = (start + end) / 2]) >= val) {
                end = mid--;
                if (src[mid] >= val) continue;
                return mid;
            }
            if (src[mid + 1] >= val) {
                return mid;
            }
            start = mid;
        }
    }

    private int[] union(int val, int[] src) {
        if (src.length == 0) {
            return new int[]{val};
        }
        int[] newInts = new int[src.length + 1];
        int idx = this.predecessor(val, src) + 1;
        if (idx == 0) {
            newInts[0] = val;
            System.arraycopy(src, 0, newInts, 1, src.length);
        } else if (idx == src.length) {
            newInts[idx] = val;
            System.arraycopy(src, 0, newInts, 0, src.length);
        } else {
            System.arraycopy(src, 0, newInts, 0, idx);
            newInts[idx] = val;
            System.arraycopy(src, idx, newInts, idx + 1, src.length - idx);
        }
        return newInts;
    }
}

