/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule;

import com.tridium.schedule.ScheduleSpyManager;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;

public class ExecutionQueue {
    public static ScheduleSpyManager scheduleManager = new ScheduleSpyManager();
    private int busyThreads = 0;
    private Map<Runnable, Runnable> map = new Hashtable<Runnable, Runnable>();
    private int maxQueueSize = 0;
    private int maxThreads = 1;
    private int minThreads = 1;
    private LinkedList<Runnable> queue = new LinkedList();
    private boolean running = false;
    private String threadName;
    private int totalThreads = 0;

    public ExecutionQueue(String threadName) {
        this.threadName = threadName;
    }

    public ExecutionQueue(String threadName, boolean autostart) {
        this.threadName = threadName;
        if (autostart) {
            this.start();
        }
    }

    public ExecutionQueue(String threadName, int minThreads, int maxThreads, int maxQueueSize) {
        this.threadName = threadName;
        this.minThreads = minThreads;
        this.maxThreads = maxThreads;
        this.maxQueueSize = maxQueueSize;
    }

    public synchronized Runnable dequeue() {
        --this.busyThreads;
        while (this.queue.isEmpty()) {
            if (this.totalThreads > this.minThreads) {
                return this.killThread();
            }
            if (!this.running) {
                return this.killThread();
            }
            try {
                this.wait(10000L);
            }
            catch (Exception exception) {}
        }
        if (!this.running) {
            return this.killThread();
        }
        Runnable ret = this.queue.removeFirst();
        ++this.busyThreads;
        this.map.remove(ret);
        scheduleManager.dequeueSpy(ret);
        return ret;
    }

    public synchronized void clear() {
        this.queue.clear();
        this.map.clear();
    }

    public synchronized void enqueue(Runnable request) throws QueueFull {
        if (!this.running) {
            throw new IllegalStateException();
        }
        if (this.maxQueueSize > 0 && this.queue.size() >= this.maxQueueSize) {
            throw new QueueFull();
        }
        if (this.map.containsKey(request)) {
            return;
        }
        this.map.put(request, request);
        this.queue.addLast(request);
        if (this.busyThreads == this.totalThreads && this.maxThreads > this.totalThreads) {
            this.createThread();
        }
        scheduleManager.enqueueSpy(request);
        this.notify();
    }

    public void start() {
        this.running = true;
        int i = this.minThreads;
        while (--i >= 0) {
            this.createThread();
        }
    }

    public synchronized void stop() {
        this.running = false;
        this.queue.clear();
        this.notifyAll();
    }

    private synchronized void createThread() {
        ++this.totalThreads;
        ++this.busyThreads;
        RunThread thd = new RunThread(this.threadName);
        thd.setDaemon(true);
        thd.start();
    }

    private Runnable killThread() {
        --this.totalThreads;
        return null;
    }

    public static class QueueFull
    extends RuntimeException {
    }

    private class RunThread
    extends Thread {
        public RunThread(String name) {
            super(name);
            try {
                this.setPriority(Math.max(this.getPriority() - 1, 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            Runnable r = ExecutionQueue.this.dequeue();
            while (r != null) {
                r.run();
                r = ExecutionQueue.this.dequeue();
            }
        }
    }
}

