/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk;

import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;
import javax.baja.xml.XWriter;

public class Wsdl {
    public static final XNs SOAP = new XNs("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
    public static final XNs WSDL = new XNs("wsdl", "http://schemas.xmlsoap.org/wsdl/");
    public static final XNs XSD = new XNs("xsd", "http://www.w3.org/2001/XMLSchema");
    public static final XNs TNS = new XNs("tns", "http://obix.org/ns/wsdl/1.0");
    protected Vector<XNs> namespaces = new Vector();
    protected Vector<Operation> operations = new Vector();
    protected String serviceName;
    protected String serviceUri;
    protected String targetNamespace;
    protected Vector<XElem> types = new Vector();

    public Wsdl(String serviceName, String targetNamespace, String serviceUri) {
        this.serviceName = serviceName;
        this.serviceUri = serviceUri;
        this.targetNamespace = targetNamespace;
    }

    public void addOperation(String name, XElem inputElement, XElem outputElement) {
        Operation o = new Operation();
        o.name = name;
        o.input = inputElement.qname();
        o.output = outputElement.qname();
        this.operations.addElement(o);
        XNs ns = inputElement.ns();
        if (ns != null && !ns.prefix().equals("")) {
            this.namespaces.addElement(ns);
        }
        if ((ns = outputElement.ns()) != null && !ns.prefix().equals("")) {
            this.namespaces.addElement(outputElement.ns());
        }
    }

    public void addType(XElem type) {
        if (!this.types.contains(type)) {
            this.types.addElement(type);
        }
    }

    public String getContentType() {
        return "text/xml";
    }

    public XElem getDocument() {
        XElem definitions = this.makeDefinitions();
        this.doTypes(definitions);
        this.doMessages(definitions);
        this.doPortType(definitions);
        this.doBinding(definitions);
        this.doService(definitions);
        return definitions;
    }

    public void write(OutputStream out) throws Exception {
        XWriter x = new XWriter(out);
        x.prolog();
        this.getDocument().write(x);
        x.flush();
    }

    protected void doBinding(XElem def) {
        Operation[] o;
        XElem binding = new XElem(WSDL, "binding");
        binding.addAttr("name", this.serviceName + "SoapBinding");
        binding.addAttr("type", this.serviceName + "SoapPort");
        XElem soapBinding = new XElem(SOAP, "binding");
        soapBinding.addAttr("style", "document");
        soapBinding.addAttr("transport", "http://schemas.xmlsoap.org/soap/http");
        def.addContent((XContent)binding);
        binding.addContent((XContent)soapBinding);
        for (Operation anO : o = this.ops()) {
            XElem op = new XElem(WSDL, "operation");
            op.addAttr("name", anO.name);
            XElem soapOp = new XElem(SOAP, "operation");
            soapOp.addAttr("soapAction", this.concat(this.targetNamespace, anO.name));
            soapOp.addAttr("style", "document");
            XElem in = new XElem(WSDL, "input");
            XElem out = new XElem(WSDL, "output");
            XElem soapBody = new XElem(SOAP, "body");
            soapBody.addAttr("use", "literal");
            binding.addContent((XContent)op);
            op.addContent((XContent)soapOp);
            op.addContent((XContent)in);
            op.addContent((XContent)out);
            in.addContent((XContent)soapBody);
            out.addContent((XContent)soapBody.copy());
        }
    }

    protected void doMessages(XElem def) {
        Operation[] o;
        for (Operation anO : o = this.ops()) {
            if (anO.input != null) {
                XElem in = new XElem(WSDL, "message");
                in.addAttr("name", anO + "SoapReq");
                XElem ipart = new XElem(WSDL, "part");
                ipart.addAttr("name", "body");
                ipart.addAttr("element", anO.input);
                in.addContent((XContent)ipart);
                def.addContent((XContent)in);
            }
            if (anO.output == null) continue;
            XElem out = new XElem(WSDL, "message");
            out.addAttr("name", anO + "SoapRes");
            XElem opart = new XElem(WSDL, "part");
            opart.addAttr("name", "body");
            opart.addAttr("element", anO.output);
            out.addContent((XContent)opart);
            def.addContent((XContent)out);
        }
    }

    protected void doPortType(XElem def) {
        Operation[] o;
        XElem portType = new XElem(WSDL, "portType");
        portType.addAttr("name", this.serviceName + "SoapPort");
        def.addContent((XContent)portType);
        for (Operation anO : o = this.ops()) {
            XElem op = new XElem(WSDL, "operation");
            op.addAttr("name", anO.name);
            XElem in = new XElem(WSDL, "input");
            in.addAttr("message", anO.name + "SoapReq");
            XElem out = new XElem(WSDL, "output");
            out.addAttr("message", anO.name + "SoapRes");
            portType.addContent((XContent)op);
            op.addContent((XContent)in);
            op.addContent((XContent)out);
        }
    }

    protected void doService(XElem def) {
        XElem service = new XElem(WSDL, "service");
        service.addAttr("name", this.serviceName);
        XElem port = new XElem(WSDL, "port");
        port.addAttr("name", this.serviceName + "Port");
        port.addAttr("binding", this.serviceName + "SoapBinding");
        XElem addr = new XElem(SOAP, "address");
        addr.addAttr("location", this.serviceUri);
        def.addContent((XContent)service);
        service.addContent((XContent)port);
        port.addContent((XContent)addr);
    }

    protected void doTypes(XElem definitions) {
        if (this.types.size() == 0) {
            return;
        }
        XElem tipes = new XElem(WSDL, "types");
        Enumeration<XElem> e = this.types.elements();
        while (e.hasMoreElements()) {
            tipes.addContent((XContent)e.nextElement());
        }
        definitions.addContent((XContent)tipes);
    }

    protected XElem makeDefinitions() {
        XElem definitions = new XElem(WSDL, "definitions");
        definitions.addAttr("targetNamespace", this.targetNamespace);
        definitions.defineDefaultNs(this.targetNamespace);
        definitions.defineNs(WSDL);
        definitions.defineNs(SOAP);
        definitions.defineNs(XSD);
        definitions.defineNs(TNS);
        if (this.namespaces.size() == 0) {
            return definitions;
        }
        Enumeration<XNs> e = this.namespaces.elements();
        while (e.hasMoreElements()) {
            definitions.defineNs(e.nextElement());
        }
        return definitions;
    }

    private String concat(String parent, String child) {
        if (parent == null) {
            return child;
        }
        if (child == null) {
            return parent;
        }
        if (parent.endsWith("/") || child.startsWith("/")) {
            return parent + child;
        }
        return parent + '/' + child;
    }

    private Operation[] ops() {
        Object[] ops = new Operation[this.operations.size()];
        this.operations.copyInto(ops);
        return ops;
    }

    private static class Operation {
        String name;
        String input;
        String output;

        private Operation() {
        }

        public String toString() {
            return this.name;
        }
    }
}

