/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower;

import com.tridium.platPower.BBattery;
import com.tridium.platPower.BBatteryState;
import com.tridium.platPower.PowerdQnx;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="state", type="BBatteryState", defaultValue="BBatteryState.unknown", flags=3), @NiagaraProperty(name="chargeTimeLeft", type="BRelTime", defaultValue="BRelTime.makeMinutes(0)", flags=3, facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, BBoolean.TRUE)")})})
public class BNimhBattery
extends BBattery {
    @Generated
    public static final Property state = BNimhBattery.newProperty((int)3, (BValue)BBatteryState.unknown, null);
    @Generated
    public static final Property chargeTimeLeft = BNimhBattery.newProperty((int)3, (BValue)BRelTime.makeMinutes((int)0), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BNimhBattery.class);
    private static final BFacets shutdownDelayFacetsDRS = BFacets.make((String[])new String[]{"showSeconds", "min", "max"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BRelTime.makeMinutes((int)0), BRelTime.makeMinutes((int)10)});
    private static final BFacets shutdownDelayFacets = BFacets.make((String[])new String[]{"showSeconds", "min", "max"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BRelTime.makeMinutes((int)0), BRelTime.makeMinutes((int)1)});
    public static Logger log = Logger.getLogger("power");

    @Generated
    public BBatteryState getState() {
        return (BBatteryState)this.get(state);
    }

    @Generated
    public void setState(BBatteryState v) {
        this.set(state, (BValue)v, null);
    }

    @Generated
    public BRelTime getChargeTimeLeft() {
        return (BRelTime)this.get(chargeTimeLeft);
    }

    @Generated
    public void setChargeTimeLeft(BRelTime v) {
        this.set(chargeTimeLeft, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.isBatteryPresent()) {
            return;
        }
        PowerdQnx.open();
    }

    @Override
    public boolean isBatteryGood() {
        try {
            return PowerdQnx.isBatteryGood();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error checking NiMH battery", e);
            return false;
        }
    }

    @Override
    public BAbsTime getTestTime() {
        try {
            return BAbsTime.make((long)PowerdQnx.getBatteryTestTime());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error checking NiMH battery test time", e);
            return BAbsTime.NULL;
        }
    }

    @Override
    public BRelTime validateShutdownDelay(BRelTime delay) {
        BRelTime maxDelay = BRelTime.makeMinutes((int)1);
        try {
            Property prop;
            BComponent serviceAsComponent;
            BFrozenEnum status;
            BIDataRecoveryService dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
            if (dataRecoveryService.isEnabled() && (status = (BFrozenEnum)(serviceAsComponent = (BComponent)dataRecoveryService).get(prop = serviceAsComponent.getProperty("dataRecoveryStatus"))) != null && status.getOrdinal() != 8) {
                maxDelay = BRelTime.makeMinutes((int)10);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (delay.getMillis() > maxDelay.getMillis()) {
            return maxDelay;
        }
        return delay;
    }

    @Override
    public void refresh() {
        this.setState(PowerdQnx.getBatteryState());
        this.setChargeTimeLeft(PowerdQnx.getBatteryChargeTime());
    }

    @Override
    public BFacets doGetShutdownDelayFacets() {
        try {
            Property prop;
            BComponent serviceAsComponent;
            BFrozenEnum status;
            BIDataRecoveryService dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
            if (dataRecoveryService.isEnabled() && (status = (BFrozenEnum)(serviceAsComponent = (BComponent)dataRecoveryService).get(prop = serviceAsComponent.getProperty("dataRecoveryStatus"))) != null && status.getOrdinal() != 8) {
                return shutdownDelayFacetsDRS;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return shutdownDelayFacets;
    }
}

