/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusTcp;

import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusTcp.BModbusTcpDeviceFolder;
import com.tridium.modbusTcp.BModbusTcpGateway;
import com.tridium.modbusTcp.BModbusTcpGatewayDevice;
import com.tridium.modbusTcp.BModbusTcpNetwork;
import com.tridium.modbusTcp.BSocketStatusEnum;
import com.tridium.modbusTcp.comm.ModbusTcpComm;
import com.tridium.modbusTcp.comm.ModbusTcpRxDriver;
import com.tridium.modbusTcp.comm.ModbusTcpSendRequest;
import java.net.InetAddress;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="deviceAddress", type="int", defaultValue="1", facets={@Facet(value="BFacets.makeInt(null, 0, 255)")}, override=true), @NiagaraProperty(name="ipAddress", type="String", defaultValue="ModbusMessageConst.DEFAULT_IP"), @NiagaraProperty(name="port", type="int", defaultValue="502", facets={@Facet(value="BFacets.makeInt(null, 0, 65535)")}), @NiagaraProperty(name="socketStatus", type="BSocketStatusEnum", defaultValue="BSocketStatusEnum.closed", flags=67), @NiagaraProperty(name="disableTransactionIdCheck", type="boolean", defaultValue="false"), @NiagaraProperty(name="maxTransactionId", type="int", defaultValue="65535", facets={@Facet(value="BFacets.makeInt(null, 0, 65535)")}), @NiagaraProperty(name="rxProcessMode", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(\"packet\", \"byte\")")})})
public class BModbusTcpDevice
extends BModbusTcpGatewayDevice {
    @Generated
    public static final Property deviceAddress = BModbusTcpDevice.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)0, (int)255));
    @Generated
    public static final Property ipAddress = BModbusTcpDevice.newProperty((int)0, (String)"###.###.###.###", null);
    @Generated
    public static final Property port = BModbusTcpDevice.newProperty((int)0, (int)502, (BFacets)BFacets.makeInt(null, (int)0, (int)65535));
    @Generated
    public static final Property socketStatus = BModbusTcpDevice.newProperty((int)67, (BValue)BSocketStatusEnum.closed, null);
    @Generated
    public static final Property disableTransactionIdCheck = BModbusTcpDevice.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property maxTransactionId = BModbusTcpDevice.newProperty((int)0, (int)65535, (BFacets)BFacets.makeInt(null, (int)0, (int)65535));
    @Generated
    public static final Property rxProcessMode = BModbusTcpDevice.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"packet", (String)"byte"));
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusTcpDevice.class);
    protected ModbusTcpComm tcpComm = null;

    @Generated
    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    @Generated
    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public BSocketStatusEnum getSocketStatus() {
        return (BSocketStatusEnum)this.get(socketStatus);
    }

    @Generated
    public void setSocketStatus(BSocketStatusEnum v) {
        this.set(socketStatus, (BValue)v, null);
    }

    @Generated
    public boolean getDisableTransactionIdCheck() {
        return this.getBoolean(disableTransactionIdCheck);
    }

    @Generated
    public void setDisableTransactionIdCheck(boolean v) {
        this.setBoolean(disableTransactionIdCheck, v, null);
    }

    @Generated
    public int getMaxTransactionId() {
        return this.getInt(maxTransactionId);
    }

    @Generated
    public void setMaxTransactionId(int v) {
        this.setInt(maxTransactionId, v, null);
    }

    @Generated
    public boolean getRxProcessMode() {
        return this.getBoolean(rxProcessMode);
    }

    @Generated
    public void setRxProcessMode(boolean v) {
        this.setBoolean(rxProcessMode, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getNetworkType() {
        return BModbusTcpNetwork.TYPE;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BModbusTcpNetwork && !(parent instanceof BModbusTcpGateway) || parent instanceof BModbusTcpDeviceFolder;
    }

    public void started() throws Exception {
        super.started();
        if (Sys.isStationStarted()) {
            this.setSocketStatus(BSocketStatusEnum.closed);
            this.startComm();
        }
    }

    public void stationStarted() {
        this.startComm();
    }

    public void startComm() {
        try {
            this.tcpComm = new ModbusTcpComm(this.modbusNet());
            this.tcpComm.setDevice((BModbusDevice)this);
            if (!this.isDisabled() && !this.isFatalFault()) {
                this.tcpComm.start();
            }
        }
        catch (Exception e) {
            this.modbusNet().getModbusLog().error("Exception generated in BModbusTcpDevice.deviceStarted(): ", (Throwable)e);
        }
    }

    public void stopped() throws Exception {
        this.stopComm();
        super.stopped();
    }

    public void stopComm() {
        if (this.tcpComm != null && this.tcpComm.isCommStarted()) {
            try {
                this.tcpComm.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public int getModbusMode() {
        return 2;
    }

    public InetAddress getInetAddr() {
        InetAddress newINet;
        try {
            String url = this.getIpAddress().trim();
            newINet = url.equalsIgnoreCase("###.###.###.###") || url.length() == 0 ? null : InetAddress.getByName(url);
        }
        catch (Exception e) {
            newINet = null;
        }
        return newINet;
    }

    public void changed(Property prop, Context context) {
        block15: {
            super.changed(prop, context);
            if (!this.isRunning()) {
                return;
            }
            try {
                if (prop.equals(ipAddress) || prop.equals(port)) {
                    if (this.tcpComm == null || !this.tcpComm.isCommStarted()) break block15;
                    long ticks = Clock.ticks();
                    while (this.getSocketStatus().equals((Object)BSocketStatusEnum.openPending)) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (Clock.ticks() - ticks <= 30000L) continue;
                    }
                    this.tcpComm.stop();
                    InetAddress ipaddr = this.getInetAddr();
                    if (ipaddr == null && this.modbusNet() != null && this.modbusNet().getModbusLog() != null) {
                        this.modbusNet().getModbusLog().error(this.getName() + ": Could not resolve IP address [" + this.getIpAddress() + "].");
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.tcpComm.start();
                    this.ping();
                    break block15;
                }
                if (prop.equals(status)) {
                    if (this.isDisabled() || this.isFatalFault()) {
                        if (this.tcpComm != null && this.tcpComm.isCommStarted()) {
                            this.tcpComm.stop();
                        }
                    } else if (this.tcpComm != null && !this.tcpComm.isCommStarted()) {
                        this.tcpComm.start();
                    }
                }
            }
            catch (Exception e) {
                if (this.modbusNet() == null || this.modbusNet().getModbusLog() == null) break block15;
                this.modbusNet().getModbusLog().error(this.getName() + ": Caught exception in BModbusTcpDevice.changed()", (Throwable)e);
            }
        }
    }

    @Override
    public Message sendModbusMessage(Message msg) {
        if (!this.modbusNet().isCommActive() || this.tcpComm == null || !this.tcpComm.isCommStarted()) {
            return null;
        }
        ModbusTcpSendRequest req = new ModbusTcpSendRequest(this, msg, true);
        Message response = null;
        int socketStatus = this.getSocketStatus().getOrdinal();
        if (socketStatus == 0 || socketStatus == 2) {
            ((ModbusTcpRxDriver)this.tcpComm.getCommReceiver()).initSocketConnection();
            socketStatus = this.getSocketStatus().getOrdinal();
        }
        if (socketStatus == 3) {
            this.incrementRequest();
            this.modbusNet().dispatch((Runnable)req);
            response = req.getResponse(0);
        }
        if (response != null && ((ModbusResponse)response).exceptionCode != 10 && ((ModbusResponse)response).exceptionCode != 11) {
            this.pingOk();
            this.resetPingsFailed();
        } else if (this.incrementPingsFailed() > ((BModbusTcpNetwork)this.modbusNet()).getMaxFailsUntilDeviceDown()) {
            String cause = this.getLexicon().getText("pingFail");
            if (response != null) {
                cause = cause + ": " + ((ModbusResponse)response).getExceptionString();
            } else {
                this.incrementTimeouts();
            }
            this.pingFail(cause);
        }
        return response;
    }

    public ModbusTcpComm getComm() {
        return this.tcpComm;
    }
}

