/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.ui;

import com.tridium.ndriver.ui.NMgrLearn;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.history.BOpcUaClientHistoryDeviceExt;
import com.tridium.opcUaClient.history.BOpcUaClientHistoryImport;
import com.tridium.opcUaClient.point.BOpcUaNodeLearnEntry;
import javax.baja.driver.ui.history.ArchiveManagerController;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.BHistoryImportManager;
import javax.baja.driver.ui.history.ImportModel;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"opcUaClient:OpcUaClientHistoryDeviceExt"})})
public class BOpcUaClientHistoryImportManager
extends BHistoryImportManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaClientHistoryImportManager.class);
    private BOpcUaClientHistoryDeviceExt deviceExt;
    MgrColumn useServerTimestamp = new MgrColumn.Prop(BOpcUaClientHistoryImport.useServerTimestamp, 1);
    MgrColumn uaNodeNameCol = new MgrColumn.Prop(BOpcUaClientHistoryImport.uaNodeName, 1);
    MgrColumn uaNodeIdCol = new MgrColumn.Prop(BOpcUaClientHistoryImport.uaNodeId, 1);
    MgrColumn typeSpecCol = new MgrColumn.Prop(BOpcUaClientHistoryImport.typeSpec, 1);
    MgrColumn localHistoryNameCol = new MgrColumn.Prop(BOpcUaClientHistoryImport.localHistoryName, 1);
    MgrColumn facets = new MgrColumn.Prop(BOpcUaClientHistoryImport.facets, 1);
    MgrColumn[] columns = new MgrColumn[]{this.useServerTimestamp, this.uaNodeNameCol, this.uaNodeIdCol, this.typeSpecCol, this.localHistoryNameCol, this.facets};

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
    }

    public MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected ImportModel makeImportModel() {
        return new Model(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    public BOpcUaClientHistoryDeviceExt getDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        return (BOpcUaClientHistoryDeviceExt)this.getCurrentValue();
    }

    public BOpcUaDevice getDevice() {
        return (BOpcUaDevice)this.getDeviceExt().getDevice();
    }

    public static class LocalHistoryNameCol
    extends MgrColumn.Prop {
        Property prop;

        public LocalHistoryNameCol(Property prop, int flags) {
            super(prop.getDefaultDisplayName(null), prop, flags);
            this.prop = prop;
        }

        public Object get(Object row) {
            return SlotPath.unescape((String)((BComplex)row).propertyValueToString(this.prop, null));
        }
    }

    class Controller
    extends ArchiveManagerController {
        public Controller(BOpcUaClientHistoryImportManager manager) {
            super((BArchiveManager)manager);
            this.cancel.setFlags(7);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BOrd jobOrd = BOpcUaClientHistoryImportManager.this.getDeviceExt().submitTrendLogDiscoveryJob();
            if (jobOrd != null && !jobOrd.equals((Object)BOrd.DEFAULT)) {
                BOpcUaClientHistoryImportManager.this.getLearn().setJob(jobOrd);
            }
            return null;
        }
    }

    class State
    extends MgrState {
        Object[] lastLearn;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BOpcUaClientHistoryImportManager mgr = (BOpcUaClientHistoryImportManager)m;
            Learn lrn = (Learn)mgr.getLearn();
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BOpcUaClientHistoryImportManager mgr = (BOpcUaClientHistoryImportManager)m;
            Learn lrn = (Learn)mgr.getLearn();
            if (this.lastLearn != null) {
                lrn.updateRoots(this.lastLearn);
            }
        }
    }

    class Learn
    extends NMgrLearn {
        Learn lastLearn;

        public Learn(BOpcUaClientHistoryImportManager manager) {
            super((BAbstractManager)manager);
        }

        public boolean isExisting(Object dis, BComponent db) {
            return ((BOpcUaClientHistoryImport)db).getUaNodeId().equals(((BOpcUaNodeLearnEntry)dis).getUaNodeId());
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return true;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            return MgrTypeInfo.makeArray((Type)BOpcUaClientHistoryImport.TYPE);
        }

        public void toRow(Object dis, MgrEditRow row) {
            BOpcUaNodeLearnEntry histNode = (BOpcUaNodeLearnEntry)dis;
            row.setName(SlotPath.escape((String)histNode.getDefaultName()));
            row.setCell(BOpcUaClientHistoryImportManager.this.useServerTimestamp, (BValue)BBoolean.make((boolean)histNode.getUseServerTimestamp()));
            row.setCell(BOpcUaClientHistoryImportManager.this.uaNodeNameCol, (BValue)BString.make((String)histNode.getUaNodeName()));
            row.setCell(BOpcUaClientHistoryImportManager.this.uaNodeIdCol, (BValue)BString.make((String)histNode.getUaNodeId()));
            row.setCell(BOpcUaClientHistoryImportManager.this.typeSpecCol, (BValue)BString.make((String)histNode.getTypeSpec()));
            row.setCell(BOpcUaClientHistoryImportManager.this.localHistoryNameCol, (BValue)BString.make((String)SlotPath.escape((String)histNode.getDefaultName())));
            row.setCell(BOpcUaClientHistoryImportManager.this.facets, (BValue)BFacets.make((BFacets)histNode.getFacets()));
        }
    }

    class Model
    extends ImportModel {
        public Model(BOpcUaClientHistoryImportManager manager) {
            super((BHistoryImportManager)manager);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BOpcUaClientHistoryImport.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BOpcUaClientHistoryImport.TYPE);
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BOpcUaClientHistoryImport result = (BOpcUaClientHistoryImport)super.newInstance(type);
            return result;
        }

        protected MgrColumn[] makeColumns() {
            MgrColumn[] cols = super.makeColumns();
            MgrColumn[] result = new MgrColumn[cols.length + BOpcUaClientHistoryImportManager.this.columns.length];
            System.arraycopy(cols, 0, result, 0, cols.length);
            System.arraycopy(BOpcUaClientHistoryImportManager.this.columns, 0, result, cols.length, BOpcUaClientHistoryImportManager.this.columns.length);
            return result;
        }
    }
}

