/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.ui;

import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.BOpcUaDeviceFolder;
import com.tridium.opcUaClient.BOpcUaNetwork;
import com.tridium.opcUaClient.learn.BOpcUaClientLearnDeviceEntry;
import com.tridium.opcUaClient.learn.BOpcUaClientLearnDevicesJob;
import com.tridium.util.ArrayUtil;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"opcUaClient:OpcUaDevice", "opcUaClient:OpcUaDeviceFolder"})})
public class BOpcUaClientDeviceManager
extends BDeviceManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaClientDeviceManager.class);
    static Lexicon lex = Lexicon.make(BOpcUaClientDeviceManager.class);
    static BImage stationIcon = BImage.make((String)"module://icons/x16/device.png");
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BOpcUaDevice());
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colServerUrl = new OpcuaDeviceMgrColumn(BOpcUaDevice.serverEndpointUrl, 1);
    MgrColumn colSecurityMode = new MgrColumn.Prop(BOpcUaDevice.securityMode, 1);
    MgrColumn colCertificateAlias = new MgrColumn.PropPath(LEX.get("opcUaDevice.manager.securityCertificateAlias"), new Property[]{BOpcUaDevice.certAliasAndPassword, BCertificateAliasAndPassword.alias}, 1);
    MgrColumn colCertificatePassword = new MgrColumn.PropPath(LEX.get("opcUaDevice.manager.securityCertificatePassword"), new Property[]{BOpcUaDevice.certAliasAndPassword, BCertificateAliasAndPassword.password}, 3);
    MgrColumn colUserAuthenticationMode = new MgrColumn.Prop(BOpcUaDevice.userAuthenticationMode, 1);
    MgrColumn colUserAuthCertificateAlias = new MgrColumn.PropPath(LEX.get("opcUaDevice.manager.userAuthCertificateAlias"), new Property[]{BOpcUaDevice.userAuthenticationCertificate, BCertificateAliasAndPassword.alias}, 1);
    MgrColumn colUserAuthCertificatePassword = new MgrColumn.PropPath(LEX.get("opcUaDevice.manager.userAuthCertificatePassword"), new Property[]{BOpcUaDevice.userAuthenticationCertificate, BCertificateAliasAndPassword.password}, 3);
    MgrColumn colUsername = new MgrColumn.Prop(BOpcUaDevice.userName, 1);
    MgrColumn colPassword = new MgrColumn.Prop(BOpcUaDevice.password, 1);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colDeviceExts, this.colStatus, this.colServerUrl, this.colSecurityMode, this.colCertificateAlias, this.colCertificatePassword, this.colUserAuthenticationMode, this.colUserAuthCertificateAlias, this.colUserAuthCertificatePassword, this.colUsername, this.colPassword, this.colEnabled, this.colHealth};
    private static final String OPC_TCP = "opc.tcp";
    private static final Lexicon LEX = Lexicon.make(BOpcUaClientDeviceManager.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOpcUaNetwork getNetwork() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BOpcUaDeviceFolder) {
            return ((BOpcUaDeviceFolder)owner).getOpcUaNetwork();
        }
        if (owner instanceof BOpcUaNetwork) {
            return (BOpcUaNetwork)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        this.updateLearnData();
    }

    void updateLearnData() {
        BOpcUaClientLearnDevicesJob learnJob = (BOpcUaClientLearnDevicesJob)this.getLearn().getJob();
        if (learnJob != null) {
            this.getLearn().updateRoots(learnJob.getLearnedDevices().getChildren(BOpcUaClientLearnDeviceEntry.class));
        }
    }

    public BOpcUaDevice[] getSelectedDevices() {
        if (this.getModel() == null || this.getModel().getTable() == null) {
            return new BOpcUaDevice[0];
        }
        BComponent[] selection = this.getModel().getTable().getSelectedComponents();
        Object[] devices = new BOpcUaDevice[]{};
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i].getType().is(BOpcUaDevice.TYPE)) continue;
            devices = (BOpcUaDevice[])ArrayUtil.addOne((Object[])devices, (Object)((BOpcUaDevice)selection[i]));
        }
        return devices;
    }

    protected MgrModel makeModel() {
        return new Model(this){

            public BComponent newInstance(MgrTypeInfo info) throws Exception {
                BOpcUaDevice device = (BOpcUaDevice)info.newInstance();
                device.setFlags((Slot)BOpcUaDevice.certificate, 0x10000005);
                device.getCertAliasAndPassword().setAlias("tridium");
                return device;
            }
        };
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    class OpcuaDeviceMgrColumn
    extends MgrColumn.Prop {
        public OpcuaDeviceMgrColumn(String name, Property prop, int flags) {
            super(name, prop, flags);
        }

        public OpcuaDeviceMgrColumn(Property prop, int flags) {
            super(prop, flags);
        }

        public OpcuaDeviceMgrColumn(Property prop) {
            super(prop);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            if (!(((BString)row.getCell(BOpcUaClientDeviceManager.this.colServerUrl)).getString().isEmpty() || ((BString)row.getCell(BOpcUaClientDeviceManager.this.colServerUrl)).getString().startsWith(BOpcUaClientDeviceManager.OPC_TCP) || BOpcUaDevice.OPCUA_IPV4_PATTERN.matcher(((BString)row.getCell(BOpcUaClientDeviceManager.this.colServerUrl)).getString()).matches())) {
                BDialog.error((BWidget)BOpcUaClientDeviceManager.this, (Object)LEX.getText("opcUaClient.endPoint", new Object[]{((BString)row.getCell(BOpcUaClientDeviceManager.this.colServerUrl)).getString(), ((BString)row.getCell(BOpcUaClientDeviceManager.this.colName)).getString()}));
                return;
            }
            super.save(row, value, cx);
        }
    }

    class Controller
    extends DeviceController {
        Controller(BDeviceManager mgr) {
            super(mgr);
        }

        public void updateCommands() {
            super.updateCommands();
            this.discover.setEnabled(false);
        }
    }

    class Learn
    extends MgrLearn {
        Learn(BDeviceManager manager) {
            super((BAbstractManager)manager);
        }

        public BImage getIcon(Object dis) {
            return stationIcon;
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            return MgrTypeInfo.makeArray((Type)BOpcUaClientDeviceManager.this.getNetwork().getDeviceType());
        }

        public void toRow(Object discovery, MgrEditRow row) {
            BOpcUaClientLearnDeviceEntry learnEntry = (BOpcUaClientLearnDeviceEntry)discovery;
        }

        public boolean isExisting(Object dis, BComponent comp) {
            BOpcUaClientLearnDeviceEntry learnEntry = (BOpcUaClientLearnDeviceEntry)dis;
            BOpcUaDevice d = (BOpcUaDevice)comp;
            return false;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BOpcUaClientLearnDevicesJob) {
                BOpcUaClientDeviceManager.this.updateLearnData();
            }
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[0];
        }
    }

    class Model
    extends DeviceModel {
        Model(BDeviceManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BOpcUaClientDeviceManager.this.cols;
        }
    }
}

