/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver.schedule;

import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.schedule.BObixScheduleDeviceExt;
import javax.baja.obix.driver.schedule.BObixScheduleExport;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import obix.Abstime;
import obix.Contract;
import obix.List;
import obix.Obj;
import obix.Uri;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="eventsPerUpdate", type="int", defaultValue="25", facets={@Facet(name="BFacets.MIN", value="BInteger.make(0)"), @Facet(name="BFacets.MAX", value="BInteger.make(50)")}), @NiagaraProperty(name="maxLookAheadDays", type="int", defaultValue="30", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"day\")"), @Facet(name="BFacets.MIN", value="BInteger.make(1)"), @Facet(name="BFacets.MAX", value="BInteger.make(90)")}), @NiagaraProperty(name="forceEventAtMidnight", type="boolean", defaultValue="true")})
public class BR2ScheduleDeviceExt
extends BObixScheduleDeviceExt {
    @Generated
    public static final Property eventsPerUpdate = BR2ScheduleDeviceExt.newProperty((int)0, (int)25, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)50))));
    @Generated
    public static final Property maxLookAheadDays = BR2ScheduleDeviceExt.newProperty((int)0, (int)30, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"day")), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1))), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)90))));
    @Generated
    public static final Property forceEventAtMidnight = BR2ScheduleDeviceExt.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BR2ScheduleDeviceExt.class);
    private static final Uri CONTRACT = new Uri("/obix/def/tridium.apps.ScheduleNode");
    private static final Uri EVENT_CONTRACT_URI = new Uri("/obix/def/tridiumx.obix.ScheduleEvent");
    private static final Contract EVENT_CONTRACT = new Contract(new Uri[]{EVENT_CONTRACT_URI});

    @Generated
    public int getEventsPerUpdate() {
        return this.getInt(eventsPerUpdate);
    }

    @Generated
    public void setEventsPerUpdate(int v) {
        this.setInt(eventsPerUpdate, v, null);
    }

    @Generated
    public int getMaxLookAheadDays() {
        return this.getInt(maxLookAheadDays);
    }

    @Generated
    public void setMaxLookAheadDays(int v) {
        this.setInt(maxLookAheadDays, v, null);
    }

    @Generated
    public boolean getForceEventAtMidnight() {
        return this.getBoolean(forceEventAtMidnight);
    }

    @Generated
    public void setForceEventAtMidnight(boolean v) {
        this.setBoolean(forceEventAtMidnight, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void execute(BObixScheduleExport export) {
        BAbsTime t1;
        int eventCounter;
        BObixClient oc = this.getObixClient();
        List eventList = new List("eventList", EVENT_CONTRACT);
        BAbstractSchedule asch = export.getSchedule();
        if (!(asch instanceof BBooleanSchedule)) {
            return;
        }
        BBooleanSchedule sch = (BBooleanSchedule)asch;
        BAbsTime t0 = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.DEFAULT);
        BAbsTime maxLookAheadTime = t0.add(BRelTime.makeHours((int)(24 * this.getMaxLookAheadDays())));
        if (this.getForceEventAtMidnight()) {
            for (eventCounter = 0; t0.isBefore(maxLookAheadTime) && eventCounter < this.getEventsPerUpdate(); ++eventCounter) {
                t1 = sch.nextCov(t0);
                boolean v = BR2ScheduleDeviceExt.getValue((BAbstractSchedule)sch, t0);
                if (t1 == null) {
                    if (this.getLogger().isLoggable(Level.FINE)) {
                        System.out.println("t1 is null! add full days at default for remaining events");
                    }
                    while (eventCounter++ < this.getEventsPerUpdate()) {
                        if (v) {
                            this.addEvent((BAbstractSchedule)sch, t0, BAbsTime.make((BAbsTime)t0.nextDay(), (BTime)BTime.DEFAULT), eventList);
                        } else {
                            this.addEvent((BAbstractSchedule)sch, t0, t0, eventList);
                        }
                        t0 = BAbsTime.make((BAbsTime)t0.nextDay(), (BTime)BTime.DEFAULT);
                    }
                    break;
                }
                if (this.getLogger().isLoggable(Level.FINE)) {
                    System.out.println("while(" + eventCounter + "): t0=" + t0 + " t1=" + t1 + " v=" + v);
                }
                while (!t0.dateEquals(t1) && eventCounter < this.getEventsPerUpdate()) {
                    BAbsTime t2 = BAbsTime.make((BAbsTime)t0.nextDay(), (BTime)BTime.DEFAULT);
                    this.addEvent((BAbstractSchedule)sch, t0, v ? t2 : t0, eventList);
                    ++eventCounter;
                    t0 = t2;
                }
                this.addEvent((BAbstractSchedule)sch, t0, v ? t1 : t0, eventList);
                t0 = t1;
            }
        } else {
            boolean v = BR2ScheduleDeviceExt.getValue((BAbstractSchedule)sch, t0);
            while (t0.isBefore(maxLookAheadTime) && eventCounter < this.getEventsPerUpdate()) {
                t1 = sch.nextCov(t0);
                v = BR2ScheduleDeviceExt.getValue((BAbstractSchedule)sch, t0);
                if (v) {
                    this.addEvent((BAbstractSchedule)sch, t0, t1, eventList);
                    ++eventCounter;
                }
                t0 = t1;
            }
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            System.out.println("\n\neventList from execute():");
            eventList.dump();
        }
        Abstime expires = (Abstime)oc.obixInvoke(new Uri(export.getSubordinate() + ".schedule"), (Obj)eventList);
        export.setSubordinateExpires(BAbsTime.make((long)expires.getMillis()));
    }

    @Override
    public Uri getScheduleContract() {
        return CONTRACT;
    }

    private BAbsTime addEvent(BAbstractSchedule schedule, BAbsTime start, BAbsTime end, List l) {
        String name = "defaultOutput";
        BAbstractSchedule outSource = schedule.getOutputSource(start);
        if (outSource != schedule) {
            name = outSource.getParent().getParent().getName();
        }
        Obj event = BR2ScheduleDeviceExt.makeEvent(start, end);
        BR2ScheduleDeviceExt.addEvent(l, name, event);
        return end;
    }

    private static void addEvent(List l, String name, Obj event) {
        Obj o = l.get(name);
        if (o == null) {
            l.add(name, event);
        } else {
            int i = 0;
            while (o != null) {
                o = l.get(name + ++i);
            }
            l.add(name + i, event);
        }
    }

    private static boolean getValue(BAbstractSchedule sched, BAbsTime t) {
        BStatusValue sv = sched.getOutput(t);
        if (!(sv instanceof BIBoolean)) {
            throw new IllegalArgumentException("Obix Schedule Export must reference BooleanSchedule type!");
        }
        boolean val = false;
        if (!sv.isNull()) {
            val = ((BIBoolean)sv).getBoolean();
        }
        return val;
    }

    private static Obj makeEvent(BAbsTime start, BAbsTime end) {
        Obj event = new Obj();
        event.setIs(EVENT_CONTRACT);
        event.add("dtstart", (Obj)new Abstime(start.getMillis()));
        event.add("dtend", (Obj)new Abstime(end.getMillis()));
        return event;
    }
}

