/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver.schedule;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.obix.driver.schedule.BObixScheduleDeviceExt;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(5)))", override=true), @NiagaraProperty(name="subordinate", type="String", defaultValue=""), @NiagaraProperty(name="subordinateExpires", type="BAbsTime", defaultValue="Clock.time()", flags=3), @NiagaraProperty(name="supervisor", type="BOrd", defaultValue="BOrd.NULL", flags=8, facets={@Facet(name="BFacets.TARGET_TYPE", value="\"baja:Component\"")}), @NiagaraProperty(name="supervisorVersion", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3)})
@NiagaraAction(name="forceSync")
public class BObixScheduleExport
extends BDescriptor
implements BIStatus {
    @Generated
    public static final Property executionTime = BObixScheduleExport.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)5))), null);
    @Generated
    public static final Property subordinate = BObixScheduleExport.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property subordinateExpires = BObixScheduleExport.newProperty((int)3, (BValue)Clock.time(), null);
    @Generated
    public static final Property supervisor = BObixScheduleExport.newProperty((int)8, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:Component"));
    @Generated
    public static final Property supervisorVersion = BObixScheduleExport.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Action forceSync = BObixScheduleExport.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BObixScheduleExport.class);
    private BObixScheduleDeviceExt deviceExt = null;
    private boolean licenseChecked = false;
    private boolean fatalFault = false;
    private String fatalFaultCause = null;

    @Generated
    public String getSubordinate() {
        return this.getString(subordinate);
    }

    @Generated
    public void setSubordinate(String v) {
        this.setString(subordinate, v, null);
    }

    @Generated
    public BAbsTime getSubordinateExpires() {
        return (BAbsTime)this.get(subordinateExpires);
    }

    @Generated
    public void setSubordinateExpires(BAbsTime v) {
        this.set(subordinateExpires, (BValue)v, null);
    }

    @Generated
    public BOrd getSupervisor() {
        return (BOrd)this.get(supervisor);
    }

    @Generated
    public void setSupervisor(BOrd v) {
        this.set(supervisor, (BValue)v, null);
    }

    @Generated
    public BAbsTime getSupervisorVersion() {
        return (BAbsTime)this.get(supervisorVersion);
    }

    @Generated
    public void setSupervisorVersion(BAbsTime v) {
        this.set(supervisorVersion, (BValue)v, null);
    }

    @Generated
    public void forceSync() {
        this.invoke(forceSync, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void atSteadyState() throws Exception {
        super.atSteadyState();
        if (!this.isDisabled()) {
            this.getObixNetwork().enqueue(new Runnable(){

                @Override
                public void run() {
                    BObixScheduleExport.this.checkObixLicense();
                }
            });
        }
        this.sExportAtSteadyState();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabled) && !this.isDisabled()) {
            this.checkObixLicense();
        }
    }

    public void doExecute() {
        this.executeInProgress();
        try {
            if (this.fatalFault) {
                this.executeFail(this.fatalFaultCause);
                return;
            }
            if (!(this.getSchedule() instanceof BBooleanSchedule)) {
                this.executeFail("Wrong Source Schedule Type:" + this.getSchedule().getType());
            }
            if (this.getSubordinateExpires().isAfter(this.getExecutionTime().getNextTrigger()) && this.getSupervisorVersion().equals((Object)BObixScheduleExport.getVersionOf(this.getSchedule()))) {
                this.setFaultCause("");
                this.setState(BDescriptorState.idle);
                this.updateStatus();
                return;
            }
            this.getObixScheduleDeviceExt().execute(this);
            this.setSupervisorVersion(BObixScheduleExport.getVersionOf(this.getSchedule()));
            this.executeOk();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Obix Schedule Export", e);
            this.executeFail(e);
        }
    }

    public void doForceSync() {
        this.setSupervisorVersion(BAbsTime.NULL);
        this.setSubordinateExpires(BAbsTime.NULL);
        this.setState(BDescriptorState.idle);
        this.execute();
    }

    public Logger getLogger() {
        return this.getObixScheduleDeviceExt().getLogger();
    }

    public BObixClient getObixClient() {
        return this.getObixScheduleDeviceExt().getObixClient();
    }

    public BObixScheduleDeviceExt getObixScheduleDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof BObixScheduleDeviceExt)) continue;
            this.deviceExt = (BObixScheduleDeviceExt)p;
            return this.deviceExt;
        }
        throw new IllegalStateException();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public BAbstractSchedule getSchedule() {
        BAbstractSchedule ret = null;
        try {
            ret = (BAbstractSchedule)this.getSupervisor().resolve((BObject)this).get();
        }
        catch (Exception x) {
            throw new BajaRuntimeException(this.getSupervisor().toString(null), (Throwable)x);
        }
        if (ret == null) {
            throw new IllegalArgumentException("Cannot resolve: " + this.getSupervisor().toString(null));
        }
        return ret;
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        if (a == execute) {
            return super.post(a, arg, cx);
        }
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public IFuture postExecute(Action a, BValue arg, Context cx) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public void stopped() throws Exception {
        this.setStatus(BStatus.down);
        this.deviceExt = null;
        super.stopped();
    }

    protected static BAbsTime getVersionOf(BAbstractSchedule sch) {
        return (BAbsTime)sch.get("lastModified");
    }

    protected void sExportAtSteadyState() throws Exception {
    }

    private void checkObixLicense() {
        String licenseFault;
        if (this.licenseChecked) {
            return;
        }
        Boolean isTridium = this.getObixClient().isTridiumServer();
        if (isTridium == null) {
            return;
        }
        if (!isTridium.booleanValue() && (licenseFault = this.getObixNetwork().checkObixLimit("foreignSchedule.limit")) != null) {
            this.configFatal(licenseFault);
        }
        this.licenseChecked = true;
    }

    private void configFatal(String ffc) {
        this.fatalFault = true;
        this.fatalFaultCause = ffc;
        this.executeFail(ffc);
    }
}

