/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver.lobby;

import com.tridium.obix.naming.ObixTarget;
import com.tridium.obix.util.BadUriErr;
import com.tridium.obix.util.Obj;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixServer;
import javax.baja.obix.driver.lobby.BIObixLobbyAgent;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BObixLobby
extends BComponent
implements BIObixEncodable {
    @Generated
    public static final Type TYPE = Sys.loadType(BObixLobby.class);
    BIObixLobbyAgent[] agents;
    HashMap<String, BIObixLobbyAgent> map;

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void encode(ObixEncoder out, Context cx) {
        Obj obj = new Obj();
        obj.setIs("obix:Lobby");
        obj.setName(out.getName());
        String href = out.getHref();
        obj.setHref(href);
        obj.write(out, true);
        for (BIObixLobbyAgent agent : this.agents) {
            String name = agent.getLobbyName();
            out.setName(name);
            out.setHref(out.getChildHref(href, name));
            agent.encodeLobbyChild(out, cx);
        }
        obj.endElem(out);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BObixServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdTarget resolve(String uri, Context cx) {
        BObixLobby bObixLobby = this;
        synchronized (bObixLobby) {
            if (this.agents == null) {
                this.loadAgents();
            }
        }
        if (uri.isEmpty() || "/".equals(uri)) {
            return new ObixTarget(this.findTarget(cx), (BObject)this);
        }
        String name = this.firstName(uri);
        BIObixLobbyAgent agent = this.map.get(name);
        if (agent == null) {
            throw new BadUriErr("Cannot find lobby agent for " + name);
        }
        int len = name.length() + 1;
        if (uri.length() == len) {
            return agent.resolve("", cx);
        }
        return agent.resolve(uri.substring(len), cx);
    }

    OrdTarget findTarget(Context cx) {
        while (cx != null) {
            if (cx instanceof OrdTarget) {
                return (OrdTarget)cx;
            }
            cx = cx.getBase();
        }
        return null;
    }

    String firstName(String uri) {
        int idx = uri.indexOf(47, 1);
        if (idx < 0) {
            return uri.substring(1);
        }
        return uri.substring(1, idx);
    }

    void loadAgents() {
        AgentList list = this.getAgents(null);
        this.map = new HashMap();
        int len = list.size();
        ArrayList<BIObixLobbyAgent> agentList = new ArrayList<BIObixLobbyAgent>();
        for (int i = 0; i < len; ++i) {
            AgentInfo info = list.get(i);
            if (!info.getAgentType().is(BIObixLobbyAgent.TYPE)) continue;
            BIObixLobbyAgent a = (BIObixLobbyAgent)info.getInstance();
            agentList.add(a);
            String name = a.getLobbyName();
            this.map.put(name, a);
            if (!(a instanceof BValue)) continue;
            name = SlotPath.escape((String)name);
            this.add(name, (BValue)a);
        }
        this.agents = agentList.toArray(new BIObixLobbyAgent[0]);
    }
}

