/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver.history;

import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.history.BObixHistoryDeviceExt;
import javax.baja.obix.driver.history.BObixHistoryDiscoveryResult;
import javax.baja.obix.driver.util.BObixDiscoveryJob;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import obix.Obj;
import obix.Uri;

@NiagaraType
@NiagaraAction(name="fetch", parameterType="BString", defaultValue="BString.make(\"\")", returnType="BObixHistoryDiscoveryResult")
public class BObixHistoryDiscoveryJob
extends BObixDiscoveryJob {
    @Generated
    public static final Action fetch = BObixHistoryDiscoveryJob.newAction((int)0, (BValue)BString.make((String)""), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BObixHistoryDiscoveryJob.class);
    private static final Uri LOBBY = new Uri("obix:Lobby");
    private static final Uri HISTORY_QUERY = new Uri("obix:History");
    protected BValue args;
    protected BObixHistoryDeviceExt ext;

    @Generated
    public BObixHistoryDiscoveryResult fetch(BString parameter) {
        return (BObixHistoryDiscoveryResult)this.invoke(fetch, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObixHistoryDiscoveryJob() {
    }

    public BObixHistoryDiscoveryJob(BObixHistoryDeviceExt ext, BValue args) {
        super(ext.getObixNetwork());
        this.ext = ext;
        this.args = args;
    }

    @Override
    public void doDiscover() {
        try {
            this.progress(25);
            BObixHistoryDiscoveryResult res = this.read(this.args.toString(null), Context.decoding);
            this.progress(75);
            this.addResult("result", (BValue)res);
            this.success();
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }

    public BObixHistoryDiscoveryResult doFetch(BString href) {
        try {
            return this.read(href.getString(), Context.decoding);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.failed(t);
            return null;
        }
    }

    public BObixHistoryDiscoveryResult getResult() {
        return (BObixHistoryDiscoveryResult)this.get("result");
    }

    protected BObixHistoryDiscoveryResult read(String href, Context cx) throws Exception {
        Obj obj = this.ext.getObixClient().obixRead(new Uri(href));
        return this.result(obj);
    }

    private BObixHistoryDiscoveryResult result(Obj obj) throws Exception {
        BObixClient client = this.ext.getObixClient();
        boolean isQuery = false;
        BObixHistoryDiscoveryResult res = new BObixHistoryDiscoveryResult();
        res.setHref(client.getRelativeUri(obj.getNormalizedHref()).get());
        if (obj.getName() != null) {
            res.setObixName(obj.getName());
        } else if (obj.is(LOBBY)) {
            res.setObixName("lobby");
        }
        if (obj.getIs() != null && obj.getIs().contains(HISTORY_QUERY)) {
            Obj tmp = obj.get("query");
            if (tmp != null && tmp.getHref() != null) {
                res.setQuery(client.getRelativeUri(tmp.getNormalizedHref()).get());
                isQuery = true;
            }
            if ((tmp = obj.get("start")) != null && !tmp.isNull()) {
                res.setStart(tmp.toDisplayString());
            }
            if ((tmp = obj.get("end")) != null && !tmp.isNull()) {
                res.setEnd(tmp.toDisplayString());
            }
            if ((tmp = obj.get("count")) != null && !tmp.isNull()) {
                res.setCount(tmp.toDisplayString());
            }
        }
        Obj[] kids = obj.list();
        BComponent children = res.getKids();
        int count = 0;
        for (Obj kid : kids) {
            BObixHistoryDiscoveryResult hr;
            if (kid.isOp() || kid.isFeed()) continue;
            String name = kid.getName();
            if (name == null || name.isEmpty()) {
                name = kid.getDisplayName();
            }
            if (name == null || name.isEmpty()) {
                name = kid.getElement();
            }
            name = SlotPath.escape((String)name);
            name = name + "?";
            if (kid.isRef()) {
                Uri uri = kid.getNormalizedHref();
                if (uri == null) continue;
                children.add(name, (BValue)BString.make((String)uri.get()));
                ++count;
                continue;
            }
            if (kid.getHref() == null || (hr = this.result(kid)) == null) continue;
            children.add(name, (BValue)hr);
            ++count;
        }
        if (count == 0 && !isQuery) {
            return null;
        }
        return res;
    }
}

