/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver.alarm;

import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.alarm.BObixAlarmDeviceExt;
import javax.baja.obix.driver.alarm.BObixAlarmDiscoveryResult;
import javax.baja.obix.driver.util.BObixDiscoveryJob;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import obix.Obj;
import obix.Uri;

@NiagaraType
@NiagaraAction(name="fetch", parameterType="BString", defaultValue="BString.make(\"\")", returnType="BObixAlarmDiscoveryResult")
public class BObixAlarmDiscoveryJob
extends BObixDiscoveryJob {
    @Generated
    public static final Action fetch = BObixAlarmDiscoveryJob.newAction((int)0, (BValue)BString.make((String)""), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BObixAlarmDiscoveryJob.class);
    private static final Uri LOBBY = new Uri("obix:Lobby");
    private static final Uri ALARM_SUBJECT = new Uri("obix:AlarmSubject");
    protected BValue uri;
    protected BObixAlarmDeviceExt ext;

    @Generated
    public BObixAlarmDiscoveryResult fetch(BString parameter) {
        return (BObixAlarmDiscoveryResult)this.invoke(fetch, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObixAlarmDiscoveryJob() {
    }

    public BObixAlarmDiscoveryJob(BObixAlarmDeviceExt ext, BValue uri) {
        super(ext.getObixNetwork());
        this.ext = ext;
        this.uri = uri;
    }

    @Override
    public void doDiscover() {
        try {
            this.progress(25);
            BObixAlarmDiscoveryResult res = this.read(this.uri.toString(null), Context.decoding);
            this.progress(75);
            this.addResult("result", (BValue)res);
            this.success();
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }

    public BObixAlarmDiscoveryResult doFetch(BString href) {
        try {
            return this.read(href.getString(), Context.decoding);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.failed(t);
            return null;
        }
    }

    public BObixAlarmDiscoveryResult getResult() {
        return (BObixAlarmDiscoveryResult)this.get("result");
    }

    protected BObixAlarmDiscoveryResult read(String href, Context cx) throws Exception {
        BObixClient client = this.ext.getObixClient();
        Obj obj = client.obixRead(new Uri(href));
        return this.result(obj);
    }

    private BObixAlarmDiscoveryResult result(Obj obj) throws Exception {
        Obj feed;
        BObixClient client = this.ext.getObixClient();
        boolean isFeed = false;
        BObixAlarmDiscoveryResult res = new BObixAlarmDiscoveryResult();
        res.setHref(client.getRelativeUri(obj.getNormalizedHref()).get());
        if (obj.getName() != null) {
            res.setObixName(obj.getName());
        } else if (obj.is(LOBBY)) {
            res.setObixName("lobby");
        }
        if (obj.getIs() != null && obj.getIs().contains(ALARM_SUBJECT) && (feed = obj.get("feed")) != null && feed.getHref() != null) {
            res.setFeed(client.getRelativeUri(feed.getNormalizedHref()).get());
            isFeed = true;
        }
        Obj[] kids = obj.list();
        BComponent children = res.getKids();
        int count = 0;
        for (Obj kid : kids) {
            BObixAlarmDiscoveryResult ar;
            if (kid.isOp() || kid.isFeed()) continue;
            String name = kid.getName();
            if (name == null || name.isEmpty()) {
                name = kid.getDisplayName();
            }
            if (name == null || name.isEmpty()) {
                name = kid.getElement();
            }
            name = SlotPath.escape((String)name);
            name = name + "?";
            if (kid.isRef()) {
                Uri uri = kid.getNormalizedHref();
                if (uri == null) continue;
                children.add(name, (BValue)BString.make((String)uri.get()));
                ++count;
                continue;
            }
            if (kid.getHref() == null || (ar = this.result(kid)) == null) continue;
            children.add(name, (BValue)ar);
            ++count;
        }
        if (count == 0 && !isFeed) {
            return null;
        }
        return res;
    }
}

