/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.util.ObixConstants;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.WrapperException;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryService;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.lobby.BIObixLobbyAgent;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType(agent={@AgentOn(types={"obixDriver:ObixLobby"}, requiredPermissions="r")})
@NiagaraProperties(value={@NiagaraProperty(name="obixVersion", type="String", defaultValue="BObixAbout.DEFAULT_OBIX_VERSION_VALUE", flags=257), @NiagaraProperty(name="serverName", type="String", defaultValue="serverName()", flags=257), @NiagaraProperty(name="serverTime", type="BAbsTime", defaultValue="Clock.time()", flags=257), @NiagaraProperty(name="serverBootTime", type="BAbsTime", defaultValue="Clock.time()", flags=257), @NiagaraProperty(name="vendorName", type="String", defaultValue="Tridium, Inc.", flags=257), @NiagaraProperty(name="vendorUrl", type="BOrd", defaultValue="BOrd.make(\"http://www.tridium.com\")", flags=257), @NiagaraProperty(name="productName", type="String", defaultValue="Niagara AX", flags=257), @NiagaraProperty(name="productVersion", type="String", defaultValue="version()", flags=257), @NiagaraProperty(name="productUrl", type="BOrd", defaultValue="BOrd.make(\"http://www.tridium.com\")", flags=257), @NiagaraProperty(name="tz", type="String", defaultValue="tz()", flags=257), @NiagaraProperty(name="componentCount", type="String", defaultValue="componentCount()", flags=257), @NiagaraProperty(name="localHistoryCount", type="String", defaultValue="localHistoryCount()", flags=257)})
public class BObixAbout
extends BObixAgent
implements BIObixLobbyAgent,
ObixConstants {
    @Generated
    public static final Property obixVersion = BObixAbout.newProperty((int)257, (String)"1.0", null);
    @Generated
    public static final Property serverName = BObixAbout.newProperty((int)257, (String)BObixAbout.serverName(), null);
    @Generated
    public static final Property serverTime = BObixAbout.newProperty((int)257, (BValue)Clock.time(), null);
    @Generated
    public static final Property serverBootTime = BObixAbout.newProperty((int)257, (BValue)Clock.time(), null);
    @Generated
    public static final Property vendorName = BObixAbout.newProperty((int)257, (String)"Tridium, Inc.", null);
    @Generated
    public static final Property vendorUrl = BObixAbout.newProperty((int)257, (BValue)BOrd.make((String)"http://www.tridium.com"), null);
    @Generated
    public static final Property productName = BObixAbout.newProperty((int)257, (String)"Niagara AX", null);
    @Generated
    public static final Property productVersion = BObixAbout.newProperty((int)257, (String)BObixAbout.version(), null);
    @Generated
    public static final Property productUrl = BObixAbout.newProperty((int)257, (BValue)BOrd.make((String)"http://www.tridium.com"), null);
    @Generated
    public static final Property tz = BObixAbout.newProperty((int)257, (String)BObixAbout.tz(), null);
    @Generated
    public static final Property componentCount = BObixAbout.newProperty((int)257, (String)BObixAbout.componentCount(), null);
    @Generated
    public static final Property localHistoryCount = BObixAbout.newProperty((int)257, (String)BObixAbout.localHistoryCount(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BObixAbout.class);
    private static final String DEFAULT_OBIX_VERSION_VALUE = "1.0";

    @Generated
    public String getObixVersion() {
        return this.getString(obixVersion);
    }

    @Generated
    public void setObixVersion(String v) {
        this.setString(obixVersion, v, null);
    }

    @Generated
    public String getServerName() {
        return this.getString(serverName);
    }

    @Generated
    public void setServerName(String v) {
        this.setString(serverName, v, null);
    }

    @Generated
    public BAbsTime getServerTime() {
        return (BAbsTime)this.get(serverTime);
    }

    @Generated
    public void setServerTime(BAbsTime v) {
        this.set(serverTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getServerBootTime() {
        return (BAbsTime)this.get(serverBootTime);
    }

    @Generated
    public void setServerBootTime(BAbsTime v) {
        this.set(serverBootTime, (BValue)v, null);
    }

    @Generated
    public String getVendorName() {
        return this.getString(vendorName);
    }

    @Generated
    public void setVendorName(String v) {
        this.setString(vendorName, v, null);
    }

    @Generated
    public BOrd getVendorUrl() {
        return (BOrd)this.get(vendorUrl);
    }

    @Generated
    public void setVendorUrl(BOrd v) {
        this.set(vendorUrl, (BValue)v, null);
    }

    @Generated
    public String getProductName() {
        return this.getString(productName);
    }

    @Generated
    public void setProductName(String v) {
        this.setString(productName, v, null);
    }

    @Generated
    public String getProductVersion() {
        return this.getString(productVersion);
    }

    @Generated
    public void setProductVersion(String v) {
        this.setString(productVersion, v, null);
    }

    @Generated
    public BOrd getProductUrl() {
        return (BOrd)this.get(productUrl);
    }

    @Generated
    public void setProductUrl(BOrd v) {
        this.set(productUrl, (BValue)v, null);
    }

    @Generated
    public String getTz() {
        return this.getString(tz);
    }

    @Generated
    public void setTz(String v) {
        this.setString(tz, v, null);
    }

    @Generated
    public String getComponentCount() {
        return this.getString(componentCount);
    }

    @Generated
    public void setComponentCount(String v) {
        this.setString(componentCount, v, null);
    }

    @Generated
    public String getLocalHistoryCount() {
        return this.getString(localHistoryCount);
    }

    @Generated
    public void setLocalHistoryCount(String v) {
        this.setString(localHistoryCount, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void encodeLobbyChild(ObixEncoder out, Context cx) {
        try {
            Obj o = new Obj();
            o.setHref(out.getHref());
            o.setName("about");
            o.setElement("ref");
            o.setIs("obix:About");
            o.write(out, false);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    @Override
    public String getLobbyName() {
        return "about";
    }

    @Override
    public String processAttr(String name, String value) {
        if (name.equals("is")) {
            return "obix:About";
        }
        return value;
    }

    @Override
    public OrdTarget resolve(String uri, Context cx) {
        this.setServerTime(Clock.time());
        try {
            BOrd o = BOrd.make((String)"station:");
            o = BOrd.make((BOrd)o, (BOrd)this.getSlotPathOrd());
            if (uri.isEmpty() || "/".equals(uri)) {
                return o.resolve((BObject)Sys.getStation(), cx);
            }
            o = BOrd.make((BOrd)o, (String)("slot:" + uri.substring(1)));
            return o.resolve((BObject)Sys.getStation(), cx);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    private static String componentCount() {
        try {
            BStation s = Sys.getStation();
            if (s != null) {
                return String.valueOf(s.getComponentSpace().getComponentCount());
            }
            return "workbench";
        }
        catch (Exception x) {
            return x.toString();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String localHistoryCount() {
        try {
            BHistoryService hs = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = hs.getDatabase();
            if (!(db instanceof BLocalHistoryDatabase)) return "0";
            BLocalHistoryDatabase ldb = (BLocalHistoryDatabase)db;
            try (TableCursor cur = ldb.cursor();){
                int historyCount = 0;
                while (cur.next()) {
                    ++historyCount;
                }
                String string = String.valueOf(historyCount);
                return string;
            }
        }
        catch (Exception x) {
            return x.toString();
        }
    }

    private static String serverName() {
        return Sys.getHostName();
    }

    private static String tz() {
        try {
            return BTimeZone.getLocal().getId();
        }
        catch (Exception x) {
            return x.getMessage();
        }
    }

    private static String version() {
        try {
            return Sys.getBajaVersion().toString();
        }
        catch (Exception x) {
            return x.getMessage();
        }
    }
}

