/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.server.BAlarmServiceAgent;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.WrapperException;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
public class BAlarmWrapper
extends BObject
implements BIObixEncodable,
BIObixInvocable {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmWrapper.class);
    boolean ack;
    BAlarmRecord rec;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmWrapper() {
    }

    public BAlarmWrapper(BAlarmRecord rec, boolean ack) {
        this.rec = rec;
        this.ack = ack;
    }

    @Override
    public void encode(ObixEncoder out, Context cx) {
        Obj obj = new Obj();
        if (this.ack) {
            obj.initOp("ack", "obix:AlarmAckIn", "obix:AlarmAckOut");
            obj.setName(out.getName());
            obj.setHref(out.getHref());
            obj.write(out, false);
            return;
        }
        BAlarmServiceAgent.encodeAlarm(this.rec, out, obj.reset(), cx);
    }

    @Override
    public void invoke(ObixDecoder in, ObixEncoder out) {
        try {
            BAlarmService service;
            BValue ackAlarmIn = in.decode();
            BUser user = in.getUser();
            String ackUser = ackAlarmIn.asComplex().get("ackUser").toString();
            if (ackUser == null) {
                this.rec.setUser(ackUser);
            } else if (user != null) {
                String s = user.getFullName();
                if (s == null || s.isEmpty()) {
                    s = user.getUsername();
                }
                if (s == null || s.isEmpty()) {
                    s = user.getName();
                }
                this.rec.setUser(s);
            }
            if (user != null && ackAlarmIn.asComplex().get("forceCleared") != null) {
                boolean hasAdminWrite;
                service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                BAlarmClass alarmClass = service.lookupAlarmClass(this.rec.getAlarmClass());
                BasicContext cx = new BasicContext(user);
                boolean bl = hasAdminWrite = alarmClass == null ? false : alarmClass.getPermissions((Context)cx).hasAdminWrite();
                if (!hasAdminWrite) {
                    throw new SecurityException("A force clear was attempted on an alarm via oBIX without admin write permission on its associated alarm class.");
                }
                this.rec.setUser(ackUser);
                this.rec.setAckTime(BAbsTime.now());
                this.rec.setAckState(BAckState.acked);
                this.rec.setSourceState(BSourceState.normal);
                this.rec.addAlarmFacet("forceCleared", (BIDataValue)BString.make((String)ackUser));
                try (AlarmDbConnection conn = service.getAlarmDb().getDbConnection(null);){
                    conn.update(this.rec);
                }
                service.invoke(BAlarmService.auditForceClear, (BValue)this.rec, (Context)user);
            } else {
                this.rec.setAckState(BAckState.ackPending);
                service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                try (AlarmDbConnection conn = service.getAlarmDb().getDbConnection(null);){
                    conn.update(this.rec);
                }
                service.ackAlarm(this.rec);
            }
            Obj ret = new Obj();
            ret.setIs("obix:AckAlarmOut");
            ret.write(out, true);
            out.setName("alarm");
            BAlarmServiceAgent.encodeAlarm(this.rec, out, ret, in);
            ret.reset().endElem(out);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WrapperException(e);
        }
    }
}

