/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsh;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nsh.NShell;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Exec
extends Thread {
    NShell nsh;
    String[] cmd;
    String[] envp;
    File dir;
    PrintStream out;
    Process proc;
    boolean done;
    private static final Logger LOGGER = Logger.getLogger("nsh");

    public Exec(NShell nsh, String[] cmd, String[] envp, File dir, PrintStream out) {
        this.nsh = nsh;
        this.cmd = cmd;
        this.envp = envp;
        this.dir = dir;
        this.out = out;
    }

    public synchronized void waitUntilDone() throws InterruptedException {
        while (!this.done) {
            this.wait();
        }
    }

    @Override
    public synchronized void run() {
        int exitCode = -1;
        try {
            String[] fCmd = this.cmd;
            String[] fEnvp = this.envp;
            File fDir = this.dir;
            this.proc = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(fCmd, fEnvp, fDir));
            ProcessReader err = new ProcessReader(this.proc.getErrorStream(), this.out);
            ProcessReader in = new ProcessReader(this.proc.getInputStream(), this.out);
            err.start();
            in.start();
            try {
                exitCode = this.proc.waitFor();
                err.kill();
                in.kill();
            }
            catch (Exception e) {
                if (this.proc != null) {
                    this.proc.destroy();
                    this.proc = null;
                    err.kill9();
                    in.kill9();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Command failed", e);
            this.out.println("Command failed: " + e);
        }
        this.out.flush();
        this.done = true;
        if (this.nsh != null) {
            this.nsh.execDone(exitCode);
        }
        this.notify();
    }

    public void kill() {
        if (this.proc != null) {
            String command = OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows) ? this.cmd[2] : this.cmd[0];
            Logger.getLogger("console").warning("Killing Console Process: " + command);
            this.interrupt();
        }
    }

    static class ProcessReader
    extends Thread {
        InputStream in;
        PrintStream out;

        ProcessReader(InputStream in, PrintStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.in.read()) >= 0) {
                    this.out.write((char)c);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void kill() {
            try {
                while (this.in.available() > 0) {
                    Thread.yield();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void kill9() {
            try {
                this.in = null;
                this.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

