/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.point;

import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.point.BOpcUaMethodProxyExt;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import com.tridium.opcUaCore.BUaArgumentVector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="callMethod", parameterType="BVector", defaultValue="new BVector()", returnType="BVector", flags=256)
public class BOpcUaMethod
extends BStringPoint {
    @Generated
    public static final Action callMethod = BOpcUaMethod.newAction((int)256, (BValue)new BVector(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaMethod.class);
    private static final String PROP_RESULT = "result";
    private static final String PROP_LAST_ARG = "lastArg";
    public static final Logger logger = Logger.getLogger("opcUaClient.point");

    @Generated
    public BVector callMethod(BVector parameter) {
        return (BVector)this.invoke(callMethod, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
    }

    public BVector doCallMethod(BVector arg) {
        logger.info("BOpcUaMethod.doInvoke(" + arg + ")");
        arg.loadSlots();
        BAbstractProxyExt proxyExt = this.getProxyExt();
        if (proxyExt instanceof BOpcUaMethodProxyExt) {
            BOpcUaMethodProxyExt proxy = (BOpcUaMethodProxyExt)proxyExt;
            BOpcUaDevice device = proxy.getBOpcUaClientDevice();
            NodeId objectNodeId = NodeId.parseNodeId((String)proxy.getObjectId());
            NodeId methodNodeId = NodeId.parseNodeId((String)proxy.getUaNodeId());
            Variant[] methodArg = proxy.getInputArgs().makeUserArguments(arg);
            try {
                Property lastArg;
                Variant[] results = OpcUaClientUtil.call(device.uaClient, objectNodeId, methodNodeId, methodArg);
                BUaArgumentVector resultDefs = ((BOpcUaMethodProxyExt)this.getProxyExt()).getResults();
                BVector resultsVector = resultDefs.makeResultVector(results);
                BValue bResult = resultsVector.get(PROP_RESULT);
                if (bResult != null) {
                    proxy.readOk((BStatusValue)new BStatusString(bResult.toString()));
                    this.updateResults(bResult);
                }
                if ((lastArg = this.getProperty(PROP_LAST_ARG)) == null) {
                    this.add(PROP_LAST_ARG, (BValue)arg, 7);
                } else {
                    this.set(lastArg, (BValue)arg);
                }
                return resultsVector;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.WARNING, "Error in CallMethod.", e);
                }
                logger.log(Level.WARNING, "Error in CallMethod: " + e.getMessage());
            }
        }
        return null;
    }

    private void updateResults(BValue bResult) {
        BStatusNumeric sValue = null;
        if (bResult instanceof BNumber) {
            sValue = new BStatusNumeric(((BNumber)bResult).getDouble());
        } else if (bResult instanceof BBoolean) {
            sValue = new BStatusBoolean(((BBoolean)bResult).getBoolean());
        } else if (bResult instanceof BString) {
            sValue = new BStatusString(((BString)bResult).getString());
        }
        BValue resultPropValue = this.get(PROP_RESULT);
        if (resultPropValue == null) {
            this.add(PROP_RESULT, (BValue)sValue, 267);
        } else if (sValue != null && resultPropValue.getType().is(sValue.getType())) {
            resultPropValue.asComplex().copyFrom((BComplex)sValue);
        } else {
            this.set(this.getProperty(PROP_RESULT), (BValue)sValue);
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(callMethod)) {
            BValue value = this.get(PROP_LAST_ARG);
            if (value != null) {
                return value.newCopy(true);
            }
            BOpcUaMethodProxyExt proxyExt = (BOpcUaMethodProxyExt)this.getProxyExt();
            return proxyExt.makeDefaultInputArgs();
        }
        return action.getParameterDefault();
    }
}

