/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.OperationLimits;
import com.prosysopc.ua.SessionActivationException;
import com.prosysopc.ua.UserIdentity;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.ServerStatusListener;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.client.UaClientListener;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.stack.core.ObjectIdentifiers;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import com.prosysopc.ua.stack.core.VariableIdentifiers;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.discover.BNDiscoveryJob;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.ndriver.poll.BINPollable;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nre.security.SecretChars;
import com.tridium.opcUaClient.BOpcUaBuildInfo;
import com.tridium.opcUaClient.BOpcUaNetwork;
import com.tridium.opcUaClient.BOpcUserAuthenticationMode;
import com.tridium.opcUaClient.alarm.BOpcUaClientAlarmDeviceExt;
import com.tridium.opcUaClient.history.BOpcUaClientHistoryDeviceExt;
import com.tridium.opcUaClient.point.BOpcUaClientPointDeviceExt;
import com.tridium.opcUaClient.point.BOpcUaClientPointDiscoveryPreferences;
import com.tridium.opcUaClient.point.BOpcUaClientProxyExt;
import com.tridium.opcUaClient.point.BOpcUaLearnBase;
import com.tridium.opcUaClient.point.BOpcUaNodeLearnEntry;
import com.tridium.opcUaClient.util.OpcUaClientCertificateValidator;
import com.tridium.opcUaClient.util.OpcUaClientListener;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import com.tridium.opcUaClient.util.OpcUaServerStatusListener;
import com.tridium.opcUaCore.enums.BSecurityMode;
import com.tridium.opcUaCore.enums.BServerState;
import com.tridium.opcUaCore.util.OpcUaCoreUtil;
import com.tridium.util.CompUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_READONLY)")}, override=true), @NiagaraProperty(name="pollScheduler", type="BNPollScheduler", defaultValue="new BNPollScheduler()"), @NiagaraProperty(name="serverEndpointUrl", type="String", defaultValue=""), @NiagaraProperty(name="securityMode", type="BSecurityMode", defaultValue="BSecurityMode.DEFAULT", flags=64), @NiagaraProperty(name="certificate", type="String", defaultValue="CertUtils.LEGACY_CERT_ALIAS", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:CertificateAliasFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:CertificateAliasEditor\"))"), @Facet(value="BFacets.make(\"purposeId\", BString.make(\"CLIENT_CERT\"))")}, deprecated=true), @NiagaraProperty(name="certAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", flags=4, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="userAuthenticationMode", type="BOpcUserAuthenticationMode", defaultValue="BOpcUserAuthenticationMode.DEFAULT", flags=64), @NiagaraProperty(name="userName", type="String", defaultValue="", flags=64), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT", flags=64), @NiagaraProperty(name="userAuthenticationCertificate", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", flags=4, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="serverState", type="BServerState", defaultValue="BServerState.Unknown", flags=67), @NiagaraProperty(name="serverCurrentTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="serverStartTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="timeoutInterval", type="BRelTime", defaultValue="BRelTime.make(30*1000)", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true"), @Facet(name="BFacets.MIN", value="BRelTime.make(1)")}), @NiagaraProperty(name="statusCheckTimeout", type="BRelTime", defaultValue="BRelTime.make(10*1000)", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true"), @Facet(name="BFacets.MIN", value="BRelTime.make(1)")}), @NiagaraProperty(name="operationLimit", type="BRelTime", defaultValue="BRelTime.make(10*1000)", flags=4, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true"), @Facet(name="BFacets.MIN", value="BRelTime.make(1)")}), @NiagaraProperty(name="serverInfo", type="BOpcUaBuildInfo", defaultValue="new BOpcUaBuildInfo()", flags=1), @NiagaraProperty(name="AlarmExt", type="BOpcUaClientAlarmDeviceExt", defaultValue="new BOpcUaClientAlarmDeviceExt()", flags=1), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal", flags=4), @NiagaraProperty(name="points", type="BOpcUaClientPointDeviceExt", defaultValue="new BOpcUaClientPointDeviceExt()"), @NiagaraProperty(name="histories", type="BOpcUaClientHistoryDeviceExt", defaultValue="new BOpcUaClientHistoryDeviceExt()"), @NiagaraProperty(name="lastLearnedInfo", type="String", defaultValue="", flags=7), @NiagaraProperty(name="learnRootNodeIdString", type="String", defaultValue="ObjectIdentifiers.RootFolder.toString()", flags=6), @NiagaraProperty(name="initialHistoryArchiveFromDate", type="BAbsTime", defaultValue="BAbsTime.DEFAULT")})
@NiagaraActions(value={@NiagaraAction(name="learn", flags=16), @NiagaraAction(name="resetComm", parameterType="BInteger", defaultValue="BInteger.make(60)", flags=16), @NiagaraAction(name="updateNamespaceUri", flags=20), @NiagaraAction(name="resetDelay", flags=20)})
public class BOpcUaDevice
extends BNDevice
implements BINPollable,
IPropertyValidator,
BISecurityDashboardProviderAgent,
BISecurityDashboardProvider {
    @Generated
    public static final Property status = BOpcUaDevice.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    @Generated
    public static final Property pollScheduler = BOpcUaDevice.newProperty((int)0, (BValue)new BNPollScheduler(), null);
    @Generated
    public static final Property serverEndpointUrl = BOpcUaDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property securityMode = BOpcUaDevice.newProperty((int)64, (BValue)BSecurityMode.DEFAULT, null);
    @Deprecated
    @Generated
    public static final Property certificate = BOpcUaDevice.newProperty((int)0, (String)"tridium", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"purposeId", (BIDataValue)BString.make((String)"CLIENT_CERT"))));
    @Generated
    public static final Property certAliasAndPassword = BOpcUaDevice.newProperty((int)4, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property userAuthenticationMode = BOpcUaDevice.newProperty((int)64, (BValue)BOpcUserAuthenticationMode.DEFAULT, null);
    @Generated
    public static final Property userName = BOpcUaDevice.newProperty((int)64, (String)"", null);
    @Generated
    public static final Property password = BOpcUaDevice.newProperty((int)64, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property userAuthenticationCertificate = BOpcUaDevice.newProperty((int)4, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property serverState = BOpcUaDevice.newProperty((int)67, (BValue)BServerState.Unknown, null);
    @Generated
    public static final Property serverCurrentTime = BOpcUaDevice.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property serverStartTime = BOpcUaDevice.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property timeoutInterval = BOpcUaDevice.newProperty((int)0, (BValue)BRelTime.make((long)30000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L))));
    @Generated
    public static final Property statusCheckTimeout = BOpcUaDevice.newProperty((int)0, (BValue)BRelTime.make((long)10000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L))));
    @Generated
    public static final Property operationLimit = BOpcUaDevice.newProperty((int)4, (BValue)BRelTime.make((long)10000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L))));
    @Generated
    public static final Property serverInfo = BOpcUaDevice.newProperty((int)1, (BValue)new BOpcUaBuildInfo(), null);
    @Generated
    public static final Property AlarmExt = BOpcUaDevice.newProperty((int)1, (BValue)new BOpcUaClientAlarmDeviceExt(), null);
    @Generated
    public static final Property pollFrequency = BOpcUaDevice.newProperty((int)4, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property points = BOpcUaDevice.newProperty((int)0, (BValue)new BOpcUaClientPointDeviceExt(), null);
    @Generated
    public static final Property histories = BOpcUaDevice.newProperty((int)0, (BValue)new BOpcUaClientHistoryDeviceExt(), null);
    @Generated
    public static final Property lastLearnedInfo = BOpcUaDevice.newProperty((int)7, (String)"", null);
    @Generated
    public static final Property learnRootNodeIdString = BOpcUaDevice.newProperty((int)6, (String)ObjectIdentifiers.RootFolder.toString(), null);
    @Generated
    public static final Property initialHistoryArchiveFromDate = BOpcUaDevice.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Action learn = BOpcUaDevice.newAction((int)16, null);
    @Generated
    public static final Action resetComm = BOpcUaDevice.newAction((int)16, (BValue)BInteger.make((int)60), null);
    @Generated
    public static final Action updateNamespaceUri = BOpcUaDevice.newAction((int)20, null);
    @Generated
    public static final Action resetDelay = BOpcUaDevice.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaDevice.class);
    private boolean initialized;
    protected final UaClientListener clientListener = new OpcUaClientListener();
    protected final OpcUaServerStatusListener serverStatusListener = new OpcUaServerStatusListener(this);
    public UaClient uaClient;
    private int lastLearnCount = 0;
    private Clock.Ticket commResetTicket;
    private BOpcUaNodeLearnEntry[] descendants;
    public static final Logger logger = Logger.getLogger("opcUaClient.client");
    public static final Lexicon lex = Lexicon.make(BOpcUaDevice.class);
    public static final String SERVER_ROOT_COMPONENT_NAME = "serverRoot";
    public static final String APP_NAME = "NiagaraOpcUaClient";
    public static final Pattern OPCUA_IPV4_PATTERN = Pattern.compile("\\b((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.|$)){4}\\b");
    private static final String OPC_TCP = "opc.tcp";
    public static final String SERVER_KEY_PASSWORD_SLOT_NAME = "serverKeyPassword";
    private static final String WRONG_KEY_USED_FOR_DECRYPTION_ERROR_MESSAGE = "Given final block not properly padded.";
    private static final int DEFAULT_MAX_ARRAY_SIZE = 200;

    @Generated
    public BNPollScheduler getPollScheduler() {
        return (BNPollScheduler)this.get(pollScheduler);
    }

    @Generated
    public void setPollScheduler(BNPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    @Generated
    public String getServerEndpointUrl() {
        return this.getString(serverEndpointUrl);
    }

    @Generated
    public void setServerEndpointUrl(String v) {
        this.setString(serverEndpointUrl, v, null);
    }

    @Generated
    public BSecurityMode getSecurityMode() {
        return (BSecurityMode)this.get(securityMode);
    }

    @Generated
    public void setSecurityMode(BSecurityMode v) {
        this.set(securityMode, (BValue)v, null);
    }

    @Deprecated
    @Generated
    public String getCertificate() {
        return this.getString(certificate);
    }

    @Deprecated
    @Generated
    public void setCertificate(String v) {
        this.setString(certificate, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getCertAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(certAliasAndPassword);
    }

    @Generated
    public void setCertAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(certAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public BOpcUserAuthenticationMode getUserAuthenticationMode() {
        return (BOpcUserAuthenticationMode)this.get(userAuthenticationMode);
    }

    @Generated
    public void setUserAuthenticationMode(BOpcUserAuthenticationMode v) {
        this.set(userAuthenticationMode, (BValue)v, null);
    }

    @Generated
    public String getUserName() {
        return this.getString(userName);
    }

    @Generated
    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getUserAuthenticationCertificate() {
        return (BCertificateAliasAndPassword)this.get(userAuthenticationCertificate);
    }

    @Generated
    public void setUserAuthenticationCertificate(BCertificateAliasAndPassword v) {
        this.set(userAuthenticationCertificate, (BValue)v, null);
    }

    @Generated
    public BServerState getServerState() {
        return (BServerState)this.get(serverState);
    }

    @Generated
    public void setServerState(BServerState v) {
        this.set(serverState, (BValue)v, null);
    }

    @Generated
    public BAbsTime getServerCurrentTime() {
        return (BAbsTime)this.get(serverCurrentTime);
    }

    @Generated
    public void setServerCurrentTime(BAbsTime v) {
        this.set(serverCurrentTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getServerStartTime() {
        return (BAbsTime)this.get(serverStartTime);
    }

    @Generated
    public void setServerStartTime(BAbsTime v) {
        this.set(serverStartTime, (BValue)v, null);
    }

    @Generated
    public BRelTime getTimeoutInterval() {
        return (BRelTime)this.get(timeoutInterval);
    }

    @Generated
    public void setTimeoutInterval(BRelTime v) {
        this.set(timeoutInterval, (BValue)v, null);
    }

    @Generated
    public BRelTime getStatusCheckTimeout() {
        return (BRelTime)this.get(statusCheckTimeout);
    }

    @Generated
    public void setStatusCheckTimeout(BRelTime v) {
        this.set(statusCheckTimeout, (BValue)v, null);
    }

    @Generated
    public BRelTime getOperationLimit() {
        return (BRelTime)this.get(operationLimit);
    }

    @Generated
    public void setOperationLimit(BRelTime v) {
        this.set(operationLimit, (BValue)v, null);
    }

    @Generated
    public BOpcUaBuildInfo getServerInfo() {
        return (BOpcUaBuildInfo)this.get(serverInfo);
    }

    @Generated
    public void setServerInfo(BOpcUaBuildInfo v) {
        this.set(serverInfo, (BValue)v, null);
    }

    @Generated
    public BOpcUaClientAlarmDeviceExt getAlarmExt() {
        return (BOpcUaClientAlarmDeviceExt)this.get(AlarmExt);
    }

    @Generated
    public void setAlarmExt(BOpcUaClientAlarmDeviceExt v) {
        this.set(AlarmExt, (BValue)v, null);
    }

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public BOpcUaClientPointDeviceExt getPoints() {
        return (BOpcUaClientPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BOpcUaClientPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public BOpcUaClientHistoryDeviceExt getHistories() {
        return (BOpcUaClientHistoryDeviceExt)this.get(histories);
    }

    @Generated
    public void setHistories(BOpcUaClientHistoryDeviceExt v) {
        this.set(histories, (BValue)v, null);
    }

    @Generated
    public String getLastLearnedInfo() {
        return this.getString(lastLearnedInfo);
    }

    @Generated
    public void setLastLearnedInfo(String v) {
        this.setString(lastLearnedInfo, v, null);
    }

    @Generated
    public String getLearnRootNodeIdString() {
        return this.getString(learnRootNodeIdString);
    }

    @Generated
    public void setLearnRootNodeIdString(String v) {
        this.setString(learnRootNodeIdString, v, null);
    }

    @Generated
    public BAbsTime getInitialHistoryArchiveFromDate() {
        return (BAbsTime)this.get(initialHistoryArchiveFromDate);
    }

    @Generated
    public void setInitialHistoryArchiveFromDate(BAbsTime v) {
        this.set(initialHistoryArchiveFromDate, (BValue)v, null);
    }

    @Generated
    public void learn() {
        this.invoke(learn, null, null);
    }

    @Generated
    public void resetComm(BInteger parameter) {
        this.invoke(resetComm, (BValue)parameter, null);
    }

    @Generated
    public void updateNamespaceUri() {
        this.invoke(updateNamespaceUri, null, null);
    }

    @Generated
    public void resetDelay() {
        this.invoke(resetDelay, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BOpcUaNetwork.TYPE;
    }

    public void started() throws Exception {
        BOpcUaNetwork opcUaNetwork;
        Slot serverKeyPasswordSlot;
        super.started();
        if (!Flags.has((BComplex)this, (Slot)certificate, (int)0x10000000)) {
            this.getCertAliasAndPassword().setAlias(this.getCertificate());
            this.getCertAliasAndPassword().setPassword(BPassword.DEFAULT);
            Flags.add((BComponent)this, (Slot)certificate, null, (int[])new int[]{0x10000005});
        }
        if (!Flags.has((BComplex)this, (Slot)certAliasAndPassword, (int)0x10000000)) {
            Flags.add((BComponent)this, (Slot)certAliasAndPassword, null, (int[])new int[]{0x10000000});
            this.setFlags((Slot)certAliasAndPassword, this.getFlags((Slot)certAliasAndPassword) & 0xFFFFFFFB);
            this.getCertAliasAndPassword().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)KeyPurpose.CLIENT_CERT.name()));
        }
        if (!Flags.has((BComplex)this, (Slot)userAuthenticationCertificate, (int)0x10000000)) {
            Flags.add((BComponent)this, (Slot)userAuthenticationCertificate, null, (int[])new int[]{0x10000000});
            this.setFlags((Slot)userAuthenticationCertificate, this.getFlags((Slot)userAuthenticationCertificate) & 0xFFFFFFFB);
            this.getUserAuthenticationCertificate().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)KeyPurpose.CLIENT_CERT.name()));
        }
        if ((serverKeyPasswordSlot = this.getSlot(SERVER_KEY_PASSWORD_SLOT_NAME)) != null) {
            if (serverKeyPasswordSlot.isProperty()) {
                this.getCertAliasAndPassword().setPassword((BPassword)this.get(SERVER_KEY_PASSWORD_SLOT_NAME));
            }
            this.remove(SERVER_KEY_PASSWORD_SLOT_NAME);
        }
        if ((opcUaNetwork = this.getOpcUaClientNetwork()).isDisabled() || opcUaNetwork.isDown() || opcUaNetwork.isFault()) {
            return;
        }
        if (BOpcUserAuthenticationMode.userNameAndPassword.equals((Object)this.getUserAuthenticationMode())) {
            this.setFlags((Slot)userName, this.getFlags((Slot)userName) & 0xFFFFFFFB);
            this.setFlags((Slot)password, this.getFlags((Slot)password) & 0xFFFFFFFB);
            this.setFlags((Slot)userAuthenticationCertificate, this.getFlags((Slot)userAuthenticationCertificate) | 4);
        } else if (BOpcUserAuthenticationMode.certificate.equals((Object)this.getUserAuthenticationMode())) {
            this.setFlags((Slot)userName, this.getFlags((Slot)userName) | 4);
            this.setFlags((Slot)password, this.getFlags((Slot)password) | 4);
            this.setFlags((Slot)userAuthenticationCertificate, this.getFlags((Slot)userAuthenticationCertificate) & 0xFFFFFFFB);
        } else if (BOpcUserAuthenticationMode.anonymous.equals((Object)this.getUserAuthenticationMode())) {
            this.setFlags((Slot)userName, this.getFlags((Slot)userName) | 4);
            this.setFlags((Slot)password, this.getFlags((Slot)password) | 4);
            this.setFlags((Slot)userAuthenticationCertificate, this.getFlags((Slot)userAuthenticationCertificate) | 4);
        } else {
            throw new IllegalArgumentException("Unknown authentication mode: " + this.getUserAuthenticationMode().getTag());
        }
        if (securityMode.getDefaultDisplayName(null).equals(this.getDisplayName((Slot)securityMode, null))) {
            this.setDisplayName(securityMode, BFormat.make((String)lex.getText("opcUaClient.securityMode.displayName")), null);
        }
        try {
            OpcUaClientUtil.connect(this);
        }
        catch (Exception e) {
            BOpcUaDevice.logException(Level.SEVERE, "Connection failed while starting device: " + this.getName() + ": " + e, e);
            throw e;
        }
        this.initDeviceAfterConnect(null);
    }

    public void stopped() throws Exception {
        if (this.commResetTicket != null) {
            this.commResetTicket.cancel();
            this.commResetTicket = null;
        }
        OpcUaClientUtil.disconnect(this);
        super.stopped();
    }

    public void changed(Property p, Context cx) {
        boolean subsPoints = false;
        if (!this.isRunning() || Context.decoding.equals(cx)) {
            super.changed(p, cx);
            return;
        }
        if (!this.getNetwork().getEnabled()) {
            try {
                OpcUaClientUtil.disconnect(this);
            }
            catch (Exception e) {
                BOpcUaDevice.logException(Level.WARNING, "Unable to disconnect client when network is disabled: " + e, e);
            }
            super.changed(p, cx);
            return;
        }
        if (p.equals(securityMode) || p.equals(timeoutInterval) || p.equals(statusCheckTimeout) || p.equals(userName) || p.equals(password) || p.equals(certAliasAndPassword) || p.equals(userAuthenticationCertificate)) {
            try {
                OpcUaClientUtil.disconnect(this);
                OpcUaClientUtil.connect(this);
                subsPoints = true;
            }
            catch (Exception e) {
                BOpcUaDevice.logException(Level.SEVERE, "Connection failed while changing security parameters for device: " + this.getName() + ": " + e, e);
            }
        }
        if (p.equals(serverEndpointUrl)) {
            try {
                OpcUaClientUtil.disconnect(this);
                OpcUaClientUtil.connect(this);
                subsPoints = true;
            }
            catch (Exception e) {
                BOpcUaDevice.logException(Level.SEVERE, "Connection failed while changing endpoint URL for device: " + this.getName() + ": " + e, e);
            }
        }
        if (p == userAuthenticationMode) {
            if (BOpcUserAuthenticationMode.certificate.equals((Object)this.getUserAuthenticationMode())) {
                this.getUserAuthenticationCertificate().setAlias(BCertificateAliasAndPassword.DEFAULT.getAlias());
                this.getUserAuthenticationCertificate().setPassword(BCertificateAliasAndPassword.DEFAULT.getPassword());
                this.setFlags((Slot)userName, this.getFlags((Slot)userName) | 4, cx);
                this.setFlags((Slot)password, this.getFlags((Slot)password) | 4, cx);
                this.setFlags((Slot)userAuthenticationCertificate, this.getFlags((Slot)userAuthenticationCertificate) & 0xFFFFFFFB, cx);
            } else if (BOpcUserAuthenticationMode.userNameAndPassword.equals((Object)this.getUserAuthenticationMode())) {
                this.setUserName("");
                this.setPassword(BPassword.DEFAULT);
                this.setFlags((Slot)userName, this.getFlags((Slot)userName) & 0xFFFFFFFB, cx);
                this.setFlags((Slot)password, this.getFlags((Slot)password) & 0xFFFFFFFB, cx);
                this.setFlags((Slot)userAuthenticationCertificate, this.getFlags((Slot)userAuthenticationCertificate) | 4, cx);
            } else if (BOpcUserAuthenticationMode.anonymous.equals((Object)this.getUserAuthenticationMode())) {
                this.setFlags((Slot)userName, this.getFlags((Slot)userName) | 4, cx);
                this.setFlags((Slot)password, this.getFlags((Slot)password) | 4, cx);
                this.setFlags((Slot)userAuthenticationCertificate, this.getFlags((Slot)userAuthenticationCertificate) | 4, cx);
            } else {
                throw new IllegalArgumentException("Unknown authentication mode: " + this.getUserAuthenticationMode().getTag());
            }
            try {
                OpcUaClientUtil.disconnect(this);
                OpcUaClientUtil.connect(this);
                subsPoints = true;
            }
            catch (Exception e) {
                BOpcUaDevice.logException(Level.SEVERE, "Connection failed while changing user authentication mode for device: " + this.getName() + ": " + e, e);
            }
        }
        if (p.equals(serverState)) {
            BServerState state = this.getServerState();
            if (state.equals((Object)BServerState.Running)) {
                if (this.uaClient == null || !this.uaClient.isConnected()) {
                    try {
                        OpcUaClientUtil.connect(this);
                    }
                    catch (Exception e) {
                        BOpcUaDevice.logException(Level.SEVERE, "Connection failed while changing server state for device: " + this.getName() + ": " + e, e);
                    }
                }
                subsPoints = true;
            } else {
                this.pingFail(lex.getText("opcUaClient.pingFailServerStateNotRunning.serverState", new Object[]{state.getTag()}));
                for (BOpcUaClientProxyExt proxyExt : (BOpcUaClientProxyExt[])CompUtil.getDescendants((BComponent)this.getPoints(), BOpcUaClientProxyExt.class)) {
                    proxyExt.setUaStatusCode(StatusCode.BAD.toString());
                }
            }
        }
        if (p.equals(enabled)) {
            try {
                if (!this.getEnabled()) {
                    OpcUaClientUtil.disconnect(this);
                } else {
                    OpcUaClientUtil.connect(this);
                    subsPoints = true;
                }
            }
            catch (Exception e) {
                this.setServerState(BServerState.Unknown);
                BOpcUaDevice.logException(Level.SEVERE, "Connection failed while changing enabled state for device: " + this.getName() + ": " + e, e);
            }
        }
        if (subsPoints) {
            this.initDeviceAfterConnect(cx);
        }
        super.changed(p, cx);
    }

    private void initDeviceAfterConnect(Context cx) {
        this.getAlarmExt().init();
    }

    public void setCertificateValidator() {
        OpcUaClientCertificateValidator validator = new OpcUaClientCertificateValidator(this.uaClient.getAddress());
        this.uaClient.setCertificateValidator((CertificateValidator)validator);
    }

    public void initialize() throws Exception {
        this.initializing();
        long startMillis = 0L;
        if (logger.isLoggable(Level.FINE)) {
            startMillis = System.currentTimeMillis();
            logger.fine("OpcUaDevice initializing for " + this.getServerEndpointUrl());
        }
        this.uaClient.setSessionName(APP_NAME);
        this.uaClient.getEndpointConfiguration().setMaxByteStringLength(Integer.valueOf(Integer.MAX_VALUE));
        this.uaClient.getEndpointConfiguration().setMaxArrayLength(Integer.valueOf(Integer.MAX_VALUE));
        this.uaClient.setLocale(Locale.ENGLISH);
        this.uaClient.setTimeout(this.getTimeoutInterval().getMillis());
        this.uaClient.setStatusCheckTimeout(this.getStatusCheckTimeout().getMillis());
        if (!this.uaClient.getOperationLimits().equals((Object)OperationLimits.allOf((UnsignedInteger)UnsignedInteger.valueOf((long)this.getOperationLimit().getMillis())))) {
            this.uaClient.setOperationLimits(OperationLimits.allOf((UnsignedInteger)UnsignedInteger.valueOf((long)this.getOperationLimit().getMillis())));
        }
        this.uaClient.setListener(this.clientListener);
        this.uaClient.addServerStatusListener((ServerStatusListener)this.serverStatusListener);
        this.setCertificateValidator();
        SecurityMode securityMode = this.getSecurityMode().getSecurityMode();
        this.uaClient.setSecurityMode(securityMode);
        if (!securityMode.equals((Object)SecurityMode.NONE)) {
            this.uaClient.getHttpsSettings().setHttpsSecurityPolicies(new HttpsSecurityPolicy[]{HttpsSecurityPolicy.TLS_1_0, HttpsSecurityPolicy.TLS_1_1, HttpsSecurityPolicy.TLS_1_2});
            try {
                AccessController.doPrivileged(() -> {
                    BCertificateAliasAndPassword aliasAndPassword = this.getCertAliasAndPassword();
                    ICryptoManager cryptoManager = CertManagerFactory.getInstance();
                    IKeyStore keyStore = cryptoManager.getKeyStore();
                    X509Certificate clientCert = keyStore.getCertificate(aliasAndPassword.getAlias());
                    PrivKey privKey = new PrivKey(BOpcUaDevice.getServerPrivateKey(keyStore, aliasAndPassword));
                    ApplicationIdentity applicationIdentity = new ApplicationIdentity(new Cert(clientCert), privKey);
                    ApplicationDescription appDescription = new ApplicationDescription();
                    appDescription.setApplicationName(new LocalizedText("NiagaraOpcUaClient@localhost"));
                    appDescription.setApplicationUri("urn:localhost:OPCUA:NiagaraOpcUaClient");
                    appDescription.setProductUri("urn:tridium.com:OPCUA:NiagaraOpcUaClient");
                    appDescription.setApplicationType(ApplicationType.Client);
                    applicationIdentity.setApplicationDescription(appDescription, true);
                    this.uaClient.setApplicationIdentity(applicationIdentity);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                logger.log(Level.SEVERE, "Exception occurred while creating OPCUA application identity: " + e.getException().getMessage());
                throw e.getException();
            }
        }
        try {
            this.checkAuthenticationMode(this.uaClient, this.getUserAuthenticationCertificate());
        }
        catch (PrivilegedActionException e) {
            logger.log(Level.SEVERE, "Exception occurred while creating OPCUA user identity: " + e.getException().getMessage());
            throw e.getException();
        }
        this.initializationComplete();
        if (logger.isLoggable(Level.FINE)) {
            long endMillis = System.currentTimeMillis();
            logger.fine("OpcUaDevice initialization complete for " + this.getServerEndpointUrl() + " (" + (endMillis - startMillis) + "ms)");
        }
    }

    private void checkAuthenticationMode(UaClient client, BCertificateAliasAndPassword userAuthCert) throws SessionActivationException, PrivilegedActionException {
        if (BOpcUserAuthenticationMode.userNameAndPassword.equals((Object)this.getUserAuthenticationMode())) {
            String username = this.getUserName().trim();
            String password = this.getPassword().getValue().trim();
            if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
                logger.log(Level.WARNING, "Username/Password invalid!");
            }
            client.setUserIdentity(new UserIdentity(username, password));
        } else if (BOpcUserAuthenticationMode.certificate.equals((Object)this.getUserAuthenticationMode())) {
            AccessController.doPrivileged(() -> {
                ICryptoManager cryptoManager = CertManagerFactory.getInstance();
                IKeyStore keyStore = cryptoManager.getKeyStore();
                BCertificateAliasAndPassword userAuthCertificateAliasAndPassword = userAuthCert;
                X509Certificate userAuthCertificate = keyStore.getCertificate(userAuthCertificateAliasAndPassword.getAlias());
                PrivKey userAuthPrivateKey = new PrivKey(BOpcUaDevice.getServerPrivateKey(keyStore, userAuthCertificateAliasAndPassword));
                client.setUserIdentity(new UserIdentity(new Cert(userAuthCertificate), userAuthPrivateKey));
                return null;
            });
        } else if (BOpcUserAuthenticationMode.anonymous.equals((Object)this.getUserAuthenticationMode())) {
            client.setUserIdentity(new UserIdentity());
        } else {
            throw new IllegalArgumentException("Unknown authentication mode: " + this.getUserAuthenticationMode().getTag());
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        return this.postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
    }

    public synchronized void doPing() {
        block12: {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("OpcUaDevice doPing() to " + this.getServerEndpointUrl());
                }
                if (!this.getNetwork().getEnabled()) {
                    this.pingFail(lex.getText("opcUaClient.pingFailNetworkDisabled"));
                    return;
                }
                if (!this.getEnabled()) {
                    this.pingFail(lex.getText("opcUaClient.pingFailDeviceDisabled"));
                    return;
                }
                if (this.commResetTicket != null) {
                    this.pingFail(lex.getText("opcUaClient.pingFailCommReset"));
                    return;
                }
                if (this.getServerState().equals((Object)BServerState.Shutdown)) {
                    return;
                }
                if (this.uaClient == null || !this.isInitialized()) {
                    this.pingFail(lex.getText("opcUaClient.pingFailDeviceUninitialized"));
                    break block12;
                }
                try {
                    AccessController.doPrivileged(() -> {
                        if (!this.uaClient.isConnected()) {
                            long startMillis = 0L;
                            if (logger.isLoggable(Level.FINE)) {
                                startMillis = System.currentTimeMillis();
                                logger.fine("OpcUaDevice connecting to " + this.getServerEndpointUrl());
                            }
                            this.uaClient.connect();
                            if (logger.isLoggable(Level.FINE)) {
                                long endMillis = System.currentTimeMillis();
                                logger.fine("OpcUaDevice connection complete to " + this.getServerEndpointUrl() + " (" + (endMillis - startMillis) + "ms)");
                            }
                        }
                        DataValue value = this.uaClient.readValue(VariableIdentifiers.Server_ServerStatus_State);
                        DataValue curTime = this.uaClient.readValue(VariableIdentifiers.Server_ServerStatus_CurrentTime);
                        DataValue startTime = this.uaClient.readValue(VariableIdentifiers.Server_ServerStatus_StartTime);
                        this.setServerCurrentTime(OpcUaClientUtil.dataValueToAbsTime(curTime));
                        this.setServerStartTime(OpcUaClientUtil.dataValueToAbsTime(startTime));
                        this.pingOk();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("ping successful with appURI: " + this.uaClient.getApplicationIdentity().getApplicationDescription().getApplicationUri());
                        }
                        return null;
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            catch (Exception e) {
                String appUri = null;
                try {
                    appUri = this.uaClient.getApplicationIdentity().getApplicationDescription().getApplicationUri();
                }
                catch (Exception e2) {
                    appUri = "<unknown>";
                }
                BOpcUaDevice.logException(Level.SEVERE, "Exception occurred during ping for device: " + this.getName() + " with appURI: " + appUri + ": " + e, e);
                this.pingFail(OpcUaCoreUtil.getLocalizedMessage((Exception)e));
            }
        }
    }

    public void doPoll() {
    }

    public void doResetComm(BInteger delay) {
        try {
            if (this.commResetTicket == null) {
                this.commResetTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)delay.getInt()), (Action)resetDelay, null);
                OpcUaClientUtil.disconnect(this);
            }
        }
        catch (Exception e) {
            BOpcUaDevice.logException(Level.SEVERE, "Exception occurred while resetting communications for device: " + this.getName() + ": " + e, e);
        }
    }

    public void doResetDelay() {
        this.commResetTicket = null;
        try {
            OpcUaClientUtil.connect(this);
        }
        catch (Exception e) {
            BOpcUaDevice.logException(Level.SEVERE, "Connection failed while resetting delay for device: " + this.getName() + ": " + e, e);
        }
    }

    public void doLearn() throws Exception {
        this.doLearn(null);
    }

    public void doLearn(BNDiscoveryJob job) throws Exception {
        this.getPoints().setDiscoveryFailCause("");
        try {
            String learnBaseRootEntryName;
            if (this.uaClient == null || !this.uaClient.isConnected()) {
                OpcUaClientUtil.connect(this);
            }
            AddressSpace addressSpace = this.uaClient.getAddressSpace();
            addressSpace.setMaxReferencesPerNode(1000);
            addressSpace.setReferenceTypeId(ReferenceTypeIdentifiers.HierarchicalReferences);
            NodeId learnBaseNodeId = NodeId.parseNodeId((String)this.getLearnRootNodeIdString());
            try {
                UaNode node = OpcUaClientUtil.getAddressSpaceNode(this.uaClient.getAddressSpace(), learnBaseNodeId);
                learnBaseRootEntryName = node.getBrowseName().toString();
            }
            catch (Exception e) {
                BOpcUaDevice.logException(Level.SEVERE, "Failed to determine learn root node for Node ID: " + this.getLearnRootNodeIdString() + ": " + e, e);
                if (job != null) {
                    job.log().message(BOpcUaNetwork.lex.getText("clientPointLearn.noRootObject", new Object[]{this.getLearnRootNodeIdString()}));
                }
                throw e;
            }
            BOpcUaNodeLearnEntry learnRoot = new BOpcUaNodeLearnEntry(learnBaseRootEntryName, learnBaseNodeId.toString(), "", "", BTypeSpec.DEFAULT);
            if (this.get(SERVER_ROOT_COMPONENT_NAME) != null) {
                this.remove(SERVER_ROOT_COMPONENT_NAME);
            }
            this.add(SERVER_ROOT_COMPONENT_NAME, (BValue)learnRoot, 2);
            int expectedCount = this.lastLearnCount <= 0 ? 3000 : this.lastLearnCount;
            BOpcUaClientPointDiscoveryPreferences preferences = (BOpcUaClientPointDiscoveryPreferences)this.getPoints().getDiscoveryPreferences();
            this.lastLearnCount = OpcUaClientUtil.learn(this, learnRoot, learnBaseNodeId, job, 0, expectedCount, preferences.getExcludeServer(), preferences.getExcludeTypesFolder());
            for (BOpcUaNodeLearnEntry descendant : this.descendants = (BOpcUaNodeLearnEntry[])CompUtil.getDescendants((BComponent)learnRoot, BOpcUaNodeLearnEntry.class)) {
                descendant.updateFacets();
            }
        }
        catch (Exception e) {
            BOpcUaDevice.logException(Level.SEVERE, "Exception occurred during learn for device: " + this.getName() + ": " + e, e);
            throw e;
        }
        String failCause = this.getPoints().getDiscoveryFailCause();
        if (!failCause.isEmpty()) {
            throw new RuntimeException(failCause);
        }
    }

    public void doUpdateNamespaceUri() throws Exception {
        this.doLearn(this.getPoints().getDiscoveryPreferences().getJob());
        for (BOpcUaClientProxyExt proxyExt : (BOpcUaClientProxyExt[])CompUtil.getDescendants((BComponent)this.getPoints(), BOpcUaClientProxyExt.class)) {
            this.updateNamespaceUri(proxyExt, this.descendants);
        }
    }

    private void updateNamespaceUri(BOpcUaClientProxyExt proxyExt, BOpcUaNodeLearnEntry[] descendants) {
        if (proxyExt.getNameSpaceUri().isEmpty() || proxyExt.getNameSpaceUri() == null) {
            try {
                for (BOpcUaNodeLearnEntry descendant : descendants) {
                    if (!descendant.getUaNodeId().equals(proxyExt.getUaNodeId())) continue;
                    proxyExt.setNameSpaceUri(descendant.getNameSpaceUri());
                }
            }
            catch (Exception e) {
                BOpcUaDevice.logException(Level.SEVERE, "Exception occurred while setting NamespaceUri for node: " + proxyExt.getUaNodeId() + ": " + e, e);
            }
        }
    }

    public BOpcUaLearnBase[] getLearnedPoints() {
        BNDiscoveryPreferences prefs = this.getPoints().getDiscoveryPreferences();
        boolean showAddableOnly = prefs instanceof BOpcUaClientPointDiscoveryPreferences ? ((BOpcUaClientPointDiscoveryPreferences)prefs).getShowAddableOnly() : false;
        int maxArraySize = prefs instanceof BOpcUaClientPointDiscoveryPreferences ? ((BOpcUaClientPointDiscoveryPreferences)prefs).getMaxArraySize() : 200;
        return this.getLearnedPoints(showAddableOnly, maxArraySize);
    }

    public BOpcUaLearnBase[] getLearnedPoints(boolean showAddableOnly, int maxArraySize) {
        BComponent root = this.get(SERVER_ROOT_COMPONENT_NAME).asComponent();
        if (!(root instanceof BOpcUaNodeLearnEntry)) {
            return new BOpcUaLearnBase[0];
        }
        return new BOpcUaLearnBase[]{((BOpcUaNodeLearnEntry)root).toDiscoveryTree(showAddableOnly, maxArraySize)};
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        if (!this.isRunning() || this.uaClient == null) {
            return;
        }
        out.startProps();
        out.trTitle((Object)"uaClient subscriptions ", 2);
        for (Subscription subscription : this.uaClient.getSubscriptions()) {
            out.prop((Object)"subscription", subscription.getPublishingInterval());
            for (MonitoredItemBase monitoredItem : subscription.getItems()) {
                out.prop((Object)"", (Object)monitoredItem.toString());
            }
        }
        out.endProps();
    }

    public final BOpcUaNetwork getOpcUaClientNetwork() {
        return (BOpcUaNetwork)this.getNetwork();
    }

    public boolean isCommReset() {
        return this.commResetTicket != null;
    }

    public void cancelCommReset() {
        if (this.commResetTicket != null) {
            this.commResetTicket.cancel();
            this.commResetTicket = null;
        }
    }

    public void validateSet(Validatable validatable, Context context) {
        BString proposedValue = (BString)validatable.getProposedValue(serverEndpointUrl);
        if (!(proposedValue == null || proposedValue.getString().startsWith(OPC_TCP) || OPCUA_IPV4_PATTERN.matcher(proposedValue.getString()).matches() || proposedValue.getString().isEmpty())) {
            throw new LocalizableRuntimeException("opcUaClient", "opcUaClient.endPoint", new Object[]{proposedValue.getString(), this.getName()});
        }
    }

    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        if (property != null && property.equals(serverEndpointUrl) && newValue != null && !((BString)newValue).getString().startsWith(OPC_TCP) && !OPCUA_IPV4_PATTERN.matcher(((BString)newValue).getString()).matches() && !((BString)newValue).getString().isEmpty()) {
            throw new LocalizableRuntimeException("opcUaClient", "opcUaClient.endPoint", new Object[]{((BString)newValue).getString(), this.getName()});
        }
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RSAPrivateKey getServerPrivateKey(IKeyStore keyStore, BCertificateAliasAndPassword aliasAndPassword) throws Exception {
        if (aliasAndPassword.getPassword().isDefault()) {
            try {
                return (RSAPrivateKey)keyStore.getKey(aliasAndPassword.getAlias(), null);
            }
            catch (Exception e) {
                if (e.getMessage() == null) throw e;
                if (e.getMessage().isEmpty()) throw e;
                if (!e.getMessage().startsWith(WRONG_KEY_USED_FOR_DECRYPTION_ERROR_MESSAGE)) throw e;
                throw new Exception(lex.getText("opcUaClient.device.error.incorrectCertificateKeyPassword.details", new Object[]{e.getLocalizedMessage()}));
            }
        }
        try (SecretChars passwordChars = AccessController.doPrivileged(() -> ((BPassword)aliasAndPassword.getPassword()).getSecretChars());){
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyStore.getKey(aliasAndPassword.getAlias(), passwordChars.get());
            return rSAPrivateKey;
        }
        catch (Exception e) {
            if (e.getMessage() == null) throw e;
            if (e.getMessage().isEmpty()) throw e;
            if (!e.getMessage().startsWith(WRONG_KEY_USED_FOR_DECRYPTION_ERROR_MESSAGE)) throw e;
            throw new Exception(lex.getText("opcUaClient.device.error.incorrectCertificateKeyPassword.details", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void initializing() {
        this.initialized = false;
    }

    private void initializationComplete() {
        this.initialized = true;
    }

    private static void logException(Level level, String msg, Exception e) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(level, msg, e);
        } else {
            logger.log(level, msg);
        }
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"opcUaDevice.securityDashboard.title");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        BSecurityMode secMode = this.getSecurityMode();
        BOpcUserAuthenticationMode authenticationMode = this.getUserAuthenticationMode();
        if (secMode.equals((Object)BSecurityMode.signBasic128Rsa15)) {
            items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"opcUaDevice.securityDashboard.SecurityModeUnsafe.signBasic128Rsa15.title", (BSimple[])new BSimple[]{BString.make((String)"securityDashboard.opcuaDeviceSecurityModeUnsafe"), BString.make((String)secMode.toString(Context.NULL))}), (String)"opcUaDevice.securityDashboard.SecurityModeUnsafe.signBasic128Rsa15.description"));
        } else if (secMode.equals((Object)BSecurityMode.none)) {
            items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"opcUaDevice.securityDashboard.SecurityModeUnsafe.none.title", (BSimple[])new BSimple[]{BString.make((String)"securityDashboard.opcuaDeviceSecurityModeUnsafe"), BString.make((String)secMode.toString(Context.NULL))}), (String)"opcUaDevice.securityDashboard.SecurityModeUnsafe.none.description"));
        } else {
            items.add(SecurityDashboardItem.makeOk((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"opcUaDevice.securityDashboard.SecurityModeOk.title", (BSimple[])new BSimple[]{BString.make((String)"securityDashboard.opcuaDeviceSecurityModeUnsafe"), BString.make((String)secMode.toString(Context.NULL))}), (String)"opcUaDevice.securityDashboard.SecurityModeOk.description"));
        }
        if (authenticationMode.equals((Object)BOpcUserAuthenticationMode.anonymous)) {
            items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"opcUaDevice.securityDashboard.authenticationModeUnsafe.title", (BSimple[])new BSimple[]{BString.make((String)"securityDashboard.opcuaDeviceUserAuthenticationModeUnsafe"), BString.make((String)authenticationMode.toString(Context.NULL))}), (String)"opcUaDevice.securityDashboard.authenticationModeUnsafe.description"));
        } else {
            items.add(SecurityDashboardItem.makeOk((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"opcUaDevice.securityDashboard.authenticationModeOk.title", (BSimple[])new BSimple[]{BString.make((String)"securityDashboard.opcuaDeviceUserAuthenticationModeUnsafe"), BString.make((String)authenticationMode.toString(Context.NULL))}), (String)"opcUaDevice.securityDashboard.authenticationModeOk.description"));
        }
        return items;
    }
}

