/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.util;

import com.tridium.aaphp.util.AaPhpTextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.units.BUnit;

public class AaPhpAttributeConversion {
    final long rawData;
    final int aaphpType;
    final boolean bit7;
    final boolean bit6;
    final boolean bit5;
    final boolean bit4;
    final boolean bit3;
    final boolean bit2;
    final boolean bit1;
    final boolean bit0;
    boolean bitmapped = false;
    boolean enumerated = false;
    boolean unreliable = false;
    boolean unsigned = false;
    boolean timeInBcd = false;
    boolean dateInBcd = false;
    boolean ieeeFloatingPoint = false;
    double scale = 1.0;
    double offset = 0.0;
    long mask = -1L;
    BFacets facets = null;
    private static final String SIXTEEN_ZEROS = "0000000000000000";
    private static final double[] TEN_TO_THE_MINUS;
    static final BEnumRange RANGE_120;
    static final BEnumRange RANGE_121;

    public AaPhpAttributeConversion(long rawData, int aaphpType) {
        this.rawData = rawData;
        this.aaphpType = aaphpType;
        this.bit7 = (aaphpType & 0x80) != 0;
        this.bit6 = (aaphpType & 0x40) != 0;
        this.bit5 = (aaphpType & 0x20) != 0;
        this.bit4 = (aaphpType & 0x10) != 0;
        this.bit3 = (aaphpType & 8) != 0;
        this.bit2 = (aaphpType & 4) != 0;
        this.bit1 = (aaphpType & 2) != 0;
        this.bit0 = (aaphpType & 1) != 0;
        this.convert();
    }

    public int getAaPhpType() {
        return this.aaphpType;
    }

    public long getRawValueFor(double numeric) {
        if (this.ieeeFloatingPoint) {
            return Float.floatToRawIntBits((float)numeric);
        }
        return (long)((numeric - this.offset) / this.scale + 0.5);
    }

    public double getNumericVal(Context c) {
        if (this.ieeeFloatingPoint) {
            return Float.intBitsToFloat((int)(this.rawData & this.mask));
        }
        long tempRaw = this.rawData & this.mask & 0xFFFFL;
        if (!this.unsigned && (this.rawData & 0x8000L) == 32768L) {
            tempRaw = -1L * (((tempRaw | 0xFFFFFFFFFFFF0000L) ^ 0xFFFFFFFFFFFFFFFFL) + 1L);
            if (this.aaphpType == 2) {
                this.scale = 0.1;
            }
            return (double)tempRaw * this.scale + this.offset;
        }
        if (this.aaphpType == 2) {
            this.scale = 0.1;
        }
        return (double)(tempRaw & 0xFFFFL) * this.scale + this.offset;
    }

    public long getRawValueFor(int enumOrdinal) {
        return this.getRawValueFor((double)enumOrdinal);
    }

    public int getEnumOrdinal(Context c) {
        return (int)Math.round(this.getNumericVal(c));
    }

    public long getRawValueFor(boolean b) {
        return this.getRawValueFor(b ? 1 : 0);
    }

    public boolean getBoolVal(Context c) {
        return this.getNumericVal(c) != 0.0;
    }

    public long getRawValueFor(String s, Context c) {
        if (this.bitmapped) {
            return Long.parseLong(s, 2);
        }
        BFacets facetsToUse = null;
        facetsToUse = c instanceof BFacets ? (BFacets)c : this.getDefaultFacets();
        BEnumRange range = (BEnumRange)facetsToUse.get("range");
        if (range != null) {
            return range.get(s).getOrdinal();
        }
        BInteger radix = (BInteger)facetsToUse.get("radix");
        if (radix != null) {
            return Long.parseLong(s, radix.getInt());
        }
        if (facetsToUse.get("trueText") != null) {
            return this.getRawValueFor(s.toLowerCase().equals(facetsToUse.gets("trueText", "true").toLowerCase()) ? 1 : 0);
        }
        if (this.timeInBcd) {
            throw new BajaRuntimeException("Unsupported operation: setting time attribute in AaPhp controller.");
        }
        if (this.dateInBcd) {
            throw new BajaRuntimeException("Unsupported operation: setting date attribute in AaPhp controller.");
        }
        return this.getRawValueFor(Long.parseLong(s));
    }

    public String getStringVal(Context c) {
        if (this.bitmapped) {
            return AaPhpTextUtil.truncate((String)(SIXTEEN_ZEROS + Long.toString(this.rawData, 2)), (int)16);
        }
        BFacets facetsToUse = null;
        facetsToUse = c instanceof BFacets ? (BFacets)c : this.getDefaultFacets();
        BEnumRange range = (BEnumRange)facetsToUse.get("range");
        if (range != null) {
            return range.getTag((int)this.rawData);
        }
        BInteger radix = (BInteger)facetsToUse.get("radix");
        if (radix != null) {
            int r = radix.getInt();
            String afterRadix = Long.toString(this.rawData, r);
            if (r == 2) {
                afterRadix = AaPhpTextUtil.padLeft(afterRadix, 32, '0');
            } else if (r == 16) {
                afterRadix = AaPhpTextUtil.padLeft(afterRadix, 4, '0');
            }
            return afterRadix;
        }
        if (facetsToUse.get("trueText") != null) {
            return BBoolean.toString((this.rawData != 0L ? 1 : 0) != 0, (Context)facetsToUse);
        }
        if (this.timeInBcd) {
            int minutes = Integer.parseInt(Integer.toString((int)(this.rawData & 0xFF00L) >> 8, 16));
            int hours = Integer.parseInt(Integer.toString((int)(this.rawData & 0xFFL), 16));
            try {
                return BTime.make((int)hours, (int)minutes, (int)0).toString((Context)facetsToUse);
            }
            catch (Exception e) {
                return "Time Error: " + e;
            }
        }
        if (this.dateInBcd) {
            int year = Integer.parseInt(Integer.toString((int)((this.rawData & 0xFFFFFFFFFFFF0000L) >> 16), 16));
            int month = Integer.parseInt(Integer.toString((int)((this.rawData & 0xFF00L) >> 8), 16));
            int day = Integer.parseInt(Integer.toString((int)(this.rawData & 0xFFL), 16));
            return BAbsTime.make((int)year, (BMonth)BMonth.make((int)month), (int)day).toString((Context)facetsToUse);
        }
        return BDouble.toString((double)this.getNumericVal((Context)facetsToUse), (Context)facetsToUse);
    }

    void convert() {
        if (this.bit7) {
            this.unreliableData();
        }
        if (this.bit6) {
            this.structuredData();
        } else {
            this.enumeratedData();
        }
    }

    void structuredData() {
        if (this.bit5) {
            this.numericSpecialOrBitmapData();
        } else {
            this.indexedData();
        }
    }

    void numericSpecialOrBitmapData() {
        int aNumber = (this.aaphpType & 0x1C) >> 2;
        if (aNumber < 0 || aNumber > 7) {
            throw new IllegalStateException("Error in program. The variable 'aNumber' should be in the range 0-7 not " + aNumber);
        }
        if (aNumber == 7) {
            this.bitmapData();
        } else if (aNumber == 6) {
            this.specialData();
        } else {
            this.numericData(aNumber);
        }
    }

    void bitmapData() {
        int bitMapType = this.aaphpType & 3;
        this.bitmapped = true;
    }

    void specialData() {
        int specialType = this.aaphpType & 3;
    }

    double tenToTheMinus(int negExp) {
        return TEN_TO_THE_MINUS[negExp];
    }

    void numericData(int decimalPrecision) {
        this.scale = this.tenToTheMinus(decimalPrecision);
        this.unsigned = !this.bit0;
    }

    void indexedData() {
        int indexType = this.aaphpType & 0x1F;
    }

    void enumeratedData() {
        this.getDefaultFacets();
        this.enumerated = true;
    }

    void unreliableData() {
        this.unreliable = true;
    }

    public BFacets getDefaultFacets() {
        if (this.facets != null) {
            return this.facets;
        }
        this.facets = BFacets.DEFAULT;
        switch (this.aaphpType & 0x7F) {
            case 0: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)-32768.0, (double)32767.0));
                break;
            }
            case 1: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)-3276.8, (double)3276.7));
                this.scale = 0.1;
                break;
            }
            case 2: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (int)0, (double)0.0, (double)100.0));
                this.unsigned = true;
                this.scale = 0.1;
                break;
            }
            case 3: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"second"), (int)0, (double)0.0, (double)3276.7));
                this.scale = 0.1;
                break;
            }
            case 4: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"second"), (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 5: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"minute"), (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 6: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"hour"), (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 7: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)6.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (String[])new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"})));
                break;
            }
            case 8: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)365.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"word Day of Year (0=Jan 1)"));
                this.unsigned = true;
                break;
            }
            case 9: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)2));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"byte Channel bitmap, 8-bit"));
                this.unsigned = true;
                break;
            }
            case 10: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"True", (String)"False"));
                break;
            }
            case 11: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Auto", (String)"Manual"));
                break;
            }
            case 12: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Enabled", (String)"Disabled"));
                break;
            }
            case 13: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Normally_Closed", (String)"Normally_Open"));
                break;
            }
            case 14: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Calibrate", (String)"Run"));
                break;
            }
            case 15: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 16: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Bipolar", (String)"Unipolar"));
                break;
            }
            case 17: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"byte Days of week bitmap (1=Mon,2=Tue..128=Holiday"));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{1, 2, 4, 8, 16, 32, 64, 128}, (String[])new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun", "Holiday"})));
                break;
            }
            case 18: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 19: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3}, (String[])new String[]{"Supervise", "Close_to_Open", "Open_to_Close", "Change_Of_State"})));
                break;
            }
            case 20: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)65535.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Number of Changes"));
                this.unsigned = true;
                break;
            }
            case 21: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"System Type"));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4}, (String[])new String[]{"RCUa", "RCUm_or_2m", "RCUg", "RCUd_or_2d", "STAR"})));
                break;
            }
            case 22: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Module Type"));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 129, 130, 131, 132, 133}, (String[])new String[]{"None", "DIDO_B1", "BMON_B2", "AMON_A1_or_MONWB_A1", "MDDC_A2", "BCTL_B3", "ADDC_A3", "FSEC_A1", "FSEC_A2", "FSEC_B3", "DDC16_B3", "MCDR_A2", "ICDR_A2_or_ICDRWB_A2", "PDDC_A4", "ALY_A2", "DLDC_B1", "CHPS_B3", "TSPU_B3", "STAT_A2", "BOKU_B3", "ALC8_A3", "DASS_B1", "UMON_A", "BCMF_C1", "JCUC_C2", "APUP_C1", "TVAV_C1", "GPUP_C1"})));
                break;
            }
            case 23: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Reverse", (String)"Normal"));
                break;
            }
            case 24: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Time in BCD lsb=HH, msb=MM 00:00 23:59"));
                this.timeInBcd = true;
                break;
            }
            case 25: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"reserved"));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (String[])new String[]{"DisableLimit", "EnableLimit", "DisableLoop", "EnableLoop", "Disable_Loop_And_Set_Desired_Position", "Turn_On_Outputs", "Turn_Off_Outputs"})));
                break;
            }
            case 26: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Channel_bitmap, 16-bit 0 65535"));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeInt(null, (int)0, (int)65535, (int)2));
                this.bitmapped = true;
                break;
            }
            case 27: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Channel_Type"));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, (String[])new String[]{"NoScaling", "mA_0_20_mA", "mA_4_20_mA", "LookupTable3", "LookupTable4", "LookupTable5", "LookupTable6", "LookupTable7", "LookupTable8", "LookupTable9", "LookupTable10", "LookupTable11", "LookupTable12", "LookupTable13", "LookupTable14", "LookupTable15"})));
                break;
            }
            case 28: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)-3276.8, (double)3276.7));
                this.scale = 0.1;
                break;
            }
            case 29: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3}, (String[])new String[]{"Normal_Off", "Normal_On", "Fail_Off", "Fail_On"})));
                break;
            }
            case 30: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Totalize_Input", (String)"Totalize_Output"));
                break;
            }
            case 31: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3}, (String[])new String[]{"Text_From_Eng_Unit_For_Point", "Text_From_Next_Seq_Eng_Unit", "Text_From_2nd_Eng_Unit_Past_The_One_Specified", "Text_From_3r_dEng_Unit_Past_The_One_Specified"})));
                break;
            }
            case 32: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3}, (String[])new String[]{"Unused", "Security", "Fire", "Loop"})));
                break;
            }
            case 33: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"(Seconds, Minutes)(msb=0, 0..127 Seconds)(msb=1, 0..127 Minutes)"));
                this.facets = (this.rawData & 0x8000L) > 0L ? BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"minute"), (int)0, (double)0.0, (double)127.0)) : BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"second"), (int)0, (double)0.0, (double)127.0));
                this.mask = 127L;
                break;
            }
            case 34: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)5.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Program Status"));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4, 5}, (String[])new String[]{"Inactive", "Run", "Wait", "Pause", "Abort", "Resume"})));
                break;
            }
            case 35: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)2.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4, 5}, (String[])new String[]{"Secure", "Access", "Timed Access"})));
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"reserved"));
                break;
            }
            case 48: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"IEEE 784 32 bit Floating Point"));
                this.ieeeFloatingPoint = true;
                break;
            }
            case 49: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"(BCD Date)(MSW is year, i.e. 1988h),[LSW is month(MSB), day(LSB)]"));
                this.dateInBcd = true;
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"reserved"));
                break;
            }
            case 61: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)7.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Program Status"));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7}, (String[])new String[]{"unloaded", "run", "stop", "error", "restart", "abort", "loading", "shutdown"})));
                break;
            }
            case 62: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)65535.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Record number, msb=drive 0 or 1 0 65535"));
                this.unsigned = true;
                break;
            }
            case 63: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeInt(null, (int)0, (int)65535, (int)16));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Hexadecimal Word 0000-FFFFh"));
                this.unsigned = true;
                break;
            }
            case 64: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)2.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2}, (String[])new String[]{"Unoccupied", "Warm-up", "Occupied"})));
                break;
            }
            case 65: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)5.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4, 5}, (String[])new String[]{"CER_Cooling_With_Electric_Reheat", "CHWR_Cooling_With_Hot_Water_Reheat", "CFPER_Cooling_With_Fan_Electric_Heat", "CFPHWR_Cooling_With_Fan_Hot_Water_Reheat", "CIHWR_Cooling_Induction_With_Hot_Water_Reheat"})));
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)15.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)("indexed Type " + ((this.aaphpType & 0x7F) - 64))));
                break;
            }
            case 96: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 97: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)-32768.0, (double)32767.0));
                break;
            }
            case 98: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 99: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)-32768.0, (double)32767.0));
                break;
            }
            case 100: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)0.0, (double)6553.5));
                this.unsigned = true;
                this.scale = 0.1;
                break;
            }
            case 101: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)-3276.8, (double)3276.7));
                this.scale = 0.1;
                break;
            }
            case 102: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)0.0, (double)6553.5));
                this.unsigned = true;
                this.scale = 0.1;
                break;
            }
            case 103: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)-3276.8, (double)3276.7));
                this.scale = 0.1;
                break;
            }
            case 104: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)0.0, (double)655.35));
                this.unsigned = true;
                this.scale = 0.01;
                break;
            }
            case 105: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)-327.68, (double)327.67));
                this.scale = 0.01;
                break;
            }
            case 106: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)0.0, (double)655.35));
                this.unsigned = true;
                this.scale = 0.01;
                break;
            }
            case 107: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)-327.68, (double)327.67));
                this.scale = 0.01;
                break;
            }
            case 108: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)0.0, (double)65.535));
                this.unsigned = true;
                this.scale = 0.001;
                break;
            }
            case 109: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)-32.768, (double)32.767));
                this.scale = 0.001;
                break;
            }
            case 110: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)0.0, (double)65.535));
                this.unsigned = true;
                this.scale = 0.001;
                break;
            }
            case 111: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)-3, (double)32.768, (double)32.767));
                this.scale = 0.001;
                break;
            }
            case 112: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)4, (double)0.0, (double)6.5535));
                this.unsigned = true;
                this.scale = 1.0E-4;
                break;
            }
            case 113: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)4, (double)-3.2768, (double)3.2767));
                this.scale = 1.0E-4;
                break;
            }
            case 114: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)4, (double)0.0, (double)6.5535));
                this.unsigned = true;
                this.scale = 1.0E-4;
                break;
            }
            case 115: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)4, (double)-3.2768, (double)3.2767));
                this.scale = 1.0E-4;
                break;
            }
            case 116: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)5, (double)0.0, (double)0.65535));
                this.unsigned = true;
                this.scale = 1.0E-5;
                break;
            }
            case 117: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)5, (double)-0.32768, (double)0.32767));
                this.scale = 1.0E-5;
                break;
            }
            case 118: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)5, (double)0.0, (double)0.65535));
                this.unsigned = true;
                this.scale = 1.0E-5;
                break;
            }
            case 119: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)5, (double)-0.32768, (double)0.32767));
                this.scale = 1.0E-5;
                break;
            }
            case 120: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)RANGE_120));
                break;
            }
            case 121: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)RANGE_121));
                break;
            }
            case 122: 
            case 123: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Special Types"));
                break;
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Bitmap Types"));
            }
        }
        return this.facets;
    }

    static {
        int i;
        TEN_TO_THE_MINUS = new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9};
        int[] rangeOrds120 = new int[256];
        String[] rangeTags120 = new String[256];
        for (i = 0; i < 256; ++i) {
            rangeOrds120[i] = i;
            rangeTags120[i] = "v" + Integer.toString(i);
        }
        rangeTags120[254] = "SeriesFan";
        rangeTags120[255] = "NotAvailable";
        RANGE_120 = BEnumRange.make((int[])rangeOrds120, (String[])rangeTags120);
        int[] rangeOrds121 = new int[256];
        String[] rangeTags121 = new String[256];
        for (i = 0; i < 256; ++i) {
            rangeOrds121[i] = i;
            rangeTags121[i] = "v" + Integer.toString(i);
        }
        rangeTags121[255] = "NotAvailable";
        RANGE_121 = BEnumRange.make((int[])rangeOrds121, (String[])rangeTags121);
    }
}

