/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpInputStream;
import com.tridium.aaphp.messages.AaPhpResponse;
import com.tridium.aaphp.util.AaPhpAttributeConversion;
import javax.baja.sys.Context;

public class AaPhpReadAttributeResponse
extends AaPhpResponse {
    final int encodingValue;
    final String attributeName;
    final long rawDataHex;
    final AaPhpAttributeConversion attrConv;

    AaPhpReadAttributeResponse(AaPhpInputStream inStream) {
        super(inStream);
        if (this.isError()) {
            this.attributeName = null;
            this.encodingValue = 0;
            this.rawDataHex = Long.MAX_VALUE;
            this.attrConv = null;
        } else {
            this.attributeName = inStream.readAttributeName();
            this.encodingValue = inStream.readEncodingType();
            this.rawDataHex = inStream.readRawDataHex32();
            this.attrConv = new AaPhpAttributeConversion(this.rawDataHex, this.encodingValue);
        }
    }

    public boolean getBooleanValue(Context c) {
        return this.attrConv.getBoolVal(c);
    }

    public double getFloatValue(Context c) {
        return this.attrConv.getNumericVal(c);
    }

    public String getStringValue(Context c) {
        return this.attrConv.getStringVal(c);
    }

    public int getIntValue(Context c) {
        return this.attrConv.getEnumOrdinal(c);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public int getEncodingValue() {
        return this.encodingValue;
    }

    public long getRawDataHex() {
        return this.rawDataHex;
    }

    public AaPhpAttributeConversion getAttrConv() {
        return this.attrConv;
    }
}

