/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.job;

import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.datatypes.BAaPhpLearnDeviceEntry;
import com.tridium.aaphp.datatypes.BAaPhpLearnDevicesParameter;
import com.tridium.aaphp.messages.AaPhpSayHelloRequest;
import com.tridium.aaphp.messages.AaPhpSayHelloResponse;
import com.tridium.aaphp.messages.AaPhpWhoAreYouRequest;
import com.tridium.aaphp.messages.AaPhpWhoAreYouResponse;
import com.tridium.aaphp.util.AaPhpTextUtil;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperty(name="learnedDevices", type="BFolder", defaultValue="new BFolder()", flags=7)
public class BAaPhpLearnDevicesJob
extends BSimpleJob {
    @Generated
    public static final Property learnedDevices = BAaPhpLearnDevicesJob.newProperty((int)7, (BValue)new BFolder(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAaPhpLearnDevicesJob.class);
    private static final String TWO_ZEROS = "00";
    private static final String LEARN_NAME_PREFIX = "Device";
    final BAaPhpNetwork aaphpNet;
    final BAaPhpLearnDevicesParameter learnParameter;

    @Generated
    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    @Generated
    public void setLearnedDevices(BFolder v) {
        this.set(learnedDevices, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAaPhpLearnDevicesJob() {
        this.aaphpNet = null;
        this.learnParameter = null;
    }

    public BAaPhpLearnDevicesJob(BAaPhpNetwork net, BAaPhpLearnDevicesParameter learnParameter) {
        this.aaphpNet = net;
        this.learnParameter = learnParameter;
    }

    AaPhpWhoAreYouResponse sendWhoAreYou() {
        return (AaPhpWhoAreYouResponse)this.aaphpNet.sendSync(new AaPhpWhoAreYouRequest());
    }

    String getLearnName(int unitNumberAddress) {
        return LEARN_NAME_PREFIX + AaPhpTextUtil.truncateRight(TWO_ZEROS + Integer.toString(unitNumberAddress, 16), 2);
    }

    void addLearnedDevice(int unitNumberAddress) {
        String learnName = this.getLearnName(unitNumberAddress);
        if (this.getLearnedDevices().get(learnName) == null) {
            this.getLearnedDevices().add(learnName, (BValue)new BAaPhpLearnDeviceEntry(unitNumberAddress, learnName));
            this.logMessage("found device " + unitNumberAddress);
        }
    }

    void removeLearnedDevice(int unitNumberAddress) {
        String learnName = this.getLearnName(unitNumberAddress);
        if (this.getLearnedDevices().get(learnName) != null) {
            this.getLearnedDevices().remove(learnName);
        }
    }

    void doExhaustiveLearn(int i, int from, int to, BRelTime timeout) {
        AaPhpSayHelloRequest req = new AaPhpSayHelloRequest(this.aaphpNet.translateAddress(i));
        AaPhpSayHelloResponse rsp = (AaPhpSayHelloResponse)this.aaphpNet.sendSync(req, timeout, 0);
        if (rsp == null) {
            this.removeLearnedDevice(i);
        } else {
            this.addLearnedDevice(i);
        }
        this.progress((int)((float)(i - from) / (float)(to - from) * 100.0f));
    }

    boolean doWhoAreYouLearn() {
        AaPhpWhoAreYouResponse whoAreYouRsp = this.sendWhoAreYou();
        if (whoAreYouRsp != null) {
            this.addLearnedDevice(whoAreYouRsp.getStarUnitNumber());
            return true;
        }
        return false;
    }

    boolean doQuickWhoAreYouLearn() {
        if (this.learnParameter.getSendWhoAreYou()) {
            return this.doWhoAreYouLearn();
        }
        return false;
    }

    void doExhaustiveLearn() {
        this.logMessage("exhaustive learn");
        BRelTime timeout = this.learnParameter.getTimeout();
        int from = this.learnParameter.getFrom();
        int to = this.learnParameter.getTo();
        for (int i = from; i <= to; ++i) {
            if (this.isAlive()) {
                this.doExhaustiveLearn(i, from, to, timeout);
                continue;
            }
            if (this.getJobState() != BJobState.canceling && this.getJobState() != BJobState.canceled) continue;
            throw new JobCancelException();
        }
    }

    public void run(Context cx) throws Exception {
        this.logMessage("starting");
        if (!this.doQuickWhoAreYouLearn()) {
            this.doExhaustiveLearn();
        }
    }

    private void logMessage(String message) {
        this.log().message(message);
        if (this.aaphpNet != null) {
            int severity = this.aaphpNet.getLog().getSeverity();
            this.aaphpNet.getLog().setSeverity(1);
            this.aaphpNet.getLog().message("Learn PHP Devices Job:" + message);
            this.aaphpNet.getLog().setSeverity(severity);
        }
    }
}

