/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.BPartInstallStatus;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import java.util.HashSet;
import java.util.Objects;
import javax.baja.ui.table.TableSelection;

public class InstallerTableSelection
extends TableSelection {
    private InstallerTableModel model;

    public InstallerTableSelection(InstallerTableModel model) {
        this.model = model;
    }

    public void deselect(int row) {
        int[] slaveRows;
        super.deselect(row);
        for (int slaveRow : slaveRows = this.getSlaveSelections(row)) {
            super.deselect(slaveRow);
        }
    }

    public void select(int row) {
        try {
            int[] slaveRows;
            this.checkSelect(row);
            for (int slaveRow1 : slaveRows = this.getSlaveSelections(row)) {
                this.checkSelect(slaveRow1);
            }
            super.select(row);
            for (int slaveRow : slaveRows) {
                super.select(slaveRow);
            }
        }
        catch (CannotSelectException cannotSelectException) {
            // empty catch block
        }
    }

    public void select(int anchor, int lead) {
        try {
            this.checkSelect(anchor, lead);
            int a = anchor > lead ? lead : anchor;
            int b = lead > anchor ? anchor : lead;
            HashSet<Integer> slavesToSelect = new HashSet<Integer>();
            for (int ixMaster = a; ixMaster <= b; ++ixMaster) {
                int[] slaveRows;
                for (int slaveRow : slaveRows = this.getSlaveSelections(ixMaster)) {
                    this.checkSelect(slaveRow);
                    slavesToSelect.add(slaveRow);
                }
            }
            super.select(anchor, lead);
            slavesToSelect.forEach(x$0 -> super.select(x$0));
        }
        catch (CannotSelectException cannotSelectException) {
            // empty catch block
        }
    }

    private void checkSelect(int row) throws CannotSelectException {
        if (!this.canSelect(row)) {
            throw new CannotSelectException();
        }
    }

    private void checkSelect(int anchor, int lead) throws CannotSelectException {
        if (!this.canSelect(anchor, lead)) {
            throw new CannotSelectException();
        }
    }

    private boolean canSelect(int anchor, int lead) {
        int a = anchor < lead ? anchor : lead;
        int b = anchor < lead ? lead : anchor;
        BPartInstallStatus s = this.model.getInstallStatusAt(a);
        for (int i = a + 1; i < b; ++i) {
            if (this.model.getInstallStatusAt(a) == s) continue;
            return false;
        }
        return true;
    }

    private boolean canSelect(int row) {
        int aRow = this.getRow();
        if (aRow >= 0) {
            return this.model.getInstallStatusAt(aRow) == this.model.getInstallStatusAt(row);
        }
        return true;
    }

    private int[] getSlaveSelections(int masterRow) {
        String masterInstallableName = this.model.getRow(masterRow).getInstallableName();
        if (masterInstallableName == null) {
            return new int[0];
        }
        int[] tooBig = new int[this.model.getRowCount()];
        int resultSize = 0;
        for (int i = 0; i < tooBig.length; ++i) {
            if (i == masterRow || !this.stringsEqual(masterInstallableName, this.model.getRow(i).getInstallableName())) continue;
            tooBig[resultSize++] = i;
        }
        int[] result = new int[resultSize];
        System.arraycopy(tooBig, 0, result, 0, resultSize);
        return result;
    }

    private boolean stringsEqual(String stringa, String stringb) {
        if (Objects.equals(stringa, stringb)) {
            return true;
        }
        if (stringa == null || stringb == null) {
            return false;
        }
        return stringa.equals(stringb);
    }

    private static class CannotSelectException
    extends Exception {
        private CannotSelectException() {
        }
    }
}

