/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

class CancelUninstallCommand
extends AsyncCommand {
    private InstallerTableModel tableModel;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");

    public CancelUninstallCommand(BWidget owner, InstallerTableModel tableModel) {
        super(owner, lex, "SoftwareManager.command.cancelUninstallSelected");
        this.tableModel = tableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeAsync() {
        BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
        try {
            if (shell != null) {
                shell.enterBusy();
            }
            int[] rows = this.tableModel.getTable().getSelection().getRows();
            TreeSet<String> newCancels = new TreeSet<String>();
            TreeSet<String> remainingUninstalls = new TreeSet<String>();
            InstallScenario initialScenario = this.tableModel.getScenario();
            String[] uninstallPre = initialScenario.getModulesToUninstall();
            Collections.addAll(remainingUninstalls, uninstallPre);
            for (int row : rows) {
                this.cascade(this.tableModel.getCurrentPartAt(row), initialScenario.getTargetPlatform(), remainingUninstalls, newCancels);
            }
            if (newCancels.size() == 0 || 1 == BDialog.confirm((BWidget)this.getOwner(), (String)lex.getText("CancelUninstallCommand.alsoCancel.title"), (Object)this.makeAlsoCancelDetailsPane(newCancels), (int)3)) {
                String[] remaining = remainingUninstalls.toArray(new String[0]);
                this.tableModel.setScenario(InstallScenario.solve((BDaemonPlatform)initialScenario.getTargetPlatform(), null, (String[])remaining, null, (BInstallable[])initialScenario.getToInstall(), (Set)initialScenario.getNewEnabledRuntimeProfiles(), (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)this.tableModel.getCertValidator()));
            }
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }

    private void cascade(BPart part, BDaemonPlatform platform, Set<String> remainingUninstalls, Set<String> newCancels) throws Exception {
        remainingUninstalls.remove(part.getPartName());
        BInstallable installable = LocalInstallableRegistry.getInstance().findInstallable(BDependency.forPart((BPart)part, (BVersionRelation)BVersionRelation.exact), null);
        if (installable == null) {
            installable = LocalInstallableRegistry.getInstance().findInstallable(BDependency.forModule((String)part.getPartName()), null);
        }
        if (installable != null) {
            BDependency[] instDeps;
            for (BDependency instDep : instDeps = installable.getAllDependencies()) {
                if (!instDep.getPartTypeSpec().equals((Object)BModulePart.TYPE.getTypeSpec()) || !remainingUninstalls.contains(instDep.getPartName())) continue;
                String moduleName = instDep.getPartName();
                newCancels.add(moduleName);
                this.cascade(platform.getPart(moduleName, BModulePart.TYPE.getTypeSpec()), platform, remainingUninstalls, newCancels);
            }
        }
    }

    private BWidget makeAlsoCancelDetailsPane(Set<String> partNames) {
        BIndentPane pane = new BIndentPane();
        pane.add(LexiconText.make((String)"platDaemon", (String)"CancelUninstallCommand.alsoCancel.heading"));
        pane.indent();
        partNames.forEach(arg_0 -> ((BIndentPane)pane).add(arg_0));
        pane.unindent();
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)pane, 5.0, 5.0, 5.0, 5.0));
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane cpane = new BConstrainedPane((BWidget)scroll);
        cpane.setFixedSize(285.0, 160.0);
        return new BEdgePane(null, null, null, null, (BWidget)cpane);
    }
}

