/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.lexiconinstall;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.logging.Level;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.FilePath;
import javax.baja.security.AuthenticationException;
import javax.baja.ui.list.ListModel;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class LexiconDirListModel
extends ListModel {
    private XElem[] items = new XElem[0];
    protected BDaemonSession session = null;
    protected DaemonSessionTaskListener listener;

    public int getItemCount() {
        return this.items.length;
    }

    public Object getItem(int index) {
        return this.getFileName(index);
    }

    public String getFileName(int index) {
        return this.items[index].get("name");
    }

    public FilePath getFilePath(int index) {
        return SystemFilePaths.getLexiconHomePath((BIFileSpace)this.session.getFileSpace()).merge(this.getFileName(index));
    }

    public boolean deleteFile(int index) throws AuthenticationException {
        try {
            if (this.session != null && DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)FileTransferMessage.makeDelete((FilePath)this.getFilePath(index), (BDaemonFileSpace)this.session.getFileSpace()), null, (DaemonSessionTaskListener)this.listener)) {
                this.loadValue(this.session, this.listener);
                return true;
            }
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
        return false;
    }

    public void transferDirectory(BIDirectory dir) throws IOException {
        if (this.session == null) {
            return;
        }
        boolean sendMessage = false;
        FilePath lexDirPath = SystemFilePaths.getLexiconHomePath((BIFileSpace)this.session.getFileSpace()).merge(((BIFile)dir).getFileName());
        FileTransferMessage message = new FileTransferMessage((BDaemonFileSpace)this.session.getFileSpace());
        for (BIFile kid : dir.listFiles()) {
            if (kid.isDirectory() || kid.getExtension() == null || !kid.getExtension().equals("lexicon")) continue;
            message.addFile(kid, lexDirPath.merge(kid.getFileName()));
            sendMessage = true;
        }
        if (sendMessage) {
            DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)message, null, (DaemonSessionTaskListener)this.listener);
            this.loadValue(this.session, this.listener);
        }
    }

    public void loadValue(BDaemonSession session, DaemonSessionTaskListener listener) throws AuthenticationException {
        this.session = session;
        this.listener = listener;
        try {
            InputStream in = session.getInputStream((DaemonMessage)new GetDirectoryMessage(SystemFilePaths.getLexiconHomePath((BIFileSpace)session.getFileSpace()), (BDaemonFileSpace)session.getFileSpace()));
            if (in == null) {
                this.items = new XElem[0];
            } else {
                XElem dirElem = XParser.make((InputStream)in).parse();
                this.items = dirElem.elems("directory");
            }
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (Exception e) {
            BDaemonSessionView.log.log(Level.SEVERE, "error listing lexicons", e);
        }
        this.updateList();
    }
}

