/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.lexiconinstall;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.lexiconinstall.BLexiconList;
import com.tridium.platDaemon.ui.lexiconinstall.LexiconDirListModel;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.CommandUtil;
import java.io.IOException;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.BTitlePane;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
@Deprecated
@NiagaraAction(name="checkEnabledStates")
public class BLexiconInstaller
extends BDaemonSessionView {
    @Generated
    public static final Action checkEnabledStates = BLexiconInstaller.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLexiconInstaller.class);
    private final DeleteFileCommand deleteCommand;
    private final BLexiconList list;
    private final BLabel headerLabel;
    private final LexiconDirListModel listModel = new LexiconDirListModel();

    @Generated
    public void checkEnabledStates() {
        this.invoke(checkEnabledStates, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLexiconInstaller() {
        this.list = new BLexiconList(this.listModel);
        this.list.setMultipleSelection(false);
        this.deleteCommand = new DeleteFileCommand(this.list);
        BButtonPane buttons = new BButtonPane();
        buttons.add((Command)new AddFileCommand(this.list));
        buttons.add((Command)this.deleteCommand);
        this.linkTo(null, (BComponent)this.list, (Slot)BList.actionPerformed, (Slot)checkEnabledStates);
        this.linkTo(null, (BComponent)this.list, (Slot)BList.listModified, (Slot)checkEnabledStates);
        this.linkTo(null, (BComponent)this.list, (Slot)BList.selectionModified, (Slot)checkEnabledStates);
        this.doCheckEnabledStates();
        this.headerLabel = new BLabel();
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(null), (BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)this.headerLabel, 0.0, 0.0, 5.0, 0.0), (BWidget)new BBorderPane((BWidget)buttons, 10.0, 0.0, 0.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)this.list, BBorder.none, BInsets.DEFAULT)), 0.0, 4.0, 0.0, 4.0)));
        this.headerLabel.setHalign(BHalign.left);
        this.setTransferWidget((BTransferWidget)this.list);
    }

    public void doCheckEnabledStates() {
        if (this.list.getSelection() == null || this.list.getSelection().isEmpty() || this.list.getSelection().getAnchor() < 0 || this.list.getSelectedIndex() < 0 || this.list.getItemCount() == 0) {
            this.deleteCommand.setEnabled(false);
            this.list.setDeleteEnabled(false);
        } else {
            this.deleteCommand.setEnabled(true);
            this.list.setDeleteEnabled(true);
        }
    }

    @Override
    protected final void doLoadSession(BDaemonSession session, Context cx) throws AuthenticationException {
        this.headerLabel.setText(this.getLexicon().getText("LexiconInstaller.list.header", new Object[]{session.getRemoteAddressString()}));
        this.listModel.loadValue(session, this);
    }

    private static class LexSelectionFilter
    implements IFileFilter {
        private LexSelectionFilter() {
        }

        public boolean accept(BIFile file) {
            if (file.isDirectory()) {
                BIFile[] kids;
                for (BIFile kid : kids = ((BIDirectory)file).listFiles()) {
                    if (kid.isDirectory() || kid.getExtension() == null || !kid.getExtension().equals("lexicon")) continue;
                    return true;
                }
            }
            return false;
        }

        public String getDescription(Context cx) {
            return "";
        }
    }

    private class AddFileCommand
    extends AsyncCommand {
        public AddFileCommand(BList list) {
            super((BWidget)list, TYPE.getModule(), "LexiconInstaller.add");
        }

        public void doInvokeAsync() {
            block11: {
                try {
                    BIFile[] lexDirs;
                    BIFile currentSelection = BFileSystem.INSTANCE.findFile(SystemFilePaths.getLexiconHomePath((BIFileSpace)BLexiconInstaller.this.getDaemonSession().getFileSpace()));
                    if (currentSelection == null) {
                        currentSelection = BFileSystem.INSTANCE.getSysHome();
                    }
                    if ((lexDirs = BFileChooserDialog.chooseFiles((BWidget)this.getOwner(), (BImage)BImage.make((String)BLexiconInstaller.this.getLexicon().getText("LexiconInstaller.addDialog.icon")), (String)BLexiconInstaller.this.getLexicon().getText("LexiconInstaller.addDialog.title"), (String)BLexiconInstaller.this.getLexicon().getText("LexiconInstaller.addDialog.message", new Object[]{BLexiconInstaller.this.getDaemonSession().getRemoteAddressString()}), (BIFile)currentSelection, (IFileFilter)IFileFilter.directory, (IFileFilter)new LexSelectionFilter())).length <= 0) break block11;
                    FileTransferMessage message = new FileTransferMessage((BDaemonFileSpace)BLexiconInstaller.this.getDaemonSession().getFileSpace());
                    boolean sendMessage = false;
                    try {
                        if (lexDirs[0].getFilePath().getParent().getBody().equals(SystemFilePaths.getLexiconHomePath((BIFileSpace)BLexiconInstaller.this.getDaemonSession().getFileSpace()).getBody()) && BLexiconInstaller.this.getDaemonSession().usesLocalNiagaraHome()) {
                            BDialog.error((BWidget)this.getOwner(), (String)BLexiconInstaller.this.getLexicon().getText("LexiconInstaller.title.sourceTargetSame"), (Object)BLexiconInstaller.this.getLexicon().getText("LexiconInstaller.message.sourceTargetSame"));
                            return;
                        }
                    }
                    catch (Exception e) {
                        throw new LocalizableRuntimeException("platDaemon", "LexiconInstaller.addLexException", (Throwable)e);
                    }
                    for (BIFile lexDir : lexDirs) {
                        BIFile[] lexFiles;
                        FilePath lexDirPath = SystemFilePaths.getLexiconHomePath((BIFileSpace)BLexiconInstaller.this.getDaemonSession().getFileSpace()).merge(lexDir.getFileName());
                        for (BIFile lexFile : lexFiles = ((BIDirectory)lexDir).listFiles()) {
                            if (lexFile.getExtension() == null || !lexFile.getExtension().equals("lexicon")) continue;
                            sendMessage = true;
                            try {
                                message.addFile(lexFile, lexDirPath.merge(lexFile.getFileName()));
                            }
                            catch (IOException ioe) {
                                BDialog.error((BWidget)BLexiconInstaller.this, (String)BLexiconInstaller.this.getLexicon().getText("LexiconInstaller.labels.finished.title"), (Object)ioe);
                                return;
                            }
                        }
                    }
                    if (sendMessage) {
                        DaemonFileUtil.transfer((BDaemonSession)BLexiconInstaller.this.getDaemonSession(), (FileTransferMessage)message, null, (DaemonSessionTaskListener)BLexiconInstaller.this);
                    }
                    BLexiconInstaller.this.loadValue(BLexiconInstaller.this.getCurrentValue());
                    BDialog.message((BWidget)BLexiconInstaller.this, (String)BLexiconInstaller.this.getLexicon().getText("LexiconInstaller.labels.finished.message"), (Object)new BBorderPane((BWidget)new BLabel(BLexiconInstaller.this.getLexicon().getText("LexiconInstaller.labels.finished.title")), 10.0, 30.0, 10.0, 30.0));
                }
                catch (Throwable t) {
                    CommandUtil.error((Command)this, (Throwable)t);
                }
            }
        }
    }

    private class DeleteFileCommand
    extends AsyncCommand {
        private final BLexiconList list;

        public DeleteFileCommand(BLexiconList list) {
            super((BWidget)list, TYPE.getModule(), "LexiconInstaller.delete");
            this.list = list;
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            try {
                LexiconDirListModel model = this.list.getLexiconDirListModel();
                int ix = this.list.getSelectedIndex();
                if (4 == BDialog.confirm((BWidget)this.list, (String)BLexiconInstaller.this.getLexicon().getText("LexiconInstaller.delete.confirmTitle", new Object[]{model.getFileName(ix)}), (Object)BLexiconInstaller.this.getLexicon().getText("LexiconInstaller.delete.confirmMessage", new Object[]{model.getFileName(ix)}))) {
                    model.deleteFile(ix);
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            BLexiconInstaller.this.doCheckEnabledStates();
        }
    }
}

