/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.install.BDependency;
import com.tridium.install.InstallScenario;
import com.tridium.install.InstallableCandidates;
import com.tridium.install.InstallableFilter;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BArchPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import javax.baja.sys.Type;

public class CommissioningParameters
extends SolutionParameters {
    private static final String EDGE10_FACTORY_FS = "tridium-qnx7-n4-edge10-factory";
    private static final String EDGE10_MAINT_OS = "tridium-qnx7-n4-edge10-maint";
    private static final String EDGE10_OPEN_FACTORY_FS = "tridium-qnx7-n4-edge10-open-factory";
    private static final String EDGE10_OPEN_MAINT_OS = "tridium-qnx7-n4-edge10-open-maint";
    private static final String EDGE10_OS_NAME = "tridium-qnx7-n4-edge10";
    private static final String EDGE10_OPEN_OS_NAME = "tridium-qnx7-n4-edge10-open";
    private static final String TITAN_MAINT_OS = "tridium-qnx7-n4-titan-am335x-hs-maint";
    private static final String TITAN_QNX6_OS_NAME = "qnx-jace-n4-titan-am335x-hs";
    private static final String TITAN_QNX7_OS_NAME = "tridium-qnx7-n4-titan-am335x-hs";
    protected static final String CONFIG_KEY = "ConfigKey";

    public CommissioningParameters(DaemonSessionTaskListener listener, InstallableFilter filter) {
        super(listener, false, "commissioning");
        this.addFilter(filter);
    }

    public InstallableCandidates getAdditionalCandidates(InstallScenario scenario, BDependency dep) throws Exception {
        InstallableCandidates existingCandidates;
        InstallableCandidates result = super.getAdditionalCandidates(scenario, dep);
        if (dep.getPartType() == BNrePart.TYPE && !(existingCandidates = scenario.getInstallableCandidates()).containsKey((Object)CONFIG_KEY)) {
            for (BInstallable toInstall : scenario.getToInstall()) {
                if (!BPart.matchesName((String)toInstall.getInstallableFileName(), (String)scenario.getTargetPlatform().getConfigDistFileName())) continue;
                return result;
            }
            result.addKey((Object)CONFIG_KEY);
            BDependency osDep = null;
            BDependency vmDep = null;
            for (Object existingKey : existingCandidates.getKeys()) {
                if (!(existingKey instanceof BDependency)) continue;
                Type depType = ((BDependency)existingKey).getPartType();
                if (depType == BOsPart.TYPE) {
                    osDep = (BDependency)existingKey;
                    continue;
                }
                if (depType != BVmPart.TYPE) continue;
                vmDep = (BDependency)existingKey;
            }
            try (LocalInstallableRegistry.InstallableCursor c = (LocalInstallableRegistry.InstallableCursor)LocalInstallableRegistry.getInstance().getInstallables(true, this.listener, scenario.getTargetPlatform().getConfigDistFileName());){
                while (c.next(BDistribution.class)) {
                    BInstallable candidate = c.get();
                    if (!this.acceptInstallable(candidate)) continue;
                    boolean acceptCandidate = true;
                    for (BDependency candDep : candidate.getAllDependencies()) {
                        Type depPartType = candDep.getPartType();
                        if (depPartType == BOsPart.TYPE) {
                            if (scenario.getTargetPlatform().getOsPart().isInstallable()) {
                                String candPartName = candDep.getPartName();
                                BOsPart targOsPart = scenario.getTargetPlatform().getOsPart();
                                if (targOsPart.matchesName(candPartName) || TITAN_QNX6_OS_NAME.equals(targOsPart.getPartName()) && "tridium-qnx7-n4-titan-am335x*".equals(candPartName)) {
                                    if (osDep != null && !candDep.getVersion().meets(osDep)) {
                                        acceptCandidate = false;
                                    }
                                } else if (!scenario.getTargetPlatform().meets(candDep)) {
                                    acceptCandidate = false;
                                }
                            } else if (!scenario.getTargetPlatform().meets(candDep)) {
                                acceptCandidate = false;
                            }
                        } else if (depPartType == BVmPart.TYPE && vmDep != null && !candDep.getVersion().meets(vmDep)) {
                            acceptCandidate = false;
                        } else if (depPartType == BNrePart.TYPE && !candDep.getVersion().meets(dep)) {
                            acceptCandidate = false;
                        } else if (!(depPartType != BArchPart.TYPE && depPartType != BModelPart.TYPE || scenario.getTargetPlatform().meets(candDep))) {
                            acceptCandidate = false;
                        } else if (depPartType == BGenericPart.TYPE) {
                            boolean partIsInstallable = false;
                            BPart part = scenario.getTargetPlatform().getPart(candDep);
                            if (part != null) {
                                partIsInstallable = part.isInstallable();
                                if (!partIsInstallable) {
                                    partIsInstallable = this.checkGenericPartInstallableOverride(partIsInstallable, candDep);
                                }
                            } else {
                                partIsInstallable = true;
                            }
                            if (!partIsInstallable) {
                                acceptCandidate = scenario.getTargetPlatform().meets(candDep);
                            } else {
                                String candidateDependencyPartName = candDep.getPartName();
                                String remoteTargetOsPartName = scenario.getTargetPlatform().getOsPart().getPartName();
                                acceptCandidate = this.validateTargetForGenericInstallable(acceptCandidate, candidateDependencyPartName, remoteTargetOsPartName);
                            }
                        }
                        if (!acceptCandidate) break;
                    }
                    if (!acceptCandidate) continue;
                    result.add((Object)CONFIG_KEY, candidate);
                    if (!this.latestOnly) continue;
                    break;
                }
            }
        }
        return result;
    }

    private boolean checkGenericPartInstallableOverride(boolean isInstallable, BDependency candidateDependency) {
        if (isInstallable) {
            return true;
        }
        String candidateDependencyPartName = candidateDependency.getPartName();
        return EDGE10_OPEN_FACTORY_FS.equals(candidateDependencyPartName) || EDGE10_OPEN_MAINT_OS.equals(candidateDependencyPartName) || EDGE10_FACTORY_FS.equals(candidateDependencyPartName) || EDGE10_MAINT_OS.equals(candidateDependencyPartName);
    }

    private boolean validateTargetForGenericInstallable(boolean candidateAcceptable, String candidateDependencyPartName, String remoteTargetOsPartName) {
        if (EDGE10_FACTORY_FS.equals(candidateDependencyPartName) || EDGE10_MAINT_OS.equals(candidateDependencyPartName)) {
            candidateAcceptable = EDGE10_OS_NAME.equals(remoteTargetOsPartName);
        }
        if (EDGE10_OPEN_FACTORY_FS.equals(candidateDependencyPartName) || EDGE10_OPEN_MAINT_OS.equals(candidateDependencyPartName)) {
            candidateAcceptable = EDGE10_OPEN_OS_NAME.equals(remoteTargetOsPartName);
        }
        if (TITAN_MAINT_OS.equals(candidateDependencyPartName)) {
            candidateAcceptable = TITAN_QNX6_OS_NAME.equals(remoteTargetOsPartName) || TITAN_QNX7_OS_NAME.equals(remoteTargetOsPartName);
        }
        return candidateAcceptable;
    }
}

