/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.install.part.BOsPart;
import com.tridium.niagarad.util.DaemonAuthUtil;
import com.tridium.nre.auth.GroupAccount;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platDaemon.ui.acctmgt.BNativeUserTable;
import com.tridium.platDaemon.ui.acctmgt.FileDomainPasswordController;
import com.tridium.platDaemon.ui.acctmgt.QnxUserNameController;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platform.daemon.message.AccountManagementMessage;
import com.tridium.platform.daemon.message.AddMemberMessage;
import com.tridium.platform.daemon.message.AddUserMessage;
import com.tridium.platform.daemon.message.AuthenticateUserMessage;
import com.tridium.platform.daemon.message.ChangePasswordMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteMemberMessage;
import com.tridium.platform.daemon.message.DeleteUserMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class AuthStep
extends CommissioningWizardStep {
    private NativeNewUserStep nativeNewUserStep = null;
    private NativeUsersStep nativeUsersStep = null;
    private NativeCredentialsStep nativeCredentialsStep = null;
    private FileDomainUserStep fileDomainUserStep = null;
    private BRadioButton scramFileButton = null;
    private BRadioButton digestFileButton = null;
    private BRadioButton basicNativeButton = null;
    private BRadioButton scramNativeButton = null;
    private boolean stepInitialized = false;

    public AuthStep(CommissioningWizardModel wizardModel) {
        super(wizardModel);
    }

    private void initStep() {
        try {
            if (!this.stepInitialized) {
                NextStepCommand cmd;
                NextStepCommand nextCommand;
                BUsernameAndPassword cred;
                this.stepInitialized = true;
                if (DaemonAuthUtil.isFileScheme((String)this.wizardModel.authMethod) && (cred = (BUsernameAndPassword)this.wizardModel.daemonSession.getCredentials()) != null) {
                    this.wizardModel.fileDomainAdminPassword = cred.getPassword();
                }
                BOsPart os = this.wizardModel.getPlatform().getOsPart();
                ToggleCommandGroup group = new ToggleCommandGroup();
                BGridPane grid = new BGridPane(1);
                grid.setValign(BValign.top);
                grid.setHalign(BHalign.left);
                String osNameForLabel = AuthStep.makeFriendlyOsName(this.wizardModel.getPlatform().getOsPart().getPartName());
                if (this.wizardModel.authTypesSupported.contains("basic/native")) {
                    if (this.wizardModel.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
                        if (this.wizardModel.defaultAccountPresent) {
                            this.nativeNewUserStep = new NativeNewUserStep(this.wizardModel);
                            nextCommand = new NextStepCommand(this.wizardModel.owner, this, this.nativeNewUserStep, "AuthWizard.authMethodStep.basicNative.label", new Object[]{osNameForLabel});
                            this.nativeNewUserStep.priorStep = this;
                            this.nativeNewUserStep.lastStep.nextStep = this.stepAfterSection;
                        } else {
                            this.nativeUsersStep = new NativeUsersStep(this.wizardModel);
                            nextCommand = new NextStepCommand(this.wizardModel.owner, this, this.nativeUsersStep, "AuthWizard.authMethodStep.basicNative.label", new Object[]{osNameForLabel});
                            this.nativeUsersStep.priorStep = this;
                            this.nativeUsersStep.lastStep.nextStep = this.stepAfterSection;
                        }
                    } else {
                        this.nativeCredentialsStep = new NativeCredentialsStep(this.wizardModel);
                        nextCommand = new NextStepCommand(this.wizardModel.owner, this, this.nativeCredentialsStep, "AuthWizard.authMethodStep.basicNative.label", new Object[]{osNameForLabel});
                        this.nativeCredentialsStep.priorStep = this;
                        this.nativeCredentialsStep.lastStep.nextStep = this.stepAfterSection;
                    }
                    this.basicNativeButton = new BRadioButton((ToggleCommand)nextCommand, true, false);
                    grid.add(null, (BValue)this.basicNativeButton);
                    group.add((ToggleCommand)nextCommand);
                }
                if (this.wizardModel.authTypesSupported.contains("scram-sha512/native") || this.wizardModel.authTypesSupported.contains("scram-glibc-sha256/native") || this.wizardModel.authTypesSupported.contains("scram-glibc-sha512/native")) {
                    if (this.wizardModel.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
                        if (this.wizardModel.defaultAccountPresent) {
                            this.nativeNewUserStep = new NativeNewUserStep(this.wizardModel);
                            nextCommand = new NextStepCommand(this.wizardModel.owner, this, this.nativeNewUserStep, "AuthWizard.authMethodStep.scramNative.label", new Object[]{osNameForLabel});
                            this.nativeNewUserStep.priorStep = this;
                            this.nativeNewUserStep.lastStep.nextStep = this.stepAfterSection;
                        } else {
                            this.nativeUsersStep = new NativeUsersStep(this.wizardModel);
                            nextCommand = new NextStepCommand(this.wizardModel.owner, this, this.nativeUsersStep, "AuthWizard.authMethodStep.scramNative.label", new Object[]{osNameForLabel});
                            this.nativeUsersStep.priorStep = this;
                            this.nativeUsersStep.lastStep.nextStep = this.stepAfterSection;
                        }
                    } else {
                        this.nativeCredentialsStep = new NativeCredentialsStep(this.wizardModel);
                        nextCommand = new NextStepCommand(this.wizardModel.owner, this, this.nativeCredentialsStep, "AuthWizard.authMethodStep.scramNative.label", new Object[]{osNameForLabel});
                        this.nativeCredentialsStep.priorStep = this;
                        this.nativeCredentialsStep.lastStep.nextStep = this.stepAfterSection;
                    }
                    this.scramNativeButton = new BRadioButton((ToggleCommand)nextCommand, true, false);
                    grid.add(null, (BValue)this.scramNativeButton);
                    group.add((ToggleCommand)nextCommand);
                }
                if (this.wizardModel.authTypesSupported.contains("digest/file")) {
                    this.fileDomainUserStep = new FileDomainUserStep(this.wizardModel, "digest/file");
                    cmd = new NextStepCommand(this.wizardModel.owner, this, this.fileDomainUserStep, "AuthWizard.authMethodStep.digestFile.label", null);
                    this.fileDomainUserStep.priorStep = this;
                    this.fileDomainUserStep.lastStep.nextStep = this.stepAfterSection;
                    this.digestFileButton = new BRadioButton((ToggleCommand)cmd, true, false);
                    grid.add(null, (BValue)this.digestFileButton);
                    group.add((ToggleCommand)cmd);
                }
                if (this.wizardModel.authTypesSupported.contains("scram-glibc-sha512/file")) {
                    this.fileDomainUserStep = new FileDomainUserStep(this.wizardModel, "scram-glibc-sha512/file");
                    cmd = new NextStepCommand(this.wizardModel.owner, this, this.fileDomainUserStep, "AuthWizard.authMethodStep.scramFile.label", null);
                    this.fileDomainUserStep.priorStep = this;
                    this.fileDomainUserStep.lastStep.nextStep = this.stepAfterSection;
                    this.scramFileButton = new BRadioButton((ToggleCommand)cmd, true, false);
                    grid.add(null, (BValue)this.scramFileButton);
                    group.add((ToggleCommand)cmd);
                }
                BLabel headerLabel = LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.authMethodStep.header"));
                this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)headerLabel, 4.0, 0.0, 8.0, 0.0), null, null, null, (BWidget)grid));
                if (this.wizardModel.authTypesSupported.size() == 1) {
                    if (this.basicNativeButton != null && this.wizardModel.authMethod.equals("basic/native") || this.scramNativeButton != null && (this.wizardModel.authMethod.equals("scram-sha512/native") || this.wizardModel.authMethod.equals("scram-glibc-sha256/native") || this.wizardModel.authMethod.equals("scram-glibc-sha512/native"))) {
                        if (this.basicNativeButton != null) {
                            this.basicNativeButton.setSelected(this.wizardModel.authMethod.equals("basic/native"));
                        }
                        if (this.scramNativeButton != null) {
                            this.scramNativeButton.setSelected(this.wizardModel.authMethod.equals("scram-sha512/native") || this.wizardModel.authMethod.equals("scram-glibc-sha256/native") || this.wizardModel.authMethod.equals("scram-glibc-sha512/native"));
                        }
                        if (this.wizardModel.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
                            if (this.wizardModel.defaultAccountPresent) {
                                this.nextStep = this.nativeNewUserStep;
                                this.lastStep = this.nativeNewUserStep.lastStep;
                            } else {
                                this.nextStep = this.nativeUsersStep;
                                this.lastStep = this.nativeUsersStep.lastStep;
                            }
                        } else {
                            this.nextStep = this.nativeCredentialsStep;
                            this.lastStep = this.nativeCredentialsStep.lastStep;
                        }
                        this.setStepAfterSection(this.stepAfterSection);
                    } else if (this.digestFileButton != null && this.wizardModel.authMethod.equals("digest/file")) {
                        this.digestFileButton.setSelected(true);
                        this.nextStep = this.fileDomainUserStep;
                        this.lastStep = this.fileDomainUserStep.lastStep;
                        this.setStepAfterSection(this.stepAfterSection);
                    } else if (this.scramFileButton != null && this.wizardModel.authMethod.equals("scram-glibc-sha512/file")) {
                        this.scramFileButton.setSelected(true);
                        this.nextStep = this.fileDomainUserStep;
                        this.lastStep = this.fileDomainUserStep.lastStep;
                        this.setStepAfterSection(this.stepAfterSection);
                    }
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getStepName() {
        return "authMethodStep";
    }

    @Override
    public String getSectionName() {
        return "auth";
    }

    @Override
    public void enter() {
        this.initStep();
        if (DaemonAuthUtil.isNativeScheme((String)this.wizardModel.authMethod)) {
            if (this.basicNativeButton != null) {
                this.basicNativeButton.setSelected(this.wizardModel.authMethod.equals("basic/native"));
            }
            if (this.scramNativeButton != null) {
                this.scramNativeButton.setSelected(this.wizardModel.authMethod.equals("scram-sha512/native") || this.wizardModel.authMethod.equals("scram-glibc-sha256/native") || this.wizardModel.authMethod.equals("scram-glibc-sha512/native"));
            }
            if (this.wizardModel.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
                if (this.wizardModel.defaultAccountPresent) {
                    this.nextStep = this.nativeNewUserStep;
                    this.lastStep = this.nativeNewUserStep.lastStep;
                } else {
                    this.nextStep = this.nativeUsersStep;
                    this.lastStep = this.nativeUsersStep.lastStep;
                }
            } else {
                this.nextStep = this.nativeCredentialsStep;
                this.lastStep = this.nativeCredentialsStep.lastStep;
            }
        } else if (this.wizardModel.authMethod.equals("digest/file")) {
            this.digestFileButton.setSelected(true);
            this.nextStep = this.fileDomainUserStep;
            this.lastStep = this.fileDomainUserStep.lastStep;
        } else if (this.wizardModel.authMethod.equals("scram-glibc-sha512/file")) {
            this.scramFileButton.setSelected(true);
            this.nextStep = this.fileDomainUserStep;
            this.lastStep = this.fileDomainUserStep.lastStep;
        }
        this.setStepAfterSection(this.stepAfterSection);
    }

    @Override
    public boolean exit(int direction) {
        if (!this.wizardModel.forceChangeUserList.isEmpty()) {
            return false;
        }
        if (this.digestFileButton != null && this.digestFileButton.isSelected() && !this.wizardModel.authMethod.equals("digest/file")) {
            this.wizardModel.authMethod = "digest/file";
            this.wizardModel.authMethodChanged = true;
        }
        if (this.scramFileButton != null && this.scramFileButton.isSelected()) {
            if (!this.wizardModel.authMethod.equals("scram-glibc-sha512/file")) {
                this.wizardModel.authMethod = "scram-glibc-sha512/file";
                this.wizardModel.authMethodChanged = true;
            }
        } else if (this.basicNativeButton != null && this.basicNativeButton.isSelected()) {
            if (!this.wizardModel.authMethod.equals("basic/native")) {
                this.wizardModel.authMethod = "basic/native";
                this.wizardModel.authMethodChanged = true;
            }
        } else if (this.scramNativeButton != null && this.scramNativeButton.isSelected() && !this.wizardModel.authMethod.equals("scram-sha512/native") && !this.wizardModel.authMethod.equals("scram-glibc-sha256/native") && !this.wizardModel.authMethod.equals("scram-glibc-sha512/native")) {
            if (this.wizardModel.authTypesSupported.contains("scram-sha512/native")) {
                this.wizardModel.authMethod = "scram-sha512/native";
            } else if (this.wizardModel.authTypesSupported.contains("scram-glibc-sha256/native")) {
                this.wizardModel.authMethod = "scram-glibc-sha256/native";
            } else if (this.wizardModel.authTypesSupported.contains("scram-glibc-sha512/native")) {
                this.wizardModel.authMethod = "scram-glibc-sha512/native";
            }
            this.wizardModel.authMethodChanged = true;
        }
        return true;
    }

    @Override
    public int getMode() {
        return 3;
    }

    @Override
    public boolean isSkipped() {
        this.initStep();
        return this.wizardModel.authTypesSupported.size() == 1 || this.wizardModel.skipAuth;
    }

    private static String makeFriendlyOsName(String osPart) {
        String osNameForLabel = null;
        osNameForLabel = osPart.toLowerCase().contains("win") ? "Windows" : (osPart.toLowerCase().contains("qnx") ? "QNX" : (osPart.toLowerCase().contains("linux") ? "Linux" : osPart));
        return osNameForLabel;
    }

    private static class ModeControlModel
    extends TextModel {
        private CommissioningWizardStep step;

        public ModeControlModel(CommissioningWizardStep pStep) {
            this.step = pStep;
        }

        protected void textModified() {
            this.step.wizardModel.update(this.step.getMode());
        }
    }

    private static class NativeUsersStep
    extends CommissioningWizardStep {
        private BNativeUserTable userTable;
        private HashMap<String, UserAccount> beforeUsers = new HashMap();
        private HashMap<String, UserAccount> afterUsers = new HashMap();

        public NativeUsersStep(CommissioningWizardModel wizardModel) throws Exception {
            super(wizardModel);
            BGridPane headers = new BGridPane(1);
            headers.setHalign(BHalign.left);
            headers.add(null, (BValue)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.authNativeUsersStep.header"), (boolean)false));
            this.userTable = new BNativeUserTable(false);
            this.userTable.loadSession(wizardModel.daemonSession);
            this.beforeUsers = this.userTable.getUsers();
            BGridPane usersPane = new BGridPane(1);
            usersPane.setHalign(BHalign.left);
            usersPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)this.getLexiconText("UserManager.label.users"), (boolean)true));
            this.setContent((BWidget)new BEdgePane((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)usersPane, 3.0, 0.0, 7.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)headers, BBorder.make((String)"bottom(groove)"), BInsets.make((double)4.0, (double)0.0, (double)8.0, (double)0.0))), (BWidget)new BBorderPane((BWidget)this.userTable.getButtonPane(), 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)this.userTable, BBorder.inset, BInsets.DEFAULT)));
        }

        @Override
        public String getStepName() {
            return "authNativeUsersStep";
        }

        @Override
        public String getSectionName() {
            return "auth";
        }

        @Override
        public void enter() {
            this.userTable.setForceChangeUsers(this.wizardModel.forceChangeUsers, this.wizardModel.forceChangeUserList);
            if (this.wizardModel.newNativeUserAccountToAdd != null) {
                BNativeUserTable.UserModel model = (BNativeUserTable.UserModel)this.userTable.getModel();
                for (int i = 0; i < model.getRowCount(); ++i) {
                    if (!model.getUser(i).getAccountName().equalsIgnoreCase(this.wizardModel.defaultAccountUserName)) continue;
                    UserAccount toRemove = (UserAccount)model.remove(i);
                    this.beforeUsers.remove(toRemove.getFullyQualifiedName());
                    this.wizardModel.defaultNativeUserAccountToRemove = toRemove;
                    break;
                }
                boolean newUserFound = false;
                for (int i = 0; i < model.getRowCount(); ++i) {
                    if (!model.getUser(i).getAccountName().equalsIgnoreCase(this.wizardModel.newNativeUserAccountToAdd.getAccountName())) continue;
                    newUserFound = true;
                    break;
                }
                if (!newUserFound) {
                    model.add(0, this.wizardModel.newNativeUserAccountToAdd);
                }
                BNativeUserTable.replacementAccountUserName = this.wizardModel.newNativeUserAccountToAdd.getAccountName();
            }
        }

        @Override
        public boolean exit(int direction) {
            boolean changed;
            String userNameAtFinish;
            boolean back;
            boolean bl = back = direction == 1;
            if (back) {
                if (this.wizardModel.newNativeUserAccountToAdd != null) {
                    BNativeUserTable.UserModel model = (BNativeUserTable.UserModel)this.userTable.getModel();
                    for (int i = 0; i < model.getRowCount(); ++i) {
                        if (!model.getUser(i).getAccountName().equalsIgnoreCase(this.wizardModel.newNativeUserAccountToAdd.getAccountName())) continue;
                        model.remove(i);
                        break;
                    }
                }
                return true;
            }
            if (this.wizardModel.forceChangeUsers && !this.wizardModel.forceChangeUserList.isEmpty()) {
                BDialog.error((BWidget)this.wizardModel.owner, (String)LEX.getText("CommissioningWizard.authNativeUsersStep.notFipsReady.title"), (Object)LEX.getText("CommissioningWizard.authNativeUsersStep.notFipsReady.info"));
                return false;
            }
            this.afterUsers = this.userTable.getUsers();
            this.wizardModel.nativeUsersToAdd.clear();
            this.wizardModel.nativeUsersToAdd.addAll(this.afterUsers.values());
            this.beforeUsers.values().forEach(this.wizardModel.nativeUsersToAdd::remove);
            this.wizardModel.nativeUsersToRemove.clear();
            this.wizardModel.nativeUsersToRemove.addAll(this.beforeUsers.values());
            this.afterUsers.values().forEach(this.wizardModel.nativeUsersToRemove::remove);
            this.wizardModel.nativePasswordsToChange.clear();
            Set<String> beforeSet = this.beforeUsers.keySet();
            Set<String> afterSet = this.afterUsers.keySet();
            boolean beforeIsLarger = beforeSet.size() > afterSet.size();
            HashSet<String> intersectionSet = new HashSet<String>(beforeIsLarger ? afterSet : beforeSet);
            intersectionSet.retainAll(beforeIsLarger ? beforeSet : afterSet);
            for (String intersection : intersectionSet) {
                UserAccount afterAccount = this.afterUsers.get(intersection);
                if (afterAccount.getPassword() == null || afterAccount.getOldPassword() == null) continue;
                this.wizardModel.nativePasswordsToChange.add(afterAccount);
            }
            this.wizardModel.authMessageQueue.clear();
            UserAccount toRemove = null;
            for (UserAccount accountToAdd : this.wizardModel.nativeUsersToAdd) {
                if (this.wizardModel.newNativeUserAccountToAdd != null && this.wizardModel.newNativeUserAccountToAdd.getAccountName().equalsIgnoreCase(accountToAdd.getAccountName())) {
                    toRemove = accountToAdd;
                    continue;
                }
                AddUserMessage addUserMessage = new AddUserMessage(accountToAdd);
                AddMemberMessage addMemberMessage = new AddMemberMessage(this.userTable.getGroup(), accountToAdd);
                this.wizardModel.authMessageQueue.add((XmlResponseMessage)addUserMessage);
                this.wizardModel.authMessageQueue.add((XmlResponseMessage)addMemberMessage);
            }
            if (toRemove != null) {
                this.wizardModel.nativeUsersToAdd.remove(toRemove);
            }
            toRemove = null;
            for (UserAccount accountToRemove : this.wizardModel.nativeUsersToRemove) {
                if (this.wizardModel.defaultAccountPresent && this.wizardModel.defaultAccountUserName.equalsIgnoreCase(accountToRemove.getAccountName())) {
                    toRemove = accountToRemove;
                    continue;
                }
                DeleteMemberMessage deleteMemberMessage = new DeleteMemberMessage(this.userTable.getGroup(), accountToRemove);
                DeleteUserMessage deleteUserMessage = new DeleteUserMessage(accountToRemove);
                this.wizardModel.authMessageQueue.add((XmlResponseMessage)deleteMemberMessage);
                this.wizardModel.authMessageQueue.add((XmlResponseMessage)deleteUserMessage);
            }
            if (toRemove != null) {
                this.wizardModel.nativeUsersToRemove.remove(toRemove);
            }
            for (UserAccount accountToChange : this.wizardModel.nativePasswordsToChange) {
                ChangePasswordMessage changeMessage = new ChangePasswordMessage(accountToChange, accountToChange.getOldPassword(), accountToChange.getPassword(), false);
                this.wizardModel.authMessageQueue.add((XmlResponseMessage)changeMessage);
            }
            if (this.wizardModel.newNativeUserAccountToAdd != null) {
                userNameAtFinish = this.wizardModel.newNativeUserAccountToAdd.getAccountName();
            } else {
                BUsernameAndPassword sessionCred = (BUsernameAndPassword)this.wizardModel.daemonSession.getCredentials();
                userNameAtFinish = NativeAccount.fullyQualifiedToUsername((String)sessionCred.getUsername());
            }
            this.wizardModel.newCredentials = null;
            ChangePasswordMessage currentUserPasswordMessage = null;
            for (XmlResponseMessage current : this.wizardModel.authMessageQueue) {
                ChangePasswordMessage message;
                UserAccount account;
                if (!(current instanceof ChangePasswordMessage) || !(account = (message = (ChangePasswordMessage)current).getAccount()).getAccountName().equals(userNameAtFinish)) continue;
                currentUserPasswordMessage = message;
                break;
            }
            boolean bl2 = changed = this.wizardModel.authMessageQueue.size() > 0 || this.wizardModel.newNativeUserAccountToAdd != null || this.wizardModel.defaultNativeUserAccountToRemove != null;
            if (changed) {
                if (currentUserPasswordMessage != null) {
                    this.wizardModel.authMessageQueue.remove(currentUserPasswordMessage);
                    this.wizardModel.authMessageQueue.add((XmlResponseMessage)new ChangePasswordMessage(currentUserPasswordMessage.getAccount(), currentUserPasswordMessage.getOldPassword(), currentUserPasswordMessage.getNewPassword(), true));
                    String accountName = currentUserPasswordMessage.getAccount().getAccountName();
                    String encodedPassword = currentUserPasswordMessage.getNewPassword();
                    String decodedPassword = null;
                    try {
                        decodedPassword = LegacyStorageUtil.decode((String)encodedPassword);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.wizardModel.newCredentials = new BUsernameAndPassword(accountName, BPassword.make((String)decodedPassword));
                }
                this.wizardModel.authUsersChanged = true;
            }
            return true;
        }

        @Override
        public int getMode() {
            return 3;
        }

        @Override
        public boolean isSkipped() {
            return this.wizardModel.skipAuth || this.wizardModel.skipConfigUsers;
        }
    }

    private static class NativeNewUserStep
    extends CommissioningWizardStep {
        BTextField userNameField = new BTextField("", 20);
        BTextField commentField = new BTextField("", 20);
        BPasswordFE passwordFE1 = new BPasswordFE();
        BPasswordFE passwordFE2 = new BPasswordFE();
        private XElem[] existingAdminUsers = null;

        public NativeNewUserStep(CommissioningWizardModel wizardModel) throws Exception {
            super(wizardModel);
            BGridPane grid = new BGridPane(2);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            grid.setStretchColumn(1);
            this.userNameField = new BTextField("", 20);
            this.commentField = new BTextField("", 20);
            this.passwordFE1 = new BPasswordFE();
            this.passwordFE2 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("UserManager.AddUserCommand.label.name"), (BWidget)this.userNameField);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("UserManager.AddUserCommand.label.password"), (BWidget)this.passwordFE1);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("UserManager.AddUserCommand.label.password2"), (BWidget)this.passwordFE2);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("UserManager.AddUserCommand.label.comment"), (BWidget)this.commentField);
            ((BTextField)this.passwordFE1.getContent()).setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE2.getContent()).setModel((TextModel)new ModeControlModel(this));
            this.userNameField.setModel((TextModel)new ModeControlModel(this));
            if (wizardModel.daemonSession.getHostProperties().getOsName().toLowerCase().contains("qnx")) {
                this.userNameField.setController((TextController)new QnxUserNameController());
            }
            this.lastStep = this.nextStep = new NativeUsersStep(wizardModel);
            this.nextStep.priorStep = this;
            BLabel headerLabel = LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.authNewNativeUserStep.header"));
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)headerLabel, 4.0, 0.0, 8.0, 0.0), null, null, null, (BWidget)grid));
        }

        @Override
        public String getStepName() {
            return "authNewNativeUserStep";
        }

        @Override
        public String getSectionName() {
            return "auth";
        }

        @Override
        public void enter() {
            if (this.wizardModel.newNativeUserAccountToAdd != null) {
                this.userNameField.setText(this.wizardModel.newNativeUserAccountToAdd.getAccountName());
                this.commentField.setText(this.wizardModel.newNativeUserAccountToAdd.getComment());
                try {
                    this.passwordFE1.loadValue((BObject)BPassword.make((String)LegacyStorageUtil.decode((String)this.wizardModel.newNativeUserAccountToAdd.getPassword())));
                    this.passwordFE2.loadValue((BObject)BPassword.make((String)LegacyStorageUtil.decode((String)this.wizardModel.newNativeUserAccountToAdd.getPassword())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean exit(int direction) {
            boolean back;
            boolean bl = back = direction == 1;
            if (back) {
                return true;
            }
            try {
                BPassword pw2;
                BPassword pw1;
                String comment;
                String fullyQualifiedName;
                block25: {
                    block24: {
                        String accountName = this.userNameField.getText().trim();
                        if (accountName.length() == 0) {
                            BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.nameRequired"));
                            return false;
                        }
                        if (!NativeAccount.isAccountNameFullyQualified((String)accountName)) {
                            fullyQualifiedName = this.wizardModel.nativeAdminGroup.getDomain() + "\\" + accountName;
                        } else {
                            fullyQualifiedName = accountName;
                            accountName = NativeAccount.fullyQualifiedToUsername((String)accountName);
                        }
                        comment = this.commentField.getText().trim();
                        if (BNativeUserTable.isReserved(accountName)) {
                            BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.userReserved", new Object[]{accountName}));
                            return false;
                        }
                        boolean alreadyExists = false;
                        if (this.nextStep instanceof NativeUsersStep) {
                            if (((NativeUsersStep)this.nextStep).userTable.getUsers().containsKey(fullyQualifiedName)) {
                                alreadyExists = true;
                            }
                        } else {
                            if (this.existingAdminUsers == null) {
                                XElem[] remoteGroups;
                                XElem accountInfo = XParser.make((InputStream)this.wizardModel.daemonSession.getInputStream((DaemonMessage)new AccountManagementMessage())).parse();
                                for (XElem currentGroup : remoteGroups = accountInfo.elems("group")) {
                                    if (!currentGroup.get("name").equals(this.wizardModel.nativeAdminGroup.getFullyQualifiedName())) continue;
                                    this.existingAdminUsers = currentGroup.elems("user");
                                }
                            }
                            if (this.existingAdminUsers != null) {
                                for (XElem adminUser : this.existingAdminUsers) {
                                    if (!UserAccount.fullyQualifiedToUsername((String)adminUser.get("name")).equals(accountName)) continue;
                                    alreadyExists = true;
                                }
                            }
                        }
                        if (alreadyExists) {
                            BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.userAlreadyExists", new Object[]{accountName}));
                            return false;
                        }
                        for (int i = 0; i < comment.length(); ++i) {
                            char c = comment.charAt(i);
                            if (!"-=+()@._ ".contains(String.valueOf(c)) && !Character.isLetterOrDigit(c)) {
                                BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.invalidCommentCharacter", new Object[]{String.valueOf(c)}));
                                return false;
                            }
                            if (i < 64) continue;
                            BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.commentTooLong"));
                            return false;
                        }
                        pw1 = (BPassword)this.passwordFE1.saveValue();
                        pw2 = (BPassword)this.passwordFE2.saveValue();
                        if (pw1 == null) break block24;
                        if (AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()).trim().length() == 0 || pw2 == null) break block24;
                        if (AccessController.doPrivileged(() -> ((BPassword)pw2).getValue()).trim().length() != 0) break block25;
                    }
                    BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.passwordRequired"));
                    return false;
                }
                if (!BNativeUserTable.validatePassword((BWidget)this.wizardModel.getWizard(), pw1, FipsOptionsHelper.getInstance().getPasswordStrengthRequirements(this.wizardModel.isFips, this.wizardModel.daemonSession))) {
                    return false;
                }
                if (!SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)pw2).getValue()))) {
                    BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.passwordMismatch"));
                    return false;
                }
                this.wizardModel.newNativeUserAccountToAdd = new UserAccount(fullyQualifiedName, null, comment, LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()), (int)0));
                this.wizardModel.defaultNativeUserAccountToRemove = new UserAccount(this.wizardModel.nativeAdminGroup.getDomain() + "\\" + this.wizardModel.defaultAccountUserName, null, null, null);
                this.wizardModel.authUsersChanged = true;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            return true;
        }

        @Override
        public int getMode() {
            int mode = 1;
            if (this.userNameField.getText().trim().length() == 0 || ((BTextField)this.passwordFE1.getContent()).getText().trim().length() == 0 || ((BTextField)this.passwordFE2.getContent()).getText().trim().length() == 0) {
                return mode;
            }
            return mode | 2;
        }

        @Override
        public boolean isSkipped() {
            return this.wizardModel.skipAuth || !this.wizardModel.defaultAccountPresent;
        }
    }

    private static class NativeGroupStep
    extends CommissioningWizardStep {
        private BListDropDown adminList;

        public NativeGroupStep(CommissioningWizardModel wizardModel) throws Exception {
            super(wizardModel);
            BGridPane grid = new BGridPane(2);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            grid.setStretchColumn(1);
            this.adminList = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("AuthWizard.authNativeGroupStep.adminList.label"), (BWidget)this.adminList);
            String osNameForLabel = AuthStep.makeFriendlyOsName(wizardModel.getPlatform().getOsPart().getPartName());
            BLabel headerLabel = LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.authNativeGroupStep.header"), (Object[])new Object[]{osNameForLabel});
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)headerLabel, 4.0, 0.0, 8.0, 0.0), null, null, null, (BWidget)grid));
        }

        @Override
        public String getStepName() {
            return "authNativeGroupStep";
        }

        @Override
        public String getSectionName() {
            return "auth";
        }

        @Override
        public void enter() {
            this.adminList.getList().removeAllItems();
            for (XElem domain : this.wizardModel.authInfo.elems("domain")) {
                for (XElem group : domain.elems("group")) {
                    this.adminList.getList().addItem((Object)new GroupAccount(group.get("name"), group.get("id")));
                }
            }
            if (this.adminList.getList().indexOfItem((Object)this.wizardModel.nativeAdminGroup) >= 0) {
                this.adminList.getList().setSelectedItem((Object)this.wizardModel.nativeAdminGroup);
            } else {
                this.adminList.getList().getSelection().deselectAll();
            }
        }

        @Override
        public boolean exit(int direction) {
            boolean back;
            boolean bl = back = direction == 1;
            if (back) {
                return true;
            }
            if (this.adminList.getList().getSelectedIndex() < 0) {
                BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("AuthWizard.error.nullAdminGroup"));
                return false;
            }
            if (this.wizardModel.nativeAdminGroup == null || !this.wizardModel.nativeAdminGroup.equals(this.adminList.getList().getSelectedItem())) {
                this.wizardModel.nativeAdminGroup = (GroupAccount)this.adminList.getList().getSelectedItem();
                this.wizardModel.authMethodChanged = true;
            }
            return true;
        }

        @Override
        public int getMode() {
            return 3;
        }

        @Override
        public boolean isSkipped() {
            return this.wizardModel.skipAuth;
        }
    }

    private static class NativeCredentialsStep
    extends CommissioningWizardStep {
        private BPasswordFE passwordFE;
        private BTextField userNameField;

        public NativeCredentialsStep(CommissioningWizardModel wizardModel) throws Exception {
            super(wizardModel);
            BGridPane grid = new BGridPane(2);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            grid.setStretchColumn(1);
            this.userNameField = new BTextField("", 20);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("AuthWizard.authNativeCredentialsStep.user.label"), (BWidget)this.userNameField);
            this.passwordFE = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("AuthWizard.authNativeCredentialsStep.pw.label"), (BWidget)this.passwordFE);
            this.userNameField.setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE.getContent()).setModel((TextModel)new ModeControlModel(this));
            this.lastStep = this.nextStep = new NativeGroupStep(wizardModel);
            this.nextStep.priorStep = this;
            BLabel headerLabel = LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.authNativeCredentialsStep.header"));
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)headerLabel, 4.0, 0.0, 8.0, 0.0), null, null, null, (BWidget)grid));
        }

        @Override
        public String getStepName() {
            return "authNativeCredentialsStep";
        }

        @Override
        public String getSectionName() {
            return "auth";
        }

        @Override
        public void enter() {
            if (this.nextStep != null) {
                this.nextStep.priorStep = this;
            }
            if (this.wizardModel.newCredentials != null) {
                this.userNameField.setText(this.wizardModel.newCredentials.getUsername());
                this.passwordFE.loadValue((BObject)this.wizardModel.newCredentials.getPassword());
            }
        }

        @Override
        public boolean exit(int direction) {
            try {
                BPassword password;
                String username;
                block10: {
                    block9: {
                        boolean back;
                        boolean bl = back = direction == 1;
                        if (back) {
                            return true;
                        }
                        username = this.userNameField.getText();
                        password = (BPassword)this.passwordFE.saveValue();
                        if (username == null || username.trim().length() == 0 || password == null) break block9;
                        if (AccessController.doPrivileged(() -> ((BPassword)password).getValue()).trim().length() != 0) break block10;
                    }
                    BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("AuthWizard.error.fieldRequired"));
                    return false;
                }
                AuthenticateUserMessage authUserMessage = new AuthenticateUserMessage(username, password, this.wizardModel.daemonSession.generateSharedSecretKey("commissioningWizard_authn"));
                XElem userAuthInfo = XParser.make((InputStream)this.wizardModel.daemonSession.getInputStream((DaemonMessage)authUserMessage, AuthenticateUserMessage.AUTH_USER_MESSAGE_TIMEOUT, "text/xml")).parse();
                if (userAuthInfo.elems("domain").length == 0) {
                    BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("AuthWizard.error.badCredentials"));
                    return false;
                }
                if (username.length() > 0 && ((BTextField)this.passwordFE.getContent()).getText().length() > 0) {
                    this.wizardModel.newCredentials = new BUsernameAndPassword(username, password);
                }
                this.wizardModel.authInfo = userAuthInfo;
                return true;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        @Override
        public boolean isSkipped() {
            return this.wizardModel.skipAuth;
        }

        @Override
        public int getMode() {
            int result = 1;
            if (this.userNameField.getText().length() > 0 && ((BTextField)this.passwordFE.getContent()).getText().length() > 0) {
                result |= 2;
            }
            return result;
        }
    }

    private static class FileDomainUserStep
    extends CommissioningWizardStep {
        private BTextField userNameField;
        private BPasswordFE passwordFE1;
        private BPasswordFE passwordFE2;
        private String authenticationScheme;

        public FileDomainUserStep(CommissioningWizardModel wizardModel, String authenticationScheme) throws Exception {
            super(wizardModel);
            BOsPart os = wizardModel.getPlatform().getOsPart();
            BGridPane grid = new BGridPane(2);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            grid.setStretchColumn(1);
            this.userNameField = new BTextField("", 20);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("AuthWizard.authFileDomainUserStep.user.label"), (BWidget)this.userNameField);
            this.passwordFE1 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("AuthWizard.authFileDomainUserStep.pw1.label"), (BWidget)this.passwordFE1);
            this.passwordFE2 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)this.getLexiconText("AuthWizard.authFileDomainUserStep.pw1.label"), (BWidget)this.passwordFE2);
            if (wizardModel.fileDomainAdminPassword != null) {
                this.passwordFE1.loadValue((BObject)wizardModel.fileDomainAdminPassword);
                this.passwordFE2.loadValue((BObject)wizardModel.fileDomainAdminPassword);
            }
            ((BTextField)this.passwordFE1.getContent()).setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE2.getContent()).setModel((TextModel)new ModeControlModel(this));
            boolean QNX = os.getPartName().toLowerCase().contains("qnx");
            if (QNX) {
                ((BTextField)this.passwordFE1.getContent()).setController((TextController)new FileDomainPasswordController());
                ((BTextField)this.passwordFE2.getContent()).setController((TextController)new FileDomainPasswordController());
            }
            this.userNameField.setModel((TextModel)new ModeControlModel(this));
            if (QNX) {
                this.userNameField.setController((TextController)new QnxUserNameController());
            }
            BLabel headerLabel = LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.authFileDomainUserStep.header"));
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)headerLabel, 4.0, 0.0, 8.0, 0.0), null, null, null, (BWidget)grid));
        }

        @Override
        public String getStepName() {
            return "authFileDomainUserStep";
        }

        @Override
        public String getSectionName() {
            return "auth";
        }

        @Override
        public void enter() {
            if (this.nextStep != null) {
                this.nextStep.priorStep = this;
            }
            this.userNameField.setText(this.wizardModel.fileDomainAdminUser);
            if (this.wizardModel.fileDomainAdminPassword != null) {
                this.passwordFE1.loadValue((BObject)this.wizardModel.fileDomainAdminPassword);
                this.passwordFE2.loadValue((BObject)this.wizardModel.fileDomainAdminPassword);
            }
        }

        @Override
        public boolean exit(int direction) {
            boolean back;
            boolean bl = back = direction == 1;
            if (back) {
                return true;
            }
            try {
                boolean passwordChanged;
                boolean userChanged;
                block19: {
                    BPassword pw1;
                    block18: {
                        BPassword pw2;
                        block17: {
                            block16: {
                                pw1 = (BPassword)this.passwordFE1.saveValue();
                                pw2 = (BPassword)this.passwordFE2.saveValue();
                                if (pw1 == null) break block16;
                                if (AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()).trim().length() == 0 || pw2 == null) break block16;
                                if (AccessController.doPrivileged(() -> ((BPassword)pw2).getValue()).trim().length() != 0) break block17;
                            }
                            BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("UserManager.error.passwordRequired"));
                            return false;
                        }
                        if (!SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)pw2).getValue()))) {
                            BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("AuthWizard.error.passwordMismatch"));
                            return false;
                        }
                        if (!BNativeUserTable.validatePassword((BWidget)this.wizardModel.getWizard(), pw1, FipsOptionsHelper.getInstance().getPasswordStrengthRequirements(this.wizardModel.isFips, this.wizardModel.daemonSession))) {
                            return false;
                        }
                        if (NativeAccount.isReservedName((String)this.userNameField.getText()) || this.userNameField.getText().contains("suNkiNg")) {
                            BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("AuthWizard.error.userReserved", new Object[]{this.userNameField.getText()}));
                            return false;
                        }
                        userChanged = false;
                        passwordChanged = false;
                        if (!this.wizardModel.fileDomainAdminUser.equals(this.userNameField.getText())) {
                            this.wizardModel.fileDomainAdminUser = this.userNameField.getText();
                            userChanged = true;
                        }
                        if (this.wizardModel.fileDomainAdminPassword == null) break block18;
                        if (SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)this.wizardModel.fileDomainAdminPassword).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()))) break block19;
                    }
                    this.wizardModel.fileDomainAdminPassword = pw1;
                    passwordChanged = true;
                }
                if (!(!this.wizardModel.defaultAccountPresent || userChanged && passwordChanged)) {
                    BDialog.error((BWidget)this.wizardModel.getWizard(), (Object)LEX.getText("AuthWizard.error.defaultCredentials"));
                    return false;
                }
                if (userChanged || passwordChanged) {
                    this.wizardModel.newCredentials = new BUsernameAndPassword(this.wizardModel.fileDomainAdminUser, this.wizardModel.fileDomainAdminPassword);
                    this.wizardModel.authMethodChanged = true;
                }
                return true;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        @Override
        public int getMode() {
            int mode = 1;
            if (this.userNameField.getText().trim().length() == 0 || ((BTextField)this.passwordFE1.getContent()).getText().trim().length() == 0 || ((BTextField)this.passwordFE2.getContent()).getText().trim().length() == 0) {
                return mode;
            }
            return mode | 2;
        }

        @Override
        public boolean isSkipped() {
            return this.wizardModel.skipAuth;
        }
    }

    private class NextStepCommand
    extends ToggleCommand {
        private CommissioningWizardStep fromStep;
        private CommissioningWizardStep toStep;

        public NextStepCommand(BWidget owner, CommissioningWizardStep pFromStep, CommissioningWizardStep pToStep, String lexTag, Object[] lexiconArguments) {
            super(owner, CommissioningWizardStep.LEX.getText(lexTag, lexiconArguments));
            this.fromStep = pFromStep;
            this.toStep = pToStep;
        }

        public CommandArtifact doInvoke() {
            if (this.isSelected()) {
                this.fromStep.nextStep = this.toStep;
                this.toStep.priorStep = this.fromStep;
            }
            return null;
        }
    }
}

