/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.appsurrogate;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.DependencyUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.file.BFileSpace;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BIcon;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

public class VerifyCommand
extends AsyncCommand {
    private FilePath stationDirPath = null;
    private BDaemonSession session = null;
    private DaemonSessionTaskListener taskListener;
    private static final BIcon iconRef = BIcon.std((String)"module.png");

    public VerifyCommand(BWidget owner, DaemonSessionTaskListener pTaskListener) {
        super(owner, BDaemonSessionView.TYPE.getModule(), "StationCopier.verify");
        this.taskListener = pTaskListener;
        this.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeAsync() {
        block35: {
            try {
                if (this.session == null) {
                    return;
                }
                try {
                    String title;
                    BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make((BDaemonSession)this.session, (DaemonSessionTaskListener)this.taskListener);
                    DependencyUtil.AnalysisResults analysisResults = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)platform, (BFileSpace)platform.getDaemonSession().getFileSpace(), (FilePath)this.stationDirPath, null, (DaemonSessionTaskListener)this.taskListener, null);
                    InstallScenario solution = analysisResults.getSolution();
                    BIndentPane pane = new BIndentPane();
                    boolean promptCommit = false;
                    boolean upToDate = false;
                    boolean promptCommission = false;
                    if (solution.canCommit()) {
                        if (solution.getToInstall().length > 0) {
                            if (this.session.usesLocalNiagaraHome() || this.session.getHostProperties().getIsSoftwareReadonly()) {
                                title = this.getLexicon().getText("StationCopier.verify.missing.title");
                                this.addStationOrPlatformMessage(pane, "StationCopier.verify.missing.top", "StationCopier.verifyPlatform.missing.top");
                            } else {
                                title = this.getLexicon().getText("StationCopier.verify.promptInstall.title");
                                this.addStationOrPlatformMessage(pane, "StationCopier.verify.promptInstall.message", "StationCopier.verifyPlatform.promptInstall.message");
                                promptCommit = true;
                            }
                        } else {
                            title = this.getLexicon().getText("StationCopier.verifyPlatform.success.title");
                            this.addStationOrPlatformMessage(pane, "StationCopier.verify.success.message", "StationCopier.verifyPlatform.success.message");
                            upToDate = true;
                        }
                    } else if (analysisResults.anyUnsolvable()) {
                        boolean canCommission;
                        title = this.getLexicon().getText("StationCopier.verify.mustCommission.title");
                        boolean bl = canCommission = this.session.getHostProperties().hasFullAccess() && this.session.getHostProperties().isNiagara4() && !this.session.getHostProperties().getNiagaraR2Enabled() && !this.session.usesLocalNiagaraHome() && CommissioningWizardModel.hostModelAllowsCommissioning(this.session);
                        if (!canCommission) {
                            pane.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.verify.mustCommission.message"));
                        } else {
                            pane.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.verify.mustCommission.prompt"));
                            promptCommission = true;
                        }
                    } else {
                        title = this.getLexicon().getText("StationCopier.verify.missing.title");
                        this.addStationOrPlatformMessage(pane, "StationCopier.verify.missing.top", "StationCopier.verifyPlatform.missing.top");
                    }
                    if (upToDate) {
                        BDialog.message((BWidget)this.getOwner(), (String)title, (Object)pane);
                        break block35;
                    }
                    if (promptCommission) {
                        if (4 != BDialog.confirm((BWidget)this.getOwner(), (String)title, (Object)pane, (int)12)) break block35;
                        try {
                            BDaemonSessionView.stopAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), this.session.getHost());
                            BWizard.open((BWidget)this.getOwner(), (WizardModel)new CommissioningWizardModel(this.getOwner(), this.session, true));
                            break block35;
                        }
                        finally {
                            BDaemonSessionView.startAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), this.session.getHost());
                        }
                    }
                    if (promptCommit) {
                        pane.indent();
                        boolean installingEarlyModuleVersion = false;
                        for (int i = 0; i < solution.getToInstall().length; ++i) {
                            BInstallable inst = solution.getToInstall()[i];
                            if (!installingEarlyModuleVersion) {
                                try {
                                    BInstallable latestModule = LocalInstallableRegistry.getInstance().findInstallable(BDependency.forModule((String)inst.getInstallableName()), null);
                                    if (latestModule.getVersion().getVendorVersion().compareTo(inst.getVersion().getVendorVersion()) > 0) {
                                        installingEarlyModuleVersion = true;
                                    }
                                }
                                catch (Exception latestModule) {
                                    // empty catch block
                                }
                            }
                            pane.add((BWidget)new BLabel(BImage.make((BIcon)inst.getIcon()), inst.toString()));
                        }
                        pane.unindent();
                        if (installingEarlyModuleVersion) {
                            pane.add((BWidget)new BBox(0.0, 5.0));
                            BLabel label = new BLabel(BImage.make((BIcon)BIcon.std((String)"warning.png")), this.getLexicon().getText("StationCopier.verifyPlatform.laterVersionAvail"));
                            label.setHalign(BHalign.left);
                            pane.add((BWidget)label);
                        }
                        if (4 == BDialog.confirm((BWidget)this.getOwner(), (String)title, (Object)this.makeScrollPane((BWidget)pane), (int)12)) {
                            solution.commit(this.taskListener, null);
                        }
                        break block35;
                    }
                    if (analysisResults.anyUnsolvable()) {
                        BDialog.warning((BWidget)this.getOwner(), (String)title, (Object)pane);
                    } else {
                        for (String partName : analysisResults.getPartNames()) {
                            if (analysisResults.isUnavailable(partName)) {
                                pane.add((BWidget)new BLabel(BImage.make((BIcon)iconRef), partName + "*"));
                                continue;
                            }
                            pane.add((BWidget)new BLabel(BImage.make((BIcon)iconRef), partName));
                        }
                        pane.unindent();
                        if (analysisResults.anyUnvailable()) {
                            pane.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.verify.missing.bottom"));
                        }
                        BDialog.warning((BWidget)this.getOwner(), (String)title, (Object)this.makeScrollPane((BWidget)pane));
                    }
                }
                catch (ICancelHint.CanceledException platform) {
                }
                catch (ActionInvokeException aie) {
                    if (!(aie.getCause() instanceof ICancelHint.CanceledException)) {
                        aie.printStackTrace();
                        throw aie;
                    }
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    public void setStationDirectory(FilePath value) {
        this.stationDirPath = value;
        this.setEnabled(value != null);
    }

    public void loadStation(BStationSurrogate value) {
        this.setStationDirectory(new FilePath("~stations/" + value.getStationName()));
    }

    public void setDaemonSession(BDaemonSession value) {
        this.session = value;
    }

    private Lexicon getLexicon() {
        return this.getOwner().getLexicon();
    }

    private void addStationOrPlatformMessage(BIndentPane pane, String stationLexKey, String platformLexKey) {
        if (this.stationDirPath == null) {
            pane.add(LexiconText.make((String)"platDaemon", (String)platformLexKey));
        } else {
            pane.add(LexiconText.make((String)"platDaemon", (String)stationLexKey), new Object[]{this.stationDirPath.getName()});
        }
    }

    private BWidget makeScrollPane(BWidget content) {
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane(content, 4.0, 4.0, 4.0, 4.0));
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane cpane = new BConstrainedPane((BWidget)scroll);
        cpane.setFixedSize(275.0, 260.0);
        return cpane;
    }
}

