/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.appsurrogate;

import com.tridium.platDaemon.ui.BOutputPane;
import com.tridium.platDaemon.ui.appsurrogate.BAppSurrogateView;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.ui.util.CommandUtil;
import javax.baja.platform.BStationStatus;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;

public class StartCommand
extends Command {
    private BOutputPane outputPane = null;
    private BAppSurrogate app = null;

    public StartCommand(BWidget owner, BOutputPane pOutputPane) {
        super(owner, BAppSurrogateView.myModule, "AppSurrogateView.command.startApp");
        this.outputPane = pOutputPane;
        this.setEnabled(false);
    }

    public void setApp(BAppSurrogate value) {
        this.app = value;
        if (this.app == null) {
            this.setEnabled(false);
        } else if (this.app.isRestartEnabled()) {
            this.setEnabled(this.app.getAppStatus() != BStationStatus.running && this.app.getAppStatus() != BStationStatus.starting && this.app.getAppStatus() != BStationStatus.stopping);
        } else {
            this.setEnabled(this.app.getAppStatus() != BStationStatus.running && this.app.getAppStatus() != BStationStatus.halted && this.app.getAppStatus() != BStationStatus.failed && this.app.getAppStatus() != BStationStatus.starting && this.app.getAppStatus() != BStationStatus.stopping);
        }
    }

    public CommandArtifact doInvoke() {
        BWidgetShell shell = this.getOwner().getShell();
        try {
            if (shell != null) {
                shell.enterBusy();
            }
            if (this.outputPane != null) {
                this.outputPane.stopUpdates();
                this.app.startAppAsync();
                this.outputPane.load();
            } else {
                this.app.startAppAsync();
            }
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
        return null;
    }
}

