/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platDaemon.ui.BDaemonSessionTaskDialog;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class DaemonSessionTaskHandler
implements DaemonSessionTaskListener {
    private BWidget owner;
    private long elapsed = 0L;
    private volatile DelayedDialogThread dlgThread = null;
    private final Array<DaemonSessionTask> taskList = new Array(DaemonSessionTask.class);
    private boolean cancelEnabled = true;
    public static final long TASK_START_DELAY = 750L;
    public static final Logger log = Logger.getLogger("platDaemon.task");
    public static final Lexicon lexicon = Lexicon.make((String)"platDaemon");
    private static final BImage clockIcon = BImage.make((String)"module://icons/x32/clock.png");

    public DaemonSessionTaskHandler(BWidget pOwner) {
        this.setOwner(pOwner);
    }

    public void taskStarted(DaemonSessionTask task) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("task started: " + task.getMessage() + " - " + this.getElapsed());
        }
        if (this.getOwner() == null || this.getOwner().widgetSupport(null) == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("task started - no window peer: " + task.getMessage());
            }
            return;
        }
        this.taskList.add((Object)task);
        this.showNextActiveTask(750L);
    }

    public void taskUpdated(DaemonSessionTask task) {
        if (this.dlgThread != null && task == this.dlgThread.getTask()) {
            this.dlgThread.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskFinished(DaemonSessionTask task) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("task finished: " + task.getMessage() + " - " + this.getElapsed());
        }
        if (this.dlgThread != null && task == this.dlgThread.getTask()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("interrupting dialog thread: " + task.getMessage() + " - " + this.getElapsed());
            }
            this.dlgThread.interrupt();
            this.dlgThread = null;
        }
        Array<DaemonSessionTask> array = this.taskList;
        synchronized (array) {
            int ix = this.taskList.lastIndexOf((Object)task);
            if (ix >= 0) {
                this.taskList.remove(ix);
            }
        }
        this.showNextActiveTask(0L);
    }

    public boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    public void setCancelEnabled(boolean value) {
        this.cancelEnabled = value;
    }

    public void setOwner(BWidget value) {
        this.owner = value;
        if (this.dlgThread != null) {
            this.dlgThread.setOwner(value);
        }
    }

    public BWidget getOwner() {
        return this.owner;
    }

    public void waitAllTasks() {
        while (this.taskList.size() > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllTasks() {
        if (this.isCancelEnabled()) {
            Array<DaemonSessionTask> array = this.taskList;
            synchronized (array) {
                for (int i = 0; i < this.taskList.size(); ++i) {
                    if (!(this.taskList.get(i) instanceof CancelableDaemonSessionTask)) continue;
                    CancelableDaemonSessionTask task = (CancelableDaemonSessionTask)this.taskList.get(i);
                    task.cancel();
                }
            }
        }
        this.waitAllTasks();
    }

    private String getElapsed() {
        long prior = this.elapsed;
        this.elapsed = Clock.ticks();
        return prior == 0L ? "" : this.elapsed - prior + " ms";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNextActiveTask(long delay) {
        if (this.dlgThread != null) {
            log.fine("showNextActiveTask - thread still active");
            return;
        }
        Array<DaemonSessionTask> array = this.taskList;
        synchronized (array) {
            DaemonSessionTask task;
            if (this.taskList.size() == 0) {
                log.fine("showNextActiveTask - no active tasks");
                return;
            }
            this.dlgThread = this.makeDelayedDialogThread(task, (task = (DaemonSessionTask)this.taskList.remove(0)).isImmediate() ? 0L : delay);
            this.dlgThread.start();
        }
    }

    private DelayedDialogThread makeDelayedDialogThread(DaemonSessionTask task, long delay) {
        return new DelayedDialogThread(task, delay, this.getOwner());
    }

    private static boolean hasAnyModalDialogOwners(BWidget owner) {
        while (owner != null) {
            if (owner instanceof BDialog && ((BDialog)owner).isModal()) {
                return true;
            }
            owner = owner.getParentWidget();
        }
        return false;
    }

    private class DelayedDialogThread
    extends Thread {
        private BDaemonSessionTaskDialog dialog;
        private Command cancelCommand;
        private final long delay;
        private final DaemonSessionTask task;
        private BWidget owner;
        private BProgressBar progressBar;
        private BLabel messageLabel;
        private volatile boolean closed;
        private static final int MAX_CLOSE_WAIT_COUNT = 100;

        public DelayedDialogThread(DaemonSessionTask task, BWidget owner) {
            this(task, 1000L, owner);
        }

        public DelayedDialogThread(DaemonSessionTask pTask, long pDelay, BWidget pOwner) {
            super("Ui:DelayedDialogThread");
            this.dialog = null;
            this.cancelCommand = null;
            this.progressBar = null;
            this.messageLabel = null;
            this.closed = false;
            this.delay = pDelay;
            this.task = pTask;
            this.owner = pOwner;
        }

        public DaemonSessionTask getTask() {
            return this.task;
        }

        public BWidget getOwner() {
            return this.owner;
        }

        public void setOwner(BWidget value) {
            this.owner = value;
        }

        public void refresh() {
            if (this.dialog != null && this.messageLabel != null) {
                this.messageLabel.setText(this.task.getMessage());
                this.messageLabel.computePreferredSize();
                if (this.messageLabel.getPreferredWidth() > this.dialog.getWidth() || this.messageLabel.getPreferredHeight() > this.dialog.getHeight()) {
                    this.dialog.setBoundsCenteredOnOwner();
                }
            }
            if (this.progressBar != null) {
                this.progressBar.setValue((double)this.task.getProgress());
            }
            if (this.cancelCommand != null && this.task instanceof CancelableDaemonSessionTask) {
                this.cancelCommand.setEnabled(((CancelableDaemonSessionTask)this.task).isCancelEnabled());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DelayedDialogThread.sleep(this.delay);
            }
            catch (InterruptedException ie) {
                log.fine("DelayedDialogThread.run interrupted before dialog raised");
                return;
            }
            try {
                this.messageLabel = new BLabel(this.task.getMessage(), BHalign.left);
                BEdgePane content = new BEdgePane((BWidget)new BBorderPane((BWidget)this.messageLabel, 10.0, 10.0, 10.0, 10.0), null, null, null, null);
                this.messageLabel.setImage(clockIcon);
                if (this.task.getTotal() > 0) {
                    this.progressBar = new BProgressBar(0.0, (double)this.task.getTotal());
                    content.setCenter((BWidget)new BBorderPane((BWidget)this.progressBar, 0.0, 10.0, 10.0, 10.0));
                    this.progressBar.setValue((double)this.task.getProgress());
                } else {
                    this.progressBar = new BProgressBar();
                    this.progressBar.setIndeterminate(true);
                    content.setCenter((BWidget)new BBorderPane((BWidget)this.progressBar, 0.0, 10.0, 10.0, 10.0));
                }
                if (DaemonSessionTaskHandler.this.isCancelEnabled() && this.task instanceof CancelableDaemonSessionTask && ((CancelableDaemonSessionTask)this.task).isCancelEnabled()) {
                    BFlowPane buttonPane = new BFlowPane(BHalign.center);
                    this.cancelCommand = new TaskCancelCommand(this.getOwner(), (CancelableDaemonSessionTask)this.task);
                    BButton cancelButton = new BButton(this.cancelCommand);
                    cancelButton.setPadding(BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)4.0));
                    buttonPane.add(null, (BValue)cancelButton);
                    content.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 0.0, 10.0, 4.0, 10.0));
                }
                DelayedDialogThread delayedDialogThread = this;
                synchronized (delayedDialogThread) {
                    block17: {
                        if (!this.closed) break block17;
                        return;
                    }
                    this.dialog = new BDaemonSessionTaskDialog(this.owner, this.task.getTitle(), DaemonSessionTaskHandler.hasAnyModalDialogOwners(this.owner), (BWidget)content);
                }
                this.dialog.setBoundsCenteredOnOwner();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("task dialog: " + this.task.getMessage());
                }
                this.dialog.open();
                while (this.dialog != null && this.dialog.isShowing() && this.ownerActive()) {
                    DelayedDialogThread.sleep(1000L);
                }
            }
            catch (InterruptedException ie) {
                log.fine("DelayedDialogThread.run interrupted after dialog raised");
            }
            finally {
                this.closeDialog();
            }
        }

        private boolean ownerActive() {
            for (BWidget c = this.getOwner(); c != null; c = c.getParent()) {
                if (!(c instanceof BDialog)) continue;
                return ((BDialog)c).isShowing();
            }
            return this.getOwner().getShell() != null;
        }

        @Override
        public void interrupt() {
            this.closeDialog();
            log.fine("DelayedDialogThread interrupt called");
            super.interrupt();
        }

        private synchronized void closeDialog() {
            if (this.dialog != null) {
                for (int i = 0; i < 100 && !this.dialog.canClose(); ++i) {
                    log.finest("Task dialog not ready to be closed, waiting 100ms");
                    try {
                        DelayedDialogThread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        log.fine("DelayedDialogThread.closeDialog interrupted while waiting for dialog to finish opening");
                    }
                }
                if (!this.dialog.canClose()) {
                    log.warning("DelayedDialogthread.closeDialog timed out waiting for dialog to be closable. Attempting to close anyway.");
                }
                try {
                    this.dialog.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.dialog = null;
                }
            }
            this.closed = true;
        }
    }

    private static class TaskCancelCommand
    extends Command {
        private final CancelableDaemonSessionTask task;

        public TaskCancelCommand(BWidget owner, CancelableDaemonSessionTask task) {
            super(owner, task.getCancelLabel(UiLexicon.bajaui().getText("dialog.cancel")), null, null, null);
            this.task = task;
        }

        public CommandArtifact doInvoke() {
            this.task.cancel();
            return null;
        }
    }
}

