/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platDaemon.BDaemonSurrogate;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.ui.util.BInputStreamPane;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BOutputPane
extends BInputStreamPane {
    @Generated
    public static final Type TYPE = Sys.loadType(BOutputPane.class);
    private BAppSurrogate app = null;
    private BDaemonSurrogate daemon = null;
    private boolean updatesOnly = false;
    private volatile boolean paused = false;
    private final Object PAUSE_STATE_MONITOR = new Object();
    private FilePath capturePath = null;
    private volatile Writer captureWriter = null;
    private static final Logger log = Logger.getLogger("platDaemon");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOutputPane() {
    }

    public BOutputPane(int rows, int cols) {
        super(rows, cols);
    }

    public BOutputPane(int rows, int cols, boolean updatesOnly) {
        super(rows, cols);
        this.updatesOnly = updatesOnly;
    }

    protected InputStream getInputStream() {
        try {
            if (this.daemon == null) {
                return null;
            }
            if (this.app == null) {
                return this.daemon.getDaemonOutput(true, this.updatesOnly);
            }
            return this.app.getAppOutput(true, this.updatesOnly);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void loadDaemon() {
        BAppSurrogate oldApp = this.app;
        this.app = null;
        if (oldApp != null || this.watcher == null) {
            this.load();
        }
    }

    public void loadApp(BAppSurrogate value) {
        BAppSurrogate oldApp = this.app;
        this.app = value;
        if (oldApp != this.app) {
            this.setOutputBufferSize(this.app.getLogBufferSize());
            this.load();
        }
    }

    public void setSession(BDaemonSession session) {
        this.daemon = new BDaemonSurrogate(session);
    }

    public void setCapturePath(FilePath value) {
        this.capturePath = value;
    }

    protected synchronized void startUpdates(BInputStreamPane.OutputWatcher value) {
        if (this.capturePath != null) {
            try {
                this.captureWriter = new BufferedWriter(new OutputStreamWriter(BFileSystem.INSTANCE.makeFile(this.capturePath).getOutputStream()), 8192);
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Failed to create output pane capture writer (" + this.capturePath + "), can not stream output", ioe);
            }
        }
        this.paused = false;
        super.startUpdates(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String text) {
        if (this.captureWriter == null) {
            super.append(text);
        } else {
            Object object = this.PAUSE_STATE_MONITOR;
            synchronized (object) {
                if (!this.paused) {
                    super.append(text);
                }
                if (this.captureWriter != null) {
                    try {
                        this.captureWriter.write(text);
                        this.captureWriter.flush();
                    }
                    catch (IOException ioe) {
                        log.log(Level.WARNING, "Failed to write to output pane capture writer (" + this.capturePath + ")", ioe);
                        try {
                            this.captureWriter.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.captureWriter = null;
                    }
                }
            }
        }
    }

    public synchronized void stopUpdates() {
        super.stopUpdates();
        if (this.captureWriter != null) {
            try {
                this.captureWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.captureWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.captureWriter = null;
        }
        try {
            Thread.sleep(BAppSurrogate.getStreamTimeoutMillis() + 100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.paused = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseUpdates() {
        if (this.captureWriter == null) {
            this.stopUpdates();
            return;
        }
        Object object = this.PAUSE_STATE_MONITOR;
        synchronized (object) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeUpdates() {
        if (this.captureWriter == null) {
            this.load();
            return;
        }
        Object object = this.PAUSE_STATE_MONITOR;
        synchronized (object) {
            try (RandomAccessFile streamFile = new RandomAccessFile(new File(this.capturePath.getBody()), "r");){
                int read;
                long filePosition = Math.max(streamFile.length() - this.getOutputBufferSize(), 0L);
                log.log(Level.FINEST, "Capture log file size = " + streamFile.length() + " bytes, seeking to file position " + filePosition + " (output buffer size = " + this.getOutputBufferSize() + " bytes)");
                streamFile.seek(filePosition);
                this.clearText();
                byte[] buf = new byte[8192];
                int appendCount = 0;
                while ((read = streamFile.read(buf)) != -1) {
                    appendCount += read;
                    super.append(new String(buf, 0, read, StandardCharsets.UTF_8));
                }
                log.log(Level.FINEST, "Appended " + appendCount + " characters on OutputPane resume");
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Failed to read capture path '" + this.capturePath + "' on resume, some output that occurred while paused may be missing from the output pane", ioe);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Failed to refresh output text on resume, some output that occurred while paused may be missing from the output pane", e);
            }
            this.paused = false;
        }
    }

    public void clearValue() {
        this.app = null;
        super.clearValue();
    }

    public void clearText() throws Exception {
        if (this.daemon == null) {
            this.setText("");
        } else {
            super.clearText();
        }
    }
}

