/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platDaemon.ui.BOutputPane;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DumpThreadsMessage;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.ConnectException;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

@NiagaraType
public class BOutputDialog
extends BFrame {
    @Generated
    public static final Type TYPE = Sys.loadType(BOutputDialog.class);
    private final BOutputPane outputPane;
    private final ToggleCommand pauseOutputCommand;
    private static final Lexicon lex = TYPE.getModule().getLexicon();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOutputDialog() {
        throw new UnsupportedOperationException();
    }

    public BOutputDialog(BWidget owner, BDaemonSession session, BAppSurrogate app) throws ConnectException, AuthenticationException {
        this(owner, session, app, null);
    }

    public BOutputDialog(BWidget owner, BDaemonSession session, BAppSurrogate app, FilePath captureTo) throws ConnectException, AuthenticationException {
        super(lex.getText("OutputDialog.appTitle", new Object[]{app.toString(null), session.getRemoteAddressString()}));
        this.outputPane = new BOutputPane();
        this.setIconImage(BImage.make((String)lex.getText("OutputDialog.icon")));
        BButtonPane buttonPane = new BButtonPane();
        if (app instanceof BStationSurrogate) {
            buttonPane.add((Command)new DumpThreadsCommand((BStationSurrogate)app));
        }
        BToggleButton pauseButton = new BToggleButton();
        buttonPane.add((BWidget)pauseButton);
        this.pauseOutputCommand = new PauseOutputCommand((BAbstractButton)pauseButton);
        pauseButton.setCommand((Command)this.pauseOutputCommand, true, false);
        buttonPane.add((Command)new ClearOutputCommand());
        buttonPane.add((Command)new CloseCommand());
        BOutputPane center = null;
        if (captureTo == null) {
            center = this.outputPane;
        } else {
            BFlowPane flow = new BFlowPane(BHalign.left);
            flow.add("capture", (BValue)new BLabel(this.getLexicon().getText("OutputDialog.capture", new Object[]{captureTo.getBody()})));
            center = new BEdgePane((BWidget)new BBorderPane((BWidget)flow, 0.0, 0.0, 5.0, 0.0), null, null, null, (BWidget)this.outputPane);
            this.outputPane.setCapturePath(captureTo);
        }
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)buttonPane, 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)center, 10.0, 10.0, 10.0, 10.0)));
        this.loadBounds();
        this.outputPane.setSession(session);
        this.outputPane.loadApp(app);
    }

    public BOutputDialog(BWidget owner, BDaemonSession session) throws ConnectException, AuthenticationException {
        super(lex.getText("OutputDialog.daemonTitle", new Object[]{session.getRemoteAddressString()}));
        this.outputPane = new BOutputPane();
        this.setIconImage(BImage.make((String)lex.getText("OutputDialog.icon")));
        BButtonPane buttonPane = new BButtonPane();
        BToggleButton pauseButton = new BToggleButton();
        buttonPane.add((BWidget)pauseButton);
        this.pauseOutputCommand = new PauseOutputCommand((BAbstractButton)pauseButton);
        pauseButton.setCommand((Command)this.pauseOutputCommand, true, false);
        buttonPane.add((Command)new ClearOutputCommand());
        buttonPane.add((Command)new CloseCommand());
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)buttonPane, 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)this.outputPane, 10.0, 10.0, 10.0, 10.0)));
        this.loadBounds();
        this.outputPane.setSession(session);
        this.outputPane.loadDaemon();
    }

    private void loadBounds() {
        try {
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BComponent bounds = (BComponent)options.get("bounds");
            if (bounds == null) {
                Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
                this.setPreferredSize((int)(0.9 * ss.getWidth()), (int)(0.9 * ss.getHeight()));
                this.setBoundsCenteredOnScreen();
            } else {
                this.setScreenBounds(bounds.getInt(bounds.getProperty("x")), bounds.getInt(bounds.getProperty("y")), bounds.getInt(bounds.getProperty("width")), bounds.getInt(bounds.getProperty("height")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBoundsCenteredOnScreen() {
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBoundsCenteredOn(new RectGeom(0.0, 0.0, (double)sd.width, (double)sd.height));
    }

    public void setBoundsCenteredOn(RectGeom screenRect) {
        this.computePreferredSize();
        double w = this.getPreferredWidth() + 8.0;
        double h = this.getPreferredHeight() + 27.0;
        double x = screenRect.x + (screenRect.width - w) / 2.0;
        double y = screenRect.y + (screenRect.height - h) / 2.0;
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        double sw = ss.width;
        double sh = ss.height;
        if (x + w > sw) {
            x = sw - w;
        }
        if (y + h > sh) {
            y = sh - h;
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        this.setScreenBounds(x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.outputPane.stop();
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BFolder bounds = new BFolder();
            IRectGeom screenBounds = this.getScreenBounds();
            bounds.add("x", (BValue)BInteger.make((int)((int)screenBounds.x())));
            bounds.add("y", (BValue)BInteger.make((int)((int)screenBounds.y())));
            bounds.add("width", (BValue)BInteger.make((int)((int)screenBounds.width())));
            bounds.add("height", (BValue)BInteger.make((int)((int)screenBounds.height())));
            if (options.get("bounds") == null) {
                options.add("bounds", (BValue)bounds);
            } else {
                options.set("bounds", (BValue)bounds);
            }
            options.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            super.close();
        }
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    private class DumpThreadsCommand
    extends Command {
        BStationSurrogate station;
        BDaemonSession session;

        public DumpThreadsCommand(BStationSurrogate pStation) {
            super((BWidget)BOutputDialog.this, TYPE.getModule(), "StationSurrogateView.command.dumpThread");
            this.station = pStation;
            this.session = null;
        }

        public DumpThreadsCommand(BDaemonSession pSession) {
            super((BWidget)BOutputDialog.this, TYPE.getModule(), "StationSurrogateView.command.dumpThread");
            this.session = pSession;
            this.station = null;
        }

        public CommandArtifact doInvoke() {
            try {
                if (this.station != null) {
                    this.station.dumpThreads();
                } else if (this.session != null) {
                    this.session.sendMessage((DaemonMessage)DumpThreadsMessage.getInstance());
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class ClearOutputCommand
    extends Command {
        public ClearOutputCommand() {
            super((BWidget)BOutputDialog.this, TYPE.getModule(), "AppSurrogateView.command.clearOutput");
        }

        public CommandArtifact doInvoke() throws Exception {
            BOutputDialog.this.outputPane.clearText();
            return null;
        }
    }

    private class PauseOutputCommand
    extends ToggleCommand {
        public PauseOutputCommand(BAbstractButton owner) {
            super((BWidget)owner, TYPE.getModule(), "AppSurrogateView.command.pauseOutput");
        }

        public String getLabel() {
            if (this.isSelected()) {
                return BOutputDialog.this.getLexicon().getText("AppSurrogateView.command.loadOutput.label");
            }
            return BOutputDialog.this.getLexicon().getText("AppSurrogateView.command.pauseOutput.label");
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                BAbstractButton button = (BAbstractButton)this.getOwner();
                button.setText(this.getLabel());
                if (this.isSelected()) {
                    BOutputDialog.this.outputPane.pauseUpdates();
                } else {
                    BOutputDialog.this.outputPane.resumeUpdates();
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand() {
            super((BWidget)BOutputDialog.this, TYPE.getModule(), "OutputDialog.command.close");
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                BOutputDialog.this.outputPane.deactivated();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            finally {
                BOutputDialog.this.close();
            }
            return null;
        }
    }
}

