/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.commissioning;

import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.commissioning.PlatformCommissioner;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.PlatformInstallOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.platform.InstallOperation;
import javax.baja.security.BPassword;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.Version;

public class CommissioningInstallOperation
extends PlatformInstallOperation {
    private static Logger log = Logger.getLogger("platformDaemon.CommissioningInstallOperation");
    private BDaemonSession daemonSession;
    private BRemoteDaemonPlatform remotePlatform;
    Set<RuntimeProfile> enabledRuntimeProfiles = null;
    private Map<String, Version> installModuleVersions = new HashMap<String, Version>();
    private List<BDistribution> installDists = new ArrayList<BDistribution>();
    final Set<String> uninstallModuleNames = new HashSet<String>();
    boolean ignoreTcpIpChanges = true;
    boolean ignoreAuthChanges = true;
    PlatformCommissioner platformCommissioner = null;

    public CommissioningInstallOperation() {
    }

    private CommissioningInstallOperation(BRemoteDaemonPlatform remotePlatform, BDaemonSession daemonSession) {
        log.log(Level.FINE, "CommissioningInstallOperation:: Entering Constructor");
        log.log(Level.FINE, "CommissioningInstallOperation:: Getting PlatformCommissioner");
        this.platformCommissioner = PlatformCommissioner.make(remotePlatform, daemonSession);
        this.setDaemonSession(daemonSession);
        this.setRemotePlatform(remotePlatform);
        log.log(Level.FINE, "CommissioningInstallOperation:: Exiting Constructor");
    }

    public static InstallOperation make(BRemoteDaemonPlatform remotePlatform, BDaemonSession daemonSession) {
        log.log(Level.FINE, "CommissioningInstallOperation:: Entering make");
        return new CommissioningInstallOperation(remotePlatform, daemonSession);
    }

    public void setIgnoreTcpIpChanges(boolean value) {
        this.ignoreTcpIpChanges = value;
    }

    public void setIgnoreAuthChanges(boolean value) {
        this.ignoreAuthChanges = value;
    }

    public void installModule(String moduleName, Version version) {
        Objects.requireNonNull(moduleName);
        if (version == null) {
            this.installModuleVersions.put(moduleName, Version.NULL);
        } else {
            this.installModuleVersions.put(moduleName, version);
        }
        this.platformCommissioner.installModule(moduleName, version);
    }

    public void installDistribution(BIFile distFile) throws Exception {
        Objects.requireNonNull(distFile);
        if (!"dist".equals(distFile.getExtension())) {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.notDistFile", new Object[]{distFile.getFilePath().getBody()});
        }
        BDistribution dist = new BDistribution(distFile);
        this.installDists.add(dist);
        this.platformCommissioner.installDistribution(dist);
    }

    public void installDistribution(String distName, Version version) {
        Objects.requireNonNull(distName);
        if (version == null) {
            version = Version.NULL;
        }
        try {
            BInstallable dist = LocalInstallableRegistry.getInstance().findInstallable(distName, version, BDistribution.TYPE, null);
            if (dist == null) {
                throw new LocalizableRuntimeException("platform", "PlatformInstallManager.softwareNotFound", new Object[]{distName, version});
            }
            this.installDists.add((BDistribution)dist);
            this.platformCommissioner.installDistribution((BDistribution)dist);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void uninstallModule(String moduleName) {
        Objects.requireNonNull(moduleName);
        this.uninstallModuleNames.add(moduleName);
        this.platformCommissioner.uninstallModule(moduleName);
    }

    public void updateEnabledRuntimeProfiles(Set<RuntimeProfile> enabledRuntimeProfiles) {
        if (enabledRuntimeProfiles == null) {
            this.enabledRuntimeProfiles = null;
        } else {
            this.enabledRuntimeProfiles = new HashSet<RuntimeProfile>(enabledRuntimeProfiles);
            if (this.enabledRuntimeProfiles.contains(RuntimeProfile.ux) != this.enabledRuntimeProfiles.contains(RuntimeProfile.wb)) {
                this.enabledRuntimeProfiles.add(RuntimeProfile.ux);
                this.enabledRuntimeProfiles.add(RuntimeProfile.wb);
            }
        }
        this.platformCommissioner.updateEnabledRuntimeProfiles(this.enabledRuntimeProfiles);
    }

    public void setDaemonSession(BDaemonSession daemonSession) {
        this.daemonSession = daemonSession;
        this.platformCommissioner.setDaemonSession(daemonSession);
    }

    public BRemoteDaemonPlatform getRemotePlatform() {
        return this.remotePlatform;
    }

    public void setRemotePlatform(BRemoteDaemonPlatform remotePlatform) {
        this.remotePlatform = remotePlatform;
        this.platformCommissioner.setRemotePlatform(remotePlatform);
    }

    public void run() {
        log.log(Level.FINE, "Entering executeScenario");
        this.platformCommissioner.run();
    }

    public BIFile getFileForDistribution(String filePath) {
        return this.platformCommissioner.getFileForDistribution(filePath);
    }

    public void addDistFile(BIFile distFile) throws Exception {
        this.platformCommissioner.addDistFile(distFile);
    }

    public void addStationToCopy(BDirectory localSourceDirectory, String targetName, boolean startStation, boolean autoStartStation, Supplier<char[]> passPhraseSupplier) {
        this.platformCommissioner.addStationToCopy(localSourceDirectory, targetName, startStation, autoStartStation, passPhraseSupplier);
    }

    public void addStationToCopy(String targetName, boolean startStation, boolean autoStartStation, Supplier<char[]> passPhraseSupplier) {
        this.platformCommissioner.addStationToCopy(targetName, startStation, autoStartStation, passPhraseSupplier);
    }

    public void addAdminUser(String userName, String password, String oldPassword, String userComment) {
        this.platformCommissioner.addAdminUser(userName, password, oldPassword, userComment);
    }

    public void setSystemPassphrase(BPassword oldSystemPassphrase, BPassword systemPassphrase) {
        this.platformCommissioner.setSystemPassphrase(oldSystemPassphrase, systemPassphrase);
    }

    public void setSystemUser(String systemUser) {
        this.platformCommissioner.setSystemUser(systemUser);
    }

    public void setLogLevel(Level logLevel) {
        log.setLevel(logLevel);
        if (this.platformCommissioner != null) {
            this.platformCommissioner.setLogLevel(logLevel);
        }
    }

    public void setStationDir(BDirectory stationDir) {
        this.platformCommissioner.setStationDir(stationDir);
    }

    public void setUpdateAllOutOfDate(boolean updateAllOutofDate) {
        this.platformCommissioner.setUpdateAllOutOfDate(updateAllOutofDate);
    }

    public void setLaxCertificateValidation(boolean laxCertificateValidation) {
        this.platformCommissioner.setLaxCertificateValidation(laxCertificateValidation);
    }
}

