/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.tag;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.file.types.bog.BBogSpace;
import com.tridium.sys.tag.ComponentTags;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.template.TemplateConst;
import com.tridium.template.ui.BTemplateIOEditor;
import com.tridium.util.CompUtil;
import java.util.HashMap;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMarker;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.tag.Tag;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.util.Lexicon;

public interface TagSupport {
    public static final Lexicon lex = Lexicon.make((String)"template");

    public static void updateTagDictionaryTable(BTable tagTable, BTagDictionary dictn, boolean markersOnly, String filter) {
        BTemplateIOEditor.TagTableModel model = (BTemplateIOEditor.TagTableModel)tagTable.getModel();
        model.removeAll();
        if (dictn == null) {
            return;
        }
        for (TagInfo tagInfo : dictn.getTagDefinitions()) {
            if (markersOnly && !(tagInfo.getDefaultValue() instanceof BMarker)) continue;
            Tag tag = new Tag(tagInfo.getTagId(), tagInfo.getDefaultValue());
            if (filter == null || filter.length() == 0) {
                model.add(tag);
                continue;
            }
            if (tagInfo.getTagId().getName().equalsIgnoreCase(filter)) {
                model.add(tag);
                break;
            }
            if (!tagInfo.getTagId().getName().toLowerCase().startsWith(filter.toLowerCase())) continue;
            model.add(tag);
        }
    }

    public static BWidget makeTagDictionarySelPane(BListDropDown dictnCombo, BTextField tagEntry, Lexicon lex) {
        BBorderPane dictnPane = new BBorderPane((BWidget)new BNullWidget(), BInsets.make((double)1.0, (double)0.0, (double)1.0, (double)1.0));
        BGridPane dictnSelPane = new BGridPane();
        dictnSelPane.setHalign(BHalign.left);
        dictnSelPane.add("label?", (BValue)new BLabel(lex.getText("tag.dictionary.select")));
        dictnSelPane.add("tagDictnSelect", (BValue)dictnCombo);
        dictnSelPane.setColumnCount(4);
        dictnSelPane.setRowGap(6.0);
        dictnSelPane.add(null, (BValue)new BLabel(BImage.make((String)"module://icons/x16/filter.png"), ""));
        dictnSelPane.add(null, (BValue)tagEntry);
        dictnPane.setContent((BWidget)dictnSelPane);
        return dictnPane;
    }

    public static BListDropDown makeDictionarySelect(HashMap<String, Object> map) {
        BListDropDown dictnSel = new BListDropDown();
        BList list = dictnSel.getList();
        HashMap<String, Object> nsMap = new HashMap<String, Object>();
        TypeInfo[] types = Sys.getRegistry().getTypes(BTagDictionary.TYPE.getTypeInfo());
        for (int i = 0; i < types.length; ++i) {
            BModule module = Sys.loadModule((String)types[i].getModuleName());
            BINavNode node = module.getNavChild("module.palette");
            BINavNode[] entries = node.getNavChildren();
            for (int e = 0; e < entries.length; ++e) {
                BTagDictionary tagDictionary;
                BINavNode thisEntry = entries[e];
                if (thisEntry instanceof BTagDictionaryService && (thisEntry = thisEntry.getNavChild("Niagara")) instanceof BNiagaraTagDictionary && !(tagDictionary = (BNiagaraTagDictionary)thisEntry).getTagDefinitions().iterator().hasNext()) {
                    tagDictionary.importFromBog(BNiagaraTagDictionary.importContext);
                    tagDictionary.loadSlots();
                }
                if (thisEntry == null || !(thisEntry instanceof BTagDictionary) || !(tagDictionary = (BTagDictionary)thisEntry).getTagDefinitions().iterator().hasNext()) continue;
                String nameKey = tagDictionary.getDisplayName(null);
                String nameSpace = tagDictionary.getNamespace();
                if (nsMap.containsKey(nameSpace) || map.containsKey(nameKey)) continue;
                nsMap.put(nameSpace, thisEntry);
                map.put(nameKey, thisEntry);
                list.addItem((Object)nameKey);
            }
        }
        BDirectory tdDirectory = TagSupport.getTagDictionaryDirectory();
        for (BIFile file : tdDirectory.listFiles()) {
            BBogFile bFile;
            BBogSpace bogSpace;
            BComponent rootComponent;
            if (!"bog".equals(file.getExtension()) || !((rootComponent = (bogSpace = (BBogSpace)(bFile = (BBogFile)file).open()).getRootComponent().getChildComponents()[0]) instanceof BTagDictionary)) continue;
            BTagDictionary td = (BTagDictionary)rootComponent;
            String nameKey = td.getDisplayName(null);
            String nameSpace = td.getNamespace();
            if (nsMap.containsKey(nameSpace) || map.containsKey(nameKey)) continue;
            nsMap.put(nameSpace, td);
            map.put(nameKey, td);
            list.addItem((Object)nameKey);
        }
        if (list.getItemCount() > 0) {
            list.setSelectedIndex(0);
        }
        return dictnSel;
    }

    public static BDirectory getTagDictionaryDirectory() {
        try {
            return (BDirectory)TagSupport.getTagDictionaryDirectoryOrd().resolve().get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BOrd getTagDictionaryDirectoryOrd() throws Exception {
        BOrd tdOrd = BOrd.make((String)"local:|file:~tagDictionaries");
        try {
            tdOrd.resolve();
        }
        catch (UnresolvedException e) {
            BDirectory fDir = BFileSystem.INSTANCE.getUserHome();
            fDir.getFileSpace().makeDir(fDir.getFilePath().merge("tagDictionaries"));
        }
        return tdOrd;
    }

    public static String isNeqlPredicateValid(String predicate, String name) {
        if (predicate.isEmpty()) {
            return lex.getText("query.empty", new Object[]{name});
        }
        String neql = "neql:" + predicate;
        BOrd newOrdValue = BOrd.make((String)neql);
        try {
            OrdQuery[] queryList;
            for (OrdQuery query : queryList = newOrdValue.parse()) {
                String scheme = query.getScheme();
                if (scheme == "neql") continue;
                return lex.getText("query.invalidScheme", new Object[]{name, scheme});
            }
        }
        catch (NullOrdException e) {
            return lex.getText("query.empty", new Object[]{name});
        }
        catch (SyntaxException e) {
            return lex.getText("query.syntax.error", new Object[]{name, predicate, e.getCause().getLocalizedMessage()});
        }
        return "";
    }

    public static boolean hasTemplateAncestor(BComplex parent) {
        while (parent != null && parent.isComponent()) {
            if (parent.asComponent().tags().contains(TemplateConst.TEMPLATE_ROOT_TAG_ID)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isSubtemplate(BComplex parent) {
        int count = 0;
        while (parent != null && parent.isComponent()) {
            if (parent.asComponent().tags().contains(TemplateConst.TEMPLATE_ROOT_TAG_ID) && ++count > 1) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static void convertMultiTags(BComponent root) {
        TagSupport.convertComponentMultiTags(root);
        for (BComponent comp : (BComponent[])CompUtil.getDescendants((BComponent)root, BComponent.class)) {
            TagSupport.convertComponentMultiTags(comp);
        }
    }

    public static void convertComponentMultiTags(BComponent comp) {
        ComponentTags tags = new ComponentTags(comp);
        for (Tag tag : tags) {
            if (!tags.isMulti(tag.getId())) continue;
            tags.removeAll(tag.getId());
            tags.set(tag);
        }
    }
}

