/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.sidebar;

import com.tridium.template.ui.BTemplateView;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.workbench.transfer.TransferUtil;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Optional;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.view.BWbView;

@NiagaraType
public class BTemplateSideBarNavTree
extends BNavTree {
    @Generated
    public static final Type TYPE = Sys.loadType(BTemplateSideBarNavTree.class);
    private static final Lexicon lex = Lexicon.make((String)"template");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public CommandArtifact doDelete() throws Exception {
        BObject[] selection = this.getSelectedObjects();
        if (selection.length == 0) {
            return null;
        }
        for (BObject object : selection) {
            BWbDeployableNtplFile file;
            if (!(object instanceof BWbDeployableNtplFile) || !(file = (BWbDeployableNtplFile)object).isOpen()) continue;
            file.close();
        }
        Mark mark = new Mark(selection);
        try {
            return TransferUtil.delete((BWidget)this, (Mark)mark);
        }
        catch (IOException e) {
            BDialog.error((BWidget)this.getShell(), (String)lex.getText("commands.delete.error.dialog.title"), (Object)lex.getText("commands.delete.error.dialog.message"), (String)e.getLocalizedMessage());
            return null;
        }
    }

    public void mouseDragStarted(BMouseEvent event) {
        for (BObject selected : this.getSelectedObjects()) {
            if (!(selected instanceof BWbDeployableNtplFile)) continue;
            BWbDeployableNtplFile file = (BWbDeployableNtplFile)selected;
            BWidgetShell shell = this.getShell();
            Optional<BWidget> templateViewWidget = this.findTemplateView((BWidget)shell);
            if (!templateViewWidget.isPresent()) {
                super.mouseDragStarted(event);
                return;
            }
            BTemplateView templateView = (BTemplateView)templateViewWidget.get();
            if (!file.getTitle().equals(templateView.getManifest().title)) continue;
            BDialog.warning((BWidget)this.getShell(), (String)lex.getText("templateSideBar.dragTemplateError.title"), (Object)lex.getText("templateSideBar.dragTemplateError.message", new Object[]{file.getTitle()}));
            return;
        }
        super.mouseDragStarted(event);
    }

    private Optional<BWidget> findTemplateView(BWidget root) {
        ArrayDeque<BWidget> q = new ArrayDeque<BWidget>();
        q.add(root);
        while (!q.isEmpty()) {
            BWidget node = (BWidget)q.remove();
            if (node.getType().is(BTemplateView.TYPE)) {
                return Optional.of(node);
            }
            for (BWidget child : node.getChildWidgets()) {
                Type childType = child.getType();
                if (!childType.is(BPane.TYPE) && !childType.is(BWbView.TYPE) && !childType.is(BTransferWidget.TYPE)) continue;
                q.add(child);
            }
        }
        return Optional.empty();
    }
}

