/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.template.BTemplateService;
import javax.baja.file.FilePath;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.SyntaxException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

public final class TemplateUiUtil {
    public static boolean isSuperUser(BComponent target) {
        BISession session = target.getSession();
        BUser user = null;
        if (session instanceof BFoxSession) {
            BFoxSession foxSession = (BFoxSession)session;
            try {
                String userName = foxSession.getUsername();
                BUserService userService = (BUserService)BOrd.make((String)"service:baja:UserService").get((BObject)target);
                userService.lease();
                user = userService.getUser(userName);
                user.lease();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return user != null && user.getPermissions().isSuperUser();
    }

    public static BTemplateService resolveTemplateService(BStation station) {
        try {
            return (BTemplateService)BOrd.make((String)"service:template:TemplateService").get((BObject)station);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isValidTemplateName(String name) {
        name = name.trim();
        try {
            int len = name.length();
            if (len == 0) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char c = name.charAt(i);
                if (!(i == 0 ? !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') : !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-'))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidTemplateFolder(String folder) {
        if ((folder = folder.trim()).isEmpty()) {
            return true;
        }
        if (folder.charAt(0) == '.') {
            return false;
        }
        try {
            FilePath folderPath = new FilePath(folder);
            return folderPath.isRelative() || folderPath.isUserHomeAbsolute() || folderPath.isLocalAbsolute();
        }
        catch (SyntaxException ignore) {
            return false;
        }
    }

    public static boolean isValidTemplateNameEntry(String nameEntry) {
        return TemplateUiUtil.isValidTemplateName(TemplateUiUtil.templateNameFromNameEntry(nameEntry)) && TemplateUiUtil.isValidTemplateFolder(TemplateUiUtil.templateFolderFromNameEntry(nameEntry));
    }

    public static boolean isValidTemplatePath(String folderEntry, String nameEntry) {
        return TemplateUiUtil.isValidTemplateNameEntry(nameEntry) && TemplateUiUtil.isValidTemplateFolder(folderEntry);
    }

    public static String templateNameFromNameEntry(String nameEntry) {
        nameEntry = nameEntry.trim();
        return nameEntry.substring(nameEntry.lastIndexOf(47) + 1);
    }

    public static String templateFolderFromNameEntry(String nameEntry) {
        int length = (nameEntry = nameEntry.trim()).lastIndexOf(47);
        if (length > 0) {
            return nameEntry.substring(0, length);
        }
        return "";
    }

    public static String templateFolderFromEntries(String folderEntry, String nameEntry) {
        return TemplateUiUtil.templateFolderFromNameEntry(TemplateUiUtil.templateRelativePathFromEntries(folderEntry, nameEntry));
    }

    public static String templateRelativePathFromEntries(String folderEntry, String nameEntry) {
        nameEntry = nameEntry.trim();
        if ((folderEntry = folderEntry.trim()).isEmpty()) {
            return nameEntry;
        }
        if (!folderEntry.endsWith("/")) {
            folderEntry = folderEntry + '/';
        }
        return folderEntry + nameEntry;
    }

    private TemplateUiUtil() {
    }
}

