/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.px.editor.BPxEditorOptions;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.util.EventUtil;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.BTemplateService;
import com.tridium.template.application.ApplicationTemplateUtil;
import com.tridium.template.file.EmbeddedPxScanner;
import com.tridium.template.file.EmbeddedPxSource;
import com.tridium.template.file.PxFileRef;
import com.tridium.template.ui.ApplicationNavTreeModel;
import com.tridium.template.ui.BTemplateNewPxViewDialog;
import com.tridium.template.ui.BTemplateView;
import com.tridium.ui.Binder;
import com.tridium.util.CompUtil;
import com.tridium.workbench.ord.RefFilter;
import com.tridium.workbench.propsheet.BPropertySheet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.agent.BPxView;
import javax.baja.file.types.image.BImageFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.event.PxComponentEvent;
import javax.baja.px.editor.event.PxEvent;
import javax.baja.px.editor.event.PxLayerEvent;
import javax.baja.px.editor.event.PxListener;
import javax.baja.px.editor.event.PxPropertyEvent;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditorBinding;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;

@NiagaraType
public class BTemplatePxEditor
extends BEdgePane
implements PxListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BTemplatePxEditor.class);
    public static final RefFilter compFilter = new RefFilter(){

        public boolean accept(BObject parent, Slot slot) {
            if (slot == null || parent == null || !slot.isProperty()) {
                return false;
            }
            Type slotType = parent.asComplex().get(slot.asProperty()).getType();
            if (!slotType.is(BComponent.TYPE) || slotType.is(BTemplateConfig.TYPE) || slotType.is(BStatusValue.TYPE) || slotType.is(BPxView.TYPE)) {
                return false;
            }
            int slotFlags = parent.asComplex().getFlags(slot);
            return (slotFlags & 3) == 0;
        }
    };
    private static final Lexicon lex = Lexicon.make((String)"template");
    private static final BModule module = Sys.getModuleForClass(BTemplatePxEditor.class);
    final List<PxFileRef> pxRefs;
    final Array<BImageFile> pxImages;
    ArrayList<SlotPath> pxEditTargets;
    private final List<PxFileRef> unusedPxRefs = new ArrayList<PxFileRef>();
    private final List<BImageFile> unusedImages = new ArrayList<BImageFile>();
    private BSplitPane split;
    private BEdgePane rightPane = new BEdgePane();
    private BEdgePane pxEditPane = new BEdgePane();
    private Binder binder;
    private BComponent rootPxComp;
    private final PxFileComboSubscriber pxFileComboSubscriber = new PxFileComboSubscriber();
    private final BComponent tmplRoot;
    private BNavTree tree;
    private BListDropDown pxFileSelCombo;
    private BToggleButton grid;
    private BToggleButton snap;
    private BToggleButton showHatch;
    private BButton clearUnusedFilesBtn;
    private BToolBar toolBar;
    final BTemplateView view;
    private final BWidget owner;
    private BPxEditorOptions editorOptions;
    private BPxEditorPane editorPane;
    private BGridPane pxControlPane;
    private BPxEditor currentPxEditor;
    private final EditorPxSource pxSource = new EditorPxSource();
    private static final Pattern pxOrdPrefixPattern = Pattern.compile("^.+:\\^?((px/deploy/.+/)|(px/))?");
    private static final Pattern pxImagePrefixPattern = Pattern.compile("^.+:\\^?(.*/)*");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTemplatePxEditor() {
        this.view = null;
        this.owner = null;
        this.tmplRoot = null;
        this.pxRefs = new ArrayList<PxFileRef>();
        this.pxImages = new Array(BImageFile.class);
    }

    public PxFileRef[] getPxRefs() {
        return this.pxRefs.toArray(new PxFileRef[0]);
    }

    public BPxEditor getCurrentPxEditor() {
        return this.currentPxEditor;
    }

    public BTemplatePxEditor(BTemplateView view, BComponent root, PxFileRef[] pxRefs, BImageFile[] pxImages) {
        this.view = view;
        this.owner = view.getShell();
        this.tmplRoot = root;
        this.pxRefs = new Array((Object[])(pxRefs != null ? pxRefs : new PxFileRef[]{})).list();
        this.pxImages = new Array((Object[])(pxImages != null ? pxImages : new BImageFile[]{}));
        ApplicationNavTreeModel model = view.isApplicationTemplate() ? new ApplicationNavTreeModel((BINavNode)this.tmplRoot, ApplicationTemplateUtil.describeDefaultStation(null), view.getManifest()) : new DefaultNavTreeModel((BINavNode)this.tmplRoot);
        this.tree = new BNavTree((NavTreeModel)model);
        this.tree.setController((TreeController)new Controller());
        this.tree.setSelection(new TreeSelection());
        this.tree.setMultipleSelection(true);
        model.setRootVisible(true);
        this.tree.setExpanded(model.getRoot(0), true);
        model.updateTree();
        this.split = new BSplitPane();
        this.split.setDividerPosition(20.0);
        this.split.setWidget1(this.buildLeftPane());
        this.split.setWidget2(this.buildRightPane());
        this.setCenter((BWidget)this.split);
    }

    public void started() {
        this.updatePxSelCombo();
    }

    private BWidget buildLeftPane() {
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)new BTreePane((BTree)this.tree), BBorder.none, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return pane;
    }

    public BWidget buildRightPane() {
        this.rightPane = new BEdgePane();
        this.rightPane.setTop(this.makePxFileSelPane());
        this.noFileDisplay();
        return this.rightPane;
    }

    private void noFileDisplay() {
        BLabel noGraphicsSelected = new BLabel(lex.getText("template.pxEditor.noFileSelected"));
        BFont font = BFont.DEFAULT;
        noGraphicsSelected.setFont(BFont.make((BFont)font, (double)(font.getSize() * 2.0)));
        this.rightPane.setCenter((BWidget)new BBorderPane((BWidget)noGraphicsSelected, 2.0, 2.0, 2.0, 2.0));
    }

    public BWidget makePxFileSelPane() {
        BBorderPane pxSelPane = new BBorderPane((BWidget)new BNullWidget(), BInsets.make((double)10.0, (double)0.0, (double)1.0, (double)10.0));
        this.pxControlPane = new BGridPane();
        this.pxFileSelCombo = new BListDropDown();
        this.pxFileSelCombo.getList().setRenderer((ListRenderer)new BPxListRenderer());
        this.pxControlPane.setHalign(BHalign.left);
        this.pxControlPane.add("label?", (BValue)new BLabel(lex.getText(lex.getText("template.pxPane.pxFileSelect"))));
        this.pxControlPane.add("pxFileSelect", (BValue)this.pxFileSelCombo);
        this.clearUnusedFilesBtn = new BButton((Command)new PxClear((BWidget)this));
        this.clearUnusedFilesBtn.setText("");
        this.unusedPxRefs.clear();
        this.unusedImages.clear();
        BTemplatePxEditor.findUnusedPxRefsAndImages(this.pxSource, this.tmplRoot, this.pxRefs, this.pxImages, this.unusedPxRefs, this.unusedImages);
        this.clearUnusedFilesBtn.setEnabled(!this.unusedPxRefs.isEmpty() || !this.unusedImages.isEmpty());
        this.pxControlPane.setHalign(BHalign.center);
        this.pxControlPane.add("clearUnusedFiles", (BValue)this.clearUnusedFilesBtn);
        this.pxControlPane.setColumnCount(30);
        this.pxControlPane.setRowGap(6.0);
        this.pxFileComboSubscriber.subscribe((BComponent)this.pxFileSelCombo);
        this.pxFileComboSubscriber.subscribe((BComponent)this.clearUnusedFilesBtn);
        this.setSubscribers();
        pxSelPane.setContent((BWidget)this.pxControlPane);
        return pxSelPane;
    }

    private void addToolBar(BPxEditor pxEditor) {
        if (this.grid == null) {
            this.grid = new BToggleButton(BImage.make((BIcon)BIcon.std((String)"grid.png")), "", false);
            this.grid.setButtonStyle(BButtonStyle.toolBar);
            this.pxControlPane.add("cb?", (BValue)this.grid);
        }
        if (this.snap == null) {
            this.snap = new BToggleButton(BImage.make((BIcon)BIcon.std((String)"snap.png")), "", false);
            this.snap.setButtonStyle(BButtonStyle.toolBar);
            this.pxControlPane.add("cb?", (BValue)this.snap);
        }
        if (this.showHatch == null) {
            this.showHatch = new BToggleButton(BImage.make((BIcon)BIcon.std((String)"hash.png")), "", false);
            this.showHatch.setButtonStyle(BButtonStyle.toolBar);
            this.pxControlPane.add("cb?", (BValue)this.showHatch);
        }
        this.toolBar = pxEditor.getViewToolBar();
        try {
            this.toolBar.remove("ToggleButton");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.pxControlPane.get("tb") != null) {
            this.pxControlPane.remove("tb");
        }
        this.pxControlPane.add("tb?", (BValue)this.toolBar);
        this.setSubscribers();
    }

    private void setSubscribers() {
        if (this.grid != null) {
            this.pxFileComboSubscriber.subscribe((BComponent)this.grid);
        }
        if (this.snap != null) {
            this.pxFileComboSubscriber.subscribe((BComponent)this.snap);
        }
        if (this.showHatch != null) {
            this.pxFileComboSubscriber.subscribe((BComponent)this.showHatch);
        }
    }

    void updatePxSelCombo() {
        BList list = this.pxFileSelCombo.getList();
        list.removeAllItems();
        for (PxFileRef pxRef : this.pxRefs) {
            list.addItem((Object)pxRef);
        }
        if (list.getItemCount() > 0) {
            if (list.getSelectedIndex() < 0) {
                this.pxFileSelCombo.setSelectedIndex(0);
            }
        } else {
            this.noFileDisplay();
        }
    }

    public void selectPxSelCombo(PxFileRef file) {
        this.pxFileSelCombo.getList().setSelectedItem((Object)file);
    }

    public void updateRightPane(PxFileRef pxFileRef) {
        this.save();
        BPxFile currentEditFile = pxFileRef.getPxFile();
        this.currentPxEditor = new BPxEditor();
        pxFileRef.setPxEditor((Object)this.currentPxEditor);
        this.rightPane.setCenter((BWidget)new BBorderPane((BWidget)this.currentPxEditor, 2.0, 2.0, 2.0, 2.0));
        this.initBinder(this.currentPxEditor);
        this.currentPxEditor.loadValue((BObject)currentEditFile, Context.NULL);
        this.editorPane = (BPxEditorPane)this.currentPxEditor.getContent();
        this.editorOptions = this.editorPane.getOptions();
        this.addToolBar(this.currentPxEditor);
        this.pxControlPane.relayout();
        if (this.grid != null) {
            this.grid.setSelected(this.editorOptions.getShowGrid());
        }
        if (this.snap != null) {
            this.snap.setSelected(this.editorOptions.getUseSnap());
        }
        if (this.showHatch != null) {
            this.showHatch.setSelected(this.editorOptions.getShowHatch());
        }
        this.currentPxEditor.addPxListener((PxListener)this);
        this.view.linkTo((BComponent)this.currentPxEditor, (Slot)BPropertySheet.pluginModified, (Slot)BTemplateView.templateModified);
    }

    private void selectTreeNode() {
        this.selectTreeNode((PxFileRef)this.pxFileSelCombo.getSelectedItem());
    }

    private void selectTreeNode(PxFileRef pxFileRef) {
        if (pxFileRef == null) {
            return;
        }
        TreeModel model = this.tree.getModel();
        String[] rootNames = this.tmplRoot.getSlotPath().getNames();
        BPxView[] pxViews = (BPxView[])CompUtil.getDescendants((BComponent)this.tmplRoot, BPxView.class);
        TreeSelection selection = this.tree.getSelection();
        selection.deselectAll();
        this.rootPxComp = null;
        for (BPxView pxView : pxViews) {
            String ord = pxView.getPxFile().encodeToString();
            ord = ord.substring(ord.indexOf("px/") + 3);
            String pxOrd = pxFileRef.getPxOrd().encodeToString();
            if (ord.equals(pxOrd = pxOrd.substring(pxOrd.indexOf("px/") + 3))) {
                NavTreeNode temp;
                String[] names = pxView.getParent().asComponent().getSlotPath().getNames();
                NavTreeNode node = (NavTreeNode)model.getRoot(0);
                for (int j = rootNames.length; j < names.length && (temp = node.getChild(names[j], true)) != null; ++j) {
                    node = temp;
                }
                TreeNode[] path = node.getPathFromRoot();
                this.tree.scrollPathToVisible(path);
                TreeNode n = path[path.length - 1];
                selection.select(n);
                if (this.rootPxComp == null) {
                    this.rootPxComp = ((NavTreeNode)n).getNavNode().asObject().asComponent();
                }
            } else {
                model.getRoot(0).setExpanded(true);
            }
            model.updateTree();
        }
        if (this.rootPxComp != null) {
            this.startBinder(this.rootPxComp);
        }
    }

    private static BPxView getPxView(BComponent comp, String pxName) {
        BPxView[] pxViews;
        for (BPxView pxView : pxViews = (BPxView[])comp.getChildren(BPxView.class)) {
            if (!BTemplatePxEditor.getFilename(pxView).equals(pxName)) continue;
            return pxView;
        }
        return null;
    }

    private static String getFilename(BPxView view) {
        BOrd ord = view.getPxFile();
        String[] names = TextUtil.splitAndTrim((String)ord.toString(), (char)'/');
        String fileName = names[names.length - 1];
        return TextUtil.splitAndTrim((String)fileName, (char)'.')[0];
    }

    private PxFileRef getPxFileRef(String fileName) {
        for (PxFileRef pxRef : this.pxRefs) {
            if (!pxRef.getPxName().equals(fileName)) continue;
            return pxRef;
        }
        return null;
    }

    private void initBinder(BPxEditor pxEditor) {
        this.binder = (Binder)pxEditor.fw(302);
        if (this.binder == null) {
            this.binder = (Binder)pxEditor.fw(403);
        }
    }

    private void startBinder(BComponent rootPxComp) {
        this.editorPane.setPxRootComponent(rootPxComp);
        OrdTarget otgt = rootPxComp.getNavOrd().resolve();
        if (otgt != null) {
            this.binder.start(otgt, null);
        }
    }

    public void save() {
        for (PxFileRef pxRef : this.pxRefs) {
            BPxEditor pxEditor = (BPxEditor)pxRef.getPxEditor();
            if (pxEditor == null) continue;
            try {
                pxEditor.saveValue((BObject)pxRef.getPxFile(), null);
            }
            catch (Exception e) {
                BTemplateService.logger.log(Level.SEVERE, "Unable to save PxRefs: " + e.getLocalizedMessage(), e);
            }
        }
        this.pxEditTargets = this.findEditBindings();
    }

    private ArrayList<SlotPath> findEditBindings() {
        BPxView[] pxViews;
        ArrayList<SlotPath> wrBindingList = new ArrayList<SlotPath>();
        for (BPxView pxView : pxViews = (BPxView[])CompUtil.getDescendants((BComponent)this.tmplRoot, BPxView.class)) {
            BComplex pxViewRoot = pxView.getParent();
            String[] filePathNames = pxView.getPxFile().toString().split("/");
            String pxName = filePathNames[filePathNames.length - 1];
            for (PxFileRef thisRef : this.pxRefs) {
                BPxEditor pxEditor;
                if (!pxName.startsWith(thisRef.getPxName()) || (pxEditor = (BPxEditor)thisRef.getPxEditor()) == null) continue;
                SlotPath pxRootSlotPath = pxViewRoot.asComponent().getSlotPath();
                Map<BOrd, List<BComponent>> bindings = BTemplatePxEditor.findEditBindings(pxEditor);
                for (BOrd bOrd : bindings.keySet()) {
                    SlotPath slotPath;
                    String s = bOrd.toString();
                    String[] body = s.split("slot:");
                    if (!s.startsWith("slot:") || wrBindingList.contains(slotPath = body.length == 1 ? pxRootSlotPath : pxRootSlotPath.merge(new SlotPath(body[1])))) continue;
                    wrBindingList.add(slotPath);
                }
            }
        }
        return wrBindingList;
    }

    private static Map<BOrd, List<BComponent>> findEditBindings(BPxEditor pxEditor) {
        TreeMap<BOrd, List<BComponent>> map = new TreeMap<BOrd, List<BComponent>>();
        BTemplatePxEditor.findEditBindings((BComponent)pxEditor.getWidget(), map);
        return map;
    }

    private static void findEditBindings(BComponent component, Map<BOrd, List<BComponent>> map) {
        BComponent[] kids;
        if (component instanceof BWbFieldEditorBinding || component instanceof BPxInclude) {
            SlotCursor c = component.getProperties();
            while (c.next(BOrd.class)) {
                BOrd ord = (BOrd)c.get();
                if (ord.equals((Object)BOrd.NULL)) continue;
                List<BComponent> comps = map.get(ord);
                if (comps == null) {
                    comps = new ArrayList<BComponent>();
                    map.put(ord, comps);
                }
                comps.add(component);
            }
        }
        if (component instanceof BPxInclude) {
            return;
        }
        for (BComponent kid : kids = component.getChildComponents()) {
            BTemplatePxEditor.findEditBindings(kid, map);
        }
    }

    public void pxEvent(PxEvent event) {
        block0 : switch (event.getEventType()) {
            case 1: {
                switch (((PxPropertyEvent)event).getEventId()) {
                    case 1: 
                    case 2: {
                        this.relativizeOrds();
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (((PxLayerEvent)event).getEventId()) {
                    case 1: 
                    case 2: {
                        this.relativizeOrds();
                        break block0;
                    }
                }
                break;
            }
            case 5: 
            case 6: {
                this.relativizeOrds();
                break;
            }
            case 3: 
            case 4: {
                switch (EventUtil.getEventType((PxComponentEvent)((PxComponentEvent)event))) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        this.relativizeOrds();
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void relativizeOrds() {
        if (this.editorPane != null) {
            this.editorPane.relativizeOrds();
        }
    }

    public CommandArtifact doSyncTree() {
        this.selectTreeNode();
        return null;
    }

    public CommandArtifact doNewView(BComponent c) {
        try {
            BTemplateNewPxViewDialog.invoke(this.owner, this, c);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.selectTreeNode((PxFileRef)this.pxFileSelCombo.getSelectedItem());
        return null;
    }

    public CommandArtifact toPxEditor(BComponent comp, String name) {
        String pxName = name + ".px";
        PxFileRef fileRef = this.getPxFileRef(pxName);
        this.selectPxSelCombo(fileRef);
        this.rootPxComp = comp;
        this.updateRightPane(fileRef);
        this.startBinder(this.rootPxComp);
        return null;
    }

    public CommandArtifact doRemove(BComponent comp, String pxName) {
        int confirm = BDialog.confirm((BWidget)this, (Object)("Remove '" + pxName + "' view from " + comp.getName() + ". Are you sure?"));
        if (confirm == 2 || confirm == 8) {
            return null;
        }
        BPxView pxView = BTemplatePxEditor.getPxView(comp, pxName);
        if (pxView == null) {
            return null;
        }
        comp.remove((BComplex)pxView);
        return this.doClearUnusedFiles(false);
    }

    public CommandArtifact doClearUnusedFiles(boolean informIfNone) {
        if (this.clearUnusedFiles(informIfNone)) {
            this.updatePxSelCombo();
            this.selectTreeNode();
            this.view.templateModified();
        }
        return null;
    }

    private boolean clearUnusedFiles(boolean informIfNone) {
        if (!this.unusedPxRefs.isEmpty() || !this.unusedImages.isEmpty()) {
            String unusedFilesMessage = BTemplatePxEditor.getUnusedFilesMessage(this.unusedPxRefs, this.unusedImages);
            int confirm = BDialog.confirm((BWidget)this, (Object)(lex.getText("templatePxEditor.permissionToClear") + '\n' + unusedFilesMessage.toString()));
            if (confirm != 4) {
                return false;
            }
            for (PxFileRef pxRef : this.unusedPxRefs) {
                BTemplateService.logger.log(Level.INFO, "Removing unused PX file from template: " + BTemplatePxEditor.getPxName(pxRef.getPxOrd()));
                this.pxRefs.remove(pxRef);
            }
            for (BImageFile image : this.unusedImages) {
                BTemplateService.logger.log(Level.INFO, "Removing unused image file from template: " + image.getFileName());
                this.pxImages.remove((Object)image);
            }
            return true;
        }
        if (informIfNone) {
            BDialog.message((BWidget)this, (Object)lex.getText("templatePxEditor.informNoFilesToClear"));
        }
        return false;
    }

    private static String getUnusedFilesMessage(List<PxFileRef> unusedPxRefs, List<BImageFile> unusedImages) {
        StringBuilder unusedFiles = new StringBuilder();
        int itemCount = 0;
        for (PxFileRef unusedFile : unusedPxRefs) {
            if (itemCount >= 10) break;
            unusedFiles.append("  - ").append(unusedFile.getPxName()).append('\n');
            ++itemCount;
        }
        for (BImageFile image : unusedImages) {
            if (itemCount >= 10) break;
            ++itemCount;
            unusedFiles.append("  - ").append(image.getFileName()).append('\n');
        }
        int leftItemCount = unusedPxRefs.size() + unusedImages.size() - 10;
        if (itemCount >= 10 && leftItemCount > 0) {
            unusedFiles.append("     ").append(lex.getText("templatePxEditor.itemsLeftCount", new Object[]{leftItemCount}));
        }
        return unusedFiles.toString();
    }

    private static void findUnusedPxRefsAndImages(EmbeddedPxSource pxSource, BComponent root, List<PxFileRef> pxRefs, Array<BImageFile> pxImages, List<PxFileRef> unusedPxRefs, List<BImageFile> unusedImages) {
        Iterator iterator;
        boolean found;
        ArrayList pxOrds = new ArrayList();
        ArrayList imageOrds = new ArrayList();
        EmbeddedPxScanner.findPxAndImageOrds((EmbeddedPxSource)pxSource, (BComponent)root, pxOrds, imageOrds);
        for (PxFileRef pxfRef : pxRefs) {
            String pxOrd;
            String filePxName = BTemplatePxEditor.getPxName(pxfRef.getPxOrd());
            if (filePxName.isEmpty()) continue;
            found = false;
            iterator = pxOrds.iterator();
            while (iterator.hasNext() && !(found = filePxName.equals(BTemplatePxEditor.getPxName(pxOrd = (String)iterator.next())))) {
            }
            if (found) continue;
            unusedPxRefs.add(pxfRef);
        }
        for (BImageFile image : pxImages) {
            String imageOrd;
            String otherName;
            String imageName = image.getFileName();
            found = false;
            iterator = imageOrds.iterator();
            while (iterator.hasNext() && !(found = imageName.equals(otherName = BTemplatePxEditor.getImageName(imageOrd = (String)iterator.next())))) {
            }
            if (found) continue;
            unusedImages.add(image);
        }
    }

    private static String getPxName(BOrd pxOrd) {
        return BTemplatePxEditor.getPxName(pxOrd.toString(null));
    }

    private static String getPxName(String pxOrd) {
        return BTemplatePxEditor.stripPrefix(pxOrdPrefixPattern, pxOrd);
    }

    private static String getImageName(String imageOrd) {
        return BTemplatePxEditor.stripPrefix(pxImagePrefixPattern, imageOrd);
    }

    private static String stripPrefix(Pattern prefixPattern, String input) {
        Matcher pxOrdPrefixMatcher = prefixPattern.matcher(input);
        if (pxOrdPrefixMatcher.find()) {
            return input.substring(pxOrdPrefixMatcher.end());
        }
        return "";
    }

    private class EditorPxSource
    implements EmbeddedPxSource {
        private EditorPxSource() {
        }

        public BPxFile getPxFile(BOrd ord) {
            String searchName = BTemplatePxEditor.getPxName(ord);
            if (!searchName.isEmpty()) {
                for (PxFileRef pxRef : BTemplatePxEditor.this.pxRefs) {
                    if (!searchName.equals(BTemplatePxEditor.getPxName(pxRef.getPxOrd()))) continue;
                    return pxRef.getPxFile();
                }
            }
            return null;
        }
    }

    private static class BPxListRenderer
    extends ListRenderer {
        private BPxListRenderer() {
        }

        public String getItemText(ListRenderer.Item item) {
            PxFileRef fileRef = (PxFileRef)item.value;
            String displayName = fileRef.getPxOrd().encodeToString();
            return displayName.substring(displayName.indexOf("px/") + 3);
        }
    }

    class PxFileComboSubscriber
    extends WidgetSubscriber {
        PxFileComboSubscriber() {
        }

        public void actionPerformed(BWidgetEvent e) {
            BWidget widget = e.getWidget();
            if (widget.equals((Object)BTemplatePxEditor.this.snap)) {
                BTemplatePxEditor.this.editorOptions.setUseSnap(BTemplatePxEditor.this.snap.isSelected());
            } else if (widget.equals((Object)BTemplatePxEditor.this.showHatch)) {
                BTemplatePxEditor.this.editorOptions.setShowHatch(BTemplatePxEditor.this.showHatch.isSelected());
            } else if (widget.equals((Object)BTemplatePxEditor.this.grid)) {
                BTemplatePxEditor.this.editorOptions.setShowGrid(BTemplatePxEditor.this.grid.isSelected());
            }
            BTemplatePxEditor.this.editorPane.forceRootLayout();
        }

        public void modified(BWidgetEvent e) {
            BWidget widget = e.getWidget();
            if (widget.equals((Object)BTemplatePxEditor.this.pxFileSelCombo)) {
                PxFileRef pxRef = (PxFileRef)BTemplatePxEditor.this.pxFileSelCombo.getSelectedItem();
                BTemplatePxEditor.this.updateRightPane(pxRef);
                BTemplatePxEditor.this.selectTreeNode(pxRef);
            }
        }
    }

    class PxClear
    extends Command {
        PxClear(BWidget owner) {
            super(owner, lex, "templatePxEditor.clearUnusedFiles");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTemplatePxEditor.this.doClearUnusedFiles(true);
        }
    }

    class PxRemove
    extends Command {
        String pxName;
        BComponent comp;

        PxRemove(BComponent comp, String pxName) {
            super(BTemplatePxEditor.this.owner, "Remove " + pxName);
            this.comp = comp;
            this.pxName = pxName;
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTemplatePxEditor.this.doRemove(this.comp, this.pxName);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"delete.png"));
        }
    }

    class PxEditor
    extends Command {
        String pxName;
        BComponent comp;

        PxEditor(BComponent comp, String pxName) {
            super(BTemplatePxEditor.this.owner, "Edit " + pxName);
            this.pxName = pxName;
            this.comp = comp;
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTemplatePxEditor.this.toPxEditor(this.comp, this.pxName);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"edit.png"));
        }
    }

    class PxNewView
    extends Command {
        BComponent comp;

        PxNewView(BComponent comp) {
            super(BTemplatePxEditor.this.owner, "NewView");
            this.comp = comp;
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTemplatePxEditor.this.doNewView(this.comp);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.make((String)"module://icons/x16/views/newView.png"));
        }
    }

    class PxSyncTree
    extends Command {
        PxSyncTree() {
            super(BTemplatePxEditor.this.owner, "SyncTree");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTemplatePxEditor.this.doSyncTree();
        }

        public BImage getIcon() {
            return BImage.make((String)"module://icons/x16/sync.png");
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        public BObject[] getSelectedObjects() {
            TreeNode[] nodes = this.getSelection().getNodes();
            BObject[] objs = new BObject[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                objs[i] = ((NavTreeNode)nodes[i]).getNavNode().asObject();
            }
            return objs;
        }

        private String[] getPxFileNames(BComponent comp) {
            BPxView[] pxViews = (BPxView[])comp.getChildren(BPxView.class);
            String[] fileNames = new String[pxViews.length];
            for (int i = 0; i < pxViews.length; ++i) {
                fileNames[i] = BTemplatePxEditor.getFilename(pxViews[i]);
            }
            return fileNames;
        }

        protected void popup(BMouseEvent event, TreeNode node) {
            BMenu menu;
            if (node == null) {
                menu = new BMenu();
                menu.add("st", (Command)new PxSyncTree());
            } else {
                BINavNode navNode = ((NavTreeNode)node).getNavNode();
                BComponent target = navNode.asObject().asComponent();
                String[] pxFileNames = this.getPxFileNames(navNode.asObject().asComponent());
                menu = new BMenu();
                menu.add("nv?", (Command)new PxNewView(target));
                for (String pxFileName : pxFileNames) {
                    menu.add("ed?", (Command)new PxEditor(target, pxFileName));
                    menu.add("del?", (Command)new PxRemove(target, pxFileName));
                }
            }
            menu.removeConsecutiveSeparators();
            menu.open(event);
        }
    }
}

