/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.data.BDataRow;
import com.tridium.file.types.bog.BBogSpace;
import com.tridium.install.BVersion;
import com.tridium.sys.transfer.DeployToComp;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.template.BPasswordBinding;
import com.tridium.template.BRelationInfo;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.BTemplateInfo;
import com.tridium.template.BTemplateService;
import com.tridium.template.TemplateConst;
import com.tridium.template.UpgradeUtil;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.TemplateManager;
import com.tridium.template.job.BUpgradeTemplateJob;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.template.ui.BTemplateConfigFE;
import com.tridium.template.ui.BulkDeploy;
import com.tridium.template.ui.UpdateConfigs;
import com.tridium.template.ui.UpdateUtil;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.template.ui.file.TmplUtil;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.Theme;
import com.tridium.util.CompUtil;
import com.tridium.util.LinkUtil;
import com.tridium.workbench.job.BJobBar;
import com.tridium.workbench.util.WbViewEventWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataTable;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.search.BSearchService;
import javax.baja.security.BPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIService;
import javax.baja.sys.BLink;
import javax.baja.sys.BMarker;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.Tags;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.BServiceContainer;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"template:TemplateService"}, requiredPermissions="r")})
@NiagaraAction(name="updateCommands", flags=4)
public class BTemplateManager
extends BWbComponentView
implements TemplateConst {
    @Generated
    public static final Action updateCommands = BTemplateManager.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTemplateManager.class);
    private static final String[] INPUT_SLOTS = new String[]{"in2", "in3", "in4", "in5", "in6", "in7", "in9", "in10", "in11", "in12", "in13", "in14", "in15", "in16", "fallback"};
    private static final BImage DEFAULT_IMAGE = BImage.make((String)"module://icons/x16/files/ntpl.png");
    private static final Lexicon lex = Lexicon.make((String)"template");
    public static final Logger log = Logger.getLogger("template.manager");
    private static String NTPL_FILE_TAG_NAME = SlotPath.escape((String)TEMPLATE_FILE_TAG_ID.getQName());
    private static String ROOT_TAG_NAME = SlotPath.escape((String)TEMPLATE_ROOT_TAG_ID.getQName());
    private static String VENDOR_TAG_NAME = SlotPath.escape((String)TEMPLATE_VENDOR_TAG_ID.getQName());
    private static String VERSION_TAG_NAME = SlotPath.escape((String)TEMPLATE_VERSION_TAG_ID.getQName());
    private static String INFO_TAG_NAME = SlotPath.escape((String)TEMPLATE_DESCRIPTION_TAG_ID.getQName());
    private static String UP_TO_DATE = "Up to Date";
    private static String OUT_OF_DATE = "Out of Date";
    private static String OLDER_VERSION_AVAILABLE = "Older version available";
    private static String NOT_AVAILABLE = "not available";
    private static String UNKNOWN = "Unknown";
    private static String UPGRADE = "Upgrade";
    private static String DOWNGRADE = "Downgrade";
    private static String REDEPLOY = "Redeploy";
    private static String UPDATED = "Updated";
    private static String[] VERSION_STATUS = new String[]{UP_TO_DATE, OUT_OF_DATE, OLDER_VERSION_AVAILABLE, NOT_AVAILABLE, UNKNOWN, UPGRADE, DOWNGRADE, REDEPLOY, UPDATED};
    private static int UP_TO_DATE_SEL = BTemplateInfo.UP_TO_DATE_SEL;
    private static int OUT_OF_DATE_SEL = BTemplateInfo.OUT_OF_DATE_SEL;
    private static int OLDER_VERSION_AVAILABLE_SEL = BTemplateInfo.OLDER_VERSION_AVAILABLE_SEL;
    private static int NOT_AVAILABLE_SEL = BTemplateInfo.NOT_AVAILABLE_SEL;
    private static int UNKNOWN_SEL = BTemplateInfo.UNKNOWN_SEL;
    private static int UPGRADE_SEL = BTemplateInfo.UPGRADE_SEL;
    private static int DOWNGRADE_SEL = BTemplateInfo.DOWNGRADE_SEL;
    private static int REDEPLOY_SEL = BTemplateInfo.REDEPLOY_SEL;
    private static int UPDATED_SEL = BTemplateInfo.UPDATED_SEL;
    public static final Id SLOT_PATH_SCOPE = Id.newId((String)"n", (String)"slotPathScope");
    private boolean isOffline = false;
    private int versionState = NOT_AVAILABLE_SEL;
    private BTemplateConfig templateConfig;
    private BComponent root;
    private Object owner;
    private BTemplateManager manager;
    private BTemplateService templateService;
    private BComponent target;
    private boolean isTemplateEditor = false;
    private BSearchService searchService;
    private BTable table;
    private Untemplate untemplateCmd;
    public UpgradeAll upgradeAllCmd;
    private BulkDeploy bulkDeployCmd;
    private UpdateConfigs updateConfigsCmd;
    private Upgrade upgradeCmd;
    private Downgrade downgradeCmd;
    private Redeploy redeployCmd;
    private BButton upDownGradeButton;
    private BButton untemplateButton;
    private Reset resetCmd;
    public Commit commitCmd;
    private IntHashMap nameMap;
    private BBorderPane topPane;
    private BJobBar jobBar;
    private BTitlePane tablePane;
    private BFlowPane buttonPane;
    private Array<TmplUtil.BindInfo> bindInfo = new Array(TmplUtil.BindInfo.class);
    private boolean abort = false;
    private boolean isDeploy = false;
    private Consumer<String> statusListener = s -> {};
    private IoSlotInfo[] inputInfo;
    private IoSlotInfo[] outputInfo;
    private IoSlotInfo[] relationInfo;
    private Hashtable<String, Object> cache;
    private Hashtable<Object, TemplateManager.TemplateInfo> availTemplates;
    private BJob job;
    private boolean commitInProgress = false;
    private boolean jobInProgress = false;
    private BVector vector;
    private Version remoteVersion;
    private boolean isRemotePre4_3 = false;

    @Generated
    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTemplateManager() {
        this.manager = this;
        this.owner = this;
        BEdgePane content = new BEdgePane();
        this.table = new BTable();
        this.table.setController((TableController)new Controller());
        this.table.setModel((TableModel)new Model());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.tablePane = BTitlePane.makePane((String)this.getTypeDisplayName(null), (BTable)this.table);
        content.setCenter((BWidget)this.tablePane);
        content.setBottom((BWidget)new BBorderPane(this.makeButtonPane(), 4.0, 0.0, 4.0, 0.0));
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.none, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.none, BInsets.DEFAULT);
        content.setTop((BWidget)new BBorderPane((BWidget)jobPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0)));
        this.setContent((BWidget)content);
        this.linkTo((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateCommands);
        this.linkTo((BComponent)this.table, (Slot)BTable.tableModified, (Slot)updateCommands);
        this.nameMap = new IntHashMap();
        this.nameMap.put(0, (Object)"templateManager.root");
        this.nameMap.put(1, (Object)"templateManager.name");
        this.nameMap.put(2, (Object)"templateManager.vendor");
        this.nameMap.put(3, (Object)"templateManager.version");
    }

    private BWidget makeButtonPane() {
        this.untemplateCmd = new Untemplate(this.table);
        this.upgradeAllCmd = new UpgradeAll(this.table);
        this.upgradeCmd = new Upgrade(this.table);
        this.downgradeCmd = new Downgrade(this.table);
        this.redeployCmd = new Redeploy(this.table);
        this.resetCmd = new Reset(this.table);
        this.commitCmd = new Commit(this.table);
        this.bulkDeployCmd = new ComponentBulkDeploy();
        this.updateConfigsCmd = new UpdateConfigs((BWidget)this, lex.get("templateManager.updateConfigs"));
        this.upDownGradeButton = new BButton((Command)this.upgradeCmd, true, false);
        this.untemplateButton = new BButton((Command)this.untemplateCmd, true, false);
        this.buttonPane = new BFlowPane(BHalign.center);
        this.buttonPane.add(null, (BValue)this.untemplateButton);
        this.buttonPane.add(null, (BValue)new BButton((Command)this.upgradeAllCmd, true, false));
        this.buttonPane.add("b2", (BValue)this.upDownGradeButton);
        this.buttonPane.add(null, (BValue)new BButton((Command)this.resetCmd, true, false));
        this.buttonPane.add(null, (BValue)new BButton((Command)this.commitCmd, true, false));
        this.buttonPane.add("bulkDeploy", (BValue)new BButton((Command)this.bulkDeployCmd, true, false));
        this.buttonPane.add("updateConfigs", (BValue)new BButton((Command)this.updateConfigsCmd, true, false));
        return this.buttonPane;
    }

    public void setTemplateConfig(BTemplateConfig templateConfig) {
        this.templateConfig = templateConfig;
        this.root = templateConfig.getParent().asComponent();
    }

    public void setTemplateService(BTemplateService templateService) {
        this.templateService = templateService;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public void bindInput(Slot slot, BTemplateConfig templateConfig, Hashtable<String, Object> cache) throws Exception {
        Bind bind = new Bind(slot, templateConfig, true, true, cache);
        bind.doInvoke();
    }

    public static boolean processPostDeploy(BWidget owner, BComponent[] deployRoots, Consumer<String> statusListener, Context cx) {
        if (deployRoots.length == 0) {
            return true;
        }
        BTemplateManager tm = new BTemplateManager();
        tm.setIsDeploy(true);
        tm.setStatusListener(statusListener);
        BTemplateService tService = tm.getTemplateService(deployRoots[0]);
        BSearchService searchService = tm.getSearchService(deployRoots[0]);
        if (searchService != null) {
            searchService.lease();
            if (!searchService.getStatus().isValid()) {
                BDialog.warning((BWidget)owner, (String)"Warning", (Object)lex.getText("templateManager.searchService.notValid.exception"));
                return true;
            }
            tm.setTemplateService(tService);
        }
        try {
            tm.setOwner(owner);
            boolean first = true;
            BTemplateConfig reuseTemplateConfig = null;
            for (BComponent deployRoot : deployRoots) {
                BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)deployRoot);
                tm.setTemplateConfig(templateConfig);
                if (cx == null || !Context.includes((Context)cx, (Context)DeployToComp.NoPostLink)) {
                    tm.queryForIoChoices(first);
                    first = false;
                    tm.promptUser(deployRoots.length > 1);
                    if (cx == null || !Context.includes((Context)cx, (Context)DeployToComp.NoPostConfigEdit)) {
                        if (reuseTemplateConfig == null) {
                            boolean reuse = BTemplateManager.editConfigProperties(owner, templateConfig, deployRoots.length > 1);
                            if (reuse) {
                                reuseTemplateConfig = templateConfig;
                            }
                        } else {
                            BTemplateManager.copyTemplateConfigProperties(reuseTemplateConfig, templateConfig);
                        }
                    }
                    tm.checkPasswords();
                    tm.formatBindInfos();
                    if (tService != null) {
                        BVector vector = new BVector();
                        for (BTemplateConfig subTemplateConfig : (BTemplateConfig[])CompUtil.getDescendants((BComponent)deployRoot, BTemplateConfig.class)) {
                            BComponent stRoot = BTemplateConfig.getRootForConfig((BTemplateConfig)subTemplateConfig);
                            if (stRoot == deployRoot) continue;
                            stRoot.lease();
                            long stRootSignature = UpgradeUtil.getTemplateSignature((BComponent)stRoot);
                            String ntplSignature = tm.getTemplateFileSignature(subTemplateConfig);
                            if (Long.toHexString(stRootSignature).equals(ntplSignature)) {
                                if (!log.isLoggable(Level.FINE)) continue;
                                log.fine(" Post Deploy: No need to update " + subTemplateConfig.getTemplateName() + " at " + subTemplateConfig.getSlotPathOrd().encodeToString());
                                continue;
                            }
                            vector.add("v?", (BValue)subTemplateConfig.getSlotPathOrd());
                        }
                        if (vector.getPropertyCount() > 0) {
                            tService.submitUpgradeJob(vector);
                        }
                    }
                }
                templateConfig.setDeployed(true);
            }
        }
        catch (Exception e) {
            if (tm.getAbort()) {
                try {
                    for (BComponent deployRoot : deployRoots) {
                        BComplex parent = deployRoot.getParent();
                        if (parent == null || !parent.isComponent()) continue;
                        deployRoot.getParent().asComponent().remove((BComplex)deployRoot);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            log.log(Level.WARNING, "Error updating template after deployment", e);
            BDialog.error((BWidget)owner, (Object)e.getLocalizedMessage());
        }
        tm.displayBindInfo();
        return false;
    }

    private String getTemplateFileSignature(BTemplateConfig config) {
        TemplateManager tmInstance = TemplateManager.INSTANCE;
        TemplateManager.TemplateInfo templateInfo = tmInstance.getTemplate(config.getUID(), config.getManifest().vendor);
        String signature = "";
        if (templateInfo == null) {
            return signature;
        }
        try (BNtplFile ntplFile = templateInfo.getNtplFile();){
            if (ntplFile == null) {
                String string = signature;
                return string;
            }
            TemplateManifest manifest = ntplFile.getTemplateManifest();
            signature = manifest.bogSignature;
        }
        return signature;
    }

    private void checkPasswords() {
        BTemplateConfig tc = this.templateConfig;
        BPasswordBinding[] pswBindings = (BPasswordBinding[])tc.getChildren(BPasswordBinding.class);
        BGridPane grid = new BGridPane(1);
        boolean hasDefaultPasswords = false;
        for (BPasswordBinding pswBinding : pswBindings) {
            Optional target = pswBinding.getTarget();
            if (!target.isPresent()) continue;
            BComponent targetComp = (BComponent)target.get();
            targetComp.lease();
            BValue bValue = targetComp.get(pswBinding.getPswSlot());
            if (!(bValue instanceof BPassword) || !((BPassword)bValue).isDefault()) continue;
            hasDefaultPasswords = true;
            grid.add(null, (BValue)new BLabel(targetComp.getSlotPath() + " has a default password."));
        }
        if (hasDefaultPasswords) {
            BBorderPane pane = new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0);
            BDialog.open((BWidget)((BWidget)this.owner), (String)lex.getText("Default Password"), (Object)pane, (int)1);
        }
    }

    private static void copyTemplateConfigProperties(BTemplateConfig from, BTemplateConfig to) {
        for (Property prop : from.getProperties()) {
            String propName;
            int flags = from.getFlags((Slot)prop);
            if ((flags & 5) != 0 || to.get(propName = prop.getName()).equivalent((Object)from.get(prop))) continue;
            to.set(propName, from.get(prop).newCopy(true));
        }
    }

    private static boolean editConfigProperties(BWidget owner, BTemplateConfig tc, boolean isMultiple) {
        if (owner == null || owner instanceof BFolderManager || tc.getDynamicPropertiesArray().length == 0) {
            return false;
        }
        BComponent root = BTemplateConfig.getRootForConfig((BTemplateConfig)tc);
        if (root == null) {
            return false;
        }
        BCheckBox reuseCb = new BCheckBox("Use values for all.");
        int state = 0;
        while (state < 2) {
            block12: {
                try {
                    if (!tc.hasConfigProperties()) break block12;
                    BTemplateConfigFE editor = new BTemplateConfigFE();
                    editor.loadValue((BObject)tc);
                    for (BExpandablePane pane : (BExpandablePane[])CompUtil.getDescendants((BComponent)editor, BExpandablePane.class)) {
                        pane.setExpanded(true);
                    }
                    BGridPane gridPane = new BGridPane(1);
                    BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)gridPane, 3.0, Theme.scrollBar().getFixedWidth() + 3.0, 3.0, 3.0));
                    gridPane.add(null, (BValue)editor);
                    if (isMultiple) {
                        gridPane.add(null, (BValue)reuseCb);
                    }
                    BOptionDialog dlg = new BOptionDialog(owner, lex.getText("templateManager.configDialog.title") + ": " + root.getNavName(), (BWidget)scrollPane, 3, null, null);
                    dlg.computePreferredSize();
                    dlg.setBoundsCenteredOnOwner();
                    boolean validEntry = false;
                    while (!validEntry) {
                        dlg.open();
                        if (dlg.getResult() != 1) {
                            return false;
                        }
                        try {
                            tc = (BTemplateConfig)editor.saveValue();
                        }
                        catch (Exception e) {
                            BDialog.error((BWidget)owner, (Object)("Exception: " + e.getLocalizedMessage()));
                            continue;
                        }
                        validEntry = true;
                    }
                }
                catch (Exception e) {
                    BDialog.error((BWidget)owner, (Object)e.getLocalizedMessage());
                    state = 1;
                    continue;
                }
            }
            if (tc == null) {
                return false;
            }
            state = 2;
        }
        return reuseCb.getSelected();
    }

    private static BWbFieldEditor makeConfigEditor(BTemplateConfig tc) {
        SlotCursor c = tc.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!p.isFrozen()) continue;
        }
        return BWbFieldEditor.makeFor((BObject)tc);
    }

    private void queryForIoChoices(boolean isFirst) {
        try {
            Slot[] slots = this.templateConfig.getInputSlots();
            this.inputInfo = this.initIoSlotInfos(this.inputInfo, this.templateConfig.getInputSlots(), true, this.templateConfig);
            this.outputInfo = this.initIoSlotInfos(this.outputInfo, this.templateConfig.getOutputSlots(), false, this.templateConfig);
            this.relationInfo = this.initRelateInfos(this.relationInfo, this.templateConfig);
            if (isFirst) {
                for (IoSlotInfo ioSlotInfo : this.inputInfo) {
                    if (ioSlotInfo.bindHints != null && !ioSlotInfo.bindHints.isEmpty()) {
                        this.statusListener.accept(lex.getText("deploy.searchForInputComp") + " " + ioSlotInfo.bindHints);
                        ioSlotInfo.choices = TmplUtil.findMatchingObjects(ioSlotInfo, this.searchService, this.templateService, (BComponent)this.templateConfig, lex);
                        if (ioSlotInfo.choices != null && ioSlotInfo.choices.length != 0 || ioSlotInfo.results != 0) continue;
                        ioSlotInfo.results = 2;
                        continue;
                    }
                    ioSlotInfo.results = 1;
                }
                for (IoSlotInfo ioSlotInfo : this.outputInfo) {
                    if (ioSlotInfo.bindHints != null && !ioSlotInfo.bindHints.isEmpty()) {
                        this.statusListener.accept(lex.getText("deploy.searchForOutputComp") + " " + ioSlotInfo.bindHints);
                        ioSlotInfo.choices = TmplUtil.findMatchingObjects(ioSlotInfo, this.searchService, this.templateService, (BComponent)this.templateConfig, lex);
                        if (ioSlotInfo.choices != null && ioSlotInfo.choices.length != 0 || ioSlotInfo.results != 0) continue;
                        ioSlotInfo.results = 12;
                        continue;
                    }
                    ioSlotInfo.results = 11;
                }
                for (IoSlotInfo relateInfo : this.relationInfo) {
                    if (relateInfo.bindHints != null && !relateInfo.bindHints.isEmpty()) {
                        this.statusListener.accept(lex.getText("deploy.searchForRelatedComp") + " " + relateInfo.bindHints);
                        relateInfo.choices = TmplUtil.findMatchingObjects(relateInfo, this.searchService, this.templateService, (BComponent)this.templateConfig, lex);
                        if (relateInfo.choices != null && relateInfo.choices.length != 0 || relateInfo.results != 0) continue;
                        relateInfo.results = 22;
                        continue;
                    }
                    relateInfo.results = 21;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error resolving I/O choices:" + e.getLocalizedMessage(), e);
        }
        this.statusListener.accept("postDeploy");
    }

    private void promptUser(boolean isMultiple) {
        this.promptRelations(isMultiple);
        this.promptInputs(isMultiple);
        this.promptOutputs(isMultiple);
    }

    private void promptInputs(boolean isMultiple) {
        for (IoSlotInfo ioSlotInfo : this.inputInfo) {
            if (ioSlotInfo.choices == null || ioSlotInfo.choices.length <= 0) continue;
            Object selectInput = ioSlotInfo.lastSelected;
            if (selectInput == null && !ioSlotInfo.dontAskAgain) {
                selectInput = TmplUtil.selectInputSource((BWidget)this.owner, ioSlotInfo, this.templateConfig, isMultiple, lex);
            }
            this.abort = ioSlotInfo.abort;
            if (this.abort) {
                throw new RuntimeException(lex.getText("templateManager.deploy.aborted"));
            }
            if (selectInput != null) {
                this.linkSource(selectInput, this.root, ioSlotInfo);
                continue;
            }
            ioSlotInfo.results = 3;
        }
    }

    private void promptOutputs(boolean isMultiple) {
        for (IoSlotInfo ioSlotInfo : this.outputInfo) {
            if (ioSlotInfo.choices == null || ioSlotInfo.choices.length <= 0) continue;
            Object targets = null;
            if (!ioSlotInfo.dontAskAgain) {
                targets = TmplUtil.selectOutputTargets((BWidget)this.owner, ioSlotInfo, this.templateConfig, isMultiple, lex);
            }
            this.abort = ioSlotInfo.abort;
            if (this.abort) {
                throw new RuntimeException(lex.getText("templateManager.deploy.aborted"));
            }
            if (targets != null) {
                this.linkTarget(targets, this.root, ioSlotInfo);
                continue;
            }
            ioSlotInfo.results = 13;
        }
    }

    private void promptRelations(boolean isMultiple) {
        for (IoSlotInfo relateInfo : this.relationInfo) {
            if (relateInfo.choices == null || relateInfo.choices.length <= 0) continue;
            Object selectRelations = relateInfo.lastSelected;
            if (selectRelations == null && !relateInfo.dontAskAgain) {
                selectRelations = TmplUtil.selectRelationSource((BWidget)this.owner, relateInfo, this.templateConfig, isMultiple, lex);
            }
            this.abort = relateInfo.abort;
            if (this.abort) {
                throw new RuntimeException(lex.getText("templateManager.deploy.aborted"));
            }
            if (selectRelations != null) {
                this.relateSource(selectRelations, this.root, relateInfo);
                continue;
            }
            relateInfo.results = 23;
        }
    }

    private IoSlotInfo changeTargetInfoInIoSlotInfo(IoSlotInfo ioSlotInfo, TmplUtil.TargetChoice targetChoice) {
        String targetSlotName = targetChoice.targetSlotEnum.getTag();
        Slot targetSlot = targetChoice.targetPoint.getSlot(targetSlotName);
        ioSlotInfo.otherName = targetChoice.targetPoint.getSlotPath().toString();
        ioSlotInfo.otherSlot = targetSlot.getName();
        return ioSlotInfo;
    }

    private IoSlotInfo changeEndpointInfoInIoSlotInfo(IoSlotInfo ioSlotInfo, BComponent extEndpoint) {
        ioSlotInfo.otherName = extEndpoint.getSlotPath().toString();
        ioSlotInfo.otherSlot = ioSlotInfo.relationInfo.getInbound() ? "from" : "to";
        return ioSlotInfo;
    }

    private void formatBindInfos() {
        for (IoSlotInfo ioSlotInfo : this.inputInfo) {
            this.bindInfo.add((Object)TmplUtil.formatBindResults(ioSlotInfo, lex));
        }
        for (IoSlotInfo ioSlotInfo : this.outputInfo) {
            if (ioSlotInfo.linkedTargets.isEmpty()) {
                this.bindInfo.add((Object)TmplUtil.formatBindResults(ioSlotInfo, lex));
                continue;
            }
            for (TmplUtil.TargetChoice targetChoice : ioSlotInfo.linkedTargets) {
                this.bindInfo.add((Object)TmplUtil.formatBindResults(this.changeTargetInfoInIoSlotInfo(ioSlotInfo, targetChoice), lex));
            }
        }
        for (IoSlotInfo ioSlotInfo : this.relationInfo) {
            if (ioSlotInfo.relatedEndpoints.isEmpty()) {
                this.bindInfo.add((Object)TmplUtil.formatBindResults(ioSlotInfo, lex));
                continue;
            }
            for (BComponent extEndpoint : ioSlotInfo.relatedEndpoints) {
                this.bindInfo.add((Object)TmplUtil.formatBindResults(this.changeEndpointInfoInIoSlotInfo(ioSlotInfo, extEndpoint), lex));
            }
        }
    }

    private IoSlotInfo[] initIoSlotInfos(IoSlotInfo[] lastInfos, Slot[] slots, boolean isInput, BTemplateConfig config) {
        IoSlotInfo[] infos = new IoSlotInfo[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            infos[i] = new IoSlotInfo(slots[i], isInput, this.templateConfig);
            if (lastInfos == null) continue;
            infos[i].choices = lastInfos[i].choices;
            infos[i].lastSelected = lastInfos[i].lastSelected;
            infos[i].linkedTargets = lastInfos[i].linkedTargets;
            infos[i].dontAskAgain = lastInfos[i].dontAskAgain;
        }
        return infos;
    }

    private IoSlotInfo[] initRelateInfos(IoSlotInfo[] lastRelateInfo, BTemplateConfig config) {
        ArrayList infos = this.templateConfig.getRelationInfos();
        this.relationInfo = new IoSlotInfo[infos.size()];
        int i = 0;
        for (BRelationInfo info : infos) {
            this.relationInfo[i] = new IoSlotInfo(info, this.templateConfig);
            if (lastRelateInfo != null) {
                this.relationInfo[i].choices = lastRelateInfo[i].choices;
                this.relationInfo[i].lastSelected = lastRelateInfo[i].lastSelected;
                this.relationInfo[i].relatedEndpoints = lastRelateInfo[i].relatedEndpoints;
                this.relationInfo[i].dontAskAgain = lastRelateInfo[i].dontAskAgain;
            }
            ++i;
        }
        return this.relationInfo;
    }

    public void bindOutput(Slot slot, BTemplateConfig templateConfig) throws Exception {
        Bind bind = new Bind(slot, templateConfig, false, true);
        bind.doInvoke();
    }

    private void bindRelations(BRelationInfo relationInfo, BTemplateConfig templateConfig, Hashtable<String, Object> cache) throws Exception {
        Bind relate = new Bind(relationInfo, templateConfig, cache);
        relate.doInvoke();
    }

    private Array<TmplUtil.BindInfo> getBindInfo() {
        return this.bindInfo;
    }

    private boolean getAbort() {
        return this.abort;
    }

    void setIsDeploy(boolean isDeploy) {
        this.isDeploy = isDeploy;
    }

    private void setStatusListener(Consumer<String> statusListener) {
        this.statusListener = statusListener;
    }

    private void displayBindInfo() {
        Object[] bindInfos = this.getBindInfo().trim();
        BScrollPane scrollPane = new BScrollPane();
        BGridPane pane = new BGridPane(1);
        int l = 0;
        if (bindInfos.length > 0) {
            for (Object bindInfo : bindInfos) {
                if (!(bindInfo instanceof TmplUtil.BindInfo)) continue;
                BLabel infoLabel = new BLabel(++l + ".  " + ((TmplUtil.BindInfo)bindInfo).getInfo(), BHalign.left);
                infoLabel.setForeground(BBrush.makeSolid((BColor)((TmplUtil.BindInfo)bindInfo).getForground()));
                pane.add(null, (BValue)infoLabel);
            }
            pane.computePreferredSize();
            scrollPane.setContent((BWidget)pane);
            int n = BDialog.info((BWidget)((BWidget)this.owner), (String)lex.getText("templateManager.inputBindingResults"), (Object)scrollPane);
        }
    }

    public BMenu[] getViewMenus() {
        BMenu menu = new BMenu(lex.getText("templateManager.label"));
        return new BMenu[]{menu};
    }

    public BToolBar getViewToolBar() {
        return new BToolBar();
    }

    HashSet<String> hasOutOfDateTemplate() {
        Model model = (Model)this.table.getModel();
        int count = model.getRowCount();
        HashSet<String> outOfDateSet = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            BTemplateInfo templateInfo = model.get(i);
            if (templateInfo.getState() == 0) continue;
            outOfDateSet.add(templateInfo.getTemplateName());
        }
        return outOfDateSet;
    }

    void setUpdatedStatus(HashSet<String> updatedSet) {
        Model model = (Model)this.table.getModel();
        int count = model.getRowCount();
        for (int i = 0; i < count; ++i) {
            BTemplateInfo templateInfo = model.get(i);
            if (!updatedSet.contains(templateInfo.getTemplateName())) continue;
            templateInfo.setStatus("Updated");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.remoteVersion = (Version)value.fw(404, (Object)"template", null, null, null);
        boolean bl = this.isRemotePre4_3 = this.remoteVersion.major() == 4 && this.remoteVersion.minor() < 3;
        if (value instanceof BTemplateService) {
            if (!((BTemplateService)value).getStatus().isValid()) throw new RuntimeException("TemplateService is disabled or not licensed.");
            this.updateTable((BComponent)((BTemplateService)value));
            this.target = value.asComponent();
            this.isTemplateEditor = false;
            this.doUpdateCommands();
            return;
        } else {
            if (!(value instanceof BComponent)) return;
            this.updateTable(value.asComponent());
            this.target = value.asComponent();
            this.isTemplateEditor = true;
            if (this.isReadonly()) return;
            this.doUpdateCommands();
        }
    }

    private void updateTable(BComponent target) {
        target.lease(2);
        if (this.isRemotePre4_3) {
            if (target instanceof BTemplateService) {
                this.templateService = (BTemplateService)target;
                this.update42Table(this.templateService);
            }
            return;
        }
        BSpace space = target.getSpace();
        this.isOffline = space instanceof BBogSpace;
        if (target instanceof BTemplateService) {
            this.templateService = (BTemplateService)target;
        }
        Model model = (Model)this.table.getModel();
        model.initTable();
        if (!this.isOffline) {
            this.initOnlineTable(this.templateService, model);
        } else {
            this.initOfflineTable(target, model);
        }
        model.initAvailTemplates();
        if (!this.isReadonly()) {
            model.initVersionStatus();
        }
        model.sortByColumn(0, true);
        model.updateTable(true);
        this.tablePane.tableModified();
    }

    private void update42Table(BTemplateService target) {
        this.templateService = target;
        Model model = (Model)this.table.getModel();
        model.initTable();
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bqlOrd = BOrd.make((BOrd)authority, (String)this.query()).normalize();
        BITable itable = (BITable)bqlOrd.resolve((BObject)target).get();
        ColumnList columns = itable.getColumns();
        try (TableCursor cursor = itable.cursor();){
            while (cursor.next()) {
                BDataRow dataRow = (BDataRow)cursor.get();
                String slotPath = dataRow.cell(columns.get(0)).toString();
                BObject bObject = BOrd.make((String)slotPath).resolve((BObject)target).get();
                if (!(bObject instanceof BTemplateConfig)) continue;
                ((BTemplateConfig)bObject).loadSlots();
                ((BTemplateConfig)bObject).clearCacheValues();
                model.add(BTemplateInfo.make((BTemplateConfig)((BTemplateConfig)bObject)));
            }
        }
        this.table.relayout();
        this.tablePane.tableModified();
    }

    private void initOfflineTable(BComponent target, Model model) {
        BComponentSpace componentSpace = target.getComponentSpace();
        BComponent rootComponent = componentSpace.getRootComponent();
        boolean isStation = rootComponent instanceof BStation;
        BTemplateConfig[] templateConfigs = (BTemplateConfig[])CompUtil.getDescendants((BComponent)rootComponent, BTemplateConfig.class);
        TagDictionaryService tagDictionaryService = componentSpace.getTagDictionaryService();
        componentSpace.setTagDictionaryService(tagDictionaryService);
        if (this.templateService != null) {
            this.templateService.removeAll();
            for (BTemplateConfig tc : templateConfigs) {
                this.templateService.register(tc);
            }
            this.initOnlineTable(this.templateService, model);
        } else {
            for (BTemplateConfig tc : templateConfigs) {
                if (tc.getPropertyInParent().isFrozen()) continue;
                BTemplateInfo templateInfo = BTemplateInfo.make((BTemplateConfig)tc);
                BComponent tRoot = tc.getParent().asComponent();
                tRoot.loadSlots();
                BComponent tRootParent = tRoot.getParent().asComponent();
                tRootParent.loadSlots();
                tc.loadSlots();
                tc.clearCacheValues();
                if (!isStation && tRoot.getParent().getParent() == null) continue;
                model.add(templateInfo);
            }
        }
    }

    private void initOnlineTable(BTemplateService target, Model model) {
        if (!this.isRemotePre4_3) {
            for (BTemplateInfo bTemplateInfo : (BTemplateInfo[])target.getChildren(BTemplateInfo.class)) {
                bTemplateInfo.loadSlots();
                OrdTarget ordTarget = null;
                BTemplateConfig tc = null;
                try {
                    ordTarget = bTemplateInfo.getLocationOrd().resolve((BObject)target);
                    tc = (BTemplateConfig)ordTarget.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tc == null) continue;
                BComponent tRoot = tc.getParent().asComponent();
                tRoot.getParent().asComponent().loadSlots();
                tc.loadSlots();
                tc.clearCacheValues();
                model.add(bTemplateInfo);
            }
        }
    }

    private String query() {
        return "station:|slot:/|bql:select slotPath from template:TemplateConfig";
    }

    private BSearchService getSearchService(BComponent base) {
        if (this.searchService != null) {
            return this.searchService;
        }
        BIService service = this.getService(BSearchService.TYPE, base);
        if (service == null) {
            return null;
        }
        this.searchService = (BSearchService)service;
        return this.searchService;
    }

    private BTemplateService getTemplateService(BComponent base) {
        if (this.templateService != null) {
            return this.templateService;
        }
        BIService service = this.getService(BTemplateService.TYPE, base);
        if (service == null) {
            return null;
        }
        this.templateService = (BTemplateService)service;
        return this.templateService;
    }

    private BIService getService(Type serviceType, BComponent base) {
        BComponentSpace space = base.getComponentSpace();
        if (space == null) {
            return null;
        }
        BComponent root = space.getRootComponent();
        BServiceContainer[] serviceContainer = (BServiceContainer[])root.getChildren(BServiceContainer.class);
        if (serviceContainer == null || serviceContainer.length == 0) {
            return null;
        }
        BIService[] services = (BIService[])serviceContainer[0].getChildren(serviceType.getTypeClass());
        if (services == null || services.length == 0) {
            return null;
        }
        return services[0];
    }

    public void doUpdateCommands() {
        int[] tRows;
        boolean hasSelections = this.table.getSelection().getRow() != -1;
        TableModel model = this.table.getModel();
        int count = model.getRowCount();
        boolean upgradeAllEnable = false;
        boolean commitEnable = false;
        for (int i = 0; i < count; ++i) {
            BTemplateInfo tRow = (BTemplateInfo)model.getSubject(i);
            tRow.lease();
            int versionState = tRow.getState();
            if (versionState == OUT_OF_DATE_SEL) {
                upgradeAllEnable = true;
                continue;
            }
            if (versionState != UPGRADE_SEL && versionState != DOWNGRADE_SEL && versionState != REDEPLOY_SEL) continue;
            commitEnable = true;
        }
        boolean upgradeEnable = false;
        boolean redeployEnable = hasSelections;
        boolean downgradeEnable = false;
        boolean untemplateEnable = false;
        for (int i : tRows = this.table.getSelection().getRows()) {
            untemplateEnable = true;
            BTemplateInfo tRow = (BTemplateInfo)model.getSubject(i);
            if (!tRow.isSubtemplate()) continue;
            untemplateEnable = false;
            break;
        }
        upgradeEnable = this.checkTemplateInfoState(tRows, model, OUT_OF_DATE_SEL);
        downgradeEnable = this.checkTemplateInfoState(tRows, model, OLDER_VERSION_AVAILABLE_SEL);
        redeployEnable = this.checkTemplateInfoState(tRows, model, UP_TO_DATE_SEL);
        BButton b2 = (BButton)this.buttonPane.get("b2");
        if (downgradeEnable) {
            b2.setCommand((Command)this.downgradeCmd, true, false);
            this.downgradeCmd.setEnabled(!this.isRemotePre4_3);
        } else if (redeployEnable) {
            b2.setCommand((Command)this.redeployCmd, true, false);
            this.redeployCmd.setEnabled(!this.isRemotePre4_3);
        } else {
            b2.setCommand((Command)this.upgradeCmd, true, false);
            this.upgradeCmd.setEnabled(!this.isRemotePre4_3 && upgradeEnable);
        }
        this.upgradeAllCmd.setEnabled(!this.isRemotePre4_3 && !this.commitInProgress && upgradeAllEnable);
        this.commitCmd.setEnabled(!this.isRemotePre4_3 && !this.commitInProgress && commitEnable);
        this.resetCmd.setEnabled(!this.isRemotePre4_3 && !this.commitInProgress && commitEnable);
        this.untemplateCmd.setEnabled(!this.isRemotePre4_3 && !this.commitInProgress && untemplateEnable);
        if (this.isTemplateEditor && this.buttonPane.get("bulkDeploy") != null) {
            this.bulkDeployCmd.setEnabled(false);
            this.buttonPane.remove("bulkDeploy");
            this.updateConfigsCmd.setEnabled(false);
            this.buttonPane.remove("updateConfigs");
        }
    }

    private boolean checkTemplateInfoState(int[] selectedRows, TableModel model, int state) {
        if (selectedRows.length == 0) {
            return false;
        }
        for (int i : selectedRows) {
            BTemplateInfo tRow = (BTemplateInfo)model.getSubject(i);
            if (tRow.getState() == state) continue;
            return false;
        }
        return true;
    }

    private void linkSource(Object source, BComponent target, IoSlotInfo slotInfo) {
        if (source == null) {
            return;
        }
        if (source instanceof ArrayList && ((ArrayList)source).size() > 0) {
            Slot slot = slotInfo.slot;
            Type targetType = target.get(slot.asProperty()).getType();
            TmplUtil.TargetChoice sourceChoice = (TmplUtil.TargetChoice)((ArrayList)source).get(0);
            String sourceSlotName = "out";
            if (sourceChoice.targetSlotEnum.getOrdinal() != 0) {
                sourceSlotName = sourceChoice.targetSlotEnum.getTag();
            }
            BComponent srcComp = sourceChoice.targetPoint;
            srcComp.loadSlots();
            slotInfo.otherName = srcComp.getSlotPath().toString();
            Property outProp = srcComp.getProperty(sourceSlotName);
            if (outProp != null) {
                Type srcType = outProp.getType();
                LinkCheck linkCheck = target.checkLink(srcComp, (Slot)outProp, slot, null);
                if (linkCheck.isValid()) {
                    BLink link = target.makeLink(srcComp, (Slot)outProp, slot, null);
                    target.add(null, (BValue)link);
                    slotInfo.otherSlot = outProp.getName();
                    slotInfo.results = 4;
                } else {
                    slotInfo.otherName = srcType.toString();
                    slotInfo.otherSlot = targetType.toString();
                    slotInfo.results = 6;
                }
            } else {
                slotInfo.results = 7;
            }
        } else {
            slotInfo.otherName = source.getClass().getName();
            slotInfo.results = 8;
        }
    }

    private void relateSource(Object extEndpoint, BComponent localEndpoint, IoSlotInfo slotInfo) {
        if (extEndpoint instanceof ArrayList) {
            ArrayList extList = (ArrayList)extEndpoint;
            for (BComponent endpoint : extList) {
                this.relateEndpoint(endpoint, localEndpoint, slotInfo);
            }
        }
        if (extEndpoint instanceof BComponent) {
            this.relateEndpoint((BComponent)extEndpoint, localEndpoint, slotInfo);
        }
        localEndpoint.lease();
    }

    private void relateEndpoint(BComponent extEndpoint, BComponent localEndpoint, IoSlotInfo slotInfo) {
        BRelationInfo relateInfo = slotInfo.relationInfo;
        Id relationId = Id.newId((String)relateInfo.getRelationId());
        BOrd endPointOrd = extEndpoint.getHandleOrd();
        BComponent relationOwner = localEndpoint;
        if (relateInfo.getInbound()) {
            endPointOrd = localEndpoint.getHandleOrd();
            relationOwner = extEndpoint;
        }
        BRelation newRelation = new BRelation(relationId, endPointOrd);
        relationOwner.relations().add((Relation)newRelation);
        relationOwner.lease();
        slotInfo.otherName = extEndpoint.getSlotPath().toString();
        slotInfo.otherSlot = relateInfo.getInbound() ? "from" : "to";
        slotInfo.relatedEndpoints.add(extEndpoint);
        slotInfo.results = 24;
    }

    private void linkTarget(Object targets, BComponent parent, IoSlotInfo slotInfo) {
        if (targets instanceof ArrayList) {
            Slot slot = slotInfo.slot;
            boolean linked = false;
            for (TmplUtil.TargetChoice targetChoice : (ArrayList)targets) {
                if (targetChoice.targetSlotEnum.getOrdinal() == 0) continue;
                String targetSlotName = targetChoice.targetSlotEnum.getTag();
                Slot targetSlot = targetChoice.targetPoint.getSlot(targetSlotName);
                BLink link = new BLink(parent.getHandleOrd(), slot.getName(), targetSlot.getName(), true);
                targetChoice.targetPoint.add(null, (BValue)link);
                targetChoice.targetPoint.lease(1);
                slotInfo.otherName = targetChoice.targetPoint.getSlotPath().toString();
                slotInfo.otherSlot = targetSlot.getName();
                slotInfo.linkedTargets.add(targetChoice);
                slotInfo.results = 14;
                linked = true;
            }
            if (!linked) {
                slotInfo.results = 15;
            }
        }
    }

    private boolean resolveInputBinding(BComponent root) {
        BSearchService searchService = this.getSearchService(root);
        return false;
    }

    private BMenu popupMenu(int row, int column) {
        BMenu menu = new BMenu();
        TableSelection selection = this.table.getSelection();
        int rowCount = selection.getRowCount();
        if (rowCount > 1) {
            menu.add(null, (Command)new BindSelection(this.table));
            return menu;
        }
        BTemplateConfig config = ((Model)this.table.getModel()).get(row).getTemplateConfig();
        Slot[] unlinkedInputSlots = config.getUnlinkedInputs();
        Slot[] unlinkedOutputSlots = config.getUnlinkedOutputs();
        ArrayList unrelatedInfos = config.getUnboundRelationInfos();
        ArrayList defaultPasswords = config.getPasswordInfos();
        boolean needsBindings = unlinkedInputSlots.length + unlinkedOutputSlots.length + unrelatedInfos.size() > 0;
        switch (column) {
            case 0: {
                if (!this.isTemplateEditor) {
                    menu.add(null, (Command)new Goto(row, this.table));
                    menu.add(null, (Command)new GotoComponent(row, this.table));
                }
                if (!needsBindings) break;
                menu.add(null, (Command)new BindSelection(this.table));
                break;
            }
            case 4: {
                if (unlinkedInputSlots.length == 0) break;
                for (Slot slot : unlinkedInputSlots) {
                    menu.add(slot.getName(), (Command)new Bind(slot, config, true, true));
                }
                break;
            }
            case 5: {
                if (unlinkedOutputSlots.length == 0) break;
                for (Slot slot : unlinkedOutputSlots) {
                    menu.add(slot.getName(), (Command)new Bind(slot, config, false, true));
                }
                break;
            }
            case 6: {
                if (unrelatedInfos.isEmpty()) break;
                for (BRelationInfo relateInfo : unrelatedInfos) {
                    Bind bindCmd = new Bind(relateInfo, config, null);
                    bindCmd.setDisplayBindInfo(true);
                    BMenuItem menuItem = menu.add(SlotPath.escape((String)relateInfo.getRelationId()), (Command)bindCmd);
                    menuItem.setText(relateInfo.getRelationId());
                }
                break;
            }
            case 7: {
                for (BPasswordBinding passwordBinding : defaultPasswords) {
                    if (!passwordBinding.getTarget().isPresent()) continue;
                    menu.add(null, (Command)new GotoPassword(passwordBinding));
                }
                break;
            }
            default: {
                if (this.isTemplateEditor) break;
                menu.add(null, (Command)new Goto(row, this.table));
            }
        }
        return menu;
    }

    private void showInputInfo(BTemplateConfig config) {
        BComponent parent = config.getParent().asComponent();
        Slot[] inputSlots = config.getInputSlots();
        IoSlotInfo[] slotInfos = new IoSlotInfo[inputSlots.length];
        if (slotInfos.length == 0) {
            return;
        }
        for (int i = 0; i < inputSlots.length; ++i) {
            slotInfos[i] = new IoSlotInfo();
            slotInfos[i].slot = inputSlots[i];
            slotInfos[i].tags = config.getInputSlotTags(inputSlots[i]);
        }
        BFont boldFont = Theme.label().getBoldText();
        boldFont = BFont.make((BFont)boldFont, (int)1);
        BGridPane pane = new BGridPane(2);
        for (IoSlotInfo slotInfo : slotInfos) {
            String slotName = slotInfo.slot.getName();
            String linkInfo = lex.getText("templateManager.notLinked");
            String hints = lex.getText("templateManager.bindHintsNotFound");
            BTextField linkField = new BTextField(linkInfo, 40, false);
            BTextField hintsField = new BTextField(hints, 40, false);
            BLabel slotLabel = new BLabel(slotName, BHalign.left);
            slotLabel.setFont(boldFont);
            pane.add(null, (BValue)slotLabel);
            pane.add(null, (BValue)new BLabel());
            pane.add(null, (BValue)new BLabel("     " + lex.getText("templateManager.linkSource"), BHalign.right));
            pane.add(null, (BValue)linkField);
            pane.add(null, (BValue)new BLabel("     " + lex.getText("templateManager.bindHints"), BHalign.right));
            pane.add(null, (BValue)hintsField);
            BLink[] links = parent.getLinks(slotInfo.slot);
            for (BLink link : parent.getLinks(slotInfo.slot)) {
                SlotPath slotPath = link.getEndpointOrd().resolve((BObject)config).get().asComponent().getSlotPath();
                linkField.setText(slotPath.toString() + "." + link.getSourceSlotName());
            }
            for (Tag tag : slotInfo.tags) {
                if (!tag.getId().getQName().equals("n:bindHints")) continue;
                hintsField.setText(tag.getValue().toString());
            }
        }
        int info = BDialog.info((BWidget)((BWidget)this.owner), (String)lex.getText("templateManager.inputInfo"), (Object)pane);
    }

    private void showOutputInfo(BTemplateConfig config) {
        BComponent parent = config.getParent().asComponent();
        Slot[] outputSlots = config.getOutputSlots();
        IoSlotInfo[] slotInfos = new IoSlotInfo[outputSlots.length];
        if (slotInfos.length == 0) {
            return;
        }
        for (int i = 0; i < outputSlots.length; ++i) {
            slotInfos[i] = new IoSlotInfo();
            slotInfos[i].slot = outputSlots[i];
            slotInfos[i].tags = config.getOutputSlotTags(outputSlots[i]);
        }
        BFont boldFont = Theme.label().getBoldText();
        boldFont = BFont.make((BFont)boldFont, (int)1);
        BGridPane pane = new BGridPane(2);
        for (IoSlotInfo slotInfo : slotInfos) {
            String slotName = slotInfo.slot.getName();
            BLabel slotLabel = new BLabel(slotName, BHalign.left);
            slotLabel.setFont(boldFont);
            pane.add(null, (BValue)slotLabel);
            pane.add(null, (BValue)new BLabel());
            for (Tag tag : slotInfo.tags) {
                pane.add(null, (BValue)new BLabel("     " + tag.getId().getQName(), BHalign.right));
                if (tag.getValue().getType().is(BMarker.TYPE)) {
                    pane.add(null, (BValue)new BLabel("Marker"));
                    continue;
                }
                pane.add(null, (BValue)new BTextField(tag.getValue().toString(), 40, false));
            }
            Knob[] knobs = parent.getKnobs(slotInfo.slot);
            if (knobs.length == 0) {
                String linkInfo = lex.getText("templateManager.notLinked");
                BTextField linkField = new BTextField(linkInfo, 40, false);
                pane.add(null, (BValue)new BLabel("     " + lex.getText("templateManager.linkTarget"), BHalign.left));
                pane.add(null, (BValue)linkField);
                continue;
            }
            int j = 1;
            for (Knob knob : knobs) {
                BOrd targetOrd = knob.getTargetOrd();
                String targetSlot = knob.getTargetSlotName();
                SlotPath slotPath = targetOrd.resolve((BObject)config).get().asComponent().getSlotPath();
                String linkInfo = slotPath.toString() + "." + targetSlot;
                BTextField linkField = new BTextField(linkInfo, 40, false);
                pane.add(null, (BValue)new BLabel("     " + lex.getText("templateManager.linkTarget") + j++, BHalign.right));
                pane.add(null, (BValue)linkField);
            }
        }
        int info = BDialog.info((BWidget)((BWidget)this.owner), (String)lex.getText("templateManager.outputInfo"), (Object)pane);
    }

    private void showRelationInfo(BTemplateConfig config) {
        BComponent parent = config.getParent().asComponent();
        ArrayList relationInfos = config.getRelationInfos();
        if (relationInfos.size() == 0) {
            return;
        }
        BFont boldFont = Theme.label().getBoldText();
        boldFont = BFont.make((BFont)boldFont, (int)1);
        BGridPane pane = new BGridPane(2);
        for (BRelationInfo relationInfo : relationInfos) {
            BLabel slotLabel = new BLabel(relationInfo.getRelationId(), BHalign.left);
            slotLabel.setFont(boldFont);
            pane.add(null, (BValue)slotLabel);
            pane.add(null, (BValue)new BLabel());
            pane.add(null, (BValue)new BLabel("     direction", BHalign.right));
            pane.add(null, (BValue)new BTextField(relationInfo.getInbound() ? "Inbound" : "Outbound", 40, false));
            pane.add(null, (BValue)new BLabel("     relateHints", BHalign.right));
            pane.add(null, (BValue)new BTextField(relationInfo.getRelateHints(), 40, false));
            int direction = relationInfo.getInbound() ? 1 : 2;
            Collection collection = parent.relations().getAll(Id.newId((String)relationInfo.getRelationId()), direction);
            if (collection.isEmpty()) {
                String relateInfo = lex.getText("templateManager.notRelated");
                BTextField relateField = new BTextField(relateInfo, 40, false);
                pane.add(null, (BValue)new BLabel("     " + lex.getText("templateManager.relatedComponent"), BHalign.left));
                pane.add(null, (BValue)relateField);
                continue;
            }
            int j = 1;
            for (Relation relation : collection) {
                BOrd targetOrd = ((BComponent)relation.getEndpoint()).getHandleOrd();
                SlotPath slotPath = targetOrd.resolve((BObject)config).get().asComponent().getSlotPath();
                String linkInfo = slotPath.toString();
                BTextField linkField = new BTextField(linkInfo, 40, false);
                pane.add(null, (BValue)new BLabel("     " + lex.getText("templateManager.relatedComponent") + j++, BHalign.right));
                pane.add(null, (BValue)linkField);
            }
        }
        int info = BDialog.info((BWidget)((BWidget)this.owner), (String)lex.getText("templateManager.relateInfo"), (Object)pane);
    }

    private static BDynamicEnum getLinkableInputs(BControlPoint point) {
        ArrayList<String> aList = new ArrayList<String>();
        aList.add(SlotPath.escape((String)"----"));
        for (String inputSlot : INPUT_SLOTS) {
            Slot slot = point.getSlot(inputSlot);
            if (Flags.isReadonly((BComplex)point, (Slot)slot) || !Flags.isFanIn((BComplex)point, (Slot)slot) && point.isLinkTarget(slot)) continue;
            aList.add(inputSlot);
        }
        String[] inTags = aList.toArray(new String[0]);
        BEnumRange inRange = BEnumRange.make((String[])inTags);
        return BDynamicEnum.make((int)0, (BEnumRange)inRange);
    }

    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        if (this.job == event.getSourceComponent()) {
            final BJob job = (BJob)event.getSourceComponent();
            this.jobBar.handleComponentEvent(event);
            if (job.getJobState().isComplete() && this.jobInProgress) {
                WbViewEventWorker.getInstance().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BTemplateManager.this.isRegisteredForComponentEvents((BComponent)job)) {
                            BTemplateManager.this.registerForComponentEvents((BComponent)job, Integer.MAX_VALUE);
                        }
                        BTemplateManager.this.jobComplete(job);
                    }
                });
            }
        }
    }

    private void jobComplete(BJob job) {
        BUpgradeTemplateJob uJob = (BUpgradeTemplateJob)job;
        Hashtable<Object, BComponent> rootParents = new Hashtable<Object, BComponent>();
        for (BOrd bOrd : (BOrd[])this.vector.getChildren(BOrd.class)) {
            try {
                BComponent tc = bOrd.resolve((BObject)this.templateService).get().asComponent();
                BComponent root = tc.getParent().asComponent();
                BComponent rootParent = root.getParent().asComponent();
                if (rootParents.containsKey(rootParent.getHandle())) continue;
                rootParent.lease(2);
                rootParents.put(rootParent.getHandle(), rootParent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.templateService.lease(Integer.MAX_VALUE);
        try {
            this.doLoadValue((BObject)this.templateService, null);
            this.jobInProgress = false;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error completing job:" + job.toString(), e);
        }
    }

    private class BEditComp
    extends BComponent {
        private BEditComp() {
        }

        public String getTypeDisplayName(Context cx) {
            return "";
        }
    }

    public static class IoSlotInfo {
        public Slot slot;
        public BRelationInfo relationInfo;
        public Tags tags;
        public boolean isInput;
        public boolean allowMultiple;
        public Object[] choices;
        public Object lastSelected;
        public ArrayList<TmplUtil.TargetChoice> linkedTargets;
        public ArrayList<BComponent> relatedEndpoints;
        public String bindHints;
        public String userTip;
        public String targetSlotHints;
        public String slotPathScope;
        public String title;
        public String prompt;
        public String rootName;
        public String otherName;
        public String otherSlot;
        public boolean abort;
        public boolean dontAskAgain;
        public int results;
        public List<String> resultsMessages;

        IoSlotInfo() {
        }

        IoSlotInfo(Slot slot, boolean isInput, BTemplateConfig config) {
            this.slot = slot;
            Tags slotTags = isInput ? config.getInputSlotTags(slot) : config.getOutputSlotTags(slot);
            Optional optBindHints = slotTags.get(BNiagaraTagDictionary.BIND_HINTS);
            Optional optUserTip = slotTags.get(BNiagaraTagDictionary.USER_TIP);
            Optional optTargetSlotHint = slotTags.get(BNiagaraTagDictionary.TARGET_SLOT_HINT);
            Optional optSlotPathScope = slotTags.get(SLOT_PATH_SCOPE);
            this.bindHints = optBindHints.isPresent() ? ((BIDataValue)optBindHints.get()).toString() : "";
            this.userTip = optUserTip.isPresent() ? ((BIDataValue)optUserTip.get()).toString() : "";
            this.targetSlotHints = optTargetSlotHint.isPresent() ? ((BIDataValue)optTargetSlotHint.get()).toString() : "";
            this.slotPathScope = optSlotPathScope.isPresent() ? ((BIDataValue)optSlotPathScope.get()).toString() : "";
            this.rootName = config.getParent().getName();
            this.linkedTargets = new ArrayList();
            this.title = isInput ? lex.getText("templateManager.input.multipleSources.title") : lex.getText("templateManager.output.select.title");
            this.isInput = isInput;
            boolean bl = this.allowMultiple = !isInput;
            if (slot != null) {
                this.prompt = this.rootName + "." + slot.getName();
            }
            this.abort = false;
            this.dontAskAgain = false;
            this.resultsMessages = new ArrayList<String>();
        }

        IoSlotInfo(BRelationInfo relateInfo, BTemplateConfig config) {
            this.relationInfo = relateInfo;
            this.bindHints = relateInfo.getRelateHints();
            this.slotPathScope = relateInfo.getSlotPathScope();
            this.userTip = relateInfo.getUserTip();
            this.isInput = relateInfo.getInbound();
            this.allowMultiple = true;
            this.rootName = config.getParent().getName();
            this.relatedEndpoints = new ArrayList();
            this.prompt = this.rootName + " <" + (this.isInput ? "Input " : "Output ") + relateInfo.getRelationId() + ">";
            this.title = lex.getText("templateManager.relation.select.title");
            this.abort = false;
            this.dontAskAgain = false;
            this.resultsMessages = new ArrayList<String>();
        }
    }

    private class CellRenderer
    extends TableCellRenderer {
        BIDataTable<?> lastTable = null;
        int statusCol = -1;

        private CellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            try {
                if (BTemplateManager.this.jobInProgress) {
                    return super.getForeground(cell);
                }
                BTemplateConfig config = ((Model)BTemplateManager.this.table.getModel()).get(cell.row).getTemplateConfig();
                BBrush fg = super.getForeground(cell);
                if (cell.column == 4) {
                    if (config.getUnlinkedInputs().length > 0) {
                        return ((BColor)BStatus.fault.getForegroundColor(null)).toBrush();
                    }
                } else if (cell.column == 5) {
                    if (config.getUnlinkedOutputs().length > 0) {
                        return ((BColor)BStatus.fault.getForegroundColor(null)).toBrush();
                    }
                } else if (cell.column == 6) {
                    if (config.getUnboundRelationInfos().size() > 0) {
                        return ((BColor)BStatus.fault.getForegroundColor(null)).toBrush();
                    }
                } else if (cell.column == 7) {
                    if (config.getPasswordInfos().size() > 0) {
                        return ((BColor)BStatus.fault.getForegroundColor(null)).toBrush();
                    }
                } else {
                    if (cell.column == 9) {
                        BTemplateInfo rowSubject = null;
                        try {
                            rowSubject = ((Model)BTemplateManager.this.table.getModel()).get(cell.row);
                        }
                        catch (Exception e) {
                            return super.getForeground(cell);
                        }
                        if (rowSubject.getModifiedState() < 0) {
                            return super.getForeground(cell);
                        }
                        return ((BColor)BStatus.alarm.getBackgroundColor(null)).toBrush();
                    }
                    if (cell.column == 10) {
                        if (cell.value.equals(OUT_OF_DATE) || cell.value.equals(UPDATED)) {
                            return BColor.red.toBrush();
                        }
                        return BColor.blue.toBrush();
                    }
                }
                return fg;
            }
            catch (Exception e) {
                return super.getBackground(cell);
            }
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            try {
                if (BTemplateManager.this.jobInProgress) {
                    return super.getBackground(cell);
                }
                BTemplateConfig config = ((Model)BTemplateManager.this.table.getModel()).get(cell.row).getTemplateConfig();
                BBrush bg = super.getBackground(cell);
                if (cell.column == 4 ? config.getUnlinkedInputs().length > 0 : (cell.column == 5 ? config.getUnlinkedOutputs().length > 0 : (cell.column == 6 ? config.getUnboundRelationInfos().size() > 0 : cell.column == 7 && config.getPasswordInfos().size() > 0))) {
                    return ((BColor)BStatus.fault.getBackgroundColor(null)).toBrush();
                }
                return bg;
            }
            catch (Exception e) {
                return super.getBackground(cell);
            }
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BTemplateConfig config = ((Model)this.getModel()).get(row).getTemplateConfig();
            switch (column) {
                case 0: {
                    if (!(BTemplateManager.this.target instanceof BTemplateService)) break;
                    Goto cmd = new Goto(row, BTemplateManager.this.table);
                    cmd.invoke();
                    break;
                }
                case 4: {
                    BTemplateManager.this.showInputInfo(config);
                    break;
                }
                case 5: {
                    BTemplateManager.this.showOutputInfo(config);
                    break;
                }
                case 6: {
                    BTemplateManager.this.showRelationInfo(config);
                    break;
                }
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            BMenu menu = BTemplateManager.this.popupMenu(row, column);
            if (menu.getItemCount() > 0) {
                menu.open((BWidget)this.getTable(), event.getX(), event.getY());
            }
        }
    }

    public class Model
    extends TableModel {
        final ArrayList<BTemplateInfo> deployedTemplates = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initTable() {
            ArrayList<BTemplateInfo> arrayList = this.deployedTemplates;
            synchronized (arrayList) {
                this.deployedTemplates.clear();
            }
            if (BTemplateManager.this.availTemplates == null) {
                BTemplateManager.this.availTemplates = new Hashtable();
            } else {
                BTemplateManager.this.availTemplates.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(BTemplateInfo tmplInfo) {
            ArrayList<BTemplateInfo> arrayList = this.deployedTemplates;
            synchronized (arrayList) {
                this.deployedTemplates.add(tmplInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BTemplateInfo get(int row) {
            ArrayList<BTemplateInfo> arrayList = this.deployedTemplates;
            synchronized (arrayList) {
                return this.deployedTemplates.get(row);
            }
        }

        public BHalign getColumnAlignment(int col) {
            switch (col) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    return BHalign.center;
                }
            }
            return BHalign.left;
        }

        public boolean isColumnSortable(int col) {
            return col == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void sortByColumn(int col, boolean ascending) {
            ArrayList<BTemplateInfo> arrayList = this.deployedTemplates;
            synchronized (arrayList) {
                if (col != 0 || this.deployedTemplates.size() == 0) {
                    return;
                }
                Object[] names = new String[this.getRowCount()];
                for (int r = 0; r < names.length; ++r) {
                    BTemplateInfo templateInfo = this.get(r);
                    names[r] = templateInfo.getTemplateRoot().getSlotPath().getBody();
                }
                BTemplateInfo[] current = this.deployedTemplates.toArray(new BTemplateInfo[0]);
                Object[] temp = new BTemplateInfo[this.deployedTemplates.size()];
                System.arraycopy(current, 0, temp, 0, names.length);
                SortUtil.sort((Object[])names, (Object[])temp, (boolean)ascending);
                this.deployedTemplates.clear();
                this.deployedTemplates.addAll(Arrays.asList(temp));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            ArrayList<BTemplateInfo> arrayList = this.deployedTemplates;
            synchronized (arrayList) {
                return this.deployedTemplates.size();
            }
        }

        public int getColumnCount() {
            return 11;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("templateManager.root");
                }
                case 1: {
                    return lex.getText("templateManager.name");
                }
                case 2: {
                    return lex.getText("templateManager.vendor");
                }
                case 3: {
                    return lex.getText("templateManager.version");
                }
                case 4: {
                    return lex.getText("templateManager.unboundInputs");
                }
                case 5: {
                    return lex.getText("templateManager.unboundOutputs");
                }
                case 6: {
                    return lex.getText("templateManager.unboundRelations");
                }
                case 7: {
                    return lex.getText("templateManager.passwords");
                }
                case 8: {
                    return lex.getText("templateManager.availVersion");
                }
                case 9: {
                    return lex.getText("templateManager.modified");
                }
            }
            return "";
        }

        public Object getValueAt(int row, int col) {
            BTemplateInfo rowSubject = null;
            try {
                rowSubject = this.get(row);
                BTemplateConfig tmplConfig = rowSubject.getTemplateConfig();
                BComponent root = tmplConfig.getParent().asComponent();
                root.lease();
                switch (col) {
                    case 0: {
                        if (BTemplateManager.this.jobInProgress) {
                            return "-";
                        }
                        String path = root.getSlotPath().getBody();
                        int depth = rowSubject.getSubtemplateDepth();
                        if (depth == 0) {
                            return path;
                        }
                        int index = path.lastIndexOf(47);
                        if (index < 0) {
                            return path;
                        }
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < depth; ++i) {
                            sb.append("  ");
                        }
                        sb.append("..");
                        sb.append(path.substring(index));
                        return sb.toString();
                    }
                    case 1: {
                        return tmplConfig.getTemplateName();
                    }
                    case 2: {
                        Optional valueOptional = root.tags().get(TemplateConst.TEMPLATE_VENDOR_TAG_ID);
                        return valueOptional.isPresent() ? valueOptional.get() : "";
                    }
                    case 3: {
                        Optional valueOptional = root.tags().get(TemplateConst.TEMPLATE_VERSION_TAG_ID);
                        return valueOptional.isPresent() ? valueOptional.get() : "";
                    }
                    case 4: {
                        return tmplConfig.getInputSlots().length;
                    }
                    case 5: {
                        return tmplConfig.getOutputSlots().length;
                    }
                    case 6: {
                        return tmplConfig.getRelationInfos().size();
                    }
                    case 7: {
                        return tmplConfig.getPasswordInfos().size();
                    }
                    case 8: {
                        String rowVersion = rowSubject.getAvailVersion();
                        if (rowVersion == null || rowVersion.isEmpty()) {
                            rowVersion = this.getLatestVersion(tmplConfig);
                        }
                        return rowSubject.getVendor() + " " + rowVersion;
                    }
                    case 9: {
                        int modifiedState = rowSubject.getModifiedState();
                        if (modifiedState < 0) {
                            return "-";
                        }
                        if (modifiedState == 0) {
                            return "";
                        }
                        return "X";
                    }
                    case 10: {
                        return rowSubject.getStatus();
                    }
                }
                return "";
            }
            catch (Exception e) {
                return "-";
            }
        }

        private String getLatestVersion(BTemplateConfig tmplConfig) {
            TemplateManager.TemplateInfo templateInfo = (TemplateManager.TemplateInfo)BTemplateManager.this.availTemplates.get(tmplConfig.getUID());
            if (templateInfo == null) {
                return "";
            }
            BVersion latestVersion = new BVersion(templateInfo.getVendor(), templateInfo.getVersion());
            return latestVersion.getVendorVersionString();
        }

        private int getAvailState(BTemplateInfo templateInfo) {
            BTemplateConfig tmplConfig = templateInfo.getTemplateConfig();
            BVersion installedVersion = tmplConfig.getVersion();
            BVersion selectedVersion = new BVersion(templateInfo.getVendor(), templateInfo.getAvailVersion());
            TemplateManager.TemplateInfo selectedInfo = (TemplateManager.TemplateInfo)BTemplateManager.this.availTemplates.get(tmplConfig.getTemplateId());
            if (selectedInfo == null) {
                return NOT_AVAILABLE_SEL;
            }
            int results = selectedVersion.compareTo((Object)installedVersion);
            if (results > 0) {
                return OUT_OF_DATE_SEL;
            }
            if (results == 0) {
                long delta;
                BAbsTime lastModified = selectedInfo.getLastModified();
                BAbsTime versionDate = tmplConfig.getVersionDate();
                if (lastModified != null && versionDate != null && (delta = lastModified.getMillis() - versionDate.getMillis()) > 1000L) {
                    return OUT_OF_DATE_SEL;
                }
                return UP_TO_DATE_SEL;
            }
            if (results < 0) {
                return OLDER_VERSION_AVAILABLE_SEL;
            }
            return UNKNOWN_SEL;
        }

        public Object getSubject(int row) {
            return this.deployedTemplates.get(row);
        }

        public BImage getRowIcon(int row) {
            try {
                if (BTemplateManager.this.jobInProgress) {
                    return super.getRowIcon(row);
                }
                BComponent root = this.get(row).getTemplateConfig().getParent().asComponent();
                Optional valueOptional = root.tags().get(TemplateConst.TEMPLATE_ICON_TAG_ID);
                return valueOptional.isPresent() ? BImage.make((BOrd)((BOrd)valueOptional.get())) : DEFAULT_IMAGE;
            }
            catch (Exception e) {
                return super.getRowIcon(row);
            }
        }

        public boolean isOutOfDate(int row) {
            return this.getValueAt(row, 9).equals(OUT_OF_DATE);
        }

        public void initAvailTemplates() {
            TemplateManager tmInstance = new TemplateManager();
            tmInstance.initTemplateMap();
            for (int row = 0; row < this.deployedTemplates.size(); ++row) {
                BTemplateConfig tc = this.deployedTemplates.get(row).getTemplateConfig();
                BComponent parent = tc.getParent().asComponent();
                parent.lease();
                Optional optVendor = parent.tags().get(TemplateConst.TEMPLATE_VENDOR_TAG_ID);
                Optional optVersion = parent.tags().get(TemplateConst.TEMPLATE_VERSION_TAG_ID);
                Optional optUID = parent.tags().get(TemplateConst.TEMPLATE_UID_TAG_ID);
                Object key = tc.getTemplateId();
                if (BTemplateManager.this.availTemplates.contains(key) || !optVendor.isPresent()) continue;
                String tVendor = ((BIDataValue)optVendor.get()).toString();
                TemplateManager.TemplateInfo templateInfo = null;
                if (key instanceof String) {
                    templateInfo = tmInstance.getTemplate((String)key, tVendor);
                } else if (key instanceof BUuid) {
                    templateInfo = tmInstance.getTemplate((BUuid)key, tVendor);
                }
                if (templateInfo == null || BTemplateManager.this.availTemplates.contains(key)) continue;
                BTemplateManager.this.availTemplates.put(key, templateInfo);
            }
        }

        public void initVersionStatus() {
            for (BTemplateInfo templateRow : this.deployedTemplates) {
                BTemplateConfig tc = templateRow.getTemplateConfig();
                templateRow.setAvailVersion(this.getLatestVersion(tc));
                templateRow.setState(this.getAvailState(templateRow));
                templateRow.setStatus(VERSION_STATUS[templateRow.getState()]);
            }
        }
    }

    public class ComponentBulkDeploy
    extends BulkDeploy {
        public ComponentBulkDeploy() {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.bulkDeploy"));
        }

        @Override
        public CommandArtifact doInvoke() throws Exception {
            if (BTemplateManager.this.isTemplateEditor) {
                return null;
            }
            this.doDeploy();
            BTemplateManager.this.doLoadValue((BObject)BTemplateManager.this.templateService, null);
            return null;
        }
    }

    public class Bind
    extends Command {
        IoSlotInfo slotInfo;
        BTemplateConfig config;
        boolean displayBindInfo;
        Hashtable<String, Object> cache;

        public Bind(Slot slot, BTemplateConfig config, boolean isInput, boolean displayBindInfo, Hashtable<String, Object> cache) {
            super((BWidget)BTemplateManager.this, slot.getName());
            this.displayBindInfo = false;
            this.slotInfo = new IoSlotInfo(slot, isInput, config);
            this.config = config;
            this.displayBindInfo = displayBindInfo;
            this.cache = cache;
        }

        public Bind(Slot slot, BTemplateConfig config, boolean isInput, boolean displayBindInfo) {
            super((BWidget)BTemplateManager.this, slot.getName());
            this.displayBindInfo = false;
            this.slotInfo = new IoSlotInfo(slot, isInput, config);
            this.config = config;
            this.displayBindInfo = displayBindInfo;
        }

        public Bind(BRelationInfo relateInfo, BTemplateConfig config, Hashtable<String, Object> cache) {
            super((BWidget)BTemplateManager.this, SlotPath.escape((String)relateInfo.getRelationId()));
            this.displayBindInfo = false;
            this.slotInfo = new IoSlotInfo(relateInfo, config);
            this.config = config;
            this.cache = cache;
        }

        public void setDisplayBindInfo(boolean value) {
            this.displayBindInfo = value;
        }

        public CommandArtifact doInvoke() throws Exception {
            TmplUtil.BindInfo results;
            BTemplateManager.this.abort = false;
            if (this.displayBindInfo) {
                BTemplateManager.this.bindInfo.clear();
            }
            BComponent parent = this.config.getParent().asComponent();
            BTemplateManager.this.getSearchService(parent);
            if (this.slotInfo.relationInfo != null) {
                String relateHints = this.slotInfo.bindHints;
                if (relateHints != null && !relateHints.isEmpty()) {
                    BTemplateManager.this.statusListener.accept(lex.getText("deploy.searchForRelatedComp") + " " + relateHints);
                    String cacheKey = this.config.getUID() + relateHints;
                    Object source = null;
                    if (this.cache != null && this.cache.containsKey(cacheKey)) {
                        source = this.cache.get(cacheKey);
                        BTemplateManager.this.relateSource(source, parent, this.slotInfo);
                    } else {
                        this.slotInfo.choices = TmplUtil.findMatchingObjects(this.slotInfo, BTemplateManager.this.searchService, BTemplateManager.this.templateService, (BComponent)this.config, lex);
                        if (this.slotInfo.choices != null && this.slotInfo.choices.length > 0) {
                            source = TmplUtil.selectRelationSource((BWidget)BTemplateManager.this.owner, this.slotInfo, this.config, true, lex);
                            BTemplateManager.this.abort = this.slotInfo.abort;
                            if (!BTemplateManager.this.abort && source != null) {
                                BTemplateManager.this.relateSource(source, parent, this.slotInfo);
                                if (this.slotInfo.lastSelected != null && this.cache != null) {
                                    this.cache.put(cacheKey, this.slotInfo.lastSelected);
                                }
                            } else {
                                this.slotInfo.results = 23;
                            }
                        } else {
                            this.slotInfo.results = 22;
                        }
                    }
                } else {
                    this.slotInfo.results = 21;
                }
            } else if (this.slotInfo.bindHints.isEmpty()) {
                this.slotInfo.results = this.slotInfo.isInput ? 1 : 11;
            } else if (this.slotInfo.isInput) {
                BTemplateManager.this.statusListener.accept(lex.getText("deploy.searchForInputComp") + " " + this.slotInfo.bindHints);
                String cacheKey = this.config.getUID() + this.slotInfo.bindHints;
                Object selectInput = null;
                if (this.cache != null && this.cache.containsKey(cacheKey)) {
                    selectInput = this.cache.get(cacheKey);
                    BTemplateManager.this.linkSource(selectInput, parent, this.slotInfo);
                } else {
                    this.slotInfo.choices = TmplUtil.findMatchingObjects(this.slotInfo, BTemplateManager.this.searchService, BTemplateManager.this.templateService, (BComponent)this.config, lex);
                    if (this.slotInfo.choices != null && this.slotInfo.choices.length > 0) {
                        selectInput = TmplUtil.selectInputSource((BWidget)BTemplateManager.this.owner, this.slotInfo, this.config, true, lex);
                        BTemplateManager.this.abort = this.slotInfo.abort;
                        if (!BTemplateManager.this.abort && selectInput != null) {
                            BTemplateManager.this.linkSource(selectInput, parent, this.slotInfo);
                            if (this.slotInfo.lastSelected != null && this.cache != null) {
                                this.cache.put(cacheKey, this.slotInfo.lastSelected);
                            }
                        } else {
                            this.slotInfo.results = 3;
                        }
                    } else {
                        this.slotInfo.results = 2;
                    }
                }
            } else {
                BTemplateManager.this.statusListener.accept(lex.getText("deploy.searchForInputComp") + " " + this.slotInfo.bindHints);
                this.slotInfo.choices = TmplUtil.findMatchingObjects(this.slotInfo, BTemplateManager.this.searchService, BTemplateManager.this.templateService, (BComponent)this.config, lex);
                if (this.slotInfo.choices != null && this.slotInfo.choices.length > 0) {
                    Object targets = TmplUtil.selectOutputTargets((BWidget)BTemplateManager.this.owner, this.slotInfo, this.config, true, lex);
                    BTemplateManager.this.abort = this.slotInfo.abort;
                    if (!BTemplateManager.this.abort && targets != null) {
                        BTemplateManager.this.linkTarget(targets, parent, this.slotInfo);
                    } else {
                        this.slotInfo.results = 13;
                    }
                } else {
                    this.slotInfo.results = 12;
                }
            }
            if (BTemplateManager.this.abort && BTemplateManager.this.isDeploy) {
                throw new RuntimeException(lex.getText("templateManager.deploy.aborted"));
            }
            if (BTemplateManager.this.abort) {
                return null;
            }
            if (this.config != null) {
                this.config.clearCacheValues();
            }
            if ((results = TmplUtil.formatBindResults(this.slotInfo, lex)) != null) {
                BTemplateManager.this.bindInfo.add((Object)results);
            }
            if (this.displayBindInfo) {
                BTemplateManager.this.displayBindInfo();
            }
            parent.lease();
            return null;
        }
    }

    public class BindSelection
    extends Command {
        BTable table;

        public BindSelection(BTable table) {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.bindSelection"));
            this.table = table;
        }

        public CommandArtifact doInvoke() throws Exception {
            BTemplateManager.this.bindInfo.clear();
            BTemplateManager.this.abort = false;
            BTemplateManager.this.cache = new Hashtable();
            Model model = (Model)this.table.getModel();
            TableSelection selection = this.table.getSelection();
            try {
                for (int i : selection.getRows()) {
                    if (!BTemplateManager.this.abort) {
                        Bind bindCommand;
                        BTemplateConfig config = ((BTemplateInfo)model.getSubject(i)).getTemplateConfig();
                        BComponent parent = config.getParent().asComponent();
                        BTemplateManager.this.getSearchService(parent);
                        for (Slot slot : config.getUnlinkedInputs()) {
                            bindCommand = new Bind(slot, config, true, false, BTemplateManager.this.cache);
                            bindCommand.doInvoke();
                            if (BTemplateManager.this.abort) break;
                        }
                        if (!BTemplateManager.this.abort) {
                            for (Slot slot : config.getUnlinkedOutputs()) {
                                bindCommand = new Bind(slot, config, false, false);
                                bindCommand.doInvoke();
                                if (BTemplateManager.this.abort) break;
                            }
                        }
                        if (!BTemplateManager.this.abort) {
                            ArrayList unboundRelationInfos = config.getUnboundRelationInfos();
                            for (BRelationInfo relateInfo : unboundRelationInfos) {
                                BTemplateManager.this.bindRelations(relateInfo, config, BTemplateManager.this.cache);
                                if (!BTemplateManager.this.abort) continue;
                                break;
                            }
                        }
                        config.clearCacheValues();
                        parent.lease(1);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error running command :" + this.toString(), e);
            }
            BTemplateManager.this.displayBindInfo();
            return null;
        }
    }

    public class UpgradeAll
    extends Command {
        BTable table;

        public UpgradeAll(BTable table) {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.updateAll"));
            this.table = table;
        }

        public CommandArtifact doInvoke() throws Exception {
            Model model = (Model)this.table.getModel();
            int rowCount = model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                BTemplateInfo templateRow = model.get(i);
                if (templateRow.getState() != OUT_OF_DATE_SEL && templateRow.getState() != UPGRADE_SEL) continue;
                String rowVersion = templateRow.getAvailVersion();
                if (rowVersion == null || rowVersion.isEmpty()) {
                    rowVersion = model.getLatestVersion(templateRow.getTemplateConfig());
                }
                templateRow.setStatus("Upgrade to " + rowVersion);
                templateRow.setState(UPGRADE_SEL);
                for (Relation relation : templateRow.relations().getAll(TemplateConst.TEMPLATE_SUBTEMPLATE_TAG_ID, 2)) {
                    Entity endpoint = relation.getEndpoint();
                    if (!(endpoint instanceof BTemplateInfo)) continue;
                    BTemplateInfo subTmpl = (BTemplateInfo)endpoint;
                    String subTmplVersion = subTmpl.getAvailVersion();
                    if (subTmplVersion == null || subTmplVersion.isEmpty()) {
                        subTmplVersion = model.getLatestVersion(subTmpl.getTemplateConfig());
                    }
                    subTmpl.setStatus("Upgrade to " + subTmplVersion);
                }
            }
            BTemplateManager.this.doUpdateCommands();
            return null;
        }
    }

    public class Redeploy
    extends Command {
        BTable table;

        public Redeploy(BTable table) {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.redeploy"));
            this.table = table;
        }

        public CommandArtifact doInvoke() throws Exception {
            Model model = (Model)this.table.getModel();
            for (int i : this.table.getSelection().getRows()) {
                BTemplateInfo templateRow = model.get(i);
                templateRow.lease();
                if (!templateRow.getStatus().equals(UP_TO_DATE)) continue;
                String rowVersion = templateRow.getAvailVersion();
                if (rowVersion == null || rowVersion.isEmpty()) {
                    rowVersion = model.getLatestVersion(templateRow.getTemplateConfig());
                }
                templateRow.setStatus("Redeploy " + rowVersion);
                templateRow.setState(REDEPLOY_SEL);
                for (Relation relation : templateRow.relations().getAll(TemplateConst.TEMPLATE_SUBTEMPLATE_TAG_ID)) {
                    Entity endpoint;
                    if (relation.isInbound() || !((endpoint = relation.getEndpoint()) instanceof BTemplateInfo)) continue;
                    BTemplateInfo subTmpl = (BTemplateInfo)endpoint;
                    String subTmplVersion = subTmpl.getAvailVersion();
                    if (subTmplVersion == null || subTmplVersion.isEmpty()) {
                        subTmplVersion = model.getLatestVersion(subTmpl.getTemplateConfig());
                    }
                    subTmpl.setStatus("Redeploy " + subTmplVersion);
                    subTmpl.lease();
                }
            }
            BTemplateManager.this.doUpdateCommands();
            return null;
        }
    }

    public class Downgrade
    extends Command {
        BTable table;

        public Downgrade(BTable table) {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.downgrade"));
            this.table = table;
        }

        public CommandArtifact doInvoke() throws Exception {
            Model model = (Model)this.table.getModel();
            for (int i : this.table.getSelection().getRows()) {
                BTemplateInfo templateRow = model.get(i);
                if (!templateRow.getStatus().equals(OLDER_VERSION_AVAILABLE)) continue;
                String rowVersion = templateRow.getAvailVersion();
                if (rowVersion == null || rowVersion.isEmpty()) {
                    rowVersion = model.getLatestVersion(templateRow.getTemplateConfig());
                }
                templateRow.setStatus("Downgrade to " + rowVersion);
                templateRow.setState(DOWNGRADE_SEL);
                for (Relation relation : templateRow.relations().getAll(TemplateConst.TEMPLATE_SUBTEMPLATE_TAG_ID)) {
                    Entity endpoint = relation.getEndpoint();
                    if (!(endpoint instanceof BTemplateInfo)) continue;
                    BTemplateInfo subTmpl = (BTemplateInfo)endpoint;
                    String subTmplVersion = subTmpl.getAvailVersion();
                    if (subTmplVersion == null || subTmplVersion.isEmpty()) {
                        subTmplVersion = model.getLatestVersion(subTmpl.getTemplateConfig());
                    }
                    subTmpl.setState(DOWNGRADE_SEL);
                    subTmpl.setStatus("Downgrade to " + subTmplVersion);
                }
            }
            BTemplateManager.this.doUpdateCommands();
            return null;
        }
    }

    public class Upgrade
    extends Command {
        BTable table;

        public Upgrade(BTable table) {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.update"));
            this.table = table;
        }

        public CommandArtifact doInvoke() throws Exception {
            Model model = (Model)this.table.getModel();
            for (int i : this.table.getSelection().getRows()) {
                BTemplateInfo templateRow = model.get(i);
                if (templateRow.getState() != OUT_OF_DATE_SEL && templateRow.getState() != UPGRADE_SEL) continue;
                String rowVersion = templateRow.getAvailVersion();
                if (rowVersion == null || rowVersion.isEmpty()) {
                    rowVersion = model.getLatestVersion(templateRow.getTemplateConfig());
                }
                templateRow.setStatus("Upgrade to " + rowVersion);
                templateRow.setState(UPGRADE_SEL);
                for (Relation relation : templateRow.relations().getAll(TemplateConst.TEMPLATE_SUBTEMPLATE_TAG_ID)) {
                    Entity endpoint;
                    if (relation.isInbound() || !((endpoint = relation.getEndpoint()) instanceof BTemplateInfo)) continue;
                    BTemplateInfo subTmpl = (BTemplateInfo)endpoint;
                    String subTmplVersion = subTmpl.getAvailVersion();
                    if (subTmplVersion == null || subTmplVersion.isEmpty()) {
                        subTmplVersion = model.getLatestVersion(subTmpl.getTemplateConfig());
                    }
                    subTmpl.setStatus("Upgrade to " + subTmplVersion);
                }
            }
            BTemplateManager.this.doUpdateCommands();
            return null;
        }
    }

    public class Untemplate
    extends Command {
        BTable table;

        public Untemplate(BTable table) {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.untemplate"));
            this.table = table;
        }

        public CommandArtifact doInvoke() throws Exception {
            BGridPane gridPane = new BGridPane(1);
            gridPane.setHalign(BHalign.right);
            BCheckBox rcsCb = new BCheckBox(lex.getText("templateManager.removeCompositeSlots"));
            rcsCb.setHalign(BHalign.right);
            BLabel warning = new BLabel(lex.getText("templateManager.untemplateWarning"));
            warning.setHalign(BHalign.left);
            gridPane.add(null, (BValue)warning);
            gridPane.add(null, (BValue)new BLabel());
            gridPane.add(null, (BValue)rcsCb);
            rcsCb.setSelected(true);
            Model model = (Model)this.table.getModel();
            BOptionDialog dlg = new BOptionDialog((BWidget)BTemplateManager.this.manager, lex.getText("templateManager.untemplate"), (BWidget)gridPane, 12, BImage.make((String)"module://icons/x32/warning.png"), null);
            dlg.computePreferredSize();
            dlg.setBoundsCenteredOnOwner();
            dlg.open();
            if (dlg.getResult() == 4) {
                for (int i : this.table.getSelection().getRows()) {
                    BTemplateInfo templateRow = model.get(i);
                    BTemplateConfig templateConfig = templateRow.getTemplateConfig();
                    BComponent root = templateConfig.getParent().asComponent();
                    this.untemplate(templateConfig, rcsCb.isSelected());
                    for (BTemplateConfig subtemplateConfig : (BTemplateConfig[])CompUtil.getDescendants((BComponent)root, BTemplateConfig.class)) {
                        this.untemplate(subtemplateConfig, rcsCb.isSelected());
                    }
                }
                BTemplateManager.this.updateTable(BTemplateManager.this.target);
                BTemplateManager.this.doUpdateCommands();
            }
            return null;
        }

        void untemplate(BTemplateConfig templateConfig, boolean removeCompositeSlots) {
            BComponent root = templateConfig.getParent().asComponent();
            log.info("Un-template " + root.getSlotPath());
            root.lease();
            root.remove((BComplex)templateConfig);
            if (root.getSlot("icon") != null) {
                root.remove("icon");
            }
            if (root.getSlot(ROOT_TAG_NAME) != null) {
                root.remove(ROOT_TAG_NAME);
            }
            if (root.getSlot(NTPL_FILE_TAG_NAME) != null) {
                root.remove(NTPL_FILE_TAG_NAME);
            }
            if (root.getSlot(VENDOR_TAG_NAME) != null) {
                root.remove(VENDOR_TAG_NAME);
            }
            if (root.getSlot(VERSION_TAG_NAME) != null) {
                root.remove(VERSION_TAG_NAME);
            }
            if (root.getSlot(INFO_TAG_NAME) != null) {
                root.remove(INFO_TAG_NAME);
            }
            root.getParent().loadSlots();
            if (removeCompositeSlots) {
                for (BLink bLink : root.getLinks()) {
                    if (!LinkUtil.isCompositeLink((BLink)bLink)) continue;
                    String targetSlot = bLink.getTargetSlotName();
                    String sourceSlot = bLink.getSourceSlotName();
                    boolean compositeSlotRemoved = false;
                    for (Knob knob : root.getKnobs(root.getSlot(targetSlot))) {
                        BComponent targetComponent = knob.getTargetOrd().resolve((BObject)root).get().asComponent();
                        String knobTargetSlot = knob.getTargetSlotName();
                        root.remove(targetSlot);
                        log.fine("removing linked output composite slot: " + targetSlot);
                        compositeSlotRemoved = true;
                        BLink newLink = new BLink(bLink.getSourceOrd(), sourceSlot, knobTargetSlot, true);
                        targetComponent.add("l?", (BValue)newLink);
                        log.fine("added link: " + targetComponent.getSlotPath() + "." + knobTargetSlot);
                    }
                    if (compositeSlotRemoved) continue;
                    root.remove(targetSlot);
                    log.fine("removed unlinked output composite slot: " + targetSlot);
                }
                for (BLink bLink : root.getKnobs()) {
                    String targetSlotName = bLink.getTargetSlotName();
                    String sourceSlotName = bLink.getSourceSlotName();
                    Slot sourceSlot = root.getSlot(sourceSlotName);
                    if (!Flags.isComposite((BComplex)root, (Slot)sourceSlot)) continue;
                    boolean compositeSlotRemoved = false;
                    BComponent targetComponent = bLink.getTargetOrd().resolve((BObject)root).get().asComponent();
                    for (BLink extLink : root.getLinks(sourceSlot)) {
                        String linkSourceSlot = extLink.getSourceSlotName();
                        root.remove(sourceSlot.asProperty());
                        log.fine("removing linked input composite slot: " + sourceSlotName);
                        compositeSlotRemoved = true;
                        BLink newLink = new BLink(extLink.getSourceOrd(), linkSourceSlot, targetSlotName, true);
                        targetComponent.add("l?", (BValue)newLink);
                        log.fine("added link to: " + targetComponent.getSlotPath() + '.' + targetSlotName);
                    }
                    if (compositeSlotRemoved) continue;
                    root.remove(sourceSlot.asProperty());
                    log.fine("removing unlinked input composite slot: " + sourceSlotName);
                }
            }
        }
    }

    public class Commit
    extends Command {
        BTable table;

        public Commit(BTable table) {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.commit"));
            this.table = table;
        }

        public CommandArtifact doInvoke() throws Exception {
            return this.doInvoke(false);
        }

        public CommandArtifact doInvoke(boolean noPrompt) throws Exception {
            block11: {
                Model model = (Model)this.table.getModel();
                try {
                    int confirm = 4;
                    if (!noPrompt) {
                        confirm = BDialog.confirm((BWidget)BTemplateManager.this.manager, (String)lex.getText("TemplateManager.commitTemplate.title"), (Object)lex.getText("TemplateManager.commitTemplate.message"));
                    }
                    if (confirm != 4) break block11;
                    BTemplateManager.this.commitInProgress = true;
                    BTemplateManager.this.doUpdateCommands();
                    int rowCount = model.getRowCount();
                    BTemplateManager.this.vector = new BVector();
                    for (int i = 0; i < rowCount; ++i) {
                        BTemplateInfo subject = (BTemplateInfo)model.getSubject(i);
                        if (subject.getState() != UPGRADE_SEL && subject.getState() != DOWNGRADE_SEL && subject.getState() != REDEPLOY_SEL) continue;
                        BTemplateConfig config = subject.getTemplateConfig();
                        BOrd slotPathOrd = subject.getSlotPathOrd();
                        BComponent deployedRoot = config.getParent().asComponent();
                        deployedRoot.loadSlots();
                        TemplateManager.TemplateInfo templateInfo = (TemplateManager.TemplateInfo)BTemplateManager.this.availTemplates.get(config.getTemplateId());
                        BNtplFile ntplFile = templateInfo.getNtplFile();
                        BWbDeployableNtplFile deployableNtplFile = ntplFile instanceof BWbDeployableNtplFile ? (BWbDeployableNtplFile)ntplFile : BWbDeployableNtplFile.make(ntplFile);
                        if (!BTemplateManager.this.isTemplateEditor && UpdateUtil.updateNtplFile(deployableNtplFile, deployedRoot)) {
                            BTemplateManager.this.vector.add("v?", (BValue)slotPathOrd);
                            continue;
                        }
                        UpgradeUtil.upgrade((BComponent)deployedRoot, (BObject)ntplFile);
                        subject.setState(UPGRADE_SEL);
                    }
                    if (BTemplateManager.this.isOffline) {
                        for (BOrd bOrd : (BOrd[])BTemplateManager.this.vector.getChildren(BOrd.class)) {
                            OrdTarget ordTarget = bOrd.resolve((BObject)BTemplateManager.this.target);
                            if (ordTarget != null) {
                                BObject bObject = ordTarget.get();
                                if (bObject instanceof BTemplateConfig) {
                                    BTemplateManager.this.templateConfig = (BTemplateConfig)bObject;
                                } else if (bObject instanceof BTemplateInfo) {
                                    BTemplateInfo tmplInfo = (BTemplateInfo)bObject;
                                    BTemplateManager.this.templateConfig = tmplInfo.getTemplateConfig();
                                }
                            }
                            if (BTemplateManager.this.templateConfig == null) continue;
                            UpgradeUtil.upgradeTemplates((BTemplateConfig)BTemplateManager.this.templateConfig);
                        }
                        BTemplateManager.this.doLoadValue((BObject)BTemplateManager.this.target, null);
                        break block11;
                    }
                    BOrd ordToJob = BTemplateManager.this.templateService.submitUpgradeJob(BTemplateManager.this.vector);
                    BTemplateManager.this.jobInProgress = true;
                    BTemplateManager.this.templateService.getComponentSpace().sync();
                    BTemplateManager.this.job = (BJob)ordToJob.get((BObject)BTemplateManager.this.templateService);
                    BTemplateManager.this.registerForComponentEvents((BComponent)BTemplateManager.this.job);
                    BTemplateManager.this.jobBar.load(BTemplateManager.this.job);
                    BTemplateManager.this.commitInProgress = false;
                    return null;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Error running command :" + this.toString(), e);
                }
            }
            BTemplateManager.this.commitInProgress = false;
            return null;
        }
    }

    public class Reset
    extends Command {
        BTable table;

        public Reset(BTable table) {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.reset"));
            this.table = table;
        }

        public CommandArtifact doInvoke() throws Exception {
            Model model = (Model)this.table.getModel();
            model.initVersionStatus();
            BTemplateManager.this.doUpdateCommands();
            BTemplateManager.this.tablePane.tableModified();
            return null;
        }
    }

    public class GotoComponent
    extends Command {
        int row;
        BTable table;

        public GotoComponent(int row, BTable table) {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.gotoComponent"));
            this.row = row;
            this.table = table;
        }

        public BOrd getTargetOrd() {
            Model model = (Model)this.table.getModel();
            BComponent root = model.get(this.row).getTemplateParent();
            return BOrd.make((String)("slot:" + root.toPathString()));
        }

        public CommandArtifact doInvoke() {
            BOrd targetOrd = this.getTargetOrd();
            if (targetOrd == null) {
                return null;
            }
            BOrd authority = ((BWbShell)BTemplateManager.this.getShell()).getActiveOrd();
            BOrd hyperlinkOrd = BOrd.make((BOrd)authority, (BOrd)targetOrd).normalize();
            ((BWbShell)this.getShell()).hyperlink(hyperlinkOrd);
            return null;
        }
    }

    public class Goto
    extends Command {
        int row;
        BTable table;

        public Goto(int row, BTable table) {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.goto"));
            this.row = row;
            this.table = table;
        }

        public BOrd getTargetOrd() {
            Model model = (Model)this.table.getModel();
            BTemplateInfo templateInfo = model.get(this.row);
            return templateInfo.getTemplateRoot().getHandleOrd();
        }

        public CommandArtifact doInvoke() {
            BOrd targetOrd = this.getTargetOrd();
            if (targetOrd == null) {
                return null;
            }
            if ((BWbShell)BTemplateManager.this.getShell() != null) {
                BOrd authority = ((BWbShell)BTemplateManager.this.getShell()).getActiveOrd();
                BOrd hyperlinkOrd = BOrd.make((BOrd)authority, (BOrd)targetOrd).normalize();
                ((BWbShell)this.getShell()).hyperlink(hyperlinkOrd);
            }
            return null;
        }
    }

    private class GotoPassword
    extends Command {
        BPasswordBinding pswBinding;

        public GotoPassword(BPasswordBinding pswBinding) {
            super((BWidget)BTemplateManager.this, lex.get("templateManager.gotoPsw"));
            this.pswBinding = pswBinding;
        }

        BOrd getTargetOrd() {
            return this.pswBinding.getPswOrd();
        }

        public CommandArtifact doInvoke() {
            BOrd targetOrd = this.getTargetOrd();
            if (targetOrd == null) {
                return null;
            }
            BOrd authority = ((BWbShell)BTemplateManager.this.getShell()).getActiveOrd();
            BOrd hyperlinkOrd = BOrd.make((BOrd)authority, (BOrd)targetOrd).normalize();
            ((BWbShell)this.getShell()).hyperlink(hyperlinkOrd);
            return null;
        }
    }
}

