/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.template.BTemplateService;
import com.tridium.template.application.ApplicationTemplateUtil;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.template.ui.BTemplateBogEditor;
import com.tridium.template.ui.MarkAsOptionalCommand;
import com.tridium.template.ui.TemplateUiUtil;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.template.ui.file.ExportApplicationCommand;
import com.tridium.template.ui.file.TmplUtil;
import com.tridium.template.ui.installapp.InstallApplicationCommand;
import com.tridium.template.ui.upgradeapp.UpgradeApplicationCommand;
import com.tridium.workbench.nav.BComponentMenuAgent;
import com.tridium.workbench.nav.BIComponentMenuDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.tree.BNavTree;

@NiagaraType(agent={@AgentOn(types={"workbench:ComponentMenuAgent"})})
@NiagaraSingleton
public final class BTemplateComponentMenuDecorator
extends BSingleton
implements BIComponentMenuDecorator {
    @Generated
    public static final BTemplateComponentMenuDecorator INSTANCE = new BTemplateComponentMenuDecorator();
    @Generated
    public static final Type TYPE = Sys.loadType(BTemplateComponentMenuDecorator.class);
    private static final Lexicon LEX = Lexicon.make(BTemplateComponentMenuDecorator.class);

    private BTemplateComponentMenuDecorator() {
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void decorateMenu(BComponentMenuAgent menuAgent, BMenu menu, BWidget owner, BComponent target, Context cx) {
        int startIndex;
        if (!BTemplateComponentMenuDecorator.isLicensed()) {
            return;
        }
        if (!BTemplateComponentMenuDecorator.isChildTemplateConfigAllowed(target)) {
            return;
        }
        ArrayList<Property> properties = new ArrayList<Property>(Arrays.asList(menu.getDynamicPropertiesArray()));
        int addIndex = startIndex = BTemplateComponentMenuDecorator.findStartIndexForTemplateCommands(properties, menu) + 1;
        if (!BTemplateComponentMenuDecorator.isTemplateEditorNav(owner)) {
            if (target instanceof BStation) {
                BMenu templatesMenu = new BMenu(UiLexicon.bajaui().get("commands.templates.label"));
                BStation station = (BStation)target;
                templatesMenu.add(null, (Command)MakeTemplateCommand.makeStationTemplateCommand(owner, (BComponent)station));
                templatesMenu.add(null, (Command)MakeTemplateCommand.makeApplicationTemplateCommand(owner, (BComponent)station));
                if (TemplateUiUtil.isSuperUser((BComponent)station)) {
                    templatesMenu.add(null, (Command)new InstallApplicationCommand(owner, station));
                    BNtplFile upgradeFile = ApplicationTemplateUtil.getApplicationUpgrade((BStation)station);
                    if (upgradeFile instanceof BWbDeployableNtplFile) {
                        templatesMenu.add(null, (Command)new UpgradeApplicationCommand(owner, station, upgradeFile.getAbsoluteOrd()));
                    }
                }
                if (!ApplicationTemplateUtil.getStationApplicationId((BStation)station).isNull()) {
                    templatesMenu.add(null, (Command)new ExportApplicationCommand(owner, station));
                }
                BTemplateComponentMenuDecorator.addPropertyToList(properties, ++addIndex, menu.add(null, (BValue)new BSubMenuItem((BIMenu)templatesMenu)));
            } else {
                Property property = menu.add(null, (Command)MakeTemplateCommand.makeTemplateCommand(owner, target)).getPropertyInParent();
                BTemplateComponentMenuDecorator.addPropertyToList(properties, ++addIndex, property);
            }
        } else if (BTemplateComponentMenuDecorator.isApplicationTemplateEditorNav(owner) && BTemplateComponentMenuDecorator.canBeAnOptionalComponent(target, owner)) {
            Property property = menu.add(null, (Command)new MarkAsOptionalCommand(owner, BTemplateComponentMenuDecorator.getManifest(owner))).getPropertyInParent();
            BTemplateComponentMenuDecorator.addPropertyToList(properties, ++addIndex, property);
        }
        if (addIndex > startIndex) {
            BTemplateComponentMenuDecorator.addPropertyToList(properties, ++addIndex, menu.add(null, (BValue)new BSeparator()));
        }
        menu.reorder(properties.toArray(new Property[0]));
    }

    private static TemplateManifest getManifest(BWidget owner) {
        for (BWidget container = owner.getParentWidget(); container != null; container = container.getParentWidget()) {
            if (!container.getType().is(BTemplateBogEditor.TYPE)) continue;
            BTemplateBogEditor bogEditor = (BTemplateBogEditor)container;
            return bogEditor.getManifest();
        }
        return null;
    }

    private static boolean isApplicationTemplateEditorNav(BWidget owner) {
        if (!owner.getType().is(BNavTree.TYPE)) {
            return false;
        }
        BTemplateBogEditor bogEditor = BTemplateComponentMenuDecorator.findTemplateBogEditor(owner);
        return bogEditor != null && bogEditor.isApplicationTemplate();
    }

    private static boolean isTemplateEditorNav(BWidget owner) {
        if (!owner.getType().is(BNavTree.TYPE)) {
            return false;
        }
        return BTemplateComponentMenuDecorator.findTemplateBogEditor(owner.getParentWidget()) != null;
    }

    private static BTemplateBogEditor findTemplateBogEditor(BWidget owner) {
        for (BWidget container = owner; container != null; container = container.getParentWidget()) {
            if (!container.getType().is(BTemplateBogEditor.TYPE)) continue;
            return (BTemplateBogEditor)container;
        }
        return null;
    }

    private static boolean canBeAnOptionalComponent(BComponent component, BWidget owner) {
        TemplateManifest manifest = BTemplateComponentMenuDecorator.getManifest(owner);
        if (manifest == null) {
            return false;
        }
        return MarkAsOptionalCommand.canBeAnOptionalComponent(component, manifest);
    }

    private static void addPropertyToList(List<Property> properties, int index, Property newProperty) {
        if (index >= properties.size()) {
            properties.add(newProperty);
        } else {
            properties.add(index, newProperty);
        }
    }

    private static boolean isLicensed() {
        try {
            Feature feature = Sys.getLicenseManager().getFeature("tridium", "template");
            feature.check();
            return true;
        }
        catch (FeatureNotLicensedException e) {
            return false;
        }
    }

    private static boolean isChildTemplateConfigAllowed(BComponent comp) {
        try {
            BComponent templateConfig = (BComponent)BTypeSpec.make((String)"template", (String)"TemplateConfig").getInstance();
            return comp.isChildLegal(templateConfig);
        }
        catch (Exception err) {
            return false;
        }
    }

    private static int findStartIndexForTemplateCommands(List<Property> properties, BMenu menu) {
        int addIndex = properties.size() - 1;
        for (int i = 0; i < properties.size(); ++i) {
            BMenuItem menuItem;
            BValue value = menu.get(properties.get(i));
            if (!(value instanceof BMenuItem) || !((menuItem = (BMenuItem)value).getCommand() instanceof BComponentMenuAgent.EditTagsCommand)) continue;
            addIndex = i;
            break;
        }
        return addIndex;
    }

    private static String getLogMessagePrefix(boolean createApp) {
        if (createApp) {
            return "makeApplication.";
        }
        return "makeStationTemplate.";
    }

    private static void hyperlink(BWidget owner, BOrd ord) {
        BWbShell shell = BWbShell.getWbShell((BWidget)owner);
        if (shell != null) {
            shell.hyperlink(ord);
        }
    }

    private static final class MakeTemplateCommand
    extends Command {
        private final boolean createApp;
        private final BComponent target;

        private MakeTemplateCommand(BWidget owner, BComponent c, String keyBase, boolean createApp) {
            super(owner, (Lexicon)UiLexicon.bajaui(), keyBase);
            this.target = c;
            this.createApp = createApp;
        }

        private static MakeTemplateCommand makeStationTemplateCommand(BWidget owner, BComponent comp) {
            return new MakeTemplateCommand(owner, comp, "commands.makeStationTemplate", false);
        }

        private static MakeTemplateCommand makeTemplateCommand(BWidget owner, BComponent comp) {
            return new MakeTemplateCommand(owner, comp, "commands.makeTemplate", false);
        }

        private static MakeTemplateCommand makeApplicationTemplateCommand(BWidget owner, BComponent comp) {
            return new MakeTemplateCommand(owner, comp, "commands.makeApplicationTemplate", true);
        }

        public CommandArtifact doInvoke() {
            BStation station;
            boolean goAhead = true;
            if (this.target instanceof BStation && TmplUtil.stationHasAce(station = (BStation)this.target)) {
                boolean templateServiceIsCapable;
                BComponentSpace space = station.getComponentSpace();
                boolean isOnline = space != null && space.isProxyComponentSpace();
                BTemplateService templateService = TemplateUiUtil.resolveTemplateService(station);
                boolean bl = templateService != null && templateService.getAction(this.createApp ? "makeApplicationTemplate" : "makeStationTemplate") != null ? true : (templateServiceIsCapable = false);
                if (isOnline) {
                    if (!TemplateUiUtil.isSuperUser((BComponent)station)) {
                        goAhead = 4 == BDialog.confirm((BWidget)this.getOwner(), (Object)LEX.get(BTemplateComponentMenuDecorator.getLogMessagePrefix(this.createApp) + "lesserUser"));
                    } else if (!templateServiceIsCapable) {
                        boolean bl2 = goAhead = 4 == BDialog.confirm((BWidget)this.getOwner(), (Object)LEX.get(BTemplateComponentMenuDecorator.getLogMessagePrefix(this.createApp) + "missingService"));
                    }
                }
            }
            if (goAhead) {
                BTemplateComponentMenuDecorator.hyperlink(this.getOwner(), BOrd.make((BOrd)this.target.getAbsoluteOrd(), (String)(this.createApp ? "template:createApp" : "template:create")));
            }
            return null;
        }
    }
}

