/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.util.metrics.mstp;

import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.util.point.BPeriodicNumericPoint;
import com.tridium.bacnet.util.point.EventsPerSecond;
import com.tridium.platMstp.EmstpStats;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicLong;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="receivedTokens", type="long", defaultValue="0"), @NiagaraProperty(name="generatedTokens", type="long", defaultValue="0"), @NiagaraProperty(name="parseAllMetrics", type="boolean", defaultValue="false"), @NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.makeNumeric(BUnit.getUnit(\"per second\"), 1)", override=true)})
public class BTokens
extends BPeriodicNumericPoint
implements EventsPerSecond {
    @Generated
    public static final Property receivedTokens = BTokens.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property generatedTokens = BTokens.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property parseAllMetrics = BTokens.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property facets = BTokens.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"per second"), (int)1), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTokens.class);
    private final AtomicLong recTokens = new AtomicLong();
    private final AtomicLong genTokens = new AtomicLong();
    private long lastExecute = 0L;
    private InputStream inputStream = null;
    private volatile boolean fileNotFound = false;
    public static final String PREFIX_CHAR = "n";

    @Generated
    public long getReceivedTokens() {
        return this.getLong(receivedTokens);
    }

    @Generated
    public void setReceivedTokens(long v) {
        this.setLong(receivedTokens, v, null);
    }

    @Generated
    public long getGeneratedTokens() {
        return this.getLong(generatedTokens);
    }

    @Generated
    public void setGeneratedTokens(long v) {
        this.setLong(generatedTokens, v, null);
    }

    @Generated
    public boolean getParseAllMetrics() {
        return this.getBoolean(parseAllMetrics);
    }

    @Generated
    public void setParseAllMetrics(boolean v) {
        this.setBoolean(parseAllMetrics, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        BNetworkPort networkPort;
        BBacnetLinkLayer link;
        if (parent instanceof BNetworkPort && (link = (networkPort = (BNetworkPort)parent).getLink()) != null) {
            return link.getClass().getCanonicalName().toLowerCase().contains("mstp");
        }
        return false;
    }

    public void onExecute(BStatusValue o, Context cx) {
        long t0 = this.lastExecute;
        long t1 = System.currentTimeMillis();
        BBacnetMstpLinkLayer linkLayer = this.getMstpLinkLayer();
        if (linkLayer != null) {
            linkLayer.doGetStatistics();
            EmstpStats stats = linkLayer.getEmstpStats();
            if (stats != null) {
                String statsString = stats.toString();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(statsString.getBytes());
                this.setInputStream(inputStream);
            }
        }
        long oldTokens = this.recTokens.get();
        if (this.inputStream == null) {
            this.readMstpDeviceFile();
        } else {
            this.readMstpMetrics(this.inputStream);
        }
        long newTokens = this.recTokens.get();
        BStatusNumeric out = (BStatusNumeric)o;
        if (t0 > 0L) {
            out.setValue(this.calculateEventsPerSecond(newTokens - oldTokens, t0, t1));
        }
        if (this.fileNotFound && (linkLayer == null || !linkLayer.getUseCoprocessor())) {
            out.setStatus(BStatus.make((BStatus)this.getStatus(), (int)2));
        }
        this.lastExecute = t1;
    }

    private void readMstpDeviceFile() {
        AccessController.doPrivileged(() -> {
            try {
                String filename = this.getMstpOsName();
                if (filename == null) {
                    this.fileNotFound = true;
                } else {
                    FileInputStream fis = new FileInputStream(filename);
                    this.readMstpMetrics(fis);
                    this.fileNotFound = false;
                }
            }
            catch (FileNotFoundException e) {
                this.fileNotFound = true;
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMstpMetrics(InputStream input) {
        try (Scanner scanner = null;){
            scanner = new Scanner(input);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] keyValue = this.parse(line);
                if (keyValue == null) continue;
                this.addOrUpdateMetric(keyValue[0], keyValue[1]);
            }
        }
    }

    public boolean isLineValid(String line) {
        return line != null && !line.isEmpty() && !line.startsWith("-----");
    }

    public String[] parse(String line) {
        if (!this.isLineValid(line)) {
            return null;
        }
        String[] split = line.split(":");
        if (split.length < 2) {
            return null;
        }
        String key = split[0];
        String value = split[1];
        if ((key = key.trim().toLowerCase().replaceAll(" ", "")).matches("[0-9].*")) {
            key = PREFIX_CHAR + key;
        }
        split[0] = key;
        split[1] = value.trim();
        return split;
    }

    public void addOrUpdateMetric(String key, String value) {
        BValue bValue;
        if ("receivedTokens".equalsIgnoreCase(key)) {
            long receivedTokens = Long.parseLong(value);
            this.recTokens.set(receivedTokens);
            this.setReceivedTokens(receivedTokens);
        } else if ("generatedTokens".equalsIgnoreCase(key)) {
            long generatedTokens = Long.parseLong(value);
            this.genTokens.set(generatedTokens);
            this.setGeneratedTokens(generatedTokens);
        } else if (this.getParseAllMetrics() && (bValue = BTokens.parseMetric(key, value)) != null) {
            Property existingProperty = null;
            existingProperty = this.getProperty(key);
            if (existingProperty != null) {
                if (!this.get(existingProperty).equals((Object)bValue)) {
                    this.set(existingProperty, bValue, null);
                }
            } else {
                this.add(key, bValue, 4);
            }
        }
    }

    private static BValue parseMetric(String key, String value) {
        BString bValue = null;
        Double parsed = null;
        try {
            parsed = Double.parseDouble(value);
            bValue = BDouble.make((double)parsed);
        }
        catch (NumberFormatException nfe) {
            bValue = BString.make((String)value);
        }
        return bValue;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    private String getMstpOsName() {
        BBacnetLinkLayer link;
        BNetworkPort networkPort = (BNetworkPort)this.getParent();
        if (networkPort != null && (link = networkPort.getLink()) instanceof BBacnetMstpLinkLayer) {
            BBacnetMstpLinkLayer mstpLink = (BBacnetMstpLinkLayer)link;
            return "/dev/mstp" + mstpLink.getMstpTrunk();
        }
        return null;
    }

    private BBacnetMstpLinkLayer getMstpLinkLayer() {
        BBacnetLinkLayer link;
        BNetworkPort networkPort = (BNetworkPort)this.getParent();
        if (networkPort != null && (link = networkPort.getLink()) instanceof BBacnetMstpLinkLayer) {
            return (BBacnetMstpLinkLayer)link;
        }
        return null;
    }
}

